#ifndef FONTS_H
#define FONTS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef ATSTYPES_H
#include <ATS/ATSTypes.h>
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif


//#include <HYS/QD/Fonts.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Marking Character Constants

Specify a character to use for an active menu or submenu item.

enum {
   commandMark = 17,
   checkMark = 18,
   diamondMark = 19,
   appleMark = 20
};
Constants
commandMark

Specifies to use a command mark next to an active menu or submenu item.

Available in Mac OS X v10.0 and later.
checkMark

Specifies to use a check mark next to an active menu or submenu item.

Available in Mac OS X v10.0 and later.
diamondMark

Specifies to use a diamond mark next to an active menu or submenu item.

Available in Mac OS X v10.0 and later.
appleMark

Specifies to use an Apple character next to an active menu or submenu item.

Available in Mac OS X v10.0 and later.
Discussion

You can pass these constants in the markChar parameter of the Menu Manager function GetItemMark and the marking character field of the menu resource (of type 'MENU') and return these constants in the markChar parameter of the Menu Manager function SetItemMark to specify the mark of a specific menu item or the menu ID of the submenu associated with the menu item.*/
enum {
   commandMark = 17,
   checkMark = 18,
   diamondMark = 19,
   appleMark = 20
};

/*System and Application Fonts

Specify the current system and application fonts.

enum {
   systemFont = 0,
   applFont = 1
};
Constants
systemFont

Specifies the current System font.

Available in Mac OS X v10.0 and later.
applFont

Specifies the current application font.

Available in Mac OS X v10.0 and later.*/

enum {
   systemFont = 0,
   applFont = 1
};

/*Font ID Constants

Specify a font. These constants are deprecated.

enum {
   kFontIDNewYork = 2,
   kFontIDGeneva = 3,
   kFontIDMonaco = 4,
   kFontIDVenice = 5,
   kFontIDLondon = 6,
   kFontIDAthens = 7,
   kFontIDSanFrancisco = 8,
   kFontIDToronto = 9,
   kFontIDCairo = 11,
   kFontIDLosAngeles = 12,
   kFontIDTimes = 20,
   kFontIDHelvetica = 21,
   kFontIDCourier = 22,
   kFontIDSymbol = 23,
   kFontIDMobile = 24
};*/
enum {
   kFontIDNewYork = 2,
   kFontIDGeneva = 3,
   kFontIDMonaco = 4,
   kFontIDVenice = 5,
   kFontIDLondon = 6,
   kFontIDAthens = 7,
   kFontIDSanFrancisco = 8,
   kFontIDToronto = 9,
   kFontIDCairo = 11,
   kFontIDLosAngeles = 12,
   kFontIDTimes = 20,
   kFontIDHelvetica = 21,
   kFontIDCourier = 22,
   kFontIDSymbol = 23,
   kFontIDMobile = 24
};

/*FamRec

Contains format information for a font family resource.

struct FamRec {
   SInt16 ffFlags;
   SInt16 ffFamID;
   SInt16 ffFirstChar;
   SInt16 ffLastChar;
   SInt16 ffAscent;
   SInt16 ffDescent;
   SInt16 ffLeading;
   SInt16 ffWidMax;
   SInt32 ffWTabOff;
   SInt32 ffKernOff;
   SInt32 ffStylOff;
   SInt16 ffProperty[9];
   SInt16 ffIntl[2];
   SInt16 ffVersion;
};
Fields
ffFlags

Flags for family.
ffFamID

Family ID number.
ffFirstChar

ASCII code of first character.
ffLastChar

ASCII code of last character.
ffAscent

Maximum ascent for 1-point font.
ffDescent

Maximum descent for 1-point font.
ffLeading

Maximum leading for 1-point font.
ffWidMax

Maximum glyph width for 1-point font.
ffWTabOff

Offset to family glyph-width table.
ffKernOff

Offset to kerning table.
ffStylOff

Offset to style-mapping table.
ffProperty

Style properties info.
ffIntl

For international use.
ffVersion

Version number.
Discussion

The font family structure, of data type FamRec, describes the format of the font family ('FOND') resource. It is shown here as a guide to the format of the resource. The font family structure is not used directly by any Font Manager functions.*/
struct FamRec {
   SInt16 ffFlags;
   SInt16 ffFamID;
   SInt16 ffFirstChar;
   SInt16 ffLastChar;
   SInt16 ffAscent;
   SInt16 ffDescent;
   SInt16 ffLeading;
   SInt16 ffWidMax;
   SInt32 ffWTabOff;
   SInt32 ffKernOff;
   SInt32 ffStylOff;
   SInt16 ffProperty[9];
   SInt16 ffIntl[2];
   SInt16 ffVersion;
};
typedef struct FamRec                   FamRec;

/*AsscEntry

Contains the size and style for a specific font.

struct AsscEntry {
   SInt16 fontSize;
   SInt16 fontStyle;
   SInt16 fontID;
};
Fields
fontSize

A font point size.
fontStyle

A font style.
fontID

A font Resource ID.
Discussion

The font association entry structure is used in FontAssoc.*/
struct AsscEntry {
   SInt16 fontSize;
   SInt16 fontStyle;
   SInt16 fontID;
};
typedef struct AsscEntry                AsscEntry;

//functions

/*GetFNum

Obtains the font family ID for a specified font family name. (Deprecated in Mac OS X v10.4. Use FMGetFontFamilyFromName instead.)

Not recommended.

void GetFNum (
   ConstStr255Param name,
   SInt16 *familyID
);
Parameters
name

The font family name. 
familyID

On output, a pointer to the font family ID for the font family specified in name. If the font specified in the parameter name does not exist, the font family ID contains 0.
Special Considerations

There are several alternatives that provide better compatibility with the operating system than using QuickDraw font functions . You may want to consider the following:
For drawing and measuring text, you can use the Appearance Manager API or the ATSUI API to render text directly through a Quartz graphics context. See Appearance Manager Reference, Rendering Unicode Text With ATSUI, and ATSUI Reference.
For accessing information on fonts tracked by the operating system, use the ATS for Fonts API. See Managing Fonts: ATS and Apple Type Services for Fonts Reference.
For accessing and modifying information on fonts in a Quartz graphics context, use the Quartz API. See Quartz 2D Programming Guide and Quartz 2D Reference Collection.
Carbon Porting Notes

You should use the function FMGetFontFamilyFromName instead of the function GetFNum.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Fonts.h*/

void GetFNum (
   ConstStr255Param name,
   SInt16 *familyID
);

/*GetFontName

Obtains the name of a font family that has a specified family ID number. (Deprecated in Mac OS X v10.4. Use FMGetFontFamilyName instead.)

Not recommended.

void GetFontName (
   SInt16 familyID,
   Str255 name
);
Parameters
familyID

The font family ID.
name

On output, this parameter contains the font family name for the font family specified in familyID. If the font specified in the familyID parameter does not exist, name contains an empty string. 
Special Considerations

There are several alternatives that provide better compatibility with the operating system than using QuickDraw font functions . You may want to consider the following:
For drawing and measuring text, you can use the Appearance Manager API or the ATSUI API to render text directly through a Quartz graphics context. See Appearance Manager Reference, Rendering Unicode Text With ATSUI, and ATSUI Reference.
For accessing information on fonts tracked by the operating system, use the ATS for Fonts API. See Managing Fonts: ATS and Apple Type Services for Fonts Reference.
For accessing and modifying information on fonts in a Quartz graphics context, use the Quartz API. See Quartz 2D Programming Guide and Quartz 2D Reference Collection.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Fonts.h*/
void GetFontName (
   SInt16 familyID,
   Str255 name
);

/*GetAppFont

Returns the font family ID of the current application font. (Deprecated in Mac OS X v10.4. There is no replacement.)

SInt16 GetAppFont ();
Return Value

The font family ID of the current application font. This is the font family ID that has been mapped to 1 by the system software. 
Special Considerations

There are several alternatives that provide better compatibility with the operating system than using QuickDraw font functions . You may want to consider the following:
For drawing and measuring text, you can use the Appearance Manager API or the ATSUI API to render text directly through a Quartz graphics context. See Appearance Manager Reference, Rendering Unicode Text With ATSUI, and ATSUI Reference.
For accessing information on fonts tracked by the operating system, use the ATS for Fonts API. See Managing Fonts: ATS and Apple Type Services for Fonts Reference.
For accessing and modifying information on fonts in a Quartz graphics context, use the Quartz API. See Quartz 2D Programming Guide and Quartz 2D Reference Collection.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Fonts.h*/
SInt16 GetAppFont ();

/*Initializing the Font Manager
PROCEDURE InitFonts;*/
void  InitFonts();

/*FMGetFontFromFontFamilyInstance

Obtains the font reference associated with a standard QuickDraw style and font family. (Deprecated in Mac OS X v10.4.)

OSStatus FMGetFontFromFontFamilyInstance (
   FMFontFamily iFontFamily,
   FMFontStyle iStyle,
   FMFont *oFont,
   FMFontStyle *oIntrinsicStyle
);
Parameters
iFontFamily

A font family reference. 
iStyle

A font style. 
oFont

A pointer to a font reference. On output, points to the font reference for the specified font family and style. You are responsible for allocating the memory for the font reference. 
oIntrinsicStyle

On output, a pointer to an intrinsic font style. If a font object isn’t found that matches the font family reference and font style you specify, the function returns the QuickDraw style that matches most closely. 
Return Value

A result code. See “Font Manager Result Codes”. If a font reference and intrinsic style are not found, the function returns a value of kFMInvalidFontErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Fonts.h*/
OSStatus FMGetFontFromFontFamilyInstance (
   FMFontFamily iFontFamily,
   FMFontStyle iStyle,
   FMFont *oFont,
   FMFontStyle *oIntrinsicStyle
);

/*FMGetFontFamilyFromName

Returns the font family reference associated with a standard QuickDraw name. (Deprecated in Mac OS X v10.4.)

FMFontFamily FMGetFontFamilyFromName (
   ConstStr255Param iName
);

Parameters
iName

A QuickDraw font family name.
Return Value

A font family reference. The function returns kInvalidFontFamily if it cannot find a matching font family. See the ATS Types documentation for a description of the FMFontFamily data type.
Discussion

This function is a replacement for the GetFNum function. You should use the function FMGetFontFamilyFromName instead of the function GetFNum to assure your application supports font formats other than the resource fork TrueType and PostScript Type 1 fonts.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Fonts.h*/
FMFontFamily FMGetFontFamilyFromName (
   ConstStr255Param iName
);


#ifdef __cplusplus
}
#endif

#endif