#import <Foundation/Foundation.h>
#import <QuickTime/QuickTime.h>
#import <QTKit/QTKitDefines.h>

//#include<HYS/QTKit/QTTime.h>

/*QTTime

Defines the value and time scale of a time.

typedef struct {     long     long            timeValue;     long                timeScale;     long                flags; }
Discussion

The QTTime structure defines the value and time scale of a time. Currently only one flag is defined:enum {
 kQTTimeIsIndefinite = 1 << 0
};


If this flag is set in a QTTime structure, the other fields should not be used. The QTKit provides a number of functions for converting and comparing QTTime structures.*/
struct QTTime{ 
  long     long            timeValue;  
  long                timeScale;   
  long                flags; 
};
typedef struct QTTime QTTime;
enum {
 kQTTimeIsIndefinite = 1 << 0
};


/*QTMakeTime

Creates a QTTime structure.

QTTime QTMakeTime (long long timeValue, long timeScale);
Discussion

This function creates a QTTime structure initialized using the scalar value timeValue and the time scale scale.
Availability
Available in Mac OS X v10.3 and later.*/
QTTime QTMakeTime (long long timeValue, long timeScale);

/*QTTimeFromString

Returns a QTTime structure.

QTTime QTTimeFromString(NSString* string);
Discussion

This function returns a QTTime structure whose time is set to the time expressed by the string; the string is assumed to be in the form “days:hours:minutes:seconds:frames/timescale”.
Availability
Available in Mac OS X v10.3 and later.*/
QTTime QTTimeFromString(NSString* string);

/*QTStringFromTime

Returns a description of a QTTime structure.

NSString* QTStringFromTime(QTTime time);
Discussion

This function returns a description of a QTTime structure. The string is in the form “sign:days:hours:minutes:seconds:timevalue:timescale”, where sign is empty or “-”. Note that this is not for user input, but for archiving and debugging purposes.
Availability
Available in Mac OS X v10.3 and later.*/
NSString* QTStringFromTime(QTTime time);

/*QTMakeTimeWithTimeRecord

Creates a QTTime structure.

QTTime QTMakeTimeWithTimeRecord(TimeRecord timeRecord);
Discussion

This function creates a QTTime structure initialized using the values in the time record timeRecord.
Availability
Available in Mac OS X v10.3 and later.*/
QTTime QTMakeTimeWithTimeRecord(TimeRecord timeRecord);

/*QTTimeDecrement

Subtracks one QTTime from another.

QTTime QTTimeDecrement(QTTime time, QTTime decrement);
Discussion

This function returns a QTTime structure whose time is set to the time of a QTTime structure minus that of the structure decrement.
Availability
Available in Mac OS X v10.3 and later.*/
QTTime QTTimeDecrement(QTTime time, QTTime decrement);

/*QTGetTimeRecord

Returns the value of a QTTime structure expressed as a TimeRecord. 

BOOL QTGetTimeRecord(QTTime time, TimeRecord* timeRecord);
Discussion

This function returns, in the location pointed to by timeRecord, the value of a QTTime structure expressed as a TimeRecord. Returns YES if the method succeeded.
Availability
Available in Mac OS X v10.3 and later.*/
BOOL QTGetTimeRecord(QTTime time, TimeRecord* timeRecord);

/*QTTimeCompare

Returns a value of type NSComparisonResult.

NSComparisonResult QTTimeCompare(QTTime time, QTTime otherTime);
Discussion

This function returns a value of type NSComparisonResult that indicates the result of comparing a QTTime structure with the specified QTTime structure otherTime.
Availability
Available in Mac OS X v10.3 and later.*/
NSComparisonResult QTTimeCompare(QTTime time, QTTime otherTime);

@interface NSValue (NSValueQTTimeExtensions)
/*QTTimeValue

Returns a QTTime structure that contains the time in an NSValue object.

- (QTTime)QTTimeValue
Availability
Available in Mac OS X v10.3 and later.*/
- (QTTime)QTTimeValue;

/*valueWithQTTime:

Creates an NSValue object that wraps the specified QTTime structure.

+ (NSValue *)valueWithQTTime:(QTTime)time 
Availability
Available in Mac OS X v10.3 and later.*/
+ (NSValue *)valueWithQTTime:(QTTime)time ;

@end


/*Data Types and Constants

All of the new data types and constants in this header file are listed alphabetically, with links to documentation and abstracts, if available.
QTIndefiniteTime	
QTTime	
QTZeroTime	
kQTTimeIsIndefinite	*/
extern const QTTime  QTIndefiniteTime	;
extern const QTTime   QTZeroTime	;
