#ifndef CVDISPLAYLINK_H
#define CVDISPLAYLINK_H

#include <ApplicationServices/ApplicationServices.h>
#include <QuartzCore/CVReturn.h>
#include <QuartzCore/CVBase.h>
#include <OpenGL/OpenGL.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CVDisplayLinkRef

Defines a display link.

typedef struct __CVDisplayLink *CVDisplayLinkRef;
Availability
Available in Mac OS X v10.3 and later*/
typedef struct __CVDisplayLink *CVDisplayLinkRef;

/*CVDisplayLinkOutputCallback

Defines a pointer to a display link output callback function, which is called whenever the display link wants the application to output a frame. 

typedef CVReturn (*CVDisplayLinkOutputCallback)(
   CVDisplayLinkRef displayLink,
   const CVTimeStamp *inNow,
   const CVTimeStamp *inOutputTime,
   CVOptionFlags flagsIn,
   CVOptionFlags *flagsOut,
   void *displayLinkContext
   );

You would declare a display link output callback function named MyDisplayLinkCallback like this: 

CVReturn MyDisplayLinkCallback (
   CVDisplayLinkRef displayLink,
   const CVTimeStamp *inNow,
   const CVTimeStamp *inOutputTime,
   CVOptionFlags flagsIn,
   CVOptionFlags *flagsOut,
   void *displayLinkContext
   );
Parameters
displayLink

The display link requesting the frame.
inNow

A pointer to the current time.
inOutputTime

A pointer to the time that the frame will be displayed. 
flagsIn

Currently unused. Pass 0.
flagsOut

Currently unused. Pass 0.
displayLinkContext

A pointer to application-defined data. This is the pointer you passed into the CVDisplayLinkSetOutputCallback function when registering your callback. 
Discussion

For a given display link, you must register a display link output callback using CVDisplayLinkSetOutputCallback so that you can process and output the requested frame.

You callback must retrieve the frame with the timestamp specified by the (inOutputTime parameter, manipulate it if desired (for example, apply color correction or map into onto a surface), and then output it to the display.*/

typedef CVReturn (*CVDisplayLinkOutputCallback)(
   CVDisplayLinkRef displayLink,
   const CVTimeStamp *inNow,
   const CVTimeStamp *inOutputTime,
   CVOptionFlags flagsIn,
   CVOptionFlags *flagsOut,
   void *displayLinkContext
   );

//function

/*CVDisplayLinkRelease

Releases a display link.

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to release. This function is NULL-safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
);

/*CVDisplayLinkCreateWithActiveCGDisplays

Creates a display link capable of being used with all active displays.

CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

CVDisplayLinkCreateWithActiveCGDisplays determines the displays actively used by the host computer and creates a display link compatible with all of them. For most applications, calling this function is the most convenient way to create a display link. After creation, you can assign the display link to any active display by calling CVDisplayLinkSetCurrentCGDisplay.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut
);

/*CVDisplayLinkSetOutputCallback

Set the renderer output callback function.

CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo
);
Parameters
displayLink

The display link whose output callback you want to set. 
callback

The callback function to set for this display link. See CVDisplayLinkOutputCallback for more information about implementing this function. 
userInfo

A pointer to user data.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

The display link invokes this callback whenever it wants you to output a frame. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo
);

/*CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext

Selects the display link most optimal for the current renderer of an OpenGL context.

CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat
);
Parameters
displayLink

The display link for which you want to set the current display.
cglContext

The OpenGL context to retrieve the current renderer from.
cglPixelFormat

The OpenGL pixel format used to create the passed-in OpenGL context.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

This function chooses the display with the lowest refresh rate. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat
);

/*CVDisplayLinkStart

Activates a display link.

CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to activate. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Calling this function starts the display link thread, which then periodically calls back to your application to request that you display frames. If the specified display link is already running, CVDisplayLinkStart returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink
);

/*CVDisplayLinkCreateWithOpenGLDisplayMask

Creates a display link from an OpenGL display mask.

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
mask

The OpenGL display mask describing the available displays.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Using this function avoids having to call the Core Graphics function CGOpenGLDisplayMaskToDisplayID.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut
);

/*CVDisplayLinkStop

Stops a display link.

CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to stop.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

If the specified display link is already stopped, CVDisplayLinkStop returns an error.

In Mac OS X v.10.4 and later, the display link thread is automatically stopped if the user employs Fast User Switching. The display link is restarted when switching back to the original user. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink
);

/*CVDisplayLinkSetCurrentCGDisplay

Sets the current display of a display link. 

CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID
);
Parameters
displayLink

The display link whose display you want to set. 
displayID

The ID of the display to be set. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Although it is safe to call this function on a running display link, a discontinuity may appear in the video timestamp. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID
);

/*CVDisplayLinkIsRunning

Indicates whether a given display link is running. 

Boolean CVDisplayLinkIsRunning (
   CVDisplayLink displayLink
);
Parameters
displayLink

The display link whose run state you want to determine. 
Return Value

Returns true if the display link is running, false otherwise. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
Boolean CVDisplayLinkIsRunning (
   CVDisplayLinkRef  displayLink
);

/*CVDisplayLinkCreateWithCGDisplay

Creates a display link for a single display.

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayID

The Core Graphics ID of the target display.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Use this call to create a display link for a single display. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
);

#ifdef __cplusplus
}
#endif
#endif