#import <AppKit/AppKit.h>

#include <stdlib.h>
#include <limits.h>

@interface ScreenSaverView : NSView

/*initWithFrame:isPreview:

Initializes a newly allocated ScreenSaverView with frame as its frame rectangle, and sets the value returned by isPreview to isPreview.

- (id)initWithFrame:(NSRect)frame isPreview:(BOOL)isPreview
Discussion

The screen saver application will install the new view object into the view hierarchy of an NSWindow before the animation begins. This method is the designated initializer for the ScreenSaverView class. Returns self.
Availability
Available in Mac OS X v10.0 and later.
See Also
– initWithFrame:*/
- (id)initWithFrame:(NSRect)frame isPreview:(BOOL)isPreview;

/*setAnimationTimeInterval:

Sets the time interval between animation frames.

- (void)setAnimationTimeInterval:(NSTimeInterval)timeInterval
Discussion

Subclasses with particular requirements for time between animation frames should call this method to set the animation rate to a reasonable value.
Availability
Available in Mac OS X v10.0 and later.
See Also
– animationTimeInterval*/
- (void)setAnimationTimeInterval:(NSTimeInterval)timeInterval;

/*startAnimation

Activates the periodic timer that animates the screen saver.

- (void)startAnimation
Discussion

This method is called when the screen saver view should begin animating. Subclasses can implement this method to set up initial state or allocate expensive resources that should be loaded lazily. Subclasses must call the inherited implementation.
Availability
Available in Mac OS X v10.0 and later.
See Also
– stopAnimation*/
- (void)startAnimation;

/*stopAnimation

Deactivates the timer that advances the animation.

- (void)stopAnimation
Discussion

This method is called when the screen saver view should stop animating. Subclasses can implement this method to unload expensive resources or reset state to original parameters. Subclasses must call the inherited implementation.
Availability
Available in Mac OS X v10.0 and later.
See Also
– startAnimation*/
- (void)stopAnimation;


@end

