#ifndef __WINE_WINBASE_H
#define __WINE_WINBASE_H

#include <Wine/winerror.h>
#include <Wine/pshpack8.h>
#include <Wine/poppack.h>

#ifdef __cplusplus
extern "C" {
#endif

#define INVALID_HANDLE_VALUE     ((HANDLE)~0UL)
#define	FORMAT_MESSAGE_ALLOCATE_BUFFER	0x00000100
#define	FORMAT_MESSAGE_FROM_SYSTEM	0x00001000

#ifndef _FILETIME_
#define _FILETIME_
/* 64 bit number of 100 nanoseconds intervals since January 1, 1601 */
typedef struct _FILETIME
{
#ifdef WORDS_BIGENDIAN
  DWORD  dwHighDateTime;
  DWORD  dwLowDateTime;
#else
  DWORD  dwLowDateTime;
  DWORD  dwHighDateTime;
#endif
} FILETIME, *PFILETIME, *LPFILETIME;
#endif /* _FILETIME_ */

typedef struct _WIN32_FIND_DATAA
{
    DWORD     dwFileAttributes;
    FILETIME  ftCreationTime;
    FILETIME  ftLastAccessTime;
    FILETIME  ftLastWriteTime;
    DWORD     nFileSizeHigh;
    DWORD     nFileSizeLow;
    DWORD     dwReserved0;
    DWORD     dwReserved1;
    CHAR      cFileName[260];
    CHAR      cAlternateFileName[14];
} WIN32_FIND_DATAA;

typedef WIN32_FIND_DATAA *LPWIN32_FIND_DATAA;

DECL_WINELIB_TYPE_AW(WIN32_FIND_DATA)

//func
#define     FormatMessage WINELIB_NAME_AW(FormatMessage)
#define     GetModuleFileName WINELIB_NAME_AW(GetModuleFileName)
#define     GetCommandLine WINELIB_NAME_AW(GetCommandLine)
#define     FindFirstFile WINELIB_NAME_AW(FindFirstFile)

DWORD       WINAPI FormatMessageA(DWORD,LPCVOID,DWORD,DWORD,LPSTR,DWORD,va_list*);
DWORD       WINAPI GetLastError(void);
HLOCAL      WINAPI LocalFree(HLOCAL);
BOOL        WINAPI FindClose(HANDLE);
HANDLE      WINAPI FindFirstFileA(LPCSTR,LPWIN32_FIND_DATAA);
LPSTR       WINAPI GetCommandLineA(void);
DWORD       WINAPI GetModuleFileNameA(HMODULE,LPSTR,DWORD);

#ifdef __cplusplus
}
#endif

#endif  /* __WINE_WINBASE_H */

