#include <AudioToolbox/AudioToolbox.h>

/*AudioConverterSetProperty

Sets the property data to inPropertyData.

extern OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
);
Discussion

The inPropertyDataSize should be the size of data being input, and inPropertyData should point to the data to be set for inPropertyID.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
){
printf ("AudioConverterSetProperty",inAudioConverter,inPropertyID,inPropertyDataSize,inPropertyData);
};

/*AudioConverterGetProperty

Returns the requested property data.

extern OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
);
Discussion

The ioPropertyDataSize parameter should be the value obtained from calling AudioConverterGetPropertyInfo(); the output value of ioPropertyDataSize will be the actual data size of the returned data, for reference.
Availability
Available in Mac OS X v10.1 and later.*/
extern OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
){
printf ("AudioConverterGetProperty",inAudioConverter,inPropertyID,ioPropertyDataSize,outPropertyData);
};



/*AudioConverterGetPropertyInfo

Retrieves the size and writable state of the data belonging to the queried property.

extern OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* outSize,
Boolean* outWritable
);
Discussion

The outSize value returned reflects the size, in bytes, of the data returned by calling AudioConverterGetProperty() with the respective property.
Availability
Available in Mac OS X v10.1 and later.*/
extern OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 * outSize,
Boolean * outWritable
){
printf ("AudioConverterGetPropertyInfo",inAudioConverter,inPropertyID,*outSize,*outWritable);
};

/*AudioConverterFillComplexBuffer

Fills the AudioBufferList with converted data.

extern OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
);
Discussion

Using the callback provided in inInputDataProc, this function will convert input data using inAudioConverter and will place the resulting converted data in outOutputData. Any relevant data for the callback should be passed in via inInputDataProcUserData, while outPacketDescription will contain the format of the returned data. On input, ioOutDataPacketSize should contain the number of packets requested, and as output, will contain the number of packets returned.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
){
printf ("AudioConverterFillComplexBuffer",inAudioConverter,inInputDataProc,inInputDataProcUserData,*ioOutputDataPacketSize,*outOutputData,*outPacketDescription);
};

/*AudioConverterDispose

Destroys an audio converter.

extern OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter);
Discussion

This function deallocates the memory used by inAudioConverter.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter){
printf ("AudioConverterDisposer",inAudioConverter);
};


/*AudioConverterNew

Creates a new audio converter.

extern OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
);
Discussion

This function takes in two AudioStreamBasicDescription instances, one for the source, and one for the destination, sets up all of the internal links needed for the conversion, and returns a pointer for the new converter. Note that if the setup fails, an error is returned which specifies the error that was encountered.
Availability
Available in Mac OS X v10.1 and later.*/
OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
){
printf ("AudioConverterNew",*inSourceFormat,*inDestinationFormat,*outAudioConverter);
};

