#include <CarbonCore/CarbonCore.h>

//work

/*FindSymbol

Searches for a specific exported symbol.

OSErr FindSymbol (
   CFragConnectionID connID,
   ConstStr255Param symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
);
Parameters
connID

A connection ID. 
symName

A symbol name. 
symAddr

On return, a pointer to the address of the symbol whose name is symName. 
symClass

On return, a pointer to the class of the symbol whose name is symName. The currently recognized symbol classes are defined by the “Load Flag, Symbol Class, and Fragment Locator Constants”. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

The FindSymbol function searches the code fragment identified by the connID parameter for the symbol whose name is specified by the symName parameter. If that symbol is found, FindSymbol returns the address of the symbol in the symAddr parameter and the class of the symbol in the symClass parameter.

Because a fragment’s code is normally exported through transition vectors to that code, the value kCodeSymbol is not returned in the PowerPC environment. You can use the other two constants to distinguish exports that represent code (of class kTVectSymbol) from those that represent general data (of class kDataSymbol). 
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/
OSErr FindSymbol (
   CFragConnectionID connID,
   ConstStr255Param symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
){};

/*GetDiskFragment

Locates and possibly also loads a fragment contained in a file’s data fork into your application’s context.

OSErr GetDiskFragment (
   const FSSpec * fileSpec,
   UInt32 offset,
   UInt32 length,
   ConstStr63Param fragName,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
);
Parameters
fileSpec

A pointer to a file system specification that identifies the disk-based fragment to load. 
offset

The number of bytes from the beginning of the file’s data fork at which the beginning of the fragment is located. 
length

The length (in bytes) of the fragment. Specify the constant kWholeFork for this parameter if the fragment extends to the end-of-file of the data fork. Specify a nonzero value for the exact length of the fragment.
fragName

An optional name of the fragment. (This information is used primarily to allow you to identify the fragment during debugging. 
loadFlags

A flag that specifies the operation to perform on the fragment.The Code Fragment Manager recognizes the constants described in “Load Flag, Symbol Class, and Fragment Locator Constants”. 
connID

On return, a pointer to the connection ID that identifies the connection to the fragment. You can pass this ID to other Code Fragment Manager functions. 
mainAddr

On return, a pointer to the main address of the fragment. The value returned is specific to the fragment itself. Your application can use this parameter for its own purposes. 
errMessage

On return, the name of the fragment that could not successfully be loaded. This parameter is meaningful only if the call to GetDiskFragment fails. 
Return Value

A result code. See “Code Fragment Manager Result Codes”. The kFindLib constant in the loadFlags parameter specifies that the Code Fragment Manager search for the specified fragment. If the fragment is already prepared and connected to your application, GetDiskFragment returns fragNoErr. If the specified fragment is not found, GetDiskFragment returns the result code fragLibNotFound. If the specified fragment is found but could not be connected to your application, the function returns fragLibConnErr.
Discussion

Loading involves finding the specified fragment, reading it into memory (if it is not already in memory), and preparing it for execution. The Code Fragment Manager attempts to resolve all symbols imported by the fragment; to do so may involve loading import libraries.

If the fragment loading fails, the Code Fragment Manager returns an error code. Note, however, that the error encountered is not always in the fragment you asked to load. Rather, the error might have occurred while attempting to load an import library that the fragment you want to load depends on. For this reason, the Code Fragment Manager also returns, in the errMessage parameter, the name of the fragment that caused the load to fail. Although fragment names are restricted to 63 characters, the errMessage parameter is declared as type Str255; doing this allows future versions of the Code Fragment Manager to return a more informative message in the errMessage parameter. 
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

On Mac OS X, GetDiskFragment does not include the folder containing the root fragment (assuming that it is different from the application fragment) in its search path for import libraries. For example, say your application used a special folder to store plugins. If that folder also contained special libraries for those plugins, then calling GetDiskFragment to load a plugin would not find those libraries. 

The workaround is to make sure that any import libraries you require are in the Code Fragment Manager's search path (such as by designating an application library subfolder in the code fragment resource, or placing the libraries in the application's container). For more details of how the Code Fragment Manager searches for import libraries, see Mac OS Runtime Architectures. 
Declared In
CodeFragments.h*/
OSErr GetDiskFragment (
   const FSSpec * fileSpec,
   UInt32 offset,
   UInt32 length,
   ConstStr63Param fragName,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
){};

/*CloseConnection

Closes a connection to a fragment.

OSErr CloseConnection (
   CFragConnectionID * connID
);
Parameters
connID

A pointer to a connection ID. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

The CloseConnection function closes the connection to a fragment indicated by the connID parameter. CloseConnection decrements the count of existing connections to the specified fragment and, if the resulting count is 0, calls the fragment’s termination function and releases the memory occupied by the code and data sections of the fragment. If the resulting count is not 0, any per-connection data is released but the code section remains in memory.

When a fragment is unloaded as a result of its final connection having been closed, all libraries that depend on that fragment are also released, provided that their usage counts are also 0.

The Code Fragment Manager automatically closes any connections that remain open at the time ExitToShell is called for your application, so you need to call CloseConnection only for fragments you wish to unload before your application terminates. 
Special Considerations

You can close a connection only to the root of a loading sequence (that is, the fragment whose loading triggered the entire load chain).
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/

OSErr CloseConnection (
   CFragConnectionID * connID
){};

/*CountSymbols

Determines how many symbols are exported from a specified fragment.

OSErr CountSymbols (
   CFragConnectionID connID,
   long * symCount
);
Parameters
connID

A connection ID. 
symCount

On return, a pointer to the number of exported symbols in the fragment whose connection ID is connID. You can use the value returned in symCount to index through all the exported symbols in a particular fragment (using the GetIndSymbol function). 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/

OSErr CountSymbols (
   CFragConnectionID connID,
   long * symCount
){};

/*GetIndSymbol

Gets information about the exported symbols in a fragment.

OSErr GetIndSymbol (
   CFragConnectionID connID,
   long symIndex,
   Str255 symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
);
Parameters
connID

A connection ID. 
symIndex

A symbol index. This index is zero-based. That is, the value of this parameter should be between zero and the number of symbols -1 (where the number of symbols is determined by calling the CountSymbols function). 
symName

On return, the name of the indicated symbol. 
symAddr

On return, a pointer to the address of the indicated symbol. 
symClass

On return, a pointer to the class of the indicated symbol. See “Load Flag, Symbol Class, and Fragment Locator Constants”. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

If GetIndSymbol executes successfully, it returns the symbol’s name, starting address, and class in the symName, symAddr, and symClass parameters, respectively. A fragment’s exported symbols are retrieved in no predetermined order. 
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/
OSErr GetIndSymbol (
   CFragConnectionID connID,
   long symIndex,
   Str255 symName,
   Ptr * symAddr,
   CFragSymbolClass * symClass
){};

/*GetSharedLibrary

Locates and possibly also loads an import library into your application’s context.

OSErr GetSharedLibrary (
   ConstStr63Param libName,
   CFragArchitecture archType,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
);
Parameters
libName

The name of an import library. 
archType

The instruction set architecture of the import library. For the PowerPC architecture, use the constant kPowerPCArch. For the 680x0 architecture, use the constant kMotorola68KArch. 
loadFlags

A flag that specifies the operation to perform on the import library. The Code Fragment Manager recognizes the constants described in “Load Flag, Symbol Class, and Fragment Locator Constants”. 
connID

On return, a pointer to the connection ID that identifies the connection to the import library. You can pass this ID to other Code Fragment Manager functions. 
mainAddr

On return, a pointer to the main address of the import library. The value returned is specific to the import library itself and is not used by the Code Fragment Manager. 
errMessage

On return, the name of the fragment that could not successfully be loaded. This parameter is meaningful only if the call to GetSharedLibrary fails. 
Return Value

A result code. See “Code Fragment Manager Result Codes”.
Discussion

The GetSharedLibrary function locates the import library named by the libName parameter and possibly also loads that import library into your application’s context. The actions of GetSharedLibrary depend on the action flag you pass in the loadFlags parameter; pass kFindLib to get the connection ID of an existing connection to the specified fragment, kLoadLib to load the specified fragment, or kLoadNewCopy to load the fragment with a new copy of the fragment’s data section.

The GetSharedLibrary function does not resolve any unresolved imports in your application. In particular, you cannot use it to resolve any weak imports in your code fragment.

Loading involves finding the specified fragment, reading it into memory (if it is not already in memory), and preparing it for execution. The Code Fragment Manager attempts to resolve all symbols imported by the fragment; to do so may involve loading import libraries.

If the fragment loading fails, the Code Fragment Manager returns an error code. Note, however, that the error encountered is not always in the fragment you asked to load. Rather, the error might have occurred while attempting to load an import library that the fragment you want to load depends on. For this reason, the Code Fragment Manager also returns, in the errMessage parameter, the name of the fragment that caused the load to fail. Although fragment names are restricted to 63 characters, the errMessage parameter is declared as type Str255; doing this allows future versions of the Code Fragment Manager to return a more informative message in the errMessage parameter. 
Availability
Available in CarbonLib 1.0 and later when Code Fragment Manager 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CodeFragments.h*/
OSErr GetSharedLibrary (
   ConstStr63Param libName,
   CFragArchitecture archType,
   CFragLoadOptions options,
   CFragConnectionID * connID,
   Ptr * mainAddr,
   Str255 errMessage
){};


