#include <CarbonCore/CarbonCore.h>
//work


/*CreateUnicodeToTextInfo

Creates and returns a Unicode converter object containing information required for converting strings from Unicode to a non-Unicode encoding. 

OSStatus CreateUnicodeToTextInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   UnicodeToTextInfo * oUnicodeToTextInfo
);
Parameters
iUnicodeMapping

A pointer to a structure of type UnicodeMapping. Your application provides this structure to identify the mapping to be used for the conversion. The unicodeEncoding field of this structure can specify a Unicode format of kUnicode16BitFormat or kUnicodeUTF8Format. Note that the versions of the Unicode Converter prior to 1.2.1 do not support kUnicodeUTF8Format. 
oUnicodeToTextInfo

On return, a pointer to a Unicode converter object that holds the mapping table information you supply as the iUnicodeMapping parameter and the state information related to the conversion. The information contained in the Unicode converter object is required for the conversion of a Unicode string to a non-Unicode encoding. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

You pass the Unicode converter object returned from CreateUnicodeToTextInfo to the function ConvertFromUnicodeToText or ConvertFromUnicodeToPString to identify the information to be used for the conversion. These two functions modify the contents of the Unicode converter object. 

If an error is returned, the Unicode converter object is invalid. 

Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/

OSStatus CreateUnicodeToTextInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   UnicodeToTextInfo * oUnicodeToTextInfo
){};

/*ConvertFromUnicodeToText

Converts a Unicode text string to the destination encoding you specify. 

OSStatus ConvertFromUnicodeToText (
   UnicodeToTextInfo iUnicodeToTextInfo,
   ByteCount iUnicodeLen,
   const UniChar iUnicodeStr[],
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oInputRead,
   ByteCount * oOutputLen,
   LogicalAddress oOutputStr
);
Parameters
iUnicodeToTextInfo

A Unicode converter object of type UnicodeToTextInfo for converting text from Unicode. You use the function CreateUnicodeToTextInfo or CreateUnicodeToTextInfoByEncoding to obtain a Unicode converter object to specify for this parameter. This function modifies the contents of the iUnicodeToTextInfo parameter. 
iUnicodeLen

The length in bytes of the Unicode string to be converted. 
iUnicodeStr

A pointer to the Unicode string to be converted. If the input text is UTF-8, which is supported for versions 1.2.1 or later of the converter, you must cast the UTF-8 buffer pointer to ConstUniCharArrayPtr before you can pass it as this parameter. 
iControlFlags

Conversion control flags. You can use “Conversion Masks” and “Directionality Masks” to set the iControlFlags parameter. 
iOffsetCount

The number of offsets contained in the array provided by the iOffsetArray parameter. Your application supplies this value. If you don’t want offsets returned to you, specify 0 (zero) for this parameter. 
iOffsetArray

An array of type ByteOffset. On input, you specify the array that gives an ordered list of significant byte offsets pertaining to the Unicode source string to be converted. These offsets may identify font or style changes, for example, in the source string. If you don’t want offsets returned to your application, specify NULL for this parameter and 0 (zero) for iOffsetCount. All offsets must be less than iUnicodeLen. 
oOffsetCount

On return, a pointer to the number of offsets that were mapped in the output stream.
oOffsetArray

An array of type ByteOffset. On return, this array contains the corresponding new offsets for the converted string in the new encoding.
iOutputBufLen

The length in bytes of the output buffer pointed to by the oOutputStr parameter. Your application supplies this buffer to hold the returned converted string. The oOutputLen parameter may return a byte count that is less than this value if the converted byte string is smaller than the buffer size you allocated.
oInputRead

On return, a pointer to a the number of bytes of the Unicode string that were converted. If the function returns a kTECUnmappableElementErr result code, this parameter returns the number of bytes that were converted before the error occurred.
oOutputLen

On return, a pointer to the length in bytes of the converted text stream.
oOutputStr

A value of type LogicalAddress. On input, this value points to a buffer for the converted string. On return, the buffer holds the converted text string. (For guidelines on estimating the size of the buffer needed, see the following discussion. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

This function can also map offsets for style or font information from the source text string to the returned converted string. The converter reads the application-supplied offsets and returns the corresponding new offsets in the converted string. If you do not want font or style information offsets mapped to the resulting string, you should pass NULL for iOffsetArray and 0 (zero) for iOffsetCount. 

Your application must allocate a buffer to hold the resulting converted string and pass a pointer to the buffer in the oOutputStr parameter. To determine the size of the output buffer to allocate, you should consider the size and content of the Unicode source string in relation to the type of encoding to which it will be converted. For example, for many encodings, such as MacRoman and Shift-JIS, the size of the returned string will be between half the size and the same size as the source Unicode string. However, for some encodings that are not Mac OS ones, such as EUC-JP, which has some 3-byte characters for Kanji, the returned string could be larger than the source Unicode string. For MacArabic and MacHebrew, the result will usually be less than half the size of the Unicode string. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus ConvertFromUnicodeToText (
   UnicodeToTextInfo iUnicodeToTextInfo,
   ByteCount iUnicodeLen,
   const UniChar iUnicodeStr[],
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oInputRead,
   ByteCount * oOutputLen,
   LogicalAddress oOutputStr
){};

/*DisposeUnicodeToTextInfo

Releases the memory allocated for the specified Unicode converter object. 

OSStatus DisposeUnicodeToTextInfo (
   UnicodeToTextInfo * ioUnicodeToTextInfo
);
Parameters
ioUnicodeToTextInfo

A pointer to a Unicode converter object for converting from Unicode to a non-Unicode encoding. You specify a Unicode converter object that your application created using the function CreateUnicodeToTextInfo or CreateUnicodeToTextInfoByEncoding. You must not point to any other type of Unicode converter object. Your application should not attempt to dispose of the same Unicode converter object more than once. 
Return Value

A result code. See “TEC Manager Result Codes”. The function returns noErr if it disposes of the Unicode converter object successfully. If your application specifies an invalid Unicode converter object, such as NULL, the function returns a paramErr result code.
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/

OSStatus DisposeUnicodeToTextInfo (
   UnicodeToTextInfo * ioUnicodeToTextInfo
){};

/*CreateTextToUnicodeInfo

Creates and returns a Unicode converter object containing information required for converting strings from a non-Unicode encoding to Unicode. 

OSStatus CreateTextToUnicodeInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   TextToUnicodeInfo * oTextToUnicodeInfo
);
Parameters
iUnicodeMapping

A pointer to a structure of type UnicodeMapping. Your application provides this structure to identify the mapping to use for the conversion. You must supply a value of type TextEncoding in the unicodeEncoding field of this structure. A TextEncoding is a triple composed of an encoding base, an encoding variant, and a format. You can obtain a UnicodeMapping value by calling the function CreateTextEncoding. 
oTextToUnicodeInfo

On return, the Unicode converter object holds mapping table information you supplied as the UnicodeMapping parameter and state information related to the conversion. This information is required for conversion of a text stream in a non-Unicode encoding to Unicode. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

You pass a Unicode converter object returned from the function CreateTextToUnicodeInfo to the function ConvertFromTextToUnicode or ConvertFromPStringToUnicode to identify the information to be used for the conversion. These two functions modify the contents of the object. 

You pass a Unicode converter object returned from CreateTextToUnicodeInfo to the function TruncateForTextToUnicode to identify the information to be used to truncate the string. This function does not modify the contents of the Unicode converter object.

If an error is returned, the Unicode converter object is invalid. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus CreateTextToUnicodeInfo (
   ConstUnicodeMappingPtr iUnicodeMapping,
   TextToUnicodeInfo * oTextToUnicodeInfo
){};

/*ConvertFromTextToUnicode

Converts a string from any encoding to Unicode. 

OSStatus ConvertFromTextToUnicode (
   TextToUnicodeInfo iTextToUnicodeInfo,
   ByteCount iSourceLen,
   ConstLogicalAddress iSourceStr,
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oSourceRead,
   ByteCount * oUnicodeLen,
   UniChar oUnicodeStr[]
);
Parameters
iTextToUnicodeInfo

A Unicode converter object of type TextToUnicodeInfo containing mapping and state information used for the conversion. The contents of this Unicode converter object are modified by the function. Your application obtains a Unicode converter object using the function CreateTextToUnicodeInfo. 
iSourceLen

The length in bytes of the source string to be converted. 
iSourceStr

The address of the source string to be converted. 
iControlFlags

Conversion control flags. You can use “Conversion Masks” to set the iControlFlags parameter. 
iOffsetCount

The number of offsets in the iOffsetArray parameter. Your application supplies this value. The number of entries in iOffsetArray must be fewer than the number of bytes specified in iSourceLen. If you don’t want offsets returned to you, specify 0 (zero) for this parameter. 
iOffsetArray

An array of type ByteOffset. On input, you specify the array that contains an ordered list of significant byte offsets pertaining to the source string. These offsets may identify font or style changes, for example, in the source string. All array entries must be less than the length in bytes specified by the iSourceLen parameter. If you don’t want offsets returned to your application, specify NULL for this parameter and 0 (zero) for iOffsetCount. 
oOffsetCount

On return, a pointer to the number of offsets that were mapped in the output stream.
oOffsetArray

An array of type ByteOffset. On return, this array contains the corresponding new offsets for the Unicode string produced by the converter.
iOutputBufLen

The length in bytes of the output buffer pointed to by the oUnicodeStr parameter. Your application supplies this buffer to hold the returned converted string. The oUnicodeLen parameter may return a byte count that is less than this value if the converted byte string is smaller than the buffer size you allocated. The relationship between the size of the source string and the Unicode string is complex and depends on the source encoding and the contents of the string.
oSourceRead

On return, a pointer to the number of bytes of the source string that were converted. If the function returns a kTECUnmappableElementErr result code, this parameter returns the number of bytes that were converted before the error occurred.
oUnicodeLen

On return, a pointer to the length in bytes of the converted stream.
oUnicodeStr

A pointer to an array used to hold a Unicode string. On input, this value points to the beginning of the array for the converted string. On return, this buffer holds the converted Unicode string. (For guidelines on estimating the size of the buffer needed, see the discussion. 
Return Value

A result code. See “TEC Manager Result Codes”. The function returns a noErr result code if it has completely converted the input string to Unicode without using fallback characters.
Discussion

You specify the source string’s encoding in the Unicode mapping structure that you pass to the function CreateTextToUnicodeInfo to obtain a Unicode converter object for the conversion. You pass the Unicode converter object returned by CreateTextToUnicodeInfo to ConvertFromTextToUnicode as the iTextToUnicodeInfo parameter. 

In addition to converting a text string in any encoding to Unicode, the ConvertFromTextToUnicode function can map offsets for style or font information from the source text string to the returned converted string. The converter reads the application-supplied offsets, which apply to the source string, and returns the corresponding new offsets in the converted string. If you do not want the offsets at which font or style information occurs mapped to the resulting string, you should pass NULL for iOffsetArray and 0 (zero) for iOffsetCount. 

Your application must allocate a buffer to hold the resulting converted string and pass a pointer to the buffer in the oUnicodeStr parameter. To determine the size of the output buffer to allocate, you should consider the size of the source string, its encoding type, and its content in relation to the resulting Unicode string. 

For example, for 1-byte encodings, such as MacRoman, the Unicode string will be at least double the size (more if it uses noncomposed Unicode) for MacArabic and MacHebrew, the corresponding Unicode string could be up to six times as big. For most 2-byte encodings, for example Shift-JIS, the Unicode string will be less than double the size. For international robustness, your application should allocate a buffer three to four times larger than the source string. If the output Unicode text is actually UTF-8—which could occur beginning with the current release of the Text Encoding Conversion Manager, version 1.2.1—the UTF-8 buffer pointer must be cast to UniCharArrayPtr before it can be passed as the oUnicodeStr parameter. Also, the output buffer length will have a wider range of variation than for UTF-16; for ASCII input, the output will be the same size; for Han input, the output will be twice as big, and so on. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus ConvertFromTextToUnicode (
   TextToUnicodeInfo iTextToUnicodeInfo,
   ByteCount iSourceLen,
   ConstLogicalAddress iSourceStr,
   OptionBits iControlFlags,
   ItemCount iOffsetCount,
   ByteOffset iOffsetArray[],
   ItemCount * oOffsetCount,
   ByteOffset oOffsetArray[],
   ByteCount iOutputBufLen,
   ByteCount * oSourceRead,
   ByteCount * oUnicodeLen,
   UniChar oUnicodeStr[]
){};

/*DisposeTextToUnicodeInfo

Releases the memory allocated for the specified Unicode converter object. 

OSStatus DisposeTextToUnicodeInfo (
   TextToUnicodeInfo * ioTextToUnicodeInfo
);
Parameters
ioTextToUnicodeInfo

A pointer to a Unicode converter object of type TextToUnicodeInfo, used for converting text to Unicode. On input, you specify the object to dispose. It must be an object which your application created using the function CreateTextToUnicodeInfo or CreateTextToUnicodeInfoByEncoding. You must not point to any other type of Unicode converter object. Your application should not use this function with the same structure more than once. 
Return Value

A result code. See “TEC Manager Result Codes”. If your application specifies an invalid Unicode converter object, such as NULL, the function returns a paramErr result code.
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
UnicodeConverter.h*/
OSStatus DisposeTextToUnicodeInfo (
   TextToUnicodeInfo * ioTextToUnicodeInfo
){};

/*CreateTextToUnicodeInfoByEncoding

Based on the given text encoding specification, creates and returns a Unicode converter object containing information required for converting strings from the specified non-Unicode encoding to Unicode. 

OSStatus CreateTextToUnicodeInfoByEncoding (
   TextEncoding iEncoding,
   TextToUnicodeInfo * oTextToUnicodeInfo
);
Parameters
iEncoding

The text encoding specification for the source text. 
oTextToUnicodeInfo

The Unicode converter object of type TextToUnicodeInfo returned by the function. 
Return Value

A result code. See “TEC Manager Result Codes”.
Discussion

You can use this function instead of the CreateTextToUnicodeInfo function when you do not need to create a Unicode mapping structure. You simply specify the text encoding of the source text. However, this method is less efficient because the text encoding parameter must be resolved internally into a Unicode mapping. 

You cannot specify a version of Unicode. The function uses a 16-bit form of Unicode as the default.

You pass a Unicode converter object returned from CreateTextToUnicodeInfoByEncoding to the function ConvertFromTextToUnicode or ConvertFromPStringToUnicode to identify the information to be used for the conversion. These two functions modify the contents of the Unicode converter object. 

You pass a Unicode converter object returned from CreateTextToUnicodeInfoByEncoding to the function TruncateForTextToUnicode to identify the information to be used to truncate the string. This function does not modify the contents of the Unicode converter object.

If you are converting the text stream to Unicode as an intermediary encoding, and then from Unicode to the final destination encoding, you use the function CreateUnicodeToTextInfo to create a Unicode converter object for the second part of the process. 
Availability
Available in CarbonLib 1.0 and later when Unicode Utilities 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
UnicodeConverter.h*/
OSStatus CreateTextToUnicodeInfoByEncoding (
   TextEncoding iEncoding,
   TextToUnicodeInfo * oTextToUnicodeInfo
){};


