#import <CoreData/NSManagedObjectContext.h>
//work
 @implementation  NSManagedObjectContext

/*setPersistentStoreCoordinator:

Sets the persistent store coordinator of the receiver.

- (void)setPersistentStoreCoordinator:(NSPersistentStoreCoordinator *)coordinator
Parameters
coordinator

The persistent store coordinator of the receiver. This value must not be nil.
Discussion

The coordinator provides the managed object model and handles persistency. Note that multiple contexts can share a coordinator. 

This method raises an exception if coordinator is nil. If you want to “disconnect" a context from its persistent store coordinator, you should simply release all references to the context and allow it to be deallocated normally.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)setPersistentStoreCoordinator:(NSPersistentStoreCoordinator *)coordinator{}


/*save:

Attempts to commit unsaved changes to registered objects to their persistent store.

- (BOOL)save:(NSError **)error
Parameters
error

A pointer to an NSError object. You do not need to create an NSError object. The save operation aborts after the first failure if you pass NULL.
Return Value

YES if the save succeeds, otherwise NO.
Discussion

If there were multiple errors (for example several edited objects had validation failures) the description of NSError returned indicates that there were multiple errors, and its userInfo dictionary contains a key, NSDetailedErrors. The value associated with the NSDetailedErrors key is an array that contains the individual NSError objects. 
Availability
Available in Mac OS X v10.4 and later.*/
- (BOOL)save:(NSError **)error{}

/*deleteObject:

Specifies an object that should be removed from its persistent store when changes are committed.

- (void)deleteObject:(NSManagedObject *)object
Parameters
object

A managed object.
Discussion

When changes are committed, object will be removed from the uniquing tables. If object has not yet been saved to a persistent store, it is simply removed from the receiver.
Availability
Available in Mac OS X v10.4 and later.
See Also
– deletedObjects
– isDeleted (NSManagedObject)*/
- (void)deleteObject:(NSManagedObject *)object{}




/*executeFetchRequest:error:

Returns an array of objects that meet the criteria specified by a given fetch request.

- (NSArray *)executeFetchRequest:(NSFetchRequest *)request error:(NSError **)error
Parameters
request

A fetch request that specifies the search criteria for the fetch.
error

If there is a problem executing the fetch, upon return contains an instance of NSError that describes the problem.
Return Value

An array of objects that meet the criteria specified by request fetched from the receiver and from the persistent stores associated with the receiver’s persistent store coordinator. If an error occurs, returns nil. If no objects match the criteria specified by request, returns an empty array.
Discussion

Returned objects are registered with the receiver.

The following points are important to consider:
If the fetch request has no predicate, then all instances of the specified entity are retrieved, modulo other criteria below.
An object that meets the criteria specified by request (it is an instance of the entity specified by the request, and it matches the request’s predicate if there is one) and that has been inserted into a context but which is not yet saved to a persistent store, is retrieved if the fetch request is executed on that context.
If an object in a context has been modified, a predicate is evaluated against its modified state, not against the current state in the persistent store. Therefore, if an object in a context has been modified such that it meets the fetch request’s criteria, the request retrieves it even if changes have not been saved to the store and the values in the store are such that it does not meet the criteria. Conversely, if an object in a context has been modified such that it does not match the fetch request, the fetch request will not retrieve it even if the version in the store does match.
If an object has been deleted from the context, the fetch request does not retrieve it even if that deletion has not been saved to a store.

Objects that have been realized (populated, faults fired, “read from”, and so on) as well as pending updated, inserted, or deleted, are never changed by a fetch operation without developer intervention. If you fetch some objects, work with them, and then execute a new fetch that includes a superset of those objects, you do not get new instances or update data for the existing objects—you get the existing objects with their current in-memory state.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSArray *)executeFetchRequest:(NSFetchRequest *)request error:(NSError **)error{}


/*undoManager

Returns the undo manager of the receiver.

- (NSUndoManager *)undoManager
Return Value

The undo manager of the receiver.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSUndoManager *)undoManager{}


/*persistentStoreCoordinator

Returns the persistent store coordinator of the receiver.

- (NSPersistentStoreCoordinator *)persistentStoreCoordinator
Return Value

The persistent store coordinator of the receiver.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSPersistentStoreCoordinator *)persistentStoreCoordinator{}


/*objectWithID:

Returns the object for a specified ID.

- (NSManagedObject *)objectWithID:(NSManagedObjectID *)objectID
Parameters
objectID

An object ID.
Return Value

The object for the specified ID.
Discussion

If the object is not registered in the context, it may be fetched or returned as a fault. This method always returns an object. The data in the persistent store represented by objectID is assumed to exist—if it does not, the returned object throws an exception when you access any property (that is, when the fault is fired). The benefit of this behavior is that it allows you to create and use faults, then create the underlying rows later or in a separate context.
Availability
Available in Mac OS X v10.4 and later.
See Also
– objectRegisteredForID:
– managedObjectIDForURIRepresentation: (NSPersistentStoreCoordinator)
– URIRepresentation (NSManagedObjectID)*/
- (NSManagedObject *)objectWithID:(NSManagedObjectID *)objectID{}


/*assignObject:toPersistentStore:

Specifies the store in which a newly-inserted object will be saved.

- (void)assignObject:(id)object toPersistentStore:(id)store
Parameters
object

A managed object.
store

A persistent store identifier.
Discussion

You can obtain the store identifier from the persistent store coordinator, using for example persistentStoreForURL:.
Special Considerations

It is only necessary to use this method if the receiver’s persistent store coordinator manages multiple writable stores that have object’s entity in their configuration. Maintaining configurations in the managed object model can eliminate the need for invoking this method directly in many situations. If the receiver’s persistent store coordinator manages only a single writable store, or if only one store has object’s entity in its model, object will automatically be assigned to that store.
Availability
Available in Mac OS X v10.4 and later.
See Also
– insertObject:
– persistentStoreCoordinator*/
- (void)assignObject:(id)object toPersistentStore:(id)store{}

/*processPendingChanges

Forces the receiver to process changes to the object graph.

- (void)processPendingChanges
Discussion

This method causes changes to registered managed objects to be recorded with the undo manager.

In AppKit-based applications, this method is invoked automatically at least once during the event loop (at the end of the loop)—it may be called more often than that if the framework needs to coalesce your changes before doing something else. You can also invoke it manually to coalesce any pending unprocessed changes.
Availability
Available in Mac OS X v10.4 and later.
See Also
– redo
– undo
– undoManager*/
- (void)processPendingChanges{}


/*rollback

Removes everything from the undo stack, discards all insertions and deletions, and restores updated objects to their last committed values.

- (void)rollback
Discussion

This method does not refetch data from the persistent store or stores.
Availability
Available in Mac OS X v10.4 and later.
See Also
– reset
– setStalenessInterval:
– undo
– processPendingChanges*/
- (void)rollback{}

/*refreshObject:mergeChanges:

Updates the persistent properties of a managed object to use the latest values from the persistent store.

- (void)refreshObject:(NSManagedObject *)object mergeChanges:(BOOL)flag
Parameters
object

A managed object.
flag

A Boolean value.

If flag is NO, then object is turned into a fault and any pending changes are lost. The object remains a fault until it is accessed again, at which time its property values will be reloaded from the store or last cached state.

If flag is YES, then object’s property values are reloaded from the values from the store or the last cached state then any changes that were made (in the local context) are re-applied over those (now newly updated) values. (If flag is YES the merge of the values into object will always succeed—in this case there is therefore no such thing as a “merge conflict” or a merge that is not possible.)
Discussion

If the staleness interval (see stalenessInterval) has not been exceeded, any available cached data is reused instead of executing a new fetch. If flag is YES, this method does not affect any transient properties; if flag is NO, transient properties are released.

You typically use this method to ensure data freshness if more than one managed object context may use the same persistent store simultaneously, in particular if you get an optimistic locking failure when attempting to save.

It is important to note that turning object into a fault (flag is NO) also causes related managed objects (that is, those to which object has a reference) to be released, so you can also use this method to trim a portion of your object graph you want to constrain memory usage.
Availability
Available in Mac OS X v10.4 and later.
See Also
– detectConflictsForObject:
– reset
– setStalenessInterval:*/
- (void)refreshObject:(NSManagedObject *)object mergeChanges:(BOOL)flag{}


/*objectRegisteredForID:

Returns the object for a specified ID, if the object is registered with the receiver.

- (NSManagedObject *)objectRegisteredForID:(NSManagedObjectID *)objectID
Parameters
objectID

An object ID.
Return Value

The object for the specified ID if it is registered with the receiver, otherwise nil.
Availability
Available in Mac OS X v10.4 and later.
See Also
– objectWithID:*/
- (NSManagedObject *)objectRegisteredForID:(NSManagedObjectID *)objectID{}


/*setMergePolicy:

Sets the merge policy of the receiver.

- (void)setMergePolicy:(id)mergePolicy
Parameters
mergePolicy

The merge policy of the receiver. For possible values, see “Constants”.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)setMergePolicy:(id)mergePolicy{}



/*reset

Returns the receiver to its base state.

- (void)reset
Discussion

All the receiver's managed objects are “forgotten.” If you use this method, you should ensure that you also discard references to any managed objects fetched using the receiver, since they will be invalid afterwards.
Availability
Available in Mac OS X v10.4 and later.
See Also
– rollback
– setStalenessInterval:
– undo*/
- (void)reset{}

@end

/*NSManagedObjectContextObjectsDidChangeNotification

Posted when values of properties of objects contained in a managed object context are changed. 

The notification is posted during processPendingChanges, after the changes have been processed, but before it is safe to call save: again (if you try, you will generate an infinite loop).

The notification object is the managed object context. The userInfo dictionary contains the following keys: NSInsertedObjectsKey, NSUpdatedObjectsKey, and NSDeletedObjectsKey.

Note that this notification is posted only when managed objects are changed; it is not posted when managed objects are added to a context as the result of a fetch. 
Availability
Available in Mac OS X v10.4 and later.*/
NSString * const NSManagedObjectContextObjectsDidChangeNotification;

/*NSManagedObjectContext Change Notification User Info Keys

Core Data uses these string constants as keys in the user info dictionary in managed object context notifications (NSManagedObjectContextObjectsDidChangeNotification and NSManagedObjectContextDidSaveNotification).

NSString * const NSInsertedObjectsKey;
NSString * const NSUpdatedObjectsKey;
NSString * const NSDeletedObjectsKey;
Constants
NSInsertedObjectsKey

Key for the set of objects that were inserted into the context.

Available in Mac OS X v10.4 and later.
NSUpdatedObjectsKey

Key for the set of objects that were updated.

Available in Mac OS X v10.4 and later.
NSDeletedObjectsKey

Key for the set of objects that were marked for deletion during the previous event. 

See also deletedObjects (NSManagedObjectContext) and isDeleted (NSManagedObject).

Available in Mac OS X v10.4 and later.
Declared In
NSManagedObjectContext.h*/
 NSString * const NSInsertedObjectsKey;
 NSString * const NSUpdatedObjectsKey;
 NSString * const NSDeletedObjectsKey;
