#include <CoreFoundation/CoreFoundation.h>

//work


/*CFDateGetTypeID

Returns the type identifier for the CFDate opaque type.

CFTypeID CFDateGetTypeID ();
Return Value

The type identifier for the CFDate opaque type. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDateGetTypeID (){};

/*CFAbsoluteTimeGetCurrent

Returns the current system absolute time.

CFAbsoluteTime CFAbsoluteTimeGetCurrent ();
Return Value

The current absolute time. 
Discussion

Absolute time is measured in seconds relative to the absolute reference date of Jan 1 2001 00:00:00 GMT. A positive value represents a date after the reference date, a negative value represents a date before it. For example, the absolute time -32940326 is equivalent to December 16th, 1999 at 17:54:34. Repeated calls to this function do not guarantee monotonically increasing results. The system time may decrease due to synchronization with external time references or due to an explicit user change of the clock.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/
CFAbsoluteTime CFAbsoluteTimeGetCurrent (){};

/*CFDateCreate

Creates a CFDate object given an absolute time.

CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
at

The absolute time to converted to a CFDate object. 
Return Value

A date object that represents the absolute time at. Ownership follows the Create Rule.
Discussion

CFDate objects must always be created using absolute time. Time intervals are not supported. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
){};

/*(CFGregorianDateGetAbsoluteTime

Converts a Gregorian date value into an absolute time value.

CFAbsoluteTime CFGregorianDateGetAbsoluteTime (
   CFGregorianDate gdate,
   CFTimeZoneRef tz
);
Parameters
gdate

The Gregorian date to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

The absolute time equivalent of gdate. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

CFAbsoluteTime CFGregorianDateGetAbsoluteTime (
   CFGregorianDate gdate,
   CFTimeZoneRef tz
){};

/*CFAbsoluteTimeGetDayOfWeek

Returns an integer representing the day of the week indicated by the specified absolute time.

SInt32 CFAbsoluteTimeGetDayOfWeek (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);
Parameters
at

The absolute time to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

An integer (1-7) representing the day of the week specified by at. Per ISO-8601, Monday is represented by 1, Tuesday by 2, and so on.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

SInt32 CFAbsoluteTimeGetDayOfWeek (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
){};

/*CFAbsoluteTimeAddGregorianUnits

Adds a time interval, expressed as Gregorian units, to a given absolute time.

CFAbsoluteTime CFAbsoluteTimeAddGregorianUnits (
   CFAbsoluteTime at,
   CFTimeZoneRef tz,
   CFGregorianUnits units
);
Parameters
at

The absolute time to which the interval is added. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
units

The time interval to add to at. 
Return Value

An absolute time value equal to the sum of at and units. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

CFAbsoluteTime CFAbsoluteTimeAddGregorianUnits (
   CFAbsoluteTime at,
   CFTimeZoneRef tz,
   CFGregorianUnits units
){};

/*CFAbsoluteTimeGetGregorianDate

Converts an absolute time value into a Gregorian date.

CFGregorianDate CFAbsoluteTimeGetGregorianDate (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);
Parameters
at

The absolute time value to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

The Gregorian date equivalent for at. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/
CFGregorianDate CFAbsoluteTimeGetGregorianDate (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
){};
