#include <CoreFoundation/CoreFoundation.h>

//work


/*CFDateFormatterCreate

Creates a new CFDateFormatter object, localized to the given locale, which will format dates to the given date and time styles.

CFDateFormatterRef CFDateFormatterCreate(
   CFAllocatorRef alloc,
   CFLocaleRef locale,
   CFDateFormatterStyle dateStyle,
   CFDateFormatterStyle timeStyle
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
locale

The locale to use for localization. If NULL uses the default system local. Use CFLocaleCopyCurrent to specify the locale of the current user.
dateStyle

The date style to use when formatting dates. See Date Formatter Styles for possible values.
timeStyle

The time style to use when formatting times. See Date Formatter Styles for possible values.
Return Value

A new date formatter, localized to the given locale, which will format dates to the given date and time styles. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

You can use kCFDateFormatterNoStyle to suppress output for the date or time. The following code fragment illustrates the creation and use of a date formatter that only outputs the date information (memory management is omitted for clarity).CFLocaleRef locale = CFLocaleCreate(kCFAllocatorDefault, CFSTR("en_GB"));
 
CFDateFormatterRef formatter = CFDateFormatterCreate(
        kCFAllocatorDefault, locale, kCFDateFormatterMediumStyle, kCFDateFormatterNoStyle);
 
CFDateRef date = CFDateCreate(kCFAllocatorDefault, 123456);
CFStringRef dateAsString = CFDateFormatterCreateStringWithDate (
        kCFAllocatorDefault, formatter, date);
 
CFShow(dateAsString);
// outputs "2 Jan 2001"

Availability
Available in Mac OS X v10.3 and later.*/
CFDateFormatterRef CFDateFormatterCreate(
   CFAllocatorRef alloc,
   CFLocaleRef locale,
   CFDateFormatterStyle dateStyle,
   CFDateFormatterStyle timeStyle
){};

/*CFDateFormatterCreateStringWithDate

Returns a string representation of the given date using the specified date formatter.

CFStringRef CFDateFormatterCreateStringWithDate(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFDateRef date
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatter

The date formatter object that specifies the format of the returned string. 
date

The date object for which to create a string representation. 
Return Value

A new string that represents date in the specified format. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.3 and later.*/

CFStringRef CFDateFormatterCreateStringWithDate(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFDateRef date
){};

/*CFDateFormatterCreateStringWithAbsoluteTime

Returns a string representation of the given absolute time using the specified date formatter.

CFStringRef CFDateFormatterCreateStringWithAbsoluteTime(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFAbsoluteTime at
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
formatter

The date formatter object that specifies the format of the returned string. 
at

The absolute time for which to generate a string representation.
Return Value

A new string that represents at in the specified format. Returns NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.3 and later.*/

CFStringRef CFDateFormatterCreateStringWithAbsoluteTime(
   CFAllocatorRef alloc,
   CFDateFormatterRef formatter,
   CFAbsoluteTime at
){};

