#include <CoreFoundation/CoreFoundation.h>

//work


/*CFMessagePortCreateRemote

Returns a CFMessagePort object connected to a remote port.

CFMessagePortRef CFMessagePortCreateRemote (
   CFAllocatorRef allocator,
   CFStringRef name
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name of the remote message port to which to connect. 
Return Value

The new CFMessagePort object, or NULL on failure. If a message port has already been created for the remote port, the pre-existing object is returned. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateRemote (
   CFAllocatorRef allocator,
   CFStringRef name
){};

/*CFMessagePortSendRequest

Sends a message to a remote CFMessagePort object.

SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote,
   SInt32 msgid,
   CFDataRef data,
   CFTimeInterval sendTimeout,
   CFTimeInterval rcvTimeout,
   CFStringRef replyMode,
   CFDataRef *returnData
);
Parameters
remote

The message port to which data should be sent.
msgid

An arbitrary integer value that you can send with the message.
data

The data to send to remote.
sendTimeout

The time to wait for data to be sent.
rcvTimeout

The time to wait for a reply to be returned.
replyMode

The run loop mode in which the function should wait for a reply. If the message is a oneway (so no response is expected), then replyMode should be NULL. If replyMode is non-NULL, the function runs the run loop waiting for a reply, in that mode. replyMode can be any string name of a run loop mode, but it should be one with input sources installed. You should use the kCFRunLoopDefaultMode constant unless you have a specific reason to use a different mode.
returnData

Upon return, contains a CFData object containing the reply data. Ownership follows the Create Rule. 
Return Value

Error code indicating success or failure. See “CFMessagePortSendRequest Error Codes” for the possible return values.
Availability
Available in Mac OS X v10.0 and later.*/

SInt32 CFMessagePortSendRequest (
   CFMessagePortRef remote,
   SInt32 msgid,
   CFDataRef data,
   CFTimeInterval sendTimeout,
   CFTimeInterval rcvTimeout,
   CFStringRef replyMode,
   CFDataRef *returnData
){};


/*CFMessagePortCreateLocal

Returns a local CFMessagePort object.

CFMessagePortRef CFMessagePortCreateLocal (
   CFAllocatorRef allocator,
   CFStringRef name,
   CFMessagePortCallBack callout,
   CFMessagePortContext *context,
   Boolean *shouldFreeInfo
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
name

The name with which to register the port. name can be NULL. 
callout

The callback function invoked when a message is received on the message port. 
context

A structure holding contextual information for the message port. The function copies the information out of the structure, so the memory pointed to by context does not need to persist beyond the function call. 
shouldFreeInfo

A flag set by the function to indicate whether the info member of context should be freed. The flag is set to true on failure or if a local port named name already exists, false otherwise. shouldFreeInfo can be NULL. 
Return Value

The new CFMessagePort object, or NULL on failure. If a local port is already named name, the function returns that port instead of creating a new object; the context and callout parameters are ignored in this case. Ownership follows the Create Rule.
Availability
Available in Mac OS X v10.0 and later.*/
CFMessagePortRef CFMessagePortCreateLocal (
   CFAllocatorRef allocator,
   CFStringRef name,
   CFMessagePortCallBack callout,
   CFMessagePortContext *context,
   Boolean *shouldFreeInfo
){};

/*CFMessagePortCreateRunLoopSource

Creates a CFRunLoopSource object for a CFMessagePort object.

CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFMessagePortRef ms,
   CFIndex order
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
ms

The message port for which to create a run loop source. 
order

A priority index indicating the order in which run loop sources are processed. order is currently ignored by CFMessagePort object run loop sources. Pass 0 for this value. 
Return Value

The new CFRunLoopSource object for ms. Ownership follows the Create Rule.
Discussion

The run loop source is not automatically added to a run loop. To add the source to a run loop, use CFRunLoopAddSource.
Availability
Available in Mac OS X v10.0 and later.*/

CFRunLoopSourceRef CFMessagePortCreateRunLoopSource (
   CFAllocatorRef allocator,
   CFMessagePortRef ms,
   CFIndex order
){};


/*CFMessagePortInvalidate

Invalidates a CFMessagePort object, stopping it from receiving or sending any more messages.

void CFMessagePortInvalidate (
   CFMessagePortRef ms
);
Parameters
ms

The message port to invalidate. 
Discussion

Invalidating a message port prevents the port from ever sending or receiving any more messages. The message port is not deallocated, though. If the port has not already been invalidated, the port’s invalidation callback function is invoked, if one has been set with CFMessagePortSetInvalidationCallBack. The CFMessagePortContext info information for ms is also released, if a release callback was specified in the port’s context structure. Finally, if a run loop source was created for ms, the run loop source is invalidated, as well.
Availability
Available in Mac OS X v10.0 and later.*/
void CFMessagePortInvalidate (
   CFMessagePortRef ms
){};


