#import <DiscRecordingEngine/DRCoreObject.h>
//work
/*DRSetRefCon


Sets the Disc Recording object's reference context value. 
extern void DRSetRefCon(
    DRTypeRef ref,
    void*refCon,
    const DRRefConCallbacks*callbacks) ;  
Parameters
ref
A generic reference to any Disc Recording object whose reference context you want to set.
refCon
The reference context value to set for the Disc Recording object. If the the Disc Recording object's reference context is not NULL when a new value is set, the previous refCon value will be released using the release callback previously set, if any. The new refCon value will be retained by the Disc Recording object using the retain callback previously set, if any. 

You may pass a value of NULL, which results in the Disc Recording object having no value in its reference context.
callbacks
A pointer to a DRRefConCallbacks structure initialized with the callbacks for the Disc Recording object to use on its reference context. A copy of the contents of the callbacks structure is made, so that a pointer to a structure on the stack can be passed in, or can be reused for multiple object references. 

If the structure's version field does not contain a known value, this function's behavior is undefined. The retain field may be NULL, in which case the Disc Recording object will not retain the reference context when set. The release field may also be NULL, in which case the Disc Recording object will not release its reference context when the object is destroyed or when a new reference context value is set. 

If this parameter itself is NULL, this function behaves as if a valid structure of version 0 and with all fields NULL had been passed in. 

If any of the callback structure's fields are not valid pointers to functions of the correct type, or if this parameter is not a valid pointer to a DRRefConCallbacks callbacks structure, this function's behavior is undefined.
Availability
Introduced in Mac OS X v10.2*/
void DRSetRefCon(
    DRTypeRef ref,
    void*refCon,
    const DRRefConCallbacks*callbacks){} ;  


/*DRGetRefCon


Gets the Disc Recording object's reference context value. 
extern void* DRGetRefCon(
    DRTypeRef ref) ;  
Parameters
ref
A generic reference to any Disc Recording object whose refCon value you want to get.
Return Value

The value currently stored in the Disc Recording object's reference context. 
Availability
Introduced in Mac OS X v10.2*/
void* DRGetRefCon(
    DRTypeRef ref){} ;  


