#import <Foundation/NSXMLNode.h>
#import <Foundation/NSXMLElement.h>
//work
 @implementation  NSXMLElement

/*addChild:

Adds a child node at the end of the receiver’s current list of children.

- (void)addChild:(NSXMLNode *)child
Parameters
child

An XML node object to add to the receiver's children.
Discussion

The new node has an index value that is one greater than the last of the current children.
Availability
Available in Mac OS X v10.4 and later.
See Also
– insertChild:atIndex:
– removeChildAtIndex:
– replaceChildAtIndex:withNode:
– setChildren:*/
- (void)addChild:(NSXMLNode *)child{}

/*insertChild:atIndex:

Inserts a new child node at a specified location in the receiver’s list of child nodes.

- (void)insertChild:(NSXMLNode *)child atIndex:(unsigned int)index
Parameters
child

An XML node object to be inserted as a child of the receiver.
index

An integer identifying a position in the receiver's list of children. An exception is raised if index is out of bounds. 
Discussion

Insertion of the node increments the indexes of sibling nodes after it. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– addChild:
– insertChildren:atIndex:
– removeChildAtIndex:
– replaceChildAtIndex:withNode:
– setChildren:*/
- (void)insertChild:(NSXMLNode *)child atIndex:(unsigned int)index{}


/*attributeForName:

Returns the attribute node of the receiver with the specified name.

- (NSXMLNode *)attributeForName:(NSString *)name
Parameters
name

A string specifying the name of an attribute.
Return Value

An XML node object representing a matching attribute or nil if no such node was found. 
Discussion

If name is a qualified name, then this method invokes attributeForLocalName:URI: with the URI parameter set to the URI associated with the prefix. Otherwise comparison is based on string equality of the qualified or non-qualified name.
Availability
Available in Mac OS X v10.4 and later.
See Also
– attributes
– removeAttributeForName:
– setAttributes:*/

- (NSXMLNode *)attributeForName:(NSString *)name{}


/*addAttribute:

Adds an attribute node to the receiver.

- (void)addAttribute:(NSXMLNode *)anAttribute
Parameters
anAttribute

An XML node object representing an attribute. If the receiver already has an attribute with the same name, anAttribute is not added.
Discussion

The order of multiple attributes is preserved if the NSXMLPreserveAttributeOrder option is specified when the element is created.
Availability
Available in Mac OS X v10.4 and later.
See Also
– attributeForName:
– attributes
– removeAttributeForName:
– setAttributes:*/
- (void)addAttribute:(NSXMLNode *)anAttribute{}




@end