#include <HIToolbox/HIToolbox.h>


/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (TXNObject iTXNObject){
printf ("TXNRevert",iTXNObject);
};

/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject){
printf ("TXNPageSetup",iTXNObject);
};

/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject){
printf ("TXNPrint",iTXNObject);
};



/*TXNNewObject

Creates a new MLTE text object which is an opaque structure that handles text formatting at the document level. (Deprecated in Mac OS X v10.3. Use TXNCreateObject instead.)

Not recommended.

OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon
);
Parameters
iFileSpec

A pointer to a variable of type FSSpec. If you pass NULL you start with an empty document. Otherwise, the contents of the file to which iFileSpec points are read into the object. The referenced file must consist entirely of data that MLTE can read ('TEXT', 'RTF ', 'utxt', or 'txtn'). If the referenced file contains your application’s private data and data that MLTE can read, you should call the TXNNewObject function with the iFileSpec parameter set to NULL. Once TXNNewObject creates the text object, your application can read the private data into the text object by calling the TXNSetDataFromFile function. 
iWindow

A reference to the window in which the document will be displayed. This parameter can be NULL. If it is NULL, you must attach a window or graphics port to the text object by using the TXNAttachObjectToWindow function. 
iFrame

A pointer to a variable of type Rect. If you pass NULL, the window’s portRect rectangle is used as the frame. If you do not want to fill the entire window, you use the iFrame parameter to specify the area to fill. 
iFrameOptions

A value that specifies the options you want the frame to support. See Frame Option Masks for a description of possible values. 

If you want to create a read-only document, you need to pass the option kTXNReadOnlyMask. Note that this option puts the text object into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically, you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag. If you choose to set the text object into this restrictive state, you will get an error if you try to call the function TXNSetData on the text object. (In this case, you can change the text object to a less restrictive state by calling TXNSetTXNObjectControls, passing the tag kTXNNoUserIOTag.)
iFrameType

A value that specifies the frame type of the text object. See Supported Frame Types for a description of possible values. 
iFileType

A value that specifies the file type of the text object. See Supported File Types for a description of possible values. You should specify the primary file type. If you use the kTXNTextensionFile constant, files are saved in a custom format. If you want saved files to be plain text files, you should specify the kTXNTextFile constant, then use the iframeOptions parameter to specify whether the plain text files should be saved with kTXNSingleStylePerTextDocumentResType or kTXNMultipleStylesPerTextDocumentResType resources. 
iPermanentEncoding

A value that specifies the encoding in which the document is saved. See Text Encoding Preferences for a description of possible values. 
oTXNObject

A pointer to a structure of type TXNObject. On return, this points to the opaque text object data structure allocated by the function. You need to pass this object to most MLTE functions. 
oTXNFrameID

On return, a pointer to the unique ID for the text object’s frame. However, in MLTE version 1.1 and earlier, the frame ID is always set to 0. 
iRefCon

A value of type TXNObjectRefcon. You can define how to use this for your application. You can set this to any value and retrieve it later. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For each document, a new text object is allocated by the TXNNewObject function and returned in the oTXNObject parameter. The object is allocated only if no errors occur, including errors that may occur when reading a file. If there is an error during the allocation process, MLTE frees the text object. 

If you are writing a text editing application, you may want to call the TXNNewObject function when the application launches (a new document will be displayed) and whenever the user selects New from the File menu. 

Many MLTE functions require you to pass a text object; some functions also require the frame ID supplied back to your application in the oTXNFrameID parameter of TXNNewObject.

Because of how MLTE uses Carbon events internally, the window in which the document is displayed must have the standard event handlers installed. You can do this in one of the following ways:
When you create the window, add the attribute kWindowStandardHandlerAttribute to the window. See Inside Mac OS X: Window Manager Reference for more information.
Call the Carbon Event Manager function InstallStandardEventHandler on the window's event target. See Inside Mac OS X: Handling Carbon Events for more information.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNNewObject (
   const FSSpec *iFileSpec,
   WindowRef iWindow,
   const Rect *iFrame,
   TXNFrameOptions iFrameOptions,
   TXNFrameType iFrameType,
   TXNFileType iFileType,
   TXNPermanentTextEncodingType iPermanentEncoding,
   TXNObject *oTXNObject,
   TXNFrameID *oTXNFrameID,
   TXNObjectRefcon iRefCon
){
printf ("TXNNewObject",*iFileSpec,iWindow,*iFrame,iFrameOptions,iFrameType,iFileType,iPermanentEncoding,*oTXNObject,*oTXNFrameID,iRefCon);
};


/*TXNIsScrapPastable

Tests whether the Clipboard contains data that is supported by MLTE. 

Boolean TXNIsScrapPastable ();
Return Value

Returns true if the data type on the Clipboard is supported.
Discussion

You can call the TXNIsScrapPastable function to determine if the Paste item in the Edit menu should be active. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
Boolean TXNIsScrapPastable (){
printf ("TXNIsScrapPastable");
};


/*TXNDataSize

Reports the amount of memory used to hold the text in a given text object.

ByteCount TXNDataSize (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that you want to examine.
Return Value

The number of bytes required to hold the characters.
Discussion

You can use this function to determine how large a handle should be if, for example, you copy text. Note that because every individual sound, picture, or movie in a text object is represented by a single character in the text buffer, the TXNDataSize function returns a value that does not necessarily represent the true size of any non-text data.

If you are using Unicode and you want to know the number of characters, divide the returned ByteCount value by sizeof(UniChar) or 2, since MLTE uses the 16-bit Unicode Transformation Format (UTF-16). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
ByteCount TXNDataSize (
   TXNObject iTXNObject
){
printf ("TXNDataSize",iTXNObject);
};


/*TXNGetSelection

Gets the absolute offsets of the current selection. 

void TXNGetSelection (
   TXNObject iTXNObject,
   TXNOffset * oStartOffset,
   TXNOffset * oEndOffset
);
Parameters
iTXNObject

The text object for the current text area. 
oStartOffset

On return, a pointer to the absolute starting offset of the current selection. 
oEndOffset

On return, a pointer to the absolute ending offset of current selection.
Discussion

Offsets in MLTE are always character offsets. Each embedded graphics or sound object is counted as one character. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNGetSelection (
   TXNObject iTXNObject,
   TXNOffset * oStartOffset,
   TXNOffset * oEndOffset
){
printf ("TXNGetSelection",iTXNObject,*oStartOffset,*oEndOffset);
};

/*TXNSetBackground

Sets the background on which the text object’s data is drawn. 

OSStatus TXNSetBackground (
   TXNObject iTXNObject,
   const TXNBackground * iBackgroundInfo
);
Parameters
iTXNObject

The text object that identifies the document to be activated. 
iBackgroundInfo

A pointer to a structure that describes the background. 
Return Value

A result code. See “MLTE Result Codes”.
Version Notes

MLTE supports only color as the background. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetBackground (
   TXNObject iTXNObject,
   const TXNBackground * iBackgroundInfo
){
printf ("TXNSetBackground",iTXNObject,*iBackgroundInfo);
};


/*TXNSetTXNObjectControls

Sets formatting and privileges attributes (such as justification, line direction, tab values, and read-only status) that apply to the entire text object.

OSStatus TXNSetTXNObjectControls (
   TXNObject iTXNObject,
   Boolean iClearAll,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   const TXNControlData iControlData[]
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set formatting and privileges attributes. 
iClearAll

A Boolean value. If you set this to true, all formatting and privileges attributes are reset to their default value. That is, true clears existing tags and resets each to its default value. 
iControlCount

The number of items in the iControlTags array. 
iControlTags

An array of values that specifies kind of data that is passed in the iControlData parameter. See Formatting and Privileges Settings for a description of possible values. On systems that use Apple Type Services for Unicode Imaging (ATSUI), you can also pass any of the following ATSUI attribute tag constants:
kATSULineDirectionTag
kATSULineJustificationFactorTag
kATSULineFlushFactorTag
kATSULineBaselineValuesTag
kATSULineLayoutOptionsTag
kATSUCGContextTag

See the ATSUI documentation for a description of these ATSUI constants.
iControlData

An array of TXNControlData unions that contain the information your application wants to set. The value you supply to the iControlTags parameter specifies how the union of type TXNControlData is treated. You must make sure that the value you assign to the iControlData parameter is the appropriate type implied by the value you passed in the iControlTags parameter. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

On systems that use Apple Type Services for Unicode Imaging (ATSUI), the ATSUI line control attribute tags can be passed to this function in the iControlTag parameter. This is the case for all the ATSUI tags except kATSULineRotationTag. ATSUI tags are applied to the entire text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetTXNObjectControls (
   TXNObject iTXNObject,
   Boolean iClearAll,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   const TXNControlData iControlData[]
){
printf ("TXNSetTXNObjectControls",iTXNObject,iClearAll,iControlCount,iControlTags,iControlData);
};



/*TXNCanRedo

Returns whether the most recently undone action is redoable and indicates the type of action that can be redone. (Deprecated in Mac OS X v10.4. Use TXNCanRedoAction instead.)

Not recommended.

Boolean TXNCanRedo (
   TXNObject iTXNObject,
   TXNActionKey * oTXNActionKey
);
Parameters
iTXNObject

The text object for the document you want to examine. 
oTXNActionKey

A pointer to a value of type TXNActionKey. On return, this value specifies the action that can be redone. See Action Constants for a description of possible values. You can use this information to customize the Redo menu item for the specific action to be redone. For example, if the value obtained by TXNCanRedo is kTXNTypingAction, you can map that value to a string that reads “Redo Typing” on a system localized for U.S. English. MLTE does not perform the mapping your program is responsible for mapping the key to the appropriate localized string you want displayed to the user. Pass NULL if you do not want to obtain this information. 
Return Value

A Boolean value. If true, the last command is redoable; otherwise the last command cannot be redone. 
Discussion

You can call the TXNCanRedo function to determine whether the Redo item in the Edit menu should be enabled. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
Boolean TXNCanRedo (
   TXNObject iTXNObject,
   TXNActionKey * oTXNActionKey
){
printf ("TXNCanRedo",iTXNObject,*oTXNActionKey);
};


/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset){
printf ("TXNSetDataFromCFURLRef",iTXNObject,iURL,iStartOffset,iEndOffset);
};


/*TXNWriteRangeToCFURL

Writes a range of a text object to a file or to a special file bundle.

OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);
Parameters
iTXNObject

The text object having a range that is to be written.
iStartOffset

The offset in iTXNObject at which to start writing data to iFileURL.
iEndOffset

The offset in iTXNObject at which to stop writing data to iFileURL. 
iDataOptions

A CFDictionaryRef that specifies options for writing out the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is written out using MLTE’s native format.
iDocumentAttributes

The document attributes that are to be embedded in the data stream. This parameter is only supported when writing out the data using one of the following formats: RTF and MLTE native format. Only the key / values defined in Document Attribute Keys are written out. The content of the dictionary is ignored for any other format. If the dictionary is NULL, no attributes are added to the data stream.
iFileURL

CFURLRef for an existing file or directory, whichever is appropriate for the file type. On return, iFileURL contains a copy of the data in the given range for the iTXNObject with the format and encoding specified by iDataOptions. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function writes a range of a text object to a file or a special file bundle (directory). It supports several document formats and encodings, which can be specified in the data options dictionary. Clients can specify additional document attributes when data is written out using a file format, such as RTF and native MLTE file format) that supports such attributes.
Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
){
printf ("TXNWriteRangeToCFURL",iTXNObject,iStartOffset,iEndOffset,iDataOptions,iDocumentAttributes,iFileURL);
};


/*TXNAttachObjectToWindowRef

Attaches a text object to a window.

OSStatus TXNAttachObjectToWindowRef (
   TXNObject iTXNObject,
   WindowRef iWindowRef
);
Parameters
iTXNObject

The text object with which you want to associate the window. You can call the function TXNCreateObject to allocate a text object.
iWindowRef

A WindowRef that specifies the window to which you want to attach the text object. 
Return Value

A result code. See “MLTE Result Codes”. Returns paramErr if the text object that you pass is invalid.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNAttachObjectToWindowRef (
   TXNObject iTXNObject,
   WindowRef iWindowRef
){
printf ("TXNAttachObjectToWindowRef",iTXNObject,iWindowRef);
};


/*TXNGetViewRect

Gets the rectangle that describes the current view of the document. 

void TXNGetViewRect (
   TXNObject iTXNObject,
   Rect *oViewRect
);
Parameters
iTXNObject

The text object for the current text area. 
oViewRect

On return, a pointer to a rectangle that describes the view of the document. The area described by the oViewRect parameter does not include the area that encloses the scroll bars. The coordinates of this rectangle are local to the window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNGetViewRect (
   TXNObject iTXNObject,
   Rect *oViewRect
){
printf ("TXNGetViewRect",iTXNObject,*oViewRect);
};



/*TXNGetRectBounds

Obtains the values for the current view, destination, and text rectangles. (Deprecated in Mac OS X v10.3. Use TXNGetHIRect instead.)

Not recommended.

OSStatus TXNGetRectBounds (
   TXNObject iTXNObject,
   Rect * oViewRect,
   TXNLongRect * oDestinationRect,
   TXNLongRect * oTextRect
);
Parameters
iTXNObject

The text object for the current text area. 
oViewRect

On output, a pointer to the Rect data structure that contains the coordinates for the view rectangle. If you do not want to obtain this structure, pass NULL. The view rectangle specifies the area of the text you see. Scroll bars are drawn inside the view rectangle.
oDestinationRect

On output, a pointer to the TXNLongRect data structure that contains the coordinates for the destination rectangle. If you do not want to obtain this structure, pass NULL. The destination rectangle controls how text is laid out. 
oTextRect

On output, a pointer to the TXNLongRect data structure that contains the coordinates for the text rectangle. If you do not want to obtain this structure, pass NULL. The text rectangle is the smallest rectangle needed to contain the current text. MLTE calculates the text rectangle by measuring each line of text. So this can be slow performance. The width of the text rectangle is the width of the longest line in the text.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You need only to pass pointers for the rectangles for which you want to obtain coordinates.
Availability
Available in Mac OS X v10.1 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNGetRectBounds (
   TXNObject iTXNObject,
   Rect * oViewRect,
   TXNLongRect * oDestinationRect,
   TXNLongRect * oTextRect
){
printf ("TXNGetRectBounds",iTXNObject,*oViewRect,*oDestinationRect,*oTextRect);
};

/*TXNCreateObject

Creates a new MLTE text object which is an opaque structure that handles text formatting at the document level.

OSStatus TXNCreateObject (
   const HIRect    *iFrameRect,
   TXNFrameOptions iFrameOptions,
   TXNObject       *oTXNObject
);
Parameters
iFrameRect

A pointer to a rectangle used to specify the destination and view rectangles for the text object. Pass NULL if you want to use the window port rectangle as the view and destination rectangles when the object is attached later to a window. See the function TXNAttachObjectToWindowRef. 
iFrameOptions

A value that specifies the options you want the frame to support. See Frame Option Masks for a description of possible values. 
oTXNObject

On input, a pointer to a structure of type TXNObject. On output, points to the opaque text object data structure allocated by the function. You need to pass this object to most MLTE functions.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For each document, a new text object is allocated by the TXNCreateObject function and returned in the oTXNObject parameter. The object is allocated only if no errors occur. If there is an error during the allocation process, MLTE frees the text object. 

If you are writing a text editing application, you may want to call the TXNCreateObject function when the application launches (a new document will be displayed) and whenever the user selects New from the File menu. In addition, many MLTE functions require you to pass a text object.

If you want to create a read-only document, you need to pass the option kTXNReadOnlyMask in the iFrameOptions parameter. Note that this option puts the text object into a state that does not allow user input. However, your application can put data into the text object by calling the function TXNSetData. If you want the text object set into a more restrictive read-only state that does not allow user input or your application to put data into the text object programmatically, you need to call the function TXNSetTXNObjectControls, passing the tag kTXNIOPrivilegesTag. If you choose to set the text object into this restrictive state, you will get an error if you try to call the function TXNSetData on the text object. (In this case, you can change the text object to a less restrictive state by calling TXNSetTXNObjectControls, passing the tag kTXNNoUserIOTag.)

Because of how MLTE uses Carbon events internally, the window in which the document is displayed must have the standard event handlers installed. You can install standard event handlers in one of the following ways:
When you create the window, add the attribute kWindowStandardHandlerAttribute to the window. See Window Manager Reference for more information.
Call the Carbon Event Manager function InstallStandardEventHandler on the window's event target. See Handling Carbon Events for more information.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNCreateObject (
   const HIRect    *iFrameRect,
   TXNFrameOptions iFrameOptions,
   TXNObject       *oTXNObject
){
printf ("TXNCreateObject",*iFrameRect,iFrameOptions,*oTXNObject);
};


/*TXNSetRectBounds

Set the view rectangle and/or the destination rectangle. (Deprecated in Mac OS X v10.3. Use TXNSetHIRectBounds instead.)

Not recommended.

void TXNSetRectBounds (
   TXNObject iTXNObject,
   const Rect * iViewRect,
   const TXNLongRect * iDestinationRect,
   Boolean iUpdate
);
Parameters
iTXNObject

The text object for the current text area. 
iViewRect

A pointer to a Rect data structure that contains the new coordinates for the view rectangle. If you do not want to change the view rectangle pass NULL.
iDestinationRect

A pointer to a TXNLongRect data structure that contains the new coordinates for the destination rectangle. If you do not want to change the destination rectangle pass NULL.
iUpdate

Pass true if you want the text and location of the scroll bars recalculated and redrawn; otherwise pass false.
Discussion

You can specify coordinates for one or both rectangles. The view rectangle controls the text you see. The destination rectangle controls how text is laid out. Scroll bars are drawn inside the view rectangle.

If you set the iViewRect parameter to a location not currently represented by the scroll bar and you pass NULL for the iDestinationRect parameter, it becomes impossible to scroll to the left bounds of the destination rectangle. If you want to position the view rectangle inside the destination rectangle, you should supply a custom scrolling callback. See TXNScrollInfoProcPtr.
Availability
Available in Mac OS X v10.1 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
void TXNSetRectBounds (
   TXNObject iTXNObject,
   const Rect * iViewRect,
   const TXNLongRect * iDestinationRect,
   Boolean iUpdate
){
printf ("TXNSetRectBounds",iTXNObject,*iViewRect,*iDestinationRect,iUpdate);
};


/*TXNScroll

Scrolls the text within a view rectangle of the specified text object.

OSStatus TXNScroll(
   TXNObject       iTXNObject,
   TXNScrollUnit   iVerticalScrollUnit,
   TXNScrollUnit   iHorizontalScrollUnit,
   SInt32          *ioVerticalDelta,
   SInt32          *ioHorizontalDelta );
Parameters
iTXNObject

The text object whose text you want to scroll.
iVerticalScrollUnit

Specifies the units to use for the ioVerticalDelta parameter. Pass kTXNScrollUnitsInPixels to specify pixels, pass kTXNScrollUnitsInLines to specify a count of lines, and pass kTXNScrollUnitsInViewRects to specify the height of the current view rectangle (viewRect). Note that scrolling in line units is the slowest because each line must be measured by MLTE before the text scrolls. See Scroll Units for more information.
iHorizontalScrollUnit

Specifies the units to use for the ioHorizontalDelta parameter. Pass kTXNScrollUnitsInPixels to specify pixels, pass kTXNScrollUnitsInLines to specify a count of lines, and pass kTXNScrollUnitsInViewRects to specify the height of the current view rectangle (viewRect). Note that scrolling in line units is the slowest because each line must be measured by MLTE before the text scrolls. See Scroll Units for more information.
ioVerticalDelta

On input, the number of units by which to scroll in the vertical direction. You specify the units in the iVerticalScollUnit parameter. On output, the number of units actually scrolled in the vertical direction. A positive value indicates to move the text in a downward direction.
ioHorizontalDelta

On input, the number of units by which to scroll in the horizontal direction. You specify the units in the iHorizontalScollUnit parameter. On output, the number of units actually scrolled in the horizontal direction. A positive value indicates to move the text to the right.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

The function TXNScroll moves the text within the view rectangle of the specified text object by the designated number of units. You can use this function to scroll the text in a text object in response to user input in a control other than the standard scroll bars that MLTE supplies.
Availability
Available in Mac OS X v10.2 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNScroll(
   TXNObject       iTXNObject,
   TXNScrollUnit   iVerticalScrollUnit,
   TXNScrollUnit   iHorizontalScrollUnit,
   SInt32          *ioVerticalDelta,
   SInt32          *ioHorizontalDelta){
printf ("TXNScroll",iTXNObject,iVerticalScrollUnit,iHorizontalScrollUnit,*ioVerticalDelta,*ioHorizontalDelta);
};

/*NewTXNScrollInfoUPP

Creates a new universal procedure pointer (UPP) to a scrolling callback function.

TXNScrollInfoUPP NewTXNScrollInfoUPP (
   TXNScrollInfoProcPtr userRoutine
);
Return Value

A universal procedure pointer.
Discussion

See the callback TXNScrollInfoProcPtr for more information. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
MacTextEditor.h*/

TXNScrollInfoUPP NewTXNScrollInfoUPP (
  TXNScrollInfoProcPtr userRoutine)
{
printf ("NewTXNScrollInfoUPP",userRoutine);
};


/*TXNRegisterScrollInfoProc

Installs or uninstalls a scrolling callback function on a text object.

void TXNRegisterScrollInfoProc(
   TXNObject          iTXNObject,
   TXNScrollInfoUPP   iTXNScrollInfoUPP,
   SInt32             iRefCon
);
Parameters
iTXNObject

The text object on which you want to install a callback to scroll text.
iTXNScrollInfoUPP

A universal procedure pointer to the callback function you want MLTE to call whenever a scroll bar for the text object must be updated. 
iRefCon

A 32-bit value that is passed to your callback.
Discussion

You can call the function TXNRegisterScrollInfoProc to install a text-scrolling callback on a text object. This is useful if your application draws and handles its own scrolling widgets. Once you register your callback (TXNScrollInfoUPP), MLTE invokes your callback each time it is necessary to update the values and maximum values of your scrolling widget. For example when the user presses the Return key to add a new line, MLTE calculates a new maximum value for the text object. Your callback is then called with the newly-calculated maximum value. To turn off your callback call the function TXNRegisterScrollInfoProc with a value of NULL for the iTXNScrollInfoUPP parameter. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
MacTextEditor.h*/
void TXNRegisterScrollInfoProc(
   TXNObject          iTXNObject,
   TXNScrollInfoUPP   iTXNScrollInfoUPP,
   SInt32             iRefCon
){
printf ("TXNRegisterScrollInfoProc",iTXNObject,iTXNScrollInfoUPP,iRefCon);
};


/*TXNOffsetToPoint

Gets the local coordinates of the point that corresponds to a specified offset of a text object. (Deprecated in Mac OS X v10.3. Use TXNOffsetToHIPoint instead.)

Not recommended.

OSStatus TXNOffsetToPoint (
   TXNObject iTXNObject,
   TXNOffset iOffset,
   Point * oPoint
);
Parameters
iTXNObject

The text object for which you want to obtain the local coordinates of a point. 
iOffset

An offset value. 
oPoint

On return, a pointer to the local coordinates of the point that corresponds to the value of the iOffset parameter. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNOffsetToPoint (
   TXNObject iTXNObject,
   TXNOffset iOffset,
   Point * oPoint
){
printf ("TXNOffsetToPoint",iTXNObject,iOffset,*oPoint);
};


/*TXNHIPointToOffset

Gets the offset value that corresponds to a point in local coordinates.

OSStatus TXNHIPointToOffset (
   TXNObject iTXNObject,
   const HIPoint *iHIPoint,
   TXNOffset *oOffset
);
Parameters
iTXNObject

The text object for which you want to obtain an offset value. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iHIPoint

The local coordinates of the point for which you want to obtain the offset value. 
oOffset

On output, a pointer to the offset that corresponds to the value of the iHIPoint parameter. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNHIPointToOffset (
   TXNObject iTXNObject,
   const HIPoint *iHIPoint,
   TXNOffset *oOffset
){
printf ("TXNHIPointToOffset",iTXNObject,*iHIPoint,*oOffset);
};


/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd){
printf ("TXNShowSelection",iTXNObject,iShowEnd);
};

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
printf ("TXNSetSelection",iTXNObject,iStartOffset,iEndOffset);
};


/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
printf ("TXNSetData",iTXNObject,iDataType,iDataPtr,iDataSize,iStartOffset,iEndOffset);
};

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView){
printf ("HITextViewGetTXNObject",inTextView);
};




/*TXNGetWindowRef

Returns a reference to the window to which the specified text object is attached.

WindowRef TXNGetWindowRef (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for which you want to obtain a window reference. You can call the function TXNCreateObject to allocate a text object.
Return Value

The window to which the text object is attached. Returns NULL if no window is attached.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
WindowRef TXNGetWindowRef (
   TXNObject iTXNObject
){
printf ("TXNGetWindowRef",iTXNObject);
};

/*TXNInitTextension

Initializes MLTE. 

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
);
Parameters
iDefaultFonts

An array of TXNMacOSPreferredFontDescription structures. You use this to specify a table of font information that includes the font family ID, point size, style, and script code. The table can be NULL or can have an entry for any script for which you would like to designate a default font. To designate that MLTE should use the default settings for a specified script, you need to supply a valid script code value in the TextEncoding field of the font description structure and a value of kTXNUseScriptDefaultValue in all other fields of the structure. In Mac OS X, the default settings are read from the Theme settings. In Mac OS 9, the default settings are read from the Script Manager.
iCountDefaultFonts

The number of scripts for which you are designating a default font in the iDefaultFonts array. 
iUsageFlags

A value that specifies whether embedded objects should be supported. You can also specify whether MLTE should use QuickDraw as the imaging system and whether temporary memory should be used. See Initialization Option Masks for a description of possible values. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

For systems prior to Mac OS X v10.3, you should call this function along with any other initialization calls you make when your application starts up. If you call this function a second time, it has no effect; the defaults you set up the first time you called the TXNInitTextension function are in effect until you call the TXNTerminateTextension function.

For Mac OS X v10.3 and later, you do not have to call this function. However, you may want to call this function to set default fonts that are different from the system default font or to enable multimedia support.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/

OSStatus TXNInitTextension (
   const TXNMacOSPreferredFontDescription iDefaultFonts[],
   ItemCount iCountDefaultFonts,
   TXNInitOptions iUsageFlags
){
printf ("TXNInitTextension",iDefaultFonts,iCountDefaultFonts,iUsageFlags);
};


/*TXNPointToOffset

Gets the offset value that corresponds to a point in local coordinates. (Deprecated in Mac OS X v10.3. Use TXNHIPointToOffset instead.)

Not recommended.

OSStatus TXNPointToOffset (
   TXNObject iTXNObject,
   Point iPoint,
   TXNOffset * oOffset
);
Parameters
iTXNObject

The text object for which you want to obtain an offset value. 
iPoint

The local coordinates of a point. 
oOffset

On return, a pointer to the offset that corresponds to the value of the iPoint parameter. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNPointToOffset (
   TXNObject iTXNObject,
   Point iPoint,
   TXNOffset * oOffset
){
printf ("TXNPointToOffset",iTXNObject,iPoint,*oOffset);
};

/*TXNReadFromCFURL

Reads data from a CFURLRef into a TXNObject.

OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);
Parameters
iTXNObject

The text object into which data read from iFileURL is to be added.
iStartOffset

The offset in iTXNObject at which to start placing data read from iFileURL.
iEndOffset

The offset in iTXNObject at which to stop placing data read from iFileURL. 
iDataOptions

Options for reading the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is read in using MLTE’s native format.
iFileURL

A CFURLRef to the data that is to be added to the text object specified by inTXNObject.
oDocumentAttributes

A value of type CFDictionary that, on return, contains the document attributes present in the data stream, if the file format supports them; otherwise this parameter is NULL. The native MLTE file format and RTF support embedded document attributes. See Document Attribute Keys for a list of supported attributes. If this parameter is NULL, no document attributes are written out.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function reads data from a file or a special file bundle (directory) into a text object. Offset parameters are used to specify whether the new data is inserted, appended or replaces an existing data range in the text object. Clients can specify the document format and encoding of the data using the iDataOptions parameter. This functions also returns the document attributes present in the data stream. Document attributes are supported only for the rich text file formats supported by MLTE, which are RTF and MLTE native file format.

If the caller passes a pointer to a CFDictionaryRef, this function returns a reference to a dictionary of attributes, if there is one, that the caller is responsible for releasing. In all other cases, this function sets the reference to NULL. Here is some sample code:CFDictionaryRef oDocumentAttributes = NULL;
status = TXNReadFromCFRUL (....,&oDocumentAttributes);
if (oDocumentAttributes != NULL) ::CFReleases(oDocumentAttributes);

Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
){
printf ("TXNReadFromCFURL",iTXNObject,iStartOffset,iEndOffset,iDataOptions,iFileURL,*oDocumentAttributes);
};

/*TXNSetHIRectBounds

Sets the view rectangle and/or the destination rectangle.

void TXNSetHIRectBounds (
   TXNObject       iTXNObject,
   const HIRect    *iViewRect,
   const HIRect    *iDestinationRect,
   Boolean         iUpdate
);
Parameters
iTXNObject

The text object for the current text area. You can call the function TXNCreateObject to allocate a text object. 
iViewRect

A pointer to rectangle that contains the new coordinates for the view rectangle. If you do not want to change the view rectangle pass NULL. You cannot set the view rectangle for text objects into an HITextView, you can only set the destination rectangle.
iDestinationRect

A pointer to a rectangle that contains the new coordinates for the destination rectangle. If you do not want to change the destination rectangle pass NULL.
iUpdate

A value that specifies whether you want the text and scroll bars recalculated and redrawn. Pass true to recalculate and redraw; otherwise pass false. You must pass false for text objects into an HITextView.
Discussion

The view rectangle controls the text you see. The destination rectangle controls how text is laid out. You can specify coordinates for one or both rectangles. Scroll bars are drawn inside the view rectangle. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/

void TXNSetHIRectBounds (
   TXNObject       iTXNObject,
   const HIRect    *iViewRect,
   const HIRect    *iDestinationRect,
   Boolean         iUpdate
){
printf ("TXNSetHIRectBounds",iTXNObject,*iViewRect,*iDestinationRect,iUpdate);
};


/*TXNGetHIRect

Obtains the values for the current view, destination, or text rectangle.

OSStatus TXNGetHIRect (
   TXNObject  iTXNObject,
   TXNRectKey iTXNRectKey,
   HIRect      oRectangle
);
Parameters
iTXNObject

The text object for the current text area. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iTXNRectKey

A value that specifies the rectangle you want the function to obtain. See Rectangle Keys for a list of the constants you can supply.
oRectangle

On output, points to the HIRect data structure that contains the coordinates for the requested rectangle. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/

OSStatus TXNGetHIRect (
   TXNObject  iTXNObject,
   TXNRectKey iTXNRectKey,
   HIRect      oRectangle
){
printf ("TXNGetHIRect",iTXNObject,iTXNRectKey,oRectangle);
};



/*HITextViewCreate

Creates an HITextView that is initially invisible.

OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
);
Parameters
inBoundsRect

The bounding box of the view. Pass NULL, if you want to initialize the bounds of the view to 0.
inOptions

Reserved for future use; you must pass 0.
inTXNFrameOptions

The frame options you want to set for the text view. 
outTextView

On output, points to the newly-created text view. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

An HITextView is an MLTE text view that can be embedded in the HIView hierarchy. The view can be embedded in an HIScrollView if you want scroll bars and can also be used in a composited window. For more information on HIView, see the document Introducing HIView, available from the Apple Developer Documentation website.

When you call the function HITextViewCreate to create a text view, an MLTE text object (TXNObject) is allocated and attached to the text view. You can extract the text object by calling the function HITextViewGetTXNObject. You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. 

The following MLTE functions return an error if you pass a text object that comes from an HITextView:
TXNAttachObjectToWindowRef
TXNGetWindowRef
TXNDrawObject
TXNSetScrollbarState
TXNGrowWindow
TXNZoomWindow
TXNResizeFrame
TXNSetFrameBounds
TXNSetViewRect
TXNDraw
TXNFocus
TXNUpdate
TXNForceUpdate
TXNPageSetup
TXNPrint
TXNIdle
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
OSStatus HITextViewCreate(
   const HIRect    *inBoundsRect,
   OptionBits      inOptions,
   TXNFrameOptions inTXNFrameOptions,
   HIViewRef       *outTextView
){
printf ("HITextViewCreate",*inBoundsRect,inOptions,inTXNFrameOptions,*outTextView);
};



/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding){
//TODO
};


/*TXNDraw

Redraws the text area, including any scroll bars associated with the text frame. (Deprecated in Mac OS X v10.3. Use the TXNDrawObject .)

Not recommended.

void TXNDraw (
   TXNObject iTXNObject,
   GWorldPtr iDrawPort
);
Parameters
iTXNObject

The text object whose text is to be redrawn. 
iDrawPort

A value of type GWorldPtr. Pass a valid pointer or NULL. If you pass NULL, the TXNDraw function redraws the text area into the port that is currently associated with the text object. If you pass a valid pointer instead of NULL, TXNDraw redraws the text area into the specified port, and does not update the selection. You should pass NULL if you want to draw on the screen but pass a valid pointer if you want to take a snapshot of the screen to save or print. 
Discussion

You can call the TXNDraw function in response to an update event for a window that contains multiple text objects or other graphic elements. If necessary, your application is also responsible for calling the Window Manager functions BeginUpdate and EndUpdate in response to the update event.

If there is nothing in your window except a single MLTE text object, you should call the TXNUpdate function to redraw the area instead of calling TXNDraw. The TXNUpdate f unction draws everything in the frame, and you do not have to call the Window Manager functions BeginUpdate and EndUpdate yourself. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
void TXNDraw (
   TXNObject iTXNObject,
   GWorldPtr iDrawPort
){};

/*TXNSetFrameBounds

Changes the boundaries of a text object’s frame.

void TXNSetFrameBounds (
   TXNObject iTXNObject,
   SInt32 iTop,
   SInt32 iLeft,
   SInt32 iBottom,
   SInt32 iRight,
   TXNFrameID iTXNFrameID
);
Parameters
iTXNObject

The text object for the current text area. 
iTop

The top boundary of the rectangle. 
iLeft

The left boundary of the rectangle. 
iBottom

The bottom boundary of the rectangle. 
iRight

The right boundary of the rectangle. 
iTXNFrameID

The frame ID of the frame you want to move. You obtain a frame ID when you call the TXNNewObject function. 
Discussion

If you want to change the view and destination rectangles, you should call the TXNResizeFrame function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNSetFrameBounds (
   TXNObject iTXNObject,
   SInt32 iTop,
   SInt32 iLeft,
   SInt32 iBottom,
   SInt32 iRight,
   TXNFrameID iTXNFrameID
){};

/*TXNCopy

Copies the current selection to the private MLTE scrap.

OSStatus TXNCopy (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the current text area.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNCopy function to respond to a user-requested copy action. Before you call TXNCopy, you can use the TXNIsSelectionEmpty function to determine whether any text is selected. 

The TXNCopy function copies the current selection to the MLTE scrap. In a Carbon application, the Scrap Manager automatically converts your application’s private scrap to the Clipboard so it is available to other applications. In a Classic application, you must call the function TXNConvertToPublicScrap after you call TXNCopy. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNCopy (
   TXNObject iTXNObject
){};


/*TXNClick

Processes a mouse-down event in a window’s content area. 

void TXNClick (
   TXNObject iTXNObject,
   const EventRecord * iEvent
);
Parameters
iTXNObject

The text object in which the mouse-down event occurred.
iEvent

A pointer to the event record that contains the mouse-down event to process.
Discussion

When you pass the event to the TXNClick function, it responds to the user’s action by scrolling, selecting text, playing a sound or movie, handling a drag–and-drop operation, or responding to a double- or triple-click, as appropriate. Before you call TXNClick, you should make sure that the front window belongs to your application. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNClick (
   TXNObject iTXNObject,
   const EventRecord * iEvent
){};

/*TXNAdjustCursor

Obtains the current cursor position and draws the cursor in a form appropriate to the content over which it is placed.

void TXNAdjustCursor (
   TXNObject iTXNObject,
   RgnHandle ioCursorRgn
);
Parameters
iTXNObject

The text object that identifies the text area for which MLTE should adjust the cursor.
ioCursorRgn

A handle to a region created by your application. Pass NULL if you do not want TXNAdjustCursor to provide information about the cursor position to your application. If you do want to obtain the cursor’s current position, pass a valid region handle in this parameter. If you pass a valid region handle and the cursor is over the text area or its scroll bars, on return TXNAdjustCursor sets the region to a 2-pixel by 2-pixel square, centered on the cursor’s hot spot. If the cursor is not over the text area or its scroll bars, or if you have passed NULL, TXNAdjustCursor does not adjust the input value.
Discussion

If the cursor is over a text area, TXNAdjustCursor sets the cursor to an I-beam. If the cursor is over graphics, a sound file, a movie, a scroll bar, or outside of a window, TXNAdjustCursor sets the cursor to an arrow. Before you call the TXNAdjustCursor function, you should make sure that the window belongs to your application.

You can pass the region handle returned by the TXNAdjustCursor function in the ioCursorRgn parameter to the WaitNextEvent function; this ensures that you receive mouse-moved events if the cursor moves outside that region. If you then receive a mouse-moved event, you can call TXNAdjustCursor again to ensure that the cursor type is appropriate to its new position. Alternately, to ensure that the cursor is adjusted correctly, you can simply call TXNAdjustCursor with every event that your application receives. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNAdjustCursor (
   TXNObject iTXNObject,
   RgnHandle ioCursorRgn
){};


/*TXNConvertToPublicScrap

Converts the private MLTE scrap content to the Clipboard. (Deprecated in Mac OS X v10.3. This function isn't needed in Mac OS X.)

Not recommended.

OSStatus TXNConvertToPublicScrap ();
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNConvertToPublicScrap (){};


/*TXNConvertFromPublicScrap

Converts the Clipboard content to the private MLTE scrap. (Deprecated in Mac OS X v10.3. This function isn't needed in Mac OS X.)

Not recommended.

OSStatus TXNConvertFromPublicScrap ();
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You should call the TXNConvertFromPublicScrap function after another application has modified the contents of the Clipboard. Calling the TXNConvertFromPublicScrap function ensures that the contents of the system Clipboard are available to your application. Typically, when you receive a resume event, you call the Scrap Manager function GetCurrentScrap to determine whether the Clipboard content has been modified. If so, you should then call TXNConvertFromPublicScrap. 
Special Considerations

The function TXNConvertFromPublicScrap is no longer needed in Mac OS X version 10.2 and later. Calling the function TXNPaste automatically handles conversion from public scrap.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNConvertFromPublicScrap (){};


/*TXNCut

Deletes the current selection and copies it to the private MLTE scrap.

OSStatus TXNCut (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the current text area.
Return Value

A result code. See “MLTE Result Codes”.TXNCut also returns Scrap Manager errors.
Discussion

You can use the TXNCut function to respond to a user-requested cut action. Before you call TXNCut, you can use the TXNIsSelectionEmpty function to determine whether any text is selected. The TXNCut function deletes the current selection and then copies it to the private MLTE scrap. In a Carbon application, the Scrap Manager automatically converts your application’s private scrap to the Clipboard so it is available to other applications. In a Classic application, you must call the function TXNConvertToPublicScrap after you call TXNCut to move the selection to the Clipboard. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNCut (
   TXNObject iTXNObject
){};



/*TXNUndo

Undoes the last command. 

void TXNUndo (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the document you want to examine. 
Discussion

The undo stack is 32 levels deep. That is, undoable actions are tracked until the total count is 32. If a user undoes two actions, the Redo command must be used twice to get back to the original state. If more than 32 actions are performed, the oldest actions are forgotten as each new action takes place.

If the user performs a new action after choosing Redo from the Edit menu, the redone action is no longer available to be undone. For example, a user performs the following actions: types some text, cuts some text, pastes some text, types some text; undoes the last typing action, and undoes the paste operation; redoes the paste; types some new text. After the new text has been typed, the undo stack contains the first text that was typed, the cut action, and the new text that was just typed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNUndo (
   TXNObject iTXNObject
){};


/*TXNRedo

Redoes the last command.

void TXNRedo (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the document you want to examine. 
Discussion

If the user undoes an action and then undoes it again, the second undo is the same as a redo. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNRedo (
   TXNObject iTXNObject
){};


/*TXNGetTXNObjectControls

Gets the current formatting and privileges attributes (such as justification, line direction, tab values, and read-only status) for a text object.

OSStatus TXNGetTXNObjectControls (
   TXNObject iTXNObject,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   TXNControlData oControlData[]
);
Parameters
iTXNObject

The text object that identifies the document to be activated. 
iControlCount

The number of items in the iControlTags array. 
iControlTags

An array of values that specify the kind of formatting information you want returned in the oControlData array. See Formatting and Privileges Settings for a description of possible values. 
oControlData

An array of TXNControlData unions. On return, the array contains the information that was requested through the iControlTags array. Your application must allocate the oControlData array. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetTXNObjectControls (
   TXNObject iTXNObject,
   ItemCount iControlCount,
   const TXNControlTag iControlTags[],
   TXNControlData oControlData[]
){};


/*TXNClear

Deletes the current selection.

OSStatus TXNClear (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the current text area.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

To remove a selected object from a text area, a user can either press the Delete key or choose Clear from the Edit menu. Before you call the TXNClear function, you can use the TXNIsSelectionEmpty function to determine whether any text is selected. Unlike the function TXNCut, the TXNClear function does not add the deleted selection to the private MLTE scrap. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNClear (
   TXNObject iTXNObject
){};


/*TXNActivate

Sets the state of the scroll bars so they are drawn correctly in response to activate events. (Deprecated in Mac OS X v10.3. Use TXNSetScrollbarState instead.)

Not recommended.

OSStatus TXNActivate (
   TXNObject iTXNObject,
   TXNFrameID iTXNFrameID,
   TXNScrollBarState iActiveState
);
Parameters
iTXNObject

The text object that identifies the document to be activated. 
iTXNFrameID

The frame ID of the document that is to be activated. You obtain a frame ID from TXNNewObject when you create a text object. 
iActiveState

A value that indicates the state of the scroll bars. See Scroll Bar States for a description of possible values. If you pass the kScrollBarsAlwaysActive constant, the scroll bars are always active, whether or not the frame’s text area currently has keyboard focus. Passing kScrollBarsAlwaysActive can be useful for a window such as a dialog box that may contain multiple text areas, each of which may have a scrollable frame. If you pass kScrollBarsSyncWithFocus, MLTE synchronizes the activity state of the scroll bars with the focus state of the frame. Therefore, only when the frame has keyboard focus does it have active scroll bars. A value of kScrollBarsSyncWithFocus is the default and is typically recommended if you have only one frame per window. 
Return Value

A result code. See “MLTE Result Codes”. TXNActivate returns ParamErr if you pass an invalid text object or frame ID.
Discussion

You typically call TXNActivate in response to an activate event. If the text object was previously inactive, TXNActivate removes any visual indication of its prior inactive state (such as a dimmed or framed selection area or inactive scroll bars). Before you call the TXNActivate function, you should make sure that the window belongs to your application.

The TXNActivate function does not change the keyboard focus. This means your application can have a text area that is not focused, but in which the scroll bars are active. This lets application users scroll the inactive text without changing the focus from another text area.

If you want to display a text area that has both keyboard focus and active scroll bars, you must call the TXNFocus function immediately before you call the TXNActivate function. Note that MLTE does not retain information about keyboard focus. So if, for example, you set the keyboard focus on a text area and the window containing the text area becomes deactivated, you must call the TXNFocus function when the window becomes activated again. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
MacTextEditor.h*/
OSStatus TXNActivate (
   TXNObject iTXNObject,
   TXNFrameID iTXNFrameID,
   TXNScrollBarState iActiveState
){};



/*TXNFocus

Changes the focus of a text object.

void TXNFocus (
   TXNObject iTXNObject,
   Boolean iBecomingFocused
);
Parameters
iTXNObject

The text object whose focus you want to change.
iBecomingFocused

If you pass true, the text object receives focus. This means the current selection or insertion point is active, text input appears at the insertion point, and the keyboard and font are synchronized. (Note that the font and keyboard are synchronized only if keyboard synchronization is enabled. See Keyboard Synchronization Settings.) If the scroll bars are not already active, they are activated. If you pass false, the text object’s current selection or insertion point is inactive.
Discussion

You should use the TXNActivate function to make scroll bars active while text input is not focused. This behavior is often desirable for windows with multiple text areas that are scrollable. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNFocus (
   TXNObject iTXNObject,
   Boolean iBecomingFocused
){};

/*TXNDeleteObject

Deletes a previously allocated text object. 

void TXNDeleteObject (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object you want to delete.
Discussion

You should call the TXNDeleteObject function when you close the window associated with a text object. The function TXNDeleteObject releases the specified text object and all associated data structures from memory. If the object has multiple frames, all frames are deleted. 
Version Notes

Multiple frames are not yet implemented in MLTE.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNDeleteObject (
   TXNObject iTXNObject
){};


/*TXNCanUndo

Returns whether the most recent action is undoable and provides a value that indicates the type of action than can be undone. (Deprecated in Mac OS X v10.4. Use TXNCanUndoAction instead.)

Not recommended.

Boolean TXNCanUndo (
   TXNObject iTXNObject,
   TXNActionKey *oTXNActionKey
);
Parameters
iTXNObject

The text object for the document you want to examine. 
oTXNActionKey

A pointer to a value of type TXNActionKey. On return, this value identifies the action that can be undone. See Action Constants for a description of possible values. You can use this information to customize the Undo menu item for the specific action to be undone. For example, if the value obtained by TXNCanUndo is kTXNTypingAction, you can map that value to a string that reads “Undo Typing” on a system localized for U.S. English. MLTE does not perform such a mapping your program is responsible for mapping the key to the appropriate localized string you want displayed to the user. Pass NULL if you do not wish to obtain this information. 
Return Value

A Boolean value. If true, the last command is undoable; otherwise the last command cannot be undone. 
Discussion

You can call TXNCanUndo to determine whether the Undo item in the Edit menu should be enabled. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
Boolean TXNCanUndo (
   TXNObject iTXNObject,
   TXNActionKey *oTXNActionKey
){};





/*TXNPaste

Pastes the contents of the private MLTE scrap into the text object.

OSStatus TXNPaste (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the current document.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Before you call TXNPaste, you can call the TXNIsScrapPastable function to determine if the current scrap contains data supported by MLTE. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPaste (
   TXNObject iTXNObject
){};

