#include <HIToolbox/HIToolbox.h>

//#include <HIToolbox/MacWindows.h>

void  MacCloseWindow(WindowRef window){
printf ("MacCloseWindow",window);
};

WindowRef 
NewCWindow(
  void *             wStorage,
  const Rect *       boundsRect,
  ConstStr255Param   title,
  Boolean            visible,
  short              procID,
  WindowRef          behind,
  Boolean            goAwayFlag,
  long               refCon){
printf ("NewCWindow",wStorage,boundsRect,title,visible,procID,behind,goAwayFlag,refCon);
};


 void InitWindows(void){
printf ("InitWindows");
};


 void DrawGrowIcon(WindowRef window){
printf ("DrawGrowIcon",window);
};

WindowRef 
GetNewCWindow(
  short       windowID,
  void *      wStorage,
  WindowRef   behind){
printf ("GetNewCWindow",windowID,wStorage,behind);
};



/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible){
printf ("GetFrontWindowOfClass",inWindowClass,mustBeVisible);
};


/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if it’s not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ShowWindow (
   WindowRef window){
printf ("ShowWindow",window);
};


/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified){
printf ("SetWindowModified",window,modified);
};

/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits){
printf ("SetWindowResizeLimits",inWindow,*inMinLimits,*inMaxLimits);
};

/*SetThemeWindowBackground

Sets a window’s background theme.

OSStatus SetThemeWindowBackground (
   WindowRef inWindow,
   ThemeBrush inBrush
   Boolean inUpdate
);
Parameters
inWindow

The window whose background theme is to be set.
inBrush

The theme brush that determines how the window background is painted. For information on theme brushes, see the Appearance Manager documentation.
inUpdate

A Boolean whose value is true if you want the window to be redrawn immediately using the new background brush; otherwise, false.
Return Value

A result code. See “Window Manager Result Codes” for a list of possible values.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetThemeWindowBackground (
   WindowRef inWindow,
   ThemeBrush inBrush,
   Boolean inUpdate
){
printf ("SetThemeWindowBackground",inWindow,inBrush,inUpdate);
};

/*GetNewWindow

Creates a new monochrome window from a window resource. 

Not recommended

WindowRef GetNewWindow (
   short windowID,
   void * wStorage,
   WindowRef behind
);
Parameters
windowID

On input, the resource ID of the 'WIND' resource that defines the properties of the window. 
wStorage

On input, a pointer to memory space for the window structure. If you specify a value of null for wStorage, the GetNewWindow function allocates the window structure as a nonrelocatable object in the heap. You can reduce the chances of heap fragmentation by allocating the memory your application needs for window structures early in your initialization code. Whenever you need to create a window, you can allocate memory from your own block and pass a pointer to it in the wStorage parameter. 
behind

On input, a pointer to the window that appears immediately in front of the new window on the desktop. To place a new window in front of all other windows on the desktop, specify a value of (WindowRef)-1l. When you place a window in front of all others, GetNewWindow removes the highlighting from the previously active window, highlights the newly created window, and generates the appropriate activate events. Note that if you create an invisible window in front of all others on the desktop, the user sees no active window until you make the new window visible (or make another window active). To place a new window behind all other windows, specify a value of null. 
Return Value

A pointer to the newly created color window structure. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Discussion

The GetNewWindow function takes the same parameters as GetNewCWindow and returns a value of type WindowRef. The only difference is that it creates a monochrome graphics port, not a color graphics port, regardless of the presence of a corresponding ' wctb ' resource (it loads the resource but doesn’t use it). The window structure and graphics port structure that describe monochrome and color graphics ports are the same size and can be used interchangeably in most Window Manager functions. 

The GetNewWindow function creates a new window from the specified window resource and returns a pointer to the newly created window structure. You can use the returned window pointer to refer to this window in most Window Manager functions. If GetNewWindow is unable to read the window or window definition function from the resource file, it returns null.

If the window’s definition function (specified in the window resource) is not already in memory, GetNewWindow reads it into memory and stores a handle to it in the window structure. It allocates space in the application heap for the structure and content regions of the window. 

To create the window, GetNewWindow retrieves the window characteristics from the window resource and then calls the function NewWindow, passing the characteristics as parameters. 
Special Considerations

If you let the Window Manager create the window structure in your application’s heap, call DisposeWindow to dispose of the window structure. If you allocated the memory for the window structure yourself and passed a pointer to the storage to GetNewWindow, use CloseWindow to close the window and the appropriate disposal function (determined by how you have allocated memory) to dispose of the window structure.
Version Notes

The GetNewWindow function was originally implemented prior to Color QuickDraw. In Mac OS 8, you should call the Color QuickDraw function GetNewCWindow instead of GetNewWindow to programmatically create a window, because Color QuickDraw is always available in Mac OS 8. Use of this function is not recommended with Mac OS 8 and later. GetNewWindow is described here only for completeness.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

If you must get your window definition from a resource, use CreateWindowFromResource. Otherwise use CreateWindowFromNib or CreateNewWindow.
Declared In
MacWindows.h*/
WindowRef GetNewWindow (
   short windowID,
   void * wStorage,
   WindowRef behind
){
printf ("GetNewWindow",windowID,wStorage,behind);
};

/*RemoveWindowProxy

Dissociates a file from a window.

OSStatus RemoveWindowProxy (
   WindowRef window
);
Parameters
window

The window for which you want to remove the associated file.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The RemoveWindowProxy function redraws the window title bar after removing all data associated with a given file, including the proxy icon, path menu, and file data. 
Special Considerations

On Mac OS 8.x and Mac OS 9.x, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the RemoveWindowProxy function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus RemoveWindowProxy (
   WindowRef window
){
printf ("RemoveWindowProxy",window);
};



/*TransitionWindow

Shows, hides, moves, or resizes a window with appropriate animation and sound.

OSStatus TransitionWindow (
   WindowRef inWindow,
   WindowTransitionEffect inEffect,
   WindowTransitionAction inAction,
   const Rect * inRect
);
Parameters
inWindow

The window on which to act.
inEffect

The type of visual effect to use. TransitionWindow supports the Zoom, Slide, Fade, and Genie transition effects. The Slide effect is supported on Mac OS X and in CarbonLib 1.5 and later. The Fade and Genie effects are supported on Mac OS X v10.3 and later. See “Window Transition Effect Constants” for constants and descriptions of these effects.
inAction

The action to take. TransitionWindow supports the Show, Hide, Move, and Resize actions. The Move and Resize actions are supported on Mac OS X and in CarbonLib 1.5 and later. See “Window Transition Action Constants” for possible values.
inRect

A screen rect in global coordinates, or NULL for some transition actions.The interpretation of the rect is dependent on the transition action. For details, see the documentation for each action.

If you pass kWindowShowTransitionAction in the action parameter then, before calling TransitionWindow, set the rectangle to specify the dimensions and position, in global coordinates, of the area from which the zoom is to start. If you pass NULL, TransitionWindow uses the center of the display screen as the source rectangle.

If you pass kWindowHideTransitionAction in the action parameter then, before calling TransitionWindow, set the rectangle to specify the dimensions and position, in global coordinates, of the area at which the zoom is to end.

If you pass NULL, TransitionWindow uses the center of the display screen as the destination rectangle.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The TransitionWindow function displays an animation of a window’s transition between the open and closed states, such as that displayed by the Finder. TransitionWindow uses the rectangle specified in the rect parameter for one end of the animation (the source or the destination of the zoom, depending upon whether the window is being shown or hidden, respectively) and the window’s current size and position for the other end of the animation. TransitionWindow also plays sounds appropriate to the current theme for the opening and closing actions. 

Your application may use TransitionWindow instead of the functions ShowWindow and HideWindow. Like these pre–Mac OS 8.5 Window Manager functions, TransitionWindow generates the appropriate update and active events when it shows and hides windows. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus TransitionWindow (
   WindowRef inWindow,
   WindowTransitionEffect inEffect,
   WindowTransitionAction inAction,
   const Rect * inRect
){
printf ("TransitionWindow",inWindow,inEffect,inAction,*inRect);
};


/*SetWindowDockTileMenu

Associates a pop-up menu with a window. 

OSStatus SetWindowDockTileMenu (
   WindowRef inWindow,
   MenuRef inMenu
);
Parameters
inWindow

The window with which a pop-up menu is to be associated.
inMenu

The pop-up menu that is to be associated with the window specified by inWindow
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You specify a dock tile menu if you want to be able to present special selections when the user activates the pop-up menu associated with the window’s minimized dock tile. 
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus SetWindowDockTileMenu (
   WindowRef inWindow,
   MenuRef inMenu
){
printf ("SetWindowDockTileMenu",inWindow,inMenu);
};

/*GetWindowProxyFSSpec

Obtains a file system specification structure for the file that is associated with a window.

Not recommended

OSStatus GetWindowProxyFSSpec (
   WindowRef window,
   FSSpec * outFile
);
Parameters
window

A pointer to the window for which you wish to determine the associated file. 
outFile

On input, a pointer to an FSSpec structure. On return, this structure contains a copy of the file system specification data for the file associated with the specified window. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You can use the GetWindowProxyFSSpec function to obtain identifying information about a proxy file: its volume reference number, directory ID, and file name. 

See also the function SetWindowProxyFSSpec. 
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/
OSStatus GetWindowProxyFSSpec (
   WindowRef window,
   FSSpec * outFile
){
printf ("GetWindowProxyFSSpec",window,*outFile);
};


/*ValidWindowRgn

Removes a region from a window’s update region.

OSStatus ValidWindowRgn (
   WindowRef window,
   RgnHandle region
);
Parameters
window

The window containing the region you want to remove from the update region.
region

Set this region to specify, in local coordinates, the area to be removed from the window’s update region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The ValidWindowRgn function informs the Window Manager that an area of a window no longer needs to be redrawn. The ValidWindowRgn function is similar to the ValidRgn function, but ValidWindowRgn allows the window that it operates upon to be explicitly specified, instead of operating on the current graphics port, so ValidWindowRgn does not require the graphics port to be set before its use. 

See also the functions InvalWindowRgn and ValidWindowRect. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ValidWindowRgn (
   WindowRef window,
   RgnHandle region
){
printf ("ValidWindowRgn",window,region);
};


/*CopyWindowTitleAsCFString

Copies the window title into a Core Foundation string.

OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);
Parameters
inWindow

The window whose title is to be copied.
outString

On output, the window’s title. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString){
printf ("CopyWindowTitleAsCFString",inWindow,*outString);
};

/*CreateNewWindow

Creates a window from parameter data.

OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
windowClass

A constant that categorizes the class of window to be created. For certain classes, the window class can be altered after the window is created by calling HIWindowChangeClass. See “Window Class Constants” for a description of possible values for this parameter.
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes.
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region.
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateNewWindow function creates a window based on the attributes and class you specify in the attributes and windowClass parameters. CreateNewWindow sets the new window’s content region to the size and location specified by the rectangle passed in the bounds parameter, which in turn determines the dimensions of the entire window. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateNewWindow, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow){
printf ("CreateNewWindow",windowClass,attributes,*contentBounds,*outWindow);
};


/*RepositionWindow

Positions a window relative to another window or a display screen.

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);
Parameters
window

The window whose position you want to set.
parentWindow

A pointer to the “parent” window, as defined by your application. In cases where the window positioning method does not require a parent window, you should set the parentWindow parameter to NULL.
method

A constant specifying the window positioning method to be used; see “Window Position Constants” for descriptions of possible values. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application may call the RepositionWindow function to position any window, relative to another window or to a display screen. After positioning the window, RepositionWindow displays the window in its new position.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method){
printf ("RepositionWindow",window,parentWindow,method);
};

/*SetWindowProxyFSSpec

Associates a file with a window.

Not recommended

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);
Parameters
window

A pointer to the window with which the specified file is to be associated. 
inFile

Set the file system specification structure to contain the data for the file to associate with the specified window. You can obtain an FSSpec structure by calling the function GetWindowProxyFSSpec. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application should call the SetWindowProxyFSSpec function to establish a proxy icon for a given window. The creator code and file type of the file associated with a window determine the proxy icon that is displayed for the window.

Because the SetWindowProxyFSSpec function won’t work without a saved file, you must establish the initial proxy icon for a new, untitled window with the function SetWindowProxyCreatorAndType , which requires that you know the file type and creator code for the file, but does not require that the file have been saved.

See also the function SetWindowProxyAlias. 
Special Considerations

With Mac OS 8.5, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the SetWindowProxyFSSpec function.
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile){
printf ("SetWindowProxyFSSpec",window,*inFile);
};



/*GetNextWindowOfClass

Obtains the next window in a given window group. 

WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindow

The window at which to start.
inWindowClass

The class of window to obtain. If you pass kAllWindowClasses, the function returns the window directly behind the input window. If no windows exist behind the front window, the function returns NULL. 
mustBeVisible

If set to true, this function returns the next visible window of the specified window class. If set to false, this function returns the next window of the specified window class, regardless of whether it is visible.
Return Value

A reference for the next window of the specified class after the window specified by inWindow.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible){
printf ("GetNextWindowOfClass",inWindow,inWindowClass,mustBeVisible);
};

/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef){
printf ("HIWindowSetProxyFSRef",inWindow,*inRef);
};

/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (
   WindowRef window){
printf ("HideWindow",window);
};

/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See “Window Region Constants” for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds){
printf ("GetWindowBounds",window,regionCode,*globalBounds);
};

/*DragWindow

Moves a window on the screen when the user drags it by its drag region.

void DragWindow (
   WindowRef window,
   Point startPt,
   const Rect * boundsRect
);
Parameters
window

The window that is to be dragged.
startPt

On input, the location, in global coordinates, of the cursor at the time the user pressed the mouse button. Your application retrieves this point from the where field of the event structure. 
boundsRect

On input, a pointer to a rectangle, given in global coordinates, that limits the region to which a window can be dragged. If the mouse button is released when the cursor is outside the limits of boundsRect, DragWindow returns without moving the window (or, if it was inactive, without making it the active window).

In CarbonLib and Mac OS X, this parameter can be NULL to indicate that there are no restrictions on window movement. This parameter is ignored by CarbonLib and Mac OS X v10.0 through v10.2; it is obeyed in Mac OX v10.3 and later.
Discussion

The DragWindow function moves the window around the screen, following the movement of the cursor until the user releases the mouse button. If the Command key was not pressed when the mouse button was pressed, DragWindow calls SelectWindow to make the window active before it drags the window. If the Command key was pressed when the mouse button was pressed, DragWindow moves the window without making it active.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DragWindow (
   WindowRef window,
   Point startPt,
   const Rect * boundsRect
){
printf ("DragWindow",window,startPt,*boundsRect);
};


/*IsWindowModified

Obtains the modification state of the specified window.

Boolean IsWindowModified (
   WindowRef window
);
Parameters
window

The window whose modification state is to be obtained.
Return Value

true if the content of the window has been modified; otherwise, false. Newly created windows start out with their modification state automatically set to true. 
Discussion

Your application can use the functions IsWindowModified and SetWindowModified instead of maintaining its own separate record of the modification state of the content of a window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean IsWindowModified (
   WindowRef window
){
printf ("IsWindowModified",window);
};

/*SelectWindow

Makes a window active.

void SelectWindow (
   WindowRef window
);
Parameters
window

The window that is to be made active.
Discussion

The SelectWindow function removes highlighting from the previously active window, brings the specified window to the front, highlights it, and generates the activate events to deactivate the previously active window and activate the specified window. If the specified window is already active, SelectWindow has no effect. Call SelectWindow when the user presses the mouse button while the cursor is in the content region of an inactive window.

Even if the specified window is invisible, SelectWindow brings the window to the front, activates the window, and deactivates the previously active window. Note that in this case, no active window is visible on the screen. If you do select an invisible window, be sure to call ShowWindow immediately to make the window visible (and accessible to the user). 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SelectWindow (
   WindowRef window
){
printf ("SelectWindow",window);
};


/*HIWindowFlush

Flushes any dirty areas a window might have.

OSStatus HIWindowFlush (
   WindowRef window
);
Parameters
window

The window to flush.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function allows you to manually flush dirty areas of a window to the screen. This is the preferred way to flush window buffers in Mac OS X v10.3 and later. If called for a composited window, this function also renders any views in the window that are invalid.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacWindows.h*/

OSStatus HIWindowFlush (
   WindowRef window
){
printf ("HIWindowFlush",window);
};

/*ReleaseQDContextForCollapsedWindowDockTile

Releases a port and other state created by CreateQDContextForCollapsedWindowDockTile.

OSStatus ReleaseQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr inContext
);
Parameters
inWindow

The window whose port is to be released.
inContext

The port that is to be released.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You must call this function instead of calling DisposePort directly, or you may leak system resources.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ReleaseQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr inContext
){
printf ("ReleaseQDContextForCollapsedWindowDockTile",inWindow,inContext);
};


/*IsWindowCollapsed

Determines whether a window is currently collapsed.

Boolean IsWindowCollapsed (
   WindowRef window
);
Parameters
window

The window to be examined.
Return Value

If true, the window is collapsed. If false, the window is expanded. 
Discussion

On Mac OS 9, only window definition functions that return the feature bit kWindowCanCollapse in response to a kWindowGetFeatures message support this function; for more information, see GetWindowFeatures. Typically, a window’s content region is empty in a collapsed state. On Mac OS X, the presence or absence of the kWindowCollapseBoxAttribute attribute determines whether a window can be collapsed.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
Boolean IsWindowCollapsed (
   WindowRef window
){
printf ("IsWindowCollapsed",window);
};


/*GetSheetWindowParent

Obtains the parent window of a sheet. 

OSStatus GetSheetWindowParent (
   WindowRef inSheet,
   WindowRef * outParentWindow
);
Parameters
inSheet

The window sheet whose parent is to be obtained.
outParentWindow

A pointer to the reference for the parent of the window sheet specified by inSheet.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetSheetWindowParent (
   WindowRef inSheet,
   WindowRef * outParentWindow
){
printf ("GetSheetWindowParent",inSheet,*outParentWindow);
};


/*SendBehind

Moves one window behind another.

void SendBehind (
   WindowRef window,
   WindowRef behindWindow
);
Parameters
window

The window to be moved.
behindWindow

On input, a pointer to the window that is to be in front of the moved window.
Discussion

The SendBehind function moves the window pointed to by the parameter window behind the window pointed to by the parameter behindWindow. If the move exposes previously obscured windows or parts of windows, SendBehind redraws the frames as necessary and generates the appropriate update events to have any newly exposed content areas redrawn.

If the value of behindWindow is NULL, SendBehind sends the window to be moved behind all other windows on the desktop. If the window to be moved is the active window, SendBehind removes its highlighting, highlights the newly exposed frontmost window, and generates the appropriate activate events.

Do not use SendBehind to deactivate a window after you’ve made a new window active with the function SelectWindow. The SelectWindow function automatically deactivates the previously active window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SendBehind (
   WindowRef window,
   WindowRef behindWindow
){
printf ("SendBehind",window,behindWindow);
};


/*SetWindowKind

Sets a window’s window kind.

void SetWindowKind (
   WindowRef window,
   short kind
);
Parameters
window

The window whose window kind is to be set.
kind

An integer representing the window kind.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWindowKind (
   WindowRef window,
   short kind
){
printf ("SetWindowKind",window,kind);
};




/*GetWRefCon

Returns the reference constant from a window.

long GetWRefCon (
   WindowRef window
);
Parameters
window

The window whose reference constant is to be returned.
Return Value

The long integer data stored in the refCon field of the window structure specified in the window parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
long GetWRefCon (WindowRef window){
printf ("GetWRefCon",window);
};



/*CreateStandardWindowMenu

Creates a standard window menu for your application. 

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);
Parameters
inOptions

Option bits. Pass 0 or kWindowMenuIncludeRotate. For information on the kWindowMenuIncludeRotate constant, see “Rotating Window Menu Item Constant”.
outMenu

On output, a new menu reference that contains the standard window menu items and commands. 
Return Value

A result code. See “Window Manager Result Codes”. An operating system status code.
Discussion

You can call this function to create a window menu for your application. To register a window to be tracked by this menu, you either create your window with CreateNewWindow, passing the kWindowInWindowMenuAttribute, or you can use ChangeWindowAttributes after the window is created. The Toolbox takes care of acting on the standard items such as zoom and minimize, as well as bringing selected windows to the front. All you need to do is insert the menu in your menu bar (typically at the end of your menu list) and register your windows, and the Toolbox does the rest.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
){
printf ("CreateStandardWindowMenu",inOptions,*outMenu);
};



/*GetWindowResizeLimits

Returns the minimum and maximum content sizes for a window. 

OSStatus GetWindowResizeLimits (
   WindowRef inWindow,
   HISize * outMinLimits,
   HISize * outMaxLimits
);
Parameters
inWindow

The window whose minimum and maximum content sizes are to be obtained.
outMinLimits

On return, the window’s minimum content size. Pass NULL if you don’t want this information. For information on the HISize data type, see HIGeometry.h.
outMaxLimits

On return, the window’s maximum content size. Pass NULL if you don’t want this information. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus GetWindowResizeLimits (
   WindowRef inWindow,
   HISize * outMinLimits,
   HISize * outMaxLimits
){
printf ("GetWindowResizeLimits",inWindow,*outMinLimits,*outMaxLimits);
};


/*GetWindowPortBounds

Obtains the bounds of the window port. 

Rect * GetWindowPortBounds (
   WindowRef window,
   Rect * bounds
);
Parameters
window

The window whose port bounds you want.
bounds

A pointer to a Rect structure. On return, the Rect structure contains the bounds of the window port.
Return Value

The same value (pointer to a Rect structure) that was passed to GetWindowPortBounds in the bounds parameter.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
Rect * GetWindowPortBounds (
   WindowRef window,
   Rect * bounds
){
printf ("GetWindowPortBounds",window,*bounds);
};



/*FrontWindow

Identifies the frontmost visible window.

WindowRef FrontWindow ();
Return Value

The first visible window in the window list. If there are no visible windows, FrontWindow returns NULL.
Discussion

Most applications should use call ActiveNonFloatingWindow or FrontNonFloatingWindow instead of FrontWindow because ActiveNonFloatingWindow and FrontNonFloatingWindow return the active and frontmost document window, respectively, skipping over other types of windows that may be in front of the active document, such as the menubar window, floating windows, help tags and toolbars.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontWindow (){
printf ("FrontWindow");
};


/*GetNextWindow

Returns the next window in a window list.

WindowRef GetNextWindow (
   WindowRef window
);
Parameters
window

The window to start from.
Return Value

The next window in a window list.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowRef GetNextWindow (
   WindowRef window
){
printf ("GetNextWindow",window);
};


/*GetWindowGoAwayFlag

Indicates whether or not a window has a close box.

Unsupported

Boolean GetWindowGoAwayFlag (
   WindowRef window
);
Parameters
window

On input, a pointer to the window. 
Return Value

A Boolean value. If true, the window has a close box. If false, the window does not have a close box. 
Availability
Carbon Porting Notes

Use GetWindowAttributes instead. 
Declared In
MacWindows.h*/

Boolean GetWindowGoAwayFlag (
   WindowRef window
){
printf ("GetWindowGoAwayFlag",window);
};



/*PinRect

Returns the point within the specified rectangle that is closest to the specified point.

long PinRect (
   const Rect * theRect,
   Point thePt
);
Parameters
theRect

On input, a pointer to a rectangle in which the point is to be contained. 
thePt

On input, a pointer to the point to be contained. 
Return Value

A long integer that specifies a point within the specified rectangle that is as close as possible to the specified point. (The high-order word of the returned long integer is the vertical coordinate; the low-order word is the horizontal coordinate. 
Discussion

DragGrayRgn uses the PinRect function to contain a point within a specified rectangle. If the specified point is within the rectangle, PinRect returns the point itself. If not, then
if the horizontal position is to the left of the rectangle, PinRect returns the left edge as the horizontal coordinate 
if the horizontal position is to the right of the rectangle, PinRect returns the right edge minus 1 as the horizontal coordinate 
if the vertical position is above the rectangle, PinRect returns the top edge as the vertical coordinate 
if the vertical position is below the rectangle, PinRect returns the bottom edge minus 1 as the vertical coordinate 

The 1 is subtracted when the point is below or to the right of the rectangle so that a pixel drawn at that point lies within the rectangle.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

long PinRect (
   const Rect * theRect,
   Point thePt
){
printf ("PinRect",*theRect,thePt);
};




/*GetWVariant

Returns a window’s variation code.

Not recommended

short GetWVariant (
   WindowRef window
);
Parameters
window

On input, a pointer to the window structure. 
Return Value

A short integer that specifies the variation code of the specified window. Depending on the window definition function, the result of GetWVariant can represent one of the standard variation codes or a variation code defined by your own window definition function. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use GetWindowAttributes instead.
Declared In
MacWindows.h*/

short GetWVariant (
   WindowRef window
){
printf ("GetWVariant",window);
};


/*SetWRefCon

Sets the refCon field of a window.

void SetWRefCon (
   WindowRef window,
   long data
);
Parameters
window

The window whose refCon field is to be set.
data

On input, the data to be placed in the refCon field. 
Discussion

The SetWRefCon function places the specified data in the refCon field of the specified window structure. The refCon field is available to your application for any window-related data it needs to store. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWRefCon (
   WindowRef window,
   long data){
printf ("SetWRefCon",window,data);
};


/*BeginUpdate

Starts updating a window when you receive an update event for that window.

void BeginUpdate (
   WindowRef window
);
Parameters
window

The window that is to be updated when an update event is received. Your application gets this information from the message field in the update event structure.
Discussion

The BeginUpdate function limits the visible region of the window’s graphics port to the intersection of the visible region and the update region it then sets the window’s update region to an empty region. After calling BeginUpdate, your application redraws either the entire content region or only the visible region. In either case, only the parts of the window that require updating are actually redrawn on the screen.

Every call to BeginUpdate must be matched with a subsequent call to EndUpdate after your application redraws the content region. BeginUpdate and EndUpdate can’t be nested. That is, you must call EndUpdate before the next call to BeginUpdate. 
Special Considerations

On classic Mac OS, if you don’t call BeginUpdate when you receive an update event, the Event Manager continues to send update events until you do. On Mac OS X, you only receive one update event. If you don’t call BeginUpdate, you won’t receive any further update events until the window is invalidated again.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void BeginUpdate (
   WindowRef window
){
printf ("BeginUpdate",window);
};

/*EndUpdate

Finishes updating a window.

void EndUpdate (
   WindowRef window
);
Parameters
window

The window for which updating is to be finished.
Discussion

The EndUpdate function restores the normal visible region of a window’s graphics port. When you receive an update event for a window, you call BeginUpdate, redraw the update region, and then call EndUpdate. Each call to BeginUpdate must be balanced by a subsequent call to EndUpdate. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void EndUpdate (
   WindowRef window
){
printf ("EndUpdate",window);
};


/*ShowHide

Sets a window’s visibility.

Not recommended

void ShowHide (
   WindowRef window,
   Boolean showFlag
);
Parameters
window

On input, a pointer to the window structure. 
showFlag

On input, a Boolean value that specifies its visibility: true makes a window visible; false makes it invisible. 
Discussion

The ShowHide function sets a window’s visibility to the status specified by the showFlag parameter. If the value of showFlag is true, ShowHide makes the window visible if it’s not already visible and has no effect if it’s already visible. If the value of showFlag is false, ShowHide makes the window invisible if it’s not already invisible and has no effect if it’s already invisible.

The ShowHide function never changes the highlighting or front-to-back ordering of windows and generates no activate events.

Use ShowHide only where you need more control than that provided by HideWindow and ShowWindow. Do not, for example, use ShowHide to hide the active window without making another window active. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use ShowWindow or HideWindow instead.
Declared In
MacWindows.h*/

void ShowHide (
   WindowRef window,
   Boolean showFlag
){
printf ("ShowHide",window,showFlag);
};

/*GrowWindow

Allows the user to change the size of a window.

Not recommended

long GrowWindow (
   WindowRef window,
   Point startPt,
   const Rect * bBox
);
Parameters
window

On input, a pointer to the window structure of the window to drag. 
startPt

On input, the location of the cursor at the time the mouse button was first pressed, in global coordinates. Your application retrieves this point from the where field of the event structure. 
bBox

On input, a pointer to a rectangle structure that specifies the limits on the vertical and horizontal measurements of the port rectangle, in pixels.

Although the bBox parameter gives the address of a structure which is in the form of the Rect data type, the four numbers in the structure represent lengths, not screen coordinates. The top, left, bottom, and right fields of the bBox parameter specify the minimum vertical measurement (top), the minimum horizontal measurement (left), the maximum vertical measurement (bottom), and the maximum horizontal measurement (right).

The minimum measurements must be large enough to allow a manageable rectangle 64 pixels on a side is typical. Because the user cannot ordinarily move the cursor off the screen, you can safely set the upper bounds to the largest possible length (65,535 pixels) when you’re using GrowWindow to follow cursor movements.

Return Value

A long integer that specifies the new dimensions, in pixels, of the resulting window: the height in the high-order word of the returned long-integer value and the width in the low-order word. A return value of 0 means that the new size is the same as the size of the current port rectangle. 
Discussion

The GrowWindow function displays an outline (grow image) of the window as the user moves the cursor to make the window larger or smaller; it handles all user interaction until the user releases the mouse button. After calling GrowWindow, you call the function SizeWindow to change the size of the window.

The GrowWindow function moves a dotted-line image of the window’s right and lower edges around the screen, following the movements of the cursor until the mouse button is released. You can use the functions HiWord and LoWord, described in the Mathematical and Logical Utilities Reference , to retrieve only the high-order and low-order words, respectively. 
Special Considerations

In non-Carbon implementations of GrowWindow on Mac OS 8 and 9, the maximum size that the specified window is allowed to grow to is actually one less than the values specified in the bBox parameter. For example, if you pass the values 500 in the bBox.bottom field and 600 in the bBox.right field, the maximum height and width of the window would actually be 499 and 599, respectively.

However, in Carbon, the maximum height and width allowed for the specified window is equal to the values passed in the bBox.bottom and bBox.right fields, respectively.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use ResizeWindow instead.
Declared In
MacWindows.h*/

long GrowWindow (
   WindowRef window,
   Point startPt,
   const Rect * bBox
){
printf ("GrowWindow",window,startPt,*bBox);
};


/*IsWindowVisible

Indicates whether the window frame is currently visible.

Boolean IsWindowVisible (
   WindowRef window
);
Parameters
window

The window to query.
Return Value

A Boolean value indicating whether or not the window is visible. If true, the window is visible. If false, the window is invisible. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean IsWindowVisible (
   WindowRef window
){
printf ("IsWindowVisible",window);
};


/*RemoveWindowProperty

Removes a piece of data that is associated with a window.

OSStatus RemoveWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag
);
Parameters
window

The window whose data is to be removed.
propertyCreator

The creator code (typically, the application’s signature) of the associated data to be removed. 
propertyTag

The application-defined code identifying the associated data to be removed. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The data removed by the RemoveWindowProperty function must have been previously associated with the window with the function SetWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus RemoveWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag
){
printf ("RemoveWindowProxy",window,propertyCreator,propertyTag);
};


/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (WindowRef window){
printf ("DisposeWindow",window);
};

/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString){
printf ("SetWindowTitleWithCFString",inWindow,inString);
};


/*IsWindowActive

Indicates whether the specified window is active. 

Boolean IsWindowActive (
   WindowRef inWindow
);
Parameters
inWindow

The window to query.
Return Value

Returns true if the window is active, false otherwise.
Discussion

Whether a window is considered active is determined by its activation scope, highlighting, and z-order. For windows that have an activation scope of kWindowActivationScopeAll, a window is active if it is the window returned by the ActiveNonFloatingWindow function or if it is in the same window group as the window returned by ActiveNonFloatingWindow and the window group has the kWindowGroupAttrSharedActivation attribute. For windows that have some other activation scope, the window is active if its window frame is highlighted and the window is the frontmost window in its window group.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
Boolean IsWindowActive (
   WindowRef inWindow
){
printf ("IsWindowActive",inWindow);
};


/*GetWindowUpdateRgn


Unsupported

void GetWindowUpdateRgn (
   WindowRef window,
   RgnHandle r
);
Parameters
window
r
Availability
Carbon Porting Notes

Use the GetWindowRegion function with the kWindowUpdateRgn selector instead.
Declared In
MacWindows.h*/
void GetWindowUpdateRgn (
   WindowRef window,
   RgnHandle r
){
printf ("GetWindowUpdateRgn",window,r);
};

/*SetPortWindowPort

Sets the current graphics port to the window’s port.

void SetPortWindowPort (
   WindowRef window
);
Parameters
window

The window whose graphics port is to be set.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetPortWindowPort (
   WindowRef window
){
printf ("SetPortWindowPort",window);
};

/*HIWindowGetProxyFSRef

Obtains the FSRef used to determine the proxy icon for a window.

OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
);
Parameters
inWindow

The window whose proxy FSRef is to be obtained.
outRef

On exit, the FSRef for the window’s proxy icon.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the specified window’s proxy icon has been specified using HIWindowSetProxyFSRef or SetWindowProxyAlias, HIWindowGetProxyFSRef returns noErr and a valid FSRef for the window’s proxy icon. If the window has no proxy icon, or if the icon was specified by calling SetWindowProxyCreatorAndType or SetWindowProxyIcon, this function returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
){
printf ("HIWindowGetProxyFSRef",inWindow,*outRef);
};


/*GetWindowRegion

Obtains a handle to a specific window region.

OSStatus GetWindowRegion (
   WindowRef window,
   WindowRegionCode inRegionCode,
   RgnHandle ioWinRgn
);
Parameters
window

The window for which a window region handle is to be obtained.
inRegionCode

A constant representing the window region whose handle you want to obtain; see “Window Region Constants” for a list of possible values. 
ioWinRgn

On input, a handle to a region created by your application. On return, the handle is set to the specified window region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The GetWindowRegion function produces a handle to a window definition function’s window region in response to a kWindowMsgGetRegion message. The visibility of the window is unimportant for GetWindowRegion to work correctly. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowRegion (
   WindowRef window,
   WindowRegionCode inRegionCode,
   RgnHandle ioWinRgn
){
printf ("GetWindowRegion",window,inRegionCode,ioWinRgn);
};

/*SetWindowGroup

Assigns a window to a window group. 

OSStatus SetWindowGroup (
   WindowRef inWindow,
   WindowGroupRef inNewGroup
);
Parameters
inWindow

The window that is to be assigned to a window group.
inNewGroup

The window group. For information on this data type, see WindowGroupRef.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus SetWindowGroup (
   WindowRef inWindow,
   WindowGroupRef inNewGroup
){
printf ("SetWindowGroup",inWindow,inNewGroup);
};

/*GetWindowGroup

Obtains the window group associated with a window. 

WindowGroupRef GetWindowGroup (
   WindowRef inWindow
);
Parameters
inWindow

The window whose window group is to be obtained.
Return Value

The window group reference for the window specified by inWindow. For information on this data type, see WindowGroupRef.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowGroupRef GetWindowGroup (
   WindowRef inWindow
){
printf ("GetWindowGroup",inWindow);
};


/*GetCWMgrPort

Gets a pointer to the color Window Manager port on a system that supports Color QuickDraw. 

Unsupported

void GetCWMgrPort (
   CGrafPtr *wMgrCPort
);
Parameters
wMgrCPort

On output, a Color Window Manager port. 
Discussion

The GetCWMgrPort function places a pointer to the color Window Manager port in the value referenced through the parameter wMgrCPort. The GetCWMgrPort function is available only on computers with Color QuickDraw.

The Window Manager port is a graphics port that occupies all of the main screen. Ordinarily, your application doesn’t need to access the Window Manager port.

Never draw directly into either of the Window Manager ports except from a window definition function. If you need to draw to the screen, create a new graphics port with OpenPort or OpenCPort and use that instead. 
Special Considerations

Do not change any regions of the Window Manager port. If you do, the Window Manager might not handle overlapping windows properly. 
Carbon Porting Notes

Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.
Declared In
MacWindows.h*/

void GetCWMgrPort (
   CGrafPtr *wMgrCPort
){
printf ("GetCWMgrPort",*wMgrCPort);
};


/*GetWindowPort

Gets the window’s color graphics port.

CGrafPtr GetWindowPort (
   WindowRef window
);
Parameters
window

The window whose color graphics port is to be obtained.
Return Value

A pointer to the window’s color graphics port. See the QuickDraw Manager documentation for a description of the CGrafPtr data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
CGrafPtr GetWindowPort (
   WindowRef window
){
printf ("GetWindowPort",window);
};


/*SizeWindow

Sets the size of a window. 

void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
);
Parameters
window

The window whose size is to be set.
w

On input, the new window width, in pixels. 
h

On input, the new window height, in pixels.
fUpdate

On input, a Boolean value that specifies whether any newly created area of the content region is to be accumulated into the update region (true) or not (false). You ordinarily pass a value of true to ensure that the area is updated. If you pass false, you’re responsible for maintaining the update region yourself. For a composited window, this parameter is ignored, and any views that intersect the newly exposed area of the window are automatically invalidated. For more information on adding rectangles to and removing rectangles from the update region, see InvalWindowRect and ValidWindowRect. 
Discussion

The SizeWindow function changes the size of the window’s graphics port rectangle to the dimensions specified by the w and h parameters, or does nothing if the values of w and h are both 0. The Window Manager redraws the window in the new size, recentering the title and truncating it if necessary.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
){
printf ("SizeWindow",window,w,h,fUpdate);
};


/*ShowSheetWindow

Shows a sheet window using appropriate visual effects.

OSStatus ShowSheetWindow (
   WindowRef inSheet,
   WindowRef inParentWindow
);
Parameters
inSheet

The window sheet that is to be shown.
inParentWindow

The parent of the window specified by inSheet.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus ShowSheetWindow (
   WindowRef inSheet,
   WindowRef inParentWindow
){
printf ("ShowSheetWindow",inSheet,inParentWindow);
};

/*HideSheetWindow

Hides a sheet window using appropriate visual effects.

OSStatus HideSheetWindow (
   WindowRef inSheet
);
Parameters
inSheet

The window sheet that is to be hidden.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus HideSheetWindow (
   WindowRef inSheet
){
printf ("HideSheetWindow",inSheet);
};


/*MoveWindow

Moves a window on the desktop.

void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
);
Parameters
window

The window that is to be moved on the desktop.
hGlobal

On input, the new location, in global coordinates, of the left edge of the window’s port rectangle. 
vGlobal

On input, the new location, in global coordinates, of the top edge of the window’s port rectangle.
front

On input, a Boolean value specifying whether the window is to become the frontmost, active window. If the value of the front parameter is false, MoveWindow does not change its plane or status. If the value of the front parameter is true and the window isn’t active, MoveWindow makes it active by calling the SelectWindow function.
Discussion

The MoveWindow function moves the specified window to the location specified by the hGlobal and vGlobal parameters, without changing the window’s size. The upper-left corner of the window’s port rectangle is placed at the point (vGlobal, hGlobal). The local coordinates of the upper-left corner are unaffected.

Your application doesn’t normally call MoveWindow. When the user drags a window by dragging its title bar, you can call DragWindow which in turn calls MoveWindow when the user releases the mouse button. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
){
printf ("MoveWindow",window,hGlobal,vGlobal,front);
};

/*InvalWindowRect

Adds a rectangle to a window’s update region.

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
);
Parameters
window

The window containing the rectangle you want to be updated.
bounds

Set this structure to specify, in local coordinates, a rectangle to be added to the window’s update region. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The InvalWindowRect function informs the Window Manager that an area of a window should be redrawn.

See also the functions ValidWindowRect and InvalWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
){
printf ("InvalWindowRect",window,*bounds);
};


/*FindWindow

Maps the location of the cursor to a part of the screen or a region of a window when your application receives a mouse-down event.

WindowPartCode FindWindow (
   Point thePoint,
   WindowRef * window
);
Parameters
thePoint

The point, in global coordinates, where the mouse-down event occurred. Your application retrieves this information from the where field of the event structure. 
window

A pointer to the window in which the mouse-down event occurred. FindWindow produces NULL if the mouse-down event occurred outside a window.
Return Value

The location of the cursor when the user pressed the mouse button; see “Window Part Code Constants”. See the description of the WindowPartCode data type.
Discussion

You typically call the function FindWindow whenever you receive a mouse-down event. The FindWindow function helps you dispatch the event by reporting whether the cursor was in the menu bar or in a window when the mouse button was pressed. If the cursor was in a window, the function will produce both a pointer to the window and a constant that identifies the region of the window in which the event occurred.

If you are using the Carbon event handlers to handle events, a faster way of getting the window and part that received a mouse-down event is to get the kEventParamWindowRef and kEventParamWindowPartCode parameters from the event.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowPartCode FindWindow (
   Point thePoint,
   WindowRef * window
){
printf ("FindWindow",thePoint,*window);
};


/*GetWindowProperty

Obtains a piece of data that is associated with a window.

OSStatus GetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
window

The window to be examined for associated data.
propertyCreator

The creator code (typically, the application’s signature) of the associated data to be obtained. 
propertyTag

The application-defined code identifying the associated data to be obtained. 
bufferSize

The size of the associated data to be obtained. If the size of the data is unknown, use the function GetWindowPropertySize to get the data’s size. If the size specified does not match the actual size of the property, GetWindowProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to a value. On return, the value specifies the actual size of the obtained data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified window. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The data retrieved by the GetWindowProperty function must have been previously associated with the window with the function SetWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){
printf ("GetWindowProperty",window,propertyCreator,propertyTag,bufferSize,*actualSize,propertyBuffer);
};

/*ValidRect

Removes a rectangle from a window’s update region.

Unsupported

void ValidRect (
   const Rect *goodRect
);
Parameters
goodRect

On input, a pointer to a rectangle, in local coordinates, to be removed from a window’s update region. 
Discussion

The ValidRect function removes a specified rectangle from the update region of the window whose graphics port is the current port. Specify the rectangle in local coordinates. 

Your application uses ValidRect to tell the Window Manager that it has already drawn a rectangle and to cancel any updates accumulated for that area. You can thereby improve response time by reducing redundant redrawing.

Suppose, for example, that you’ve resized a window that contains a size box and scroll bars. Depending on the dimensions of the newly sized window, the new size box and scroll bar areas may or may not have been accumulated into the window’s update region. After calling SizeWindow, you can redraw the size box or scroll bars immediately and then call ValidRect for the areas they occupy. If they were in fact accumulated into the update region, ValidRect removes them so that you do not have to redraw them with the next update event. 
Availability
Unsupported.
Carbon Porting Notes

Calls ValidWindowRect, which takes a window pointer as an additional parameter. Validation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/
void ValidRect (
   const Rect *goodRect
){
printf ("ValidRgn",*goodRect);
};

/*CreateQDContextForCollapsedWindowDockTile

Obtains a CGrafPtr for a collapsed window’s tile in the dock.

OSStatus CreateQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr * outContext
);
Parameters
inWindow

The window whose CGrafPtr is to be obtained.
outContext

On output, a pointer to the window’s CGrafPtr.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr * outContext
){
printf ("CreateQDContextForCollapsedWindowDockTile",inWindow,*outContext);
};

//work




/*BringToFront

Brings a window to the front.

void BringToFront (
   WindowRef window
);
Parameters
window

The window that is to be brought to the front.
Discussion

The BringToFront function puts the specified window at the beginning of the window list and redraws the window in front of all others on the screen. It does not change the window’s highlighting or make it active.

Your application does not ordinarily call BringToFront. The user interface guidelines specify that the frontmost window should be the active window. To bring a window to the front and make it active, call the function SelectWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void BringToFront (
   WindowRef window
){};


/*FrontNonFloatingWindow

Returns to the application the frontmost visible window that is not a floating window.

WindowRef FrontNonFloatingWindow ();
Return Value

The first visible window in the window list that is of a nonfloating class. See “Window Class Constants” for a description of window classes.
Discussion

Your application should call the FrontNonFloatingWindow function when you want to identify the frontmost visible window that is not a floating window. If you want to identify the frontmost visible window, whether floating or not, your application should call the function FrontWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontNonFloatingWindow (){
//TODO
};


/*ActiveNonFloatingWindow

Returns the currently active nonfloating window. 

WindowRef ActiveNonFloatingWindow ();
Return Value

A reference to the active window.
Discussion

Note that the active window is not necessarily the frontmost window, and it is not necessarily the window with user focus. Call GetUserFocusWindow to get the window that has user focus. For information on the GetUserFocusWindow function, see Carbon Event Manager Reference.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef ActiveNonFloatingWindow (){};


/*MoveWindowStructure

Positions a window relative to its structure region.

OSStatus MoveWindowStructure (
   WindowRef window,
   short hGlobal,
   short vGlobal
);
Parameters
window

The window that is to be moved.
hGlobal

A value specifying the horizontal position, in global coordinates, to which the left edge of the window’s structure region is to be moved. 
vGlobal

A value specifying the vertical position, in global coordinates, to which the top edge of the window’s structure region is to be moved.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The MoveWindowStructure function moves the specified window, but does not change the window’s size. When your application calls MoveWindowStructure, the positioning of the specified window is determined by the positioning of its structure region. This is in contrast to the MoveWindow function, where the positioning of the window’s content region determines the positioning of the window. After moving the window, MoveWindowStructure displays the window in its new position.

Note that your application should not call the MoveWindowStructure function to position a window when the user drags the window by its drag region. When the user drags the window, your application should call the pre–Mac OS 8.5 Window Manager function DragWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus MoveWindowStructure (
   WindowRef window,
   short hGlobal,
   short vGlobal
){};

/*ChangeWindowAttributes

Changes a window’s attributes. 

OSStatus ChangeWindowAttributes (
   WindowRef window,
   WindowAttributes setTheseAttributes,
   WindowAttributes clearTheseAttributes
);
Parameters
window

The window whose attributes you want to change.
setTheseAttributes

The attributes you want to set. Pass kWindowNoAttributes if you do not want to set any attributes. See “Window Attributes” for a list of window attributes.
clearTheseAttributes

The attributes you want to clear (if any). Pass kWindowNoAttributes if you do not want to clear any attributes. See “Window Attributes” for a list of window attributes.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the changed attributes affect the visible window’s frame, the window regions are recalculated and the window is redrawn.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ChangeWindowAttributes (
   WindowRef window,
   WindowAttributes setTheseAttributes,
   WindowAttributes clearTheseAttributes
){};


/*GetWindowClass

Obtains the class of a window.

OSStatus GetWindowClass (
   WindowRef window,
   WindowClass * outClass
);
Parameters
window

The window whose class you want to obtain.
outClass

On input, a pointer to a value of type WindowClass. On return, this value identifies the class of the specified window. See “Window Class Constants” for a list of possible window classes. In Mac OS 8 and Mac OS 9, for windows not originally created by CreateNewWindow, the class pointed to by the outClass parameter is always identified by the constant kDocumentWindowClass. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Call SetWindowClass to change a window’s class after the window is created.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowClass (
   WindowRef window,
   WindowClass * outClass
){};




/*SetWindowGroupParent

Sets a window group to be the parent of another window group. 

OSStatus SetWindowGroupParent (
   WindowGroupRef inGroup,
   WindowGroupRef inNewGroup
);
Parameters
inGroup

The window group whose parent window group is to be set. The specified window group cannot contain any windows at the time of this call. 
inNewGroup

The window group that is to be the parent of inGroup. For information on this data type, see WindowGroupRef.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You can nest groups within each other using this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowGroupParent (
   WindowGroupRef inGroup,
   WindowGroupRef inNewGroup
){};


/*CreateWindowGroup

Creates a window group. 

OSStatus CreateWindowGroup (
   WindowGroupAttributes inAttributes,
   WindowGroupRef * outGroup
);
Parameters
inAttributes

Attributes for the new window group. See “Window Group Attributes” for a listing of possible attributes.
outGroup

For information on this data type, see “WindowGroupRef”.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateWindowGroup (
   WindowGroupAttributes inAttributes,
   WindowGroupRef * outGroup
){};

/*SetWindowBounds

Sets a window’s size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the window’s size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The SetWindowBounds function sets a window’s size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the window’s content region or its structure region is more important in determining the window’s ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window—and, therefore, its spatial relationship to the rest of the screen—may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your application’s content is of greatest concern, then it is important to note that with some appearances some part of the window’s structure region or “frame” may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds){
//TODO
};


/*SetWindowProperty

Associates an arbitrary piece of data with a window.

OSStatus SetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 propertySize,
   const void * propertyBuffer
);
Parameters
window

The window with which data is to be associated.
propertyCreator

The creator code (typically, the application’s signature) of the data to be associated. 
propertyTag

A value identifying the data to be associated. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data. 
propertySize

The size of the data to be associated. 
propertyBuffer

A pointer to the data to be associated. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Data set with the SetWindowProperty function may be obtained with the function GetWindowProperty and removed with the function RemoveWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus SetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 propertySize,
   const void * propertyBuffer
){};




/*UpdateCollapsedWindowDockTile

Updates the image of a window in the dock to the current contents of the window.

OSStatus UpdateCollapsedWindowDockTile (
   WindowRef inWindow
);
Parameters
inWindow

The window whose image is to be updated.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use this function for periodic updates, not for animation purposes. If you want animation, use CreateQDContextForCollapsedWindowDockTile.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus UpdateCollapsedWindowDockTile (
   WindowRef inWindow
){};


/*InvalRgn

Adds a region to a window’s update region.

Unsupported

void InvalRgn (
   RgnHandle badRgn
);
Parameters
badRgn

On input, the region, in local coordinates, that is to be added to a window’s update region. 
Discussion

The InvalRgn function adds a specified region to the update region of the window whose graphics port is the current port. Specify the region in local coordinates. 
Availability
Unsupported.
Carbon Porting Notes

Call InvalWindowRgn, which takes a window pointer as an additional parameter. Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/
void InvalRgn (
   RgnHandle badRgn
){};


/*PaintBehind

Redraws a series of windows in the window list.

Not recommended

void PaintBehind (
   WindowRef startWindow,
   RgnHandle clobberedRgn
);
Parameters
startWindow

On input, a pointer to the window’s complete window structure. 
clobberedRgn

On input, a handle to the region that has become invalid. 
Discussion

The Window Manager calls the PaintBehind function; your application does not normally need to. PaintBehind calls PaintOne for startWindow and all the windows behind startWindow, clipped to clobberedRgn. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead. 
Declared In
MacWindows.h*/
void PaintBehind (
   WindowRef startWindow,
   RgnHandle clobberedRgn
){};



/*TrackGoAway

Tracks the cursor when the user presses the mouse button while the cursor is in the close box.

Boolean TrackGoAway (
   WindowRef window,
   Point thePt
);
Parameters
window

On input, the window in which the mouse-down event occurred.
thePt

On input, the location of the cursor at the time the mouse button was pressed. Your application receives this point from the where field of the event structure. 
Return Value

When the mouse button is released, TrackGoAway removes the highlighting from the close box and returns true if the cursor is within the close region and false if it is not. 
Discussion

The TrackGoAway function tracks cursor activity when the user presses the mouse button while the cursor is in the close box, retaining control until the user releases the mouse button. While the button is down, TrackGoAway highlights the close box as long as the cursor is in the close region.

Your application calls the TrackGoAway function when it receives a result code of inGoAway from FindWindow. If TrackGoAway returns true, your application calls its own function for closing a window, which can call DisposeWindow to remove the window from the screen. If TrackGoAway returns false, your application does nothing. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean TrackGoAway (
   WindowRef window,
   Point thePt
){};


/*TrackBox

Tracks clicks in the collapse, close, size, and zoom boxes, and clicks of the toolbar button.

Boolean TrackBox (
   WindowRef window,
   Point thePt,
   WindowPartCode partCode
);
Parameters
window

The window in which the mouse button was pressed.
thePt

On input, the location of the cursor when the mouse button was pressed. Your application receives this point from the where field in the event structure. 
partCode

On input, the part code (inZoomIn, inZoomOut, inGoAway, inGrow, inCollapseBox, or inToolbarButton) returned by FindWindow; see “Part Identifier Constants”. 
Return Value

A Boolean whose value is true if the specified part was clicked; otherwise, false. If TrackBox returns true, it also removes highlighting from the specified part.
Discussion

The TrackBox function tracks the cursor when the user presses the mouse button while the cursor is in the specified part, retaining control until the mouse button is released. While the button is down, TrackBox highlights the part while the cursor is in the part’s region.

When the mouse button is released, TrackBox removes the highlighting from the part and returns true if the cursor is within the part’s region and false if it is not.

If TrackBox returns true after tracking the close box, your application should close the window. If TrackBox returns true after tracking the grow box, your application should call ResizeWindow. If TrackBox returns true after tracking the collapse box, your application should call CollapseWindow. When tracking the toolbar button, your application should call ShowHideWindowToolbar.

Your application calls the TrackBox function when it receives a result code of inZoomIn or inZoomOut from the function FindWindow. If TrackBox returns true, your application calculates the standard state, if necessary, and calls the function ZoomWindow to zoom the window. If TrackBox returns false, your application does nothing.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean TrackBox (
   WindowRef window,
   Point thePt,
   WindowPartCode partCode
){};



/*SetWindowClass

Sets the class of a window.

OSStatus SetWindowClass (
   WindowRef window,
   WindowClass inClass
);
Parameters
window

The window whose class you want to set.
inClass

The class that is to be set. See “Window Class Constants” for a list of possible window classes. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

A window’s class categorizes the window for purposes of display (that is, both the window’s appearance and its display ordering) and tracking.

Instead of calling this function, you should call SetWindowGroup to move a window into the group of the desired class.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowClass (
   WindowRef window,
   WindowClass inClass
){};




/*ActivateWindow

Activates or deactivates a window. 

OSStatus ActivateWindow (
   WindowRef inWindow,
   Boolean inActivate
);
Parameters
inWindow

The window to activate or deactivate.
inActivate

Pass true to activate the window, false otherwise. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ActivateWindow (
   WindowRef inWindow,
   Boolean inActivate
){};



/*InvalRect

Adds a rectangle to a window’s update region.

Unsupported

void InvalRect (
   const Rect *badRect
);
Parameters
badRect

On input, a pointer to a rectangle, in local coordinates, that is to be added to a window’s update region. 
Discussion

The InvalRect function adds a specified rectangle to the update region of the window whose graphics port is the current port. Specify the rectangle in local coordinates. 

Both your application and the Window Manager use the InvalRect function. When the user enlarges a window, for example, the Window Manager uses InvalRect to add the newly created content region to the update region. Your application uses InvalRect to add the two rectangles formerly occupied by the scroll bars in the smaller content area. 
Availability
Unsupported.
Carbon Porting Notes

Calls InvalWindowRect, which takes a window pointer as an additional parameter.

Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/

void InvalRect (
   const Rect *badRect
){};



/*ZoomWindow

Zooms the window when the user has pressed and released the mouse button with the cursor in the zoom box.

void ZoomWindow (
   WindowRef window,
   WindowPartCode partCode,
   Boolean front
);
Parameters
window

The window that is to be zoomed.
partCode

On input, the part code (either inZoomIn or inZoomOut) returned by the FindWindow function; see “Part Identifier Constants”. 
front

On return, a Boolean value that determines whether the window is to be brought to the front. If the value of front is true, the window necessarily becomes the frontmost, active window. If the value of front is false, the window’s position in the window list does not change. Note that if a window was active before it was zoomed, it remains active even if the value of front is false. 
Discussion

The ZoomWindow function zooms a window in or out, depending on the value of the partCode parameter. Your application calls ZoomWindow, passing it the part code returned by FindWindow, when it receives a result of true from TrackBox. The ZoomWindow function then changes the window’s port rectangle to either the user state (if the part code is inZoomIn) or the standard state (if the part code is inZoomOut), as stored in the window state structure, described in the section WStateData.

If the part code is inZoomOut, your application ordinarily calculates and sets the standard state before calling ZoomWindow.

For best results, call the QuickDraw function EraseRect, passing the window’s graphics port as the port rectangle, before calling ZoomWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ZoomWindow (
   WindowRef window,
   WindowPartCode partCode,
   Boolean front
){};




/*ValidWindowRect

Removes a rectangle from a window’s update region.

OSStatus ValidWindowRect (
   WindowRef window,
   const Rect * bounds
);
Parameters
window

The window containing the rectangle you want to remove from the update region.
bounds

Set this structure to specify, in local coordinates, a rectangle to be removed from the window’s update region. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The ValidWindowRect function informs the Window Manager that an area of a window no longer needs to be redrawn. The ValidWindowRect function is similar to the ValidRect function, but ValidWindowRect allows the window that it operates upon to be explicitly specified, instead of operating on the current graphics port, so ValidWindowRect does not require the graphics port to be set before its use.

See also the functions InvalWindowRect and ValidWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ValidWindowRect (
   WindowRef window,
   const Rect * bounds
){};



/*SetWindowStandardState

Sets a window’s standard zoom rectangle. 

void SetWindowStandardState (
   WindowRef window,
   const Rect * rect
);
Parameters
window

The window whose standard zoom rectangle is to be set.
rect

On input, a rectangle (in global coordinates) representing the window’s standard zoom rectangle. A window’s standard zoom rectangle is the window content bounds when the window is zoomed out to its largest extent.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWindowStandardState (
   WindowRef window,
   const Rect * rect
){};


/*InvalWindowRgn

Adds a region to a window’s update region.

OSStatus InvalWindowRgn (
   WindowRef window,
   RgnHandle region
);
Parameters
window

The window containing the region that you want to update.
region

Set this region to specify, in local coordinates, the area to be added to the window’s update region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The InvalWindowRgn function informs the Window Manager that an area of a window should be redrawn.

See also the functions InvalWindowRect and ValidWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus InvalWindowRgn (
   WindowRef window,
   RgnHandle region
){};



/*GetGrayRgn

Returns a handle to the current desktop region.

Not recommended

RgnHandle GetGrayRgn ();
Parameters
Return Value

A handle to the current desktop region from the global variable GrayRgn. See the QuickDraw Manager documentation for a description of the RgnHandle data type.
Discussion

When your application calls DragWindow to let the user drag a window, it can use GetGrayRgn to set the limiting rectangle to the entire desktop area. The desktop region represents all available screen space, that is, the desktop area displayed by all monitors attached to the computer. 
Special Considerations

Your application should not modify the desktop region.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use GetAvailableWindowPositioningBounds if you want to determine where you can position your windows.
Declared In
MacWindows.h*/
RgnHandle GetGrayRgn (){};



/*CreateWindowFromResource

Creates a window from 'wind' resource data.

OSStatus CreateWindowFromResource (
   SInt16 resID,
   WindowRef * outWindow
);
Parameters
resID

The resource ID of a resource of type ‘wind’. Pass in the ID of the 'wind' resource to be used to create the window. 
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateWindowFromResource function loads a window from a 'wind' resource. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateWindowFromResource, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateWindowFromResource (
   SInt16 resID,
   WindowRef * outWindow
){};



/*GetWindowFromPort

Gets a window reference from a CGrafPtr data type.

WindowRef GetWindowFromPort (
   CGrafPtr port
);
Parameters
port

The port to query.
Return Value

The window reference obtained from the port specified by port, or NULL if the port parameter is not actually attached to a window.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowRef GetWindowFromPort (
   CGrafPtr port
){};


/*GetWindowKind

Returns a window’s window kind.

short GetWindowKind (
   WindowRef window
);
Parameters
window

The window whose window kind is to be returned.
Return Value

An integer representing the window kind; see “Window Kinds”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
short GetWindowKind (
   WindowRef window
){};


/*NewWindowDefUPP

Creates a new UPP for a window definition.

WindowDefUPP NewWindowDefUPP (
   WindowDefProcPtr userRoutine
);
Parameters
userRoutine

For information, see WindowDefProcPtr. 
Return Value

For a description of the WindowDefUPP data type, see WindowDefUPP.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowDefUPP NewWindowDefUPP (
   WindowDefProcPtr userRoutine
){};



/*DisposeWindowDefUPP

Disposes of the UPP for your window definition.

void DisposeWindowDefUPP (
   WindowDefUPP userUPP
);
Parameters
userUPP

The UPP that is to be disposed of. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void DisposeWindowDefUPP (
   WindowDefUPP userUPP
){};


/*CreateCustomWindow

Creates a custom window based on a registered toolbox object class or a custom window root view. 

OSStatus CreateCustomWindow (
   const WindowDefSpec * def,
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
def

For information on this data type, see WindowDefSpec.
windowClass

The class the custom window should belong to. This value determines the layer ordering of the custom window. 
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes. 
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region. 
outWindow

On return, the newly-created window.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateCustomWindow (
   const WindowDefSpec * def,
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
){};

/*GetWMgrPort

Gets a pointer to the monochrome Window Manager port on a system that does not support Color QuickDraw. 

Unsupported

void GetWMgrPort (
   GrafPtr *wPort
);
Parameters
wPort

On output, a monochrome Window Manager port. 
Discussion

The GetWMgrPort function places a pointer to the Window Manager port in the value referenced through the parameter wPort. The Window Manager port is a graphics port that occupies all of the main screen. Never draw directly into either of the Window Manager ports except from a window definition function. If you need to draw to the screen, create a new graphics port with OpenPort or OpenCPort and use that instead. 
Special Considerations

Do not change any regions of the Window Manager port. If you do, the Window Manager might not handle overlapping windows properly.
Carbon Porting Notes

Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.
Declared In
MacWindows.h*/

void GetWMgrPort (
   GrafPtr *wPort
){};

/*HIWindowChangeClass

Changes the look and feel of an existing window.

OSStatus HIWindowChangeClass (
   WindowRef window,
   WindowClass inClass
);
Parameters
window

The window whose class you want to change.
inClass

The new class that is to be applied to the window. See “Window Class Constants” for a list of possible window classes. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

HIWindowChangeClass changes the class of a window. Unlike SetWindowClass, HIWindowChangeClass effectively changes the look and behavior of the window all at once.

This function can convert a window between kDocumentWindowClass, kFloatingWindowClass, kUtilityWindowClass, and kMovableModalWindowClass only. It cannot, for example, change a document window into a plain window.

The attributes of the window are adjusted to contain only those that are allowed for the new class. It is the caller’s responsibility to adjust them further, as necessary, after HIWindowChangeClass returns.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacWindows.h*/
OSStatus HIWindowChangeClass (
   WindowRef window,
   WindowClass inClass
){
printf ("HIWindowChangeClass",window,inClass);
};


/*SetDrawerParent

Sets the parent window for a drawer. 

OSStatus SetDrawerParent (
   WindowRef inDrawerWindow,
   WindowRef inParent
);
Parameters
inDrawerWindow

The drawer window whose parent window is to be set.
inParent

The window that is to be set as the parent of the window specified by inDrawerWindow.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus SetDrawerParent (
   WindowRef inDrawerWindow,
   WindowRef inParent
){
printf ("SetDrawerParent",inDrawerWindow,inParent);
};


/*ToggleDrawer

Toggles the drawer state.

OSStatus ToggleDrawer (
   WindowRef inDrawerWindow
);
Parameters
inDrawerWindow

The drawer window whose drawer state is to be toggled.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the drawer is currently open or opening, this function closes the drawer. If the drawer is currently closed or closing, this function opens the drawer.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus ToggleDrawer (
   WindowRef inDrawerWindow
){
printf ("ToggleDrawer",inDrawerWindow);
};

/*GetAuxWin

Obtains a handle to a window’s auxiliary window structure.

Unsupported

Boolean GetAuxWin (
   WindowRef window,
   AuxWinHandle *awHndl
);
Parameters
window

On input, a pointer to the window structure. 
awHndl

On output, a handle to the auxiliary window structure. 
Return Value

Returns a Boolean value that reports whether or not the window has an auxiliary window structure. If the window has no auxiliary window structure, it returns a value of false. If window is NULL, the function returns the system default and true. 
Discussion

The GetAuxWin function sets the value referenced through the parameter awHndl to contain a handle to the auxiliary window structure. If the window has no auxiliary window structure, GetAuxWin places the default auxiliary window structure in the value referenced through awHndl. 
Version Notes

This function is not recommended with Appearance Manager 1.0 and later.

When the Appearance Manager is available and you are using standard windows, most of the fields of the auxiliary window structure are ignored. In the future, standard system windows may not have entries in the auxiliary window list. If you are creating your own window definition function, GetAuxWin can still be used.
Carbon Porting Notes

Remove application reliance on AuxWinRec data structures; in the future, the information in these structures may be invalid or unavailable to applications.
Declared In
MacWindows.h*/
Boolean GetAuxWin (
   WindowRef window,
   AuxWinHandle *awHndl
){};



