#include <OSServices/OSServices.h>


/*OTInetHostToString

Converts an an address in InetHost format into a character string in dotted-decimal notation. (Deprecated in Mac OS X v10.4.)

void OTInetHostToString (
   InetHost host,
   char * str
);
Parameters
host
str

A pointer to a C string containing an IP address in dotteddecimal notation (for example, “12.13.14.15”). You must allocate storage for this string and provide the pointer to the function.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

void OTInetHostToString (
   InetHost host,
   char * str
){};

/*OTInetGetInterfaceInfo

Returns internet address information about the local host. (Deprecated in Mac OS X v10.4.)

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
);
Parameters
info
val

An index into the local host’s array of configured IP interfaces. Specify 0 for information about the first interface. Specify kDefaultInetInterface to get information about the primary interface.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Because the architecture of Open Transport TCP/IP provides for multihoming, in principle a given host can receive packets simultaneously through more than one network interface. For each IP interface configured for the local host, the OTInetGetInterfaceInfo function provides the internet address and subnet mask, a default gateway (that is, a gateway, if any exists, that can be used to route any packet to all destinations outside the locally connected subnet), and a domain name server, if any is known. The function also returns the version number of the OTInetGetInterfaceInfo function and, if available, the broadcast address for each interface. If the broadcast address is not available, you can determine it from the internet address and subnet mask.

Because multihoming has not been implemented in the initial release of Open Transport, the OTInetGetInterfaceInfo function never returns information for more than one interface.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
){};

/*OTInitDNSAddress

Fills in a DNSAddress structure with the data you provide. (Deprecated in Mac OS X v10.4.)

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
);
Parameters
addr
str

A pointer to a domain name string. This string can be just a host name (otteam), a partially qualified domain name (for example, “otteam.ssw”), a fully qualified domain name (for example, “otteam.ssw.apple.com.”), or an internet address in dotteddecimal format (for example, “17.202.99.99”), and can optionally include the port number (for example, “otteam.ssw.apple.com:25” or “17.202.99.99:25”).
Return Value

See the description of the OTByteCount data type.
Discussion

This function fills in the fAddressType field of the DNSAddress structure with the value AF_DNS, fills in the fName field with the address string you specify, and returns the size of the resulting DNSAddress structure as an unsigned integer. You can use the DNSAddress structure to provide an address when you use a UDP or TCP endpoint. If you do so, the domain name resolver resolves the address for you automatically.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
){};

/*OTInitInetAddress

Fills in an InetAddress structure with the data you provide. (Deprecated in Mac OS X v10.4.)

void OTInitInetAddress (
   InetAddress * addr,
   InetPort port,
   InetHost host
);
Parameters
addr
port
host
Discussion

This function fills in the fAddressType field of the InetAddress structure with the value AF_INET. You use the InetAddress structure when providing a TCP or UDP address to the Open Transport functions OTConnect, OTSndURequest, and OTBind. You are not required to use the OTInitInetAddress function when creating an InetAddress structure; this function is provided for your convenience only.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/
void OTInitInetAddress (
   InetAddress * addr,
   InetPort port,
   InetHost host
){};

/*OTInetStringToAddress

Resolves a domain name to its equivalent internet addresses. (Deprecated in Mac OS X v10.4.)

OSStatus OTInetStringToAddress (
   InetSvcRef ref,
   char * name,
   InetHostInfo * hinfo
);
Parameters
ref
name

A pointer to the domain name you want to resolve. This can be a host name, a partially qualified domain name, a fully qualified domain name, or an internet address in dotted-decimal format.
hinfo
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Because the architecture of Open Transport TCP/IP provides for multihoming, a single host can be associated with multiple internet addresses. You can use the OTInetStringToAddress function to return multiple addresses for multihomed hosts.

Because multihoming has not been implemented in the initial release of Open Transport, the OTInetStringToAddress function never returns more than one address.

If you specify an internet address in dotted-decimal format for the hinfo parameter, the OTInetStringToAddress function places that address in the InetHostInfo.name field instead of a canonical domain name.

If you call the OTInetStringToAddress function asynchronously, the TCP/IP service provider calls your notifier function with the T_DNRSTRINGTOADDRCOMPLETE completion event code when the function completes. The cookie parameter to the notifier function contains the pointer you specified in the hinfo parameter. If you had more than one simultaneous outstanding call to the OTInetStringToAddress function, you can use this information to determine which call has completed execution.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/
OSStatus OTInetStringToAddress (
   InetSvcRef ref,
   char * name,
   InetHostInfo * hinfo
){};

/*OTAsyncOpenInternetServices
C INTERFACE
OSStatus OTAsyncOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OTNotifyProcPtr proc,
                                         
C++ INTERFACE
None. C++ clients use the C interface to this function.

PARAMETERS
cfig 
A pointer to a network configuration structure. You can obtain the default configuration by using the constant kDefaultInternetServicesPath for this parameter. 
oflag 
Reserved. Must be set to 0. 
proc 
A pointer to your notifier function. The TCP/IP service provider passes the internet services reference to your notifier function in the cookie parameter. 
contextPtr 
A pointer for your use. The TCP/IP service provider passes this value unchanged to your notifier function. 
function result 
A result code. See Appendix B for additional information. 
DISCUSSION
You must open a TCP/IP service provider before calling any TCP/IP services functions other than the address utility functions. You must provide the Internet services reference when calling any of these non-utility functions. The OTAsyncOpenInternetServices function runs asynchronously and sets the mode of the TCP/IP service provider as asynchronous.

For information on how to specify options using the cfig parameter, see Table 11-2.

SEE ALSO
The OTOpenInternetServices function.*/
OSStatus OTAsyncOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OTNotifyProcPtr proc,
                                           int contextPtr/*hys*/){};
                  
                       
/*OTOpenInternetServices
Opens the TCP/IP service provider and returns an internet services reference. 

C INTERFACE
InetSvcRef OTOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OSStatus *
C++ INTERFACE
None. C++ clients use the C interface to this function.

PARAMETERS
cfig 
A pointer to a network configuration structure. You can obtain the default configuration by using the constant kDefaultInternetServicesPath for this parameter. 
oflag 
Reserved. Must be set to 0. 
err 
A pointer to the function result. 
function result 
An internet services reference. 
DISCUSSION
You must open a TCP/IP service provider before calling any TCP/IP service functions other than the address utility functions. The return value of this function is the internet services reference. You must provide the internet services reference when calling any of these non-utility functions. The OTOpenInternetServices function runs synchronously and also sets the mode of the TCP/IP service provider as synchronous.

If you want to set an option as part of the configuration string, you should translate the option's constant name, given in the header files, into a string that the configuration functions can parse. For the TCP/IP options, Table 11-2 provides the constant name used in "Options" and the value to used in the configuration string

SEE ALSO
The OTAsyncOpenInternetServices function.*/

InetSvcRef OTOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OSStatus *err){};

