#import <PDFKit/PDFView.h>
//work
@implementation PDFView
/*drawPage:

For use by subclasses of PDFView for custom rendering of pages.

- (void)drawPage:(PDFPage *)page
Discussion

Do not invoke this method, except by invoking it on super from a subclass.

The PDFView class calls drawPage: as necessary for each visible page that requires rendering. In the PDFView class, this method erases page to white, calls [page drawInRect: pageRect withBox: [self displayBox]] , and then draws the selection, if any.

You can override this method to draw on top of a PDF page or to control how pages are drawn. In these cases, invoke this method on super and then perform custom drawing on top of the PDF page.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)drawPage:(PDFPage *)page{}


/*displayBox

Returns the current style of display box.

- (PDFDisplayBox)displayBox
Discussion

The available values for display boxes are defined in the “Constants” section in the PDFPage class.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setDisplayBox:*/
- (PDFDisplayBox)displayBox{}


/*setDocument:

Associates a document with a PDF View object.

- (void)setDocument:(PDFDocument *)document
Discussion

If a document was already associated with the view, it is released first and then document is associated with the view.
Availability
Available in Mac OS X v10.4 and later.
See Also
– document*/
- (void)setDocument:(PDFDocument *)document{}


/*setAutoScales:

Toggles whether or not the scaling factor applied to a view automatically responds to resizing.

- (void)setAutoScales:(BOOL)newAuto
Discussion

When set to autoscaling, the document scales to fill the PDFView as the user resizes it.

For the single-page and two-up continuous modes, autoscaling fits the page to the width of the view. For single-page and two-up noncontinuous modes, autoscaling provides best fit, in which the viewed pages are as large as possible while displaying in their entirety within the PDF view.
Availability
Available in Mac OS X v10.4 and later.
See Also
– autoScales*/
- (void)setAutoScales:(BOOL)newAuto{}


/*setDisplaysPageBreaks:

Toggles the display of page breaks.

- (void)setDisplaysPageBreaks:(BOOL)breaks
Availability
Available in Mac OS X v10.4 and later.
See Also
– displaysPageBreaks*/
- (void)setDisplaysPageBreaks:(BOOL)breaks{}

/*document

Gets the document associated with a PDF View object.

- (PDFDocument *)document
Availability
Available in Mac OS X v10.4 and later.
See Also
– setDocument:*/
- (PDFDocument *)document{}


/*convertRect:fromPage:

Converts a rectangle from page space to view space.

- (NSRect)convertRect:(NSRect)rect fromPage:(PDFPage *)page
Discussion

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page. View space is a coordinate system with the origin at the lower-left corner of the current PDF view.
Availability
Available in Mac OS X v10.4 and later.
See Also
– convertPoint:toPage:
– convertRect:toPage:
– convertPoint:fromPage:*/
- (NSRect)convertRect:(NSRect)rect fromPage:(PDFPage *)page{}


/*goToDestination:

Navigates to the specified destination.

- (void)goToDestination:(PDFDestination *)destination
Discussion

Destinations include a page and a point on the page specified in page space.

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page.
Availability
Available in Mac OS X v10.4 and later.
See Also
– currentDestination (PDFDestination)
– currentPage*/
- (void)goToDestination:(PDFDestination *)destination{}






@end


