#include <QD/QD.h>

/*Once you’ve registered your window, you can use the conversion routine GetHWNDPort to obtain a QTML-style window pointer for it:WindowPtr GetNativeWindowPort (void *h)*/
WindowPtr GetHWNDPort (void *h){
printf ("GetHWNDPort",h);
};

QDGlobals qd;


void * GetPortHDC(GrafPtr port){
printf ("GetPortHDC",port);
};

void *GetPortHBITMAP(GrafPtr port){
printf ("GetPortHBITMAP",port);
};

//work


/*FrameRoundRect

Draws an outline inside a rounded rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRoundRect (
   const Rect * r,
   short ovalWidth,
   short ovalHeight
);
Parameters
r

The rectangle that defines the rounded rectangle’s boundaries.
ovalWidth

The width of the oval defining the rounded corner.
ovalHeight

The height of the oval defining the rounded corner.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRoundRect function draws an outline just inside the rounded rectangle bounded by the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change. 

Use the ovalWidth and ovalHeight parameters to specify the diameters of curvature for the corners of the rounded rectangle.

If a region is open and being formed, the outside outline of the new rounded rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRoundRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void FrameRoundRect (
   const Rect * r,
   short ovalWidth,
   short ovalHeight
){};


/*SetRect

Assigns coordinates to a rectangle. 

void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
r

A pointer to the rectangle to set.
left

The horizontal coordinate of the new upper-left corner of the rectangle.
top

The vertical coordinate of the new upper-left corner of the rectangle.
right

The horizontal coordinate of the new lower-right corner of the rectangle.
bottom

The vertical coordinate of the new lower-right corner of the rectangle.
Discussion

The SetRect function assigns the coordinates you specify in the left, top, right, and bottom parameters to the rectangle that you specify in the r parameter. This function is provided to help you shorten your program text. If you want a more readable text, at the expense of source text length, you can instead assign integers (or points) directly into the fields of a Rect structure.

You can use a rectangle to specify locations and sizes for various graphics operations.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom){
//TODO
};

/*GetPortBounds

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect){
//TODO
};

/*EraseRect

Erases a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRect (
   const Rect * r
);
Parameters
r

The rectangle to erase.
Discussion

Using the patCopy pattern mode, the EraseRect function draws the interior of the rectangle that you specify in the r parameter with the background pattern for the current graphics port. This effectively erases the rectangle, making the shape blend into the background pattern of the graphics port. For example, use EraseRect to erase the port rectangle for a window before redrawing into the window.

This function leaves the location of the graphics pen unchanged. 
Special Considerations

The EraseRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void EraseRect (
   const Rect * r){
//TODO
};

/*CopyBits

Copies a portion of a bitmap or a pixel map from one graphics port or offscreen graphics world into another graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

The source BitMap structure. 
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
dstRect

The destination rectangle.
mode

One of the eight source modes in which the copy is to be performed. See Source, Pattern, and Arithmetic Transfer Mode Constants. The CopyBits function always dithers images when shrinking them between pixel maps on direct devices. 

When transferring pixels from a source pixel map to a destination pixel map, color QuickDraw interprets the source mode constants differently than basic QuickDraw does.

When you use CopyBits on a computer running color QuickDraw, you can also specify one of the transfer modes in the mode parameter.
maskRgn

A region to use as a clipping mask. You can pass a region handle to specify a mask region the resulting image is always clipped to this mask region and to the boundary rectangle of the destination bitmap. If the destination bitmap is the current graphics port’s bitmap, it is also clipped to the intersection of the graphics port’s clipping region and visible region. If you do not want to clip to a masking region, just pass NULL for this parameter. 
Discussion

The CopyBits function transfers any portion of a bitmap between two basic graphics ports, or any portion of a pixel map between two color graphics ports. Use CopyBits to move offscreen graphic images into an onscreen window, to blend colors for the image in a pixel map, and to shrink and expand images.

Specify a source bitmap in the srcBits parameter and a destination bitmap in the dstBits parameter. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. In a CGrafPort structure, the high 2 bits of the portVersion field are set. This field, which shares the same position in a CGrafPort structure as the portBits.rowBytes field in a GrafPort structure, indicates to CopyBits that you have passed it a handle to a pixel map rather than a bitmap.

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyBits scales the source image to fit the destination. If the bit image is a circle in a square source rectangle, and the destination rectangle is not square, the bit image appears as an oval in the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

The CopyDeepMask function combines the functions of the CopyBits and CopyMask functions. 
Special Considerations

When you use the CopyBits function to transfer an image between pixel maps, the source and destination images may be of different pixel depths, of different sizes, and they may have different color tables. However, CopyBits assumes that the destination pixel map uses the same color table as the color table for the current GDevice structure. (This is because the Color Manager requires an inverse table for translating the color table from the source pixel map to the destination pixel map.) 

The CopyBits function applies the foreground and background colors of the current graphics port to the image in the destination pixel map (or bitmap), even if the source image is a bitmap. This causes the foreground color to replace all black pixels in the destination and the background color to replace all white pixels. To avoid unwanted coloring of the image, use the RGBForeColor function to set the foreground to black and use the RGBBackColor function to set the background to white before calling CopyBits.

The source bitmap or pixel map must not occupy more memory than half the available stack space. The stack space required by CopyBits is roughly five times the value of the rowBytes field of the source pixel map: one rowBytes value for the pixel map (or bitmap), an additional rowBytes value for dithering, another rowBytes value when stretching or shrinking the source pixel map into the destination, another rowBytes value for any color map changing, and a fifth additional rowBytes value for any color aliasing. If there is insufficient memory to complete a CopyBits operation in Color QuickDraw, the QDError function returns the result code –143.

If you use CopyBits to copy between two graphics ports that overlap, you must first use the LocalToGlobal function to convert to global coordinates, and then specify the global variable screenBits for both the srcBits and dstBits parameters.

The CopyBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

If you are reading directly from a NuBus video card with a base address of Fs00000 and there is not a card in the slot (s–1) below it, CopyBits reads addresses less than the base address of the pixel map. This causes a bus error. To work around the problem, remap the baseAddr field of the pixel map in your video card to at least 20 bytes above the NuBus boundary; an address link of Fs000020 precludes the problem.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn){
//TODO
};


/*QDFlushPortBuffer

Calls the Quartz compositor to flush all new drawing in a Carbon window to the display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);
Parameters
port

A window port. If the port has no back buffer, or if the port is an offscreen or printing port, this function does nothing.
region

An update region. Under normal conditions, you should pass NULL to avoid the overhead of additional region operations.
Discussion

In Mac OS X, drawing in a window port updates a back buffer associated with the window. Updates to this buffer are accumulated in a list called the dirty region. 

The back buffer is automatically flushed to the display each time through the event loop. When the event loop does not get control soon enough—for example, during an animation sequence—you can call this function to flush the port buffer to the device immediately. 

When you call this function, there are several different execution paths:
If the region parameter is NULL, the dirty region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the dirty region is set to empty.
If the region parameter specifies an update region, the intersection of the dirty region and the update region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the flushed region is subtracted from the dirty region.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region){
//TODO
};

/*LMSetHiliteMode

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LMSetHiliteMode (
   UInt8 value
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void LMSetHiliteMode (
   UInt8 value
){};

/*SetQDGlobalsArrow

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetQDGlobalsArrow (
   const Cursor * arrow
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetQDGlobalsArrow (
   const Cursor * arrow
){};


/*LMGetHiliteMode

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

UInt8 LMGetHiliteMode ();
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
UInt8 LMGetHiliteMode (){};


/*GetPortTextFont

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

short GetPortTextFont (
   CGrafPtr port
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
short GetPortTextFont (
   CGrafPtr port
){};

/*IsPortColor

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean IsPortColor (
   CGrafPtr port
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
Boolean IsPortColor (
   CGrafPtr port
){};



/*InsetRect

Shrinks or expands a rectangle. 

void InsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to alter.
dh

The horizontal distance to move the left and right sides in toward or outward from the center of the rectangle.
dv

The vertical distance to move the top and bottom sides in toward or outward from the center of the rectangle.
Discussion

The InsetRect function shrinks or expands the rectangle that you specify in the r parameter: the left and right sides are moved in by the amount you specify in the dh parameter; the top and bottom are moved toward the center by the amount you specify in the dv parameter. If the value you pass in dh or dv is negative, the appropriate pair of sides is moved outward instead of inward. The effect is to alter the size by 2*dh horizontally and 2*dv vertically, with the rectangle remaining centered in the same place on the coordinate plane.

If the resulting width or height becomes less than 1, the rectangle is set to the empty rectangle (0,0,0,0).

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void InsetRect (
   Rect * r,
   short dh,
   short dv
){};


/*LMGetHiliteRGB

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LMGetHiliteRGB (
   RGBColor * hiliteRGBValue
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void LMGetHiliteRGB (
   RGBColor * hiliteRGBValue
){};



/*DisposeCCursor

Disposes of all structures allocated by the GetCCursor function. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeCCursor (
   CCrsrHandle cCrsr
);
Parameters
cCrsr

A handle to the color cursor to be disposed of. 
Discussion

Use DisposeCCursor for each call to the GetCCursor function.

The DisposeCCursor function is also available as the DisposCCursor function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DisposeCCursor (
   CCrsrHandle cCrsr
){};


/*GetCCursor

Loads a color cursor resource into memory. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CCrsrHandle GetCCursor (
   short crsrID
);
Parameters
crsrID

The resource ID of the cursor that you want to display.
Return Value

A handle to the new CCrsr structure. To display this cursor on the screen, call SetCCursor. If a resource with the specified ID isn’t found, then this function returns a NULL handle. 
Discussion

The GetCCursor function creates a new CCrsr structure and initializes it using the information in the ‘crsr’ resource with the specified ID. 

Since the GetCCursor function creates a new CCrsr structure each time it is called, do not call the GetCCursor function before each call to the SetCCursor function. Unlike the way GetCursor and SetCursor are normally used, GetCCursor does not dispose of or detach the resource, so resources of type 'crsr' should typically be purgeable. Call the DisposeCCursor function when you are finished using the color cursor created with GetCCursor. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
CCrsrHandle GetCCursor (
   short crsrID
){};

/*Move

Moves the graphics pen a particular distance. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void Move (
   short dh,
   short dv
);
Parameters
dh

The horizontal distance of the graphics pen’s movement.
dv

The vertical distance of the graphics pen’s movement.
Discussion

The Move function moves the graphics pen from its current location in the current graphics port a horizontal distance that you specify in the dh parameter and a vertical distance that you specify in the dv parameter. The Move function calls 

MoveTo(h+dh,v+dv)

where (h,v) is the graphics pen’s current location in local coordinates. The Move function performs no drawing. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void Move (
   short dh,
   short dv
){};

/*QDDisplayWaitCursor

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDDisplayWaitCursor (
   Boolean forceWaitCursor
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDDisplayWaitCursor (
   Boolean forceWaitCursor
){};

/*FrameRgn

Draws an outline inside a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to frame. 
Discussion

Using the current graphics port’s pen pattern, pattern mode, and pen size, the FrameRgn function draws an outline just inside the region whose handle you pass in the rgn parameter. The outline never goes outside the region boundary. The pen location does not change.

If a region is open and being formed, the outside outline of the region being framed is mathematically added to that region’s boundary.

This function depends on the local coordinate system of the current graphics port. If you draw a region in a graphics port different from the one in which you defined the region, it may not appear in the proper position in the graphics port.

If any horizontal or vertical line drawn through the region would intersect the region’s outline more than 50 times, the results of this graphics operation are undefined. The FrameRgn function in particular requires that there would be no more than 25 such intersections. 
Special Considerations

The FrameRgn function calls the functions CopyRgn, InsetRgn, and DiffRgn, so FrameRgn may temporarily use heap space that’s three times the size of the original region.

The FrameRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void FrameRgn (
   RgnHandle rgn
){};



/*PaintArc

Paints a wedge of the oval that fits inside a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintArc (
   const Rect * r,
   short startAngle,
   short arcAngle
);
Parameters
r

The rectangle that defines an oval’s boundaries.
startAngle

The angle indicating the start of the arc.
arcAngle

The angle indicating the arc’s extent.
Discussion

Using the pen pattern and pattern mode of the current graphics port, the PaintArc function draws a wedge of the oval bounded by the rectangle that you specify in the r parameter. As in the FrameArc function, use the startAngle and arcAngle parameters to define the arc of the wedge. 

The pen location does not change.

Use FillArc , to draw a wedge with a pattern different from that specified in the pnPat field of the current graphics port. 
Special Considerations

The PaintArc function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PaintArc (
   const Rect * r,
   short startAngle,
   short arcAngle
){};


/*EmptyRgn

Determines whether a region is empty. (Deprecated in Mac OS X v10.4.)

Boolean EmptyRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to test for emptiness. 
Return Value

TRUE if the region whose handle you pass in the rgn parameter is an empty region or FALSE if it is not. 
Discussion

The EmptyRgn function does not create an empty region. To create an empty region, you can perform any of the following operations:
Use NewRgn. 
Pass the handle to an empty region to CopyRgn. 
Pass an empty rectangle to either SetRectRgn or RectRgn. 
Call CloseRgn without a previous call to OpenRgn. 
Call CloseRgn without performing any drawing after calling OpenRgn. 
Pass an empty region to OffsetRgn. 
Pass an empty region or too large an inset to InsetRgn
Pass two nonintersecting regions to SectRgn. 
Pass two empty regions to UnionRgn. 
Pass two identical or nonintersecting regions to DiffRgn or XorRgn. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean EmptyRgn (
   RgnHandle rgn
){};


/*CreateCGContextForPort

Creates a Quartz 2D drawing environment associated with a graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Not Recommended

OSStatus CreateCGContextForPort (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A color graphics port in which to draw. Offscreen graphics worlds with pixel depths of 1, 2, 4, and 8 are not supported. When using Quartz 2D to draw in a offscreen graphics world, alpha information is always ignored. Printing ports are not supported—if you specify a printing port, this function does nothing and returns a non-zero result code. 
contextPtr

A pointer to your storage for a Quartz context. Upon completion, contextPtr points to a context associated with the port. The context matches the port’s pixel depth, width, and height. Otherwise the context is in a default state and does not necessarily match other port attributes such as foreground color, background color, or clip region.

You should release this context when you no longer need it.
Return Value

A result code. If noErr, the context was successfully created.
Discussion

This function is not recommended in Mac OS X version 10.1 and later. For information about its replacement, see QDBeginCGContext.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSStatus CreateCGContextForPort (
   CGrafPtr port,
   CGContextRef * contextPtr
){};

/*UnionRect

Calculates the smallest rectangle that encloses two rectangles. 

void UnionRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);
Parameters
src1

The first of two rectangles to enclose.
src2

The second of two rectangles to enclose.
dstRect

On return, a pointer to the smallest rectangle that encloses both of the rectangles you specify in the src1 and src2 parameters. One of the source rectangles may also be the destination.
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void UnionRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
){};


/*RGBBackColor

Changes the background color. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBBackColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbBkColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the bkColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. F or direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system.

You can also use Palette Manager functions to set the background color.

To determine the current background color, use the GetBackColor function.

Because a pixel pattern already contains color, QuickDraw ignores the background color and foreground colors when your application draws with a pixel pattern. Use the PenPixPat function to assign a pixel pattern to the foreground pattern used by the graphics pen. Use the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port. Use the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBBackColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

This function is available for basic QuickDraw only in System 7. To set the background color for basic graphics ports on older versions of system software, use the BackColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBBackColor (
   const RGBColor * color
){};

/*GetMainDevice

Obtains a handle to the GDevice structure for the main screen. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetMainDevice ();
Return Value

A handle to the device for the main screen, which is the device containing the menu bar. 
Discussion

A handle to the main device is kept in the global variable MainDevice.

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetMainDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetMainDevice (){};

/*ShowCursor

Displays a cursor hidden by the HideCursor or ShieldCursor functions. 

void ShowCursor ();
Discussion

ShowCursor increments the cursor level, which has been decremented by the HideCursor or ShieldCursor function and displays the cursor on the screen when the level is 0. A call to the ShowCursor function balances each previous call to the HideCursor or ShieldCursor function. The level is not incremented beyond 0, so extra calls to ShowCursor have no effect.

Low-level interrupt-driven functions link the cursor with the mouse position, so that if the cursor level is 0 and visible, the cursor automatically follows the mouse. 

If the cursor has been changed with the SetCursor function while hidden, ShowCursor displays the new cursor. 
Declared In
Quickdraw.h*/
void ShowCursor (){};

/*HideCursor

Hides the cursor if it is visible on the screen. (Deprecated in Mac OS X v10.4.)

void HideCursor ();
Discussion

The HideCursor function removes the cursor from the screen, restores the bits under the cursor image, and decrements the cursor level (which InitCursor initialized to 0). You might want to use HideCursor when the user is using the keyboard to create content in one of your application’s windows. Every call to HideCursor should be balanced by a subsequent call to the ShowCursor function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void HideCursor (){};




/*GetPortBitMapForCopyBits

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

const BitMap * GetPortBitMapForCopyBits (
   CGrafPtr port
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
const BitMap * GetPortBitMapForCopyBits (
   CGrafPtr port
){};

/*GetRegionBounds

(Deprecated in Mac OS X v10.4.)

Rect * GetRegionBounds (
   RgnHandle region,
   Rect * bounds
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Rect * GetRegionBounds (
   RgnHandle region,
   Rect * bounds
){};


/*DisposePort

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposePort (
   CGrafPtr port
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DisposePort (
   CGrafPtr port
){};

/*CreateNewPortForCGDisplayID

Creates a graphics port associated with a display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CGrafPtr CreateNewPortForCGDisplayID (
   UInt32 displayID
);
Parameters
displayID

A display identifier. If the identifier is not valid, the main display is used instead. For information about finding displays, see Quartz Display Services Reference.
Return Value

A new display port. The portBounds rectangle is the same size as the display. When you are finished using the port, you should call DisposePort to release it.
Discussion

This function returns a graphics port used to draw directly to a display. The pixel map for the new port is taken from the GDevice record corresponding to the display. There is no back buffer associated with the port.

Before calling this function, you should capture the display. For information about capturing displays, see Quartz Display Services Reference.

You should not call this function and then attempt to create a Quartz drawing environment inside the port. Instead, applications using Quartz 2D can call CGDisplayGetDrawingContext to obtain a context suitable for drawing directly to a captured display.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

CGrafPtr CreateNewPortForCGDisplayID (
   UInt32 displayID
){};



/*QDIsPortBuffered

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean QDIsPortBuffered (
   CGrafPtr port
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean QDIsPortBuffered (
   CGrafPtr port
){};


/*InvertColor

Finds the complement of an RGBColor data structure. This function is used only by system software. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void InvertColor (
   RGBColor * myColor
);
Parameters
myColor

A pointer to the RGBColor data structure for which the complement is to be found.The InvertColor function returns the complement of an absolute color, using the list of complement functions in the current device data structure. The default complement function uses the one’s complement of each component of the given color. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void InvertColor (
   RGBColor * myColor
){};


/*PaintOval

Paints an oval with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintOval (
   const Rect * r
);
Parameters
r

The rectangle that defines the oval’s boundary.
Discussion

Using the pen pattern and pattern mode for the current graphics port, the PaintOval function draws the interior of an oval just inside the bounding rectangle that you specify in the r parameter. The pen location does not change.

Use FillOval to draw the interior of an oval with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintOval function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void PaintOval (
   const Rect * r
){};



/*GlobalToLocal

Converts the coordinates of a point from global coordinates to the local coordinates of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GlobalToLocal (
   Point * pt
);
Parameters
pt

A pointer to a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]). On return, this point is converted to local coordinates.
Discussion

The GlobalToLocal procedure takes a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]) and converts it into the local coordinates of the current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GlobalToLocal (
   Point * pt
){};


/*GetPenState

Determines the graphics pen’s location, size, pattern, and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPenState (
   PenState * pnState
);
Parameters
pnState

On return, a pointer to a PenState structure holding information about the graphics pen. The GetPenState function saves the location, size, pattern, and pattern mode of the graphics pen for the current graphics port in this structure. 
Discussion

After changing the graphics pen as necessary, restore these pen states with the SetPenState function. 

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPenState (
   PenState * pnState
){};

/*GetPort

Saves the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPort (
   GrafPtr * port
);
Parameters
port

On return, a pointer to a GrafPort structure for the current graphics port. If the current graphics port is a color graphics port, GetPort coerces its CGrafPort structure into a GrafPort structure. 
Discussion

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the GetGWorld function instead of GetPort. The GetGWorld function saves the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPort (
   GrafPtr * port
){};

/*SetPort

Changes the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPort (
   GrafPtr port
);
Parameters
port

A pointer to a GrafPort structure. Typically, you pass a pointer to a GrafPort structure that you previously saved with the GetPort function. The SetPort function sets this structure to be the current graphics port. 
Discussion

All QuickDraw drawing functions affect the bitmap of, and use the local coordinate system of, the current graphics port. Each graphics port has its own graphics pen and text characteristics, which remain unchanged when the graphics port isn’t selected as the current graphics port.

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the SetGWorld function instead of SetPort. The SetGWorld function restores the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void SetPort (
   GrafPtr port){
//TODO
};


/*PenSize

Sets the dimensions of the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenSize (
   short width,
   short height
);
Parameters
width

The pen width, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
height

The pen height, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
Discussion

The PenSize function sets the width that you specify in the width parameter and the height that you specify in the height parameter for the graphics pen in the current graphics port. All subsequent calls to the Line and LineTo functions and to the functions that draw framed shapes in the current graphics port use the new pen dimensions.

You can get the current pen dimensions from the pnSize field of the current graphics port, where the width and height are stored as a Point structure.

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenSize (
   short width,
   short height
){};



/*MapRect

Maps and scales a rectangle within one rectangle to another rectangle. (Deprecated in Mac OS X v10.4.)

void MapRect (
   Rect * r,
   const Rect * srcRect,
   const Rect * dstRect
);
Parameters
r

Upon input, a pointer to the rectangle to map; upon completion, the mapped rectangle.
srcRect

The rectangle containing the rectangle to map.
dstRect

The rectangle in which the new rectangle will be mapped.
Discussion

The MapRect function takes a rectangle within one rectangle and maps and scales it to another rectangle. In the r parameter, you specify a rectangle that lies within the rectangle that you specify in the srcRect parameter. By calling the MapPt function to map the upper-left and lower-right corners of the rectangle in the r parameter, MapRect maps and scales it to the rectangle that you specify in the dstRect parameter. The MapRect function returns the newly mapped rectangle in the r parameter. 
Special Considerations

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void MapRect (
   Rect * r,
   const Rect * srcRect,
   const Rect * dstRect
){};


/*XorRgn

Calculates the difference between the union and the intersection of two regions.

void XorRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
);
Parameters
srcRgnA

A handle to the first of two regions to compare. 
srcRgnB

A handle to the second of two regions to compare.
dstRgn

On return, a handle to the region holding the result.

This does not create the destination region; you must have already allocated memory for it by using the NewRgn function.

If the regions are coincident, XorRgn sets the destination region to the empty region defined by the rectangle (0,0,0,0).
Discussion

The XorRgn procedure calculates the difference between the union and the intersection of the regions whose handles you pass in the srcRgnA and srcRgnB parameters and places the result in the region whose handle you pass in the dstRgn parameter. 

This does not create the destination region; you must have already allocated memory for it by using the NewRgn function.

If the regions are coincident, XorRgn sets the destination region to the empty region defined by the rectangle (0,0,0,0). 
Special Considerations

The XorRgn function may temporarily use heap space that’s twice the size of the two input regions.

The XorRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Declared In
Quickdraw.h*/
void XorRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
){};

/*SetOrigin

Changes the coordinates of the window origin of the port rectangle of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetOrigin (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the upper-left corner of the port rectangle.
v

The vertical coordinate of the upper-left corner of the port rectangle.
Discussion

The SetOrigin function changes the coordinates of the upper-left corner of the current graphics port’s port rectangle to the values supplied by the h and v parameters. All other points in the current graphics port’s local coordinate system are calculated from this point. All subsequent drawing and calculation functions use the new coordinate system.

The SetOrigin function does not affect the screen; it does, however, affect where subsequent drawing inside the graphics port appears. The SetOrigin function does not offset the coordinates of the clipping region or the graphics pen, which therefore change position on the screen (unlike the boundary rectangle, port rectangle, and visible region, which don’t change position onscreen).

Because SetOrigin does not move the window’s clipping region, use the GetClip function to store your clipping region immediately after your first call to SetOrigin—if you use clipping regions in your windows. Before calling your own window-drawing function, use the ClipRect function to define a new clipping region—to avoid drawing over your scroll bars, for example. After calling your own window-drawing function, use the SetClip function to restore the original clipping region. You can then call SetOrigin again to restore the window origin to a horizontal coordinate of 0 and a vertical coordinate of 0 with your original clipping region intact. 

All other functions in the Macintosh Toolbox and Operating System preserve the local coordinate system of the current graphics port. The SetOrigin function is useful for readjusting the coordinate system after a scrolling operation. 

Note that the Window Manager and Control Manager always assume the window’s upper-left point has a horizontal coordinate of 0 and a vertical coordinate of 0 when they draw in a window. Therefore, if you use SetOrigin to change the window origin, be sure to use SetOrigin again to return the window origin to a horizontal coordinate of 0 and a vertical coordinate of 0 before using any Window Manager or Control Manager functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetOrigin (
   short h,
   short v
){};


/*SetEmptyRgn

Sets an existing region to be empty. (Deprecated in Mac OS X v10.4.)

void SetEmptyRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to be made empty. 
Discussion

The SetEmptyRgn function destroys the previous structure of the region whose handle you pass in the rgn parameter; it then sets the new structure to the empty region defined by the rectangle (0,0,0,0). 
Special Considerations

The SetEmptyRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetEmptyRgn (
   RgnHandle rgn
){};

/*SectRgn

Calculates the intersection of two regions. (Deprecated in Mac OS X v10.4.)

void SectRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
);
Parameters
srcRgnA

A handle to the first of two regions whose intersection is to be determined. 
srcRgnB

A handle to the second of two regions whose intersection is to be determined.
dstRgn

On return, a handle to the region holding the intersection area.If the regions do not intersect, or one of the regions is empty, SectRgn sets the destination to the empty region defined by the rectangle (0,0,0,0). 

The SectRgn function does not create a destination region; you must have already allocated memory for it by using the NewRgn function. 

The destination region may be one of the source regions, if desired.
Discussion

The SectRgn procedure calculates the intersection of the two regions whose handles you pass in the srcRgnA and srcRgnB parameters, and it places the intersection in the region whose handle you pass in the dstRgn parameter. If the regions do not intersect, or one of the regions is empty, SectRgn sets the destination to the empty region defined by the rectangle (0,0,0,0). 

The SectRgn procedure does not create a destination region; you must have already allocated memory for it by using the NewRgn function. 

The destination region may be one of the source regions, if desired. 
Special Considerations

The SectRgn function may temporarily use heap space that’s twice the size of the two input regions.

The SectRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SectRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
){};

/*DisposeCTable

Disposes a ColorTable structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeCTable (
   CTabHandle cTable
);
Parameters
cTable

A handle to a ColorTable structure to dispose of. 
Discussion

The DisposeCTable procedure disposes of the ColorTable record whose handle you pass in the cTable parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DisposeCTable (
   CTabHandle cTable
){};

/*EqualPt

Determines whether the coordinates of two given points are equal. (Deprecated in Mac OS X v10.4.)

Boolean EqualPt (
   Point pt1,
   Point pt2
);
Parameters
pt1

The first of two points to be compared.
pt2

The second of two points to be compared.
Return Value

TRUE if the coordinates of the two points are equal, or FALSE if they are not. 
Discussion

The EqualPt function compares the points specified in the pt1 and pt2 parameters and returns TRUE if their coordinates are equal or FALSE if they are not. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean EqualPt (
   Point pt1,
   Point pt2
){};

/*SubPt

Subtracts the coordinates of one point from another. (Deprecated in Mac OS X v10.4.)

void SubPt (
   Point src,
   Point * dst
);
Parameters
src

A point, the coordinates of which are to be subtracted from the coordinates of the point specified in the dst parameter.
dst

The address of a point. Upon completion, the coordinates of this point contain the differences between the coordinates of the two points specified in the entry parameters.

If you pass NULL in the dst parameter, this function sets the QDError result code to paramErr and returns.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SubPt (
   Point src,
   Point * dst
){};


/*TestDeviceAttribute

Determines whether the flag bit for an attribute has been set in the gdFlags field of a GDevice structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean TestDeviceAttribute (
   GDHandle gdh,
   short attribute
);
Parameters
gdh

A handle to a GDevice structure. 
attribute

One of the specific constants, which represent bits in the gdFlags field of a GDevice structure. See Device Attribute Constants for a description of the values you can use in this parameter.
Return Value

TRUE if the bit of the graphics device attribute specified in the attribute parameter is set to 1. Otherwise, TestDeviceAttribute returns FALSE. 
Discussion

Use the SetDeviceAttribute function to change any of the flags tested by the TestDeviceAttribute function. 
Special Considerations

The TestDeviceAttribute function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean TestDeviceAttribute (
   GDHandle gdh,
   short attribute
){};


/*GetNextDevice

Returns a handle to the next GDevice structure in the device list. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetNextDevice (
   GDHandle curDevice
);
Parameters
curDevice

A handle to the GDevice structure at which you want the search to begin. 
Return Value

A handle to the next device. If there are no more GDevice structures in the list, NULL. 
Discussion

After using any of the functions GetDeviceList , GetGDevice , GetMainDevice , or GetMaxDevice to obtain a handle to a GDevice structure, use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetNextDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetNextDevice (
   GDHandle curDevice
){};


/*GetDeviceList

Obtains a handle to the first GDevice structure in the device list. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetDeviceList ();
Return Value

A handle to the first GDevice structure in the global variable DeviceList. 
Discussion

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetDeviceList function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetDeviceList (){};




/*PenNormal

Sets the size, pattern, and pattern mode of the graphics pen in the current graphics port to their initial values. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenNormal ();
Discussion

The PenNormal function restores the size, pattern, and pattern mode of the graphics pen in the current graphics port to their initial values: a size of 1 pixel by 1 pixel, a pattern mode of patCopy, and a pattern of black. The pen location does not change. 
Special Considerations

The PenNormal function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenNormal (){};


/*GetCTSeed

Obtains a unique seed value for a color table created by your application. This function is used by system software and your application should not need to call it. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

long GetCTSeed ();
Return Value

A unique seed value that you can use in the ctSeed field of a color table created by your application. It is greater than the value stored in the constant minSeed. 
Discussion

The seed value guarantees that the color table is recognized as distinct from the destination, and that color table translation is performed properly. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
long GetCTSeed (){};

/*NewQDBitsUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDBitsUPP NewQDBitsUPP (
   QDBitsProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDBitsUPP NewQDBitsUPP (
   QDBitsProcPtr userRoutine
){};


/*NewQDRgnUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRgnUPP NewQDRgnUPP (
   QDRgnProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDRgnUPP NewQDRgnUPP (
   QDRgnProcPtr userRoutine
){};

/*NewQDPolyUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDPolyUPP NewQDPolyUPP (
   QDPolyProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDPolyUPP NewQDPolyUPP (
   QDPolyProcPtr userRoutine
){};

/*NewQDArcUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDArcUPP NewQDArcUPP (
   QDArcProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/


QDArcUPP NewQDArcUPP (
   QDArcProcPtr userRoutine
){};

/*NewQDTextUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDTextUPP NewQDTextUPP (
   QDTextProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h */

QDTextUPP NewQDTextUPP (
   QDTextProcPtr userRoutine
){};

/*NewQDRectUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRectUPP NewQDRectUPP (
   QDRectProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
QDRectUPP NewQDRectUPP (
   QDRectProcPtr userRoutine
){};


/*NewQDLineUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDLineUPP NewQDLineUPP (
   QDLineProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDLineUPP NewQDLineUPP (
   QDLineProcPtr userRoutine
){};



/*NewQDOvalUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDOvalUPP NewQDOvalUPP (
   QDOvalProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
QDOvalUPP NewQDOvalUPP (
   QDOvalProcPtr userRoutine
){};

/*NewQDRRectUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

QDRRectUPP NewQDRRectUPP (
   QDRRectProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

QDRRectUPP NewQDRRectUPP (
   QDRRectProcPtr userRoutine
){};


/*GetQDGlobalsLightGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsLightGray (
   Pattern * ltGray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Pattern * GetQDGlobalsLightGray (
   Pattern * ltGray
){};


/*SetStdCProcs

Obtains a CQDProcs structure with fields that point to QuickDraw’s standard low-level functions, which you can modify to change QuickDraw’s standard low-level behavior. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetStdCProcs (
   CQDProcs * procs
);
Parameters
procs

Upon completion, a CQDProcs structure with fields that point to QuickDraw’s standard low-level functions. You can change one or more fields to point to your own functions and then set the color graphics port to use this modified CQDProcs structure. 
Discussion

For each shape that QuickDraw can draw, certain functions perform basic graphics operations on the shape: framing, painting, erasing, inverting, and filling. These functions, in turn, call a low-level drawing function for the shape.

The grafProcs field determines which low-level functions are called. If that field contains a value of NULL, the standard functions are called. You can set the grafProcs field to point to a structure of pointers to your own functions, and either completely override the standard ones or call them after your functions have modified their parameters as necessary.

The SetStdCProcs function sets all the fields of the CQDProcs structure to point to the standard functions. You can then reset the ones with which you are concerned.

The functions you install in the CDQProcs structure must have the same calling sequences as the standard basic QuickDraw functions.

When drawing in a color graphics port, your application must always use SetStdCProcs instead of SetStdProcs. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetStdCProcs (
   CQDProcs * procs
){};


/*GetPixDepth

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

short GetPixDepth (
   PixMapHandle pixMap
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

short GetPixDepth (
   PixMapHandle pixMap
){};


/*BackPat

Changes the bit pattern used as the background pattern by the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void BackPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The BackPat function sets the bit pattern defined in the Pattern structure, which you specify in the pat parameter, to be the background pattern. (The standard bit patterns white, black, gray, ltGray, and dkGray are predefined; the initial background pattern for the graphics port is white.) This pattern is stored in the bkPat field of a GrafPort structure.

The BackPat function also sets a bit pattern for the background color in a color graphics port. The BackPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the bkPixPat field of the CGrafPort structure. As in basic graphics ports, Color QuickDraw draws patterns in color graphics ports at the time of drawing, not at the time you use PenPat to set the pattern.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The BackPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/


void BackPat (
   const Pattern * pat
){};


/*LockPortBits

Acquires an exclusive lock on the back buffer for a Carbon window. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSErr LockPortBits (
   GrafPtr port
);
Parameters
port

A window port.
Return Value

A result code. If noErr, the window’s back buffer is locked and available for direct access. 
Discussion

In Mac OS X, a Carbon window’s port bits are in a back buffer shared by the application and the Quartz compositor (sometimes called the window server). When an application needs to update this buffer, the Quartz compositor must be locked out temporarily. You can use this function together with UnlockPortBits to acquire and release an exclusive lock.

If you’re using QuickDraw or Quartz 2D to draw in a window, you do not need to call this function—buffer locks are handled for you automatically. If you’re writing code that reads or modifies the port bits directly, you should bracket your code with calls to this function and UnlockPortBits.

Nested calls to this function for the same port are permitted. For a given port, if you call LockPortBits n times, the lock is actually released after the nth balancing call to UnlockPortBits.

You should not call any QuickTime functions while holding the lock. To avoid degrading the user experience, you should release the lock as quickly as possible. 

In Mac OS 9, this function does nothing and returns noErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSErr LockPortBits (
   GrafPtr port
){};

/*UnlockPortBits

Releases a previously acquired lock on the back buffer for a Carbon window. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSErr UnlockPortBits (
   GrafPtr port
);
Parameters
port

A window port specified in a previous call to LockPortBits.
Return Value

A result code. If noErr, the corresponding lock is released.
Discussion

For more information about this function, see LockPortBits.

In Mac OS 9, this function does nothing and returns noErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSErr UnlockPortBits (
   GrafPtr port
){};

/*PenPat

Sets the bit pattern to be used by the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The PenPat function sets the graphics pen to use the bit pattern defined in the Pattern structure that you specify in the pat parameter. (The standard patterns white, black, gray, ltGray, and dkGray are predefined; the initial bit pattern for the pen is black.) This pattern is stored in the pnPat field of a GrafPort structure. The QuickDraw painting functions (such as PaintRect) also use the pen’s pattern when drawing a shape.

The PenPat function also sets a bit pattern for the graphics pen in a color graphics port. The PenPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the pnPixPat field of the CGrafPort structure. This pattern always uses the graphics port’s current foreground and background colors.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The PenPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenPat (
   const Pattern * pat
){};


/*SetPenState

Restores the state of the graphics pen that was saved with the GetPenState function. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPenState (
   const PenState * pnState
);
Parameters
pnState

A PenState structure previously created with the GetPenState function. The SetPenState function sets the graphics pen’s location, size, pattern, and pattern mode in the current graphics port to the values stored in this structure. 
Discussion

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPenState (
   const PenState * pnState
){};
/*PtInRect

Determines whether a pixel below is enclosed in a rectangle. 

Boolean PtInRect (
   Point pt,
   const Rect * r
);
Parameters
pt

The point to test.
r

The rectangle to test.
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is enclosed in the rectangle specified in the r parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

Boolean PtInRect (
   Point pt,
   const Rect * r
){};


/*GetQDGlobalsGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsGray (
   Pattern * gray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Pattern * GetQDGlobalsGray (
   Pattern * gray
){};


/*FrameRect

Draws an outline inside a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRect (
   const Rect * r
);
Parameters
r

The rectangle to frame.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRect function draws an outline just inside the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void FrameRect (
   const Rect * r
){};

/*PaintRect

Paints a rectangle with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRect (
   const Rect * r
);
Parameters
r

The rectangle to paint.
Discussion

The PaintRect function draws the interior of the rectangle that you specify in the r parameter with the pen pattern for the current graphics port, according to the pattern mode for the current graphics port. The pen location does not change.

Use the FillRect to draw the interior of a rectangle with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PaintRect (
   const Rect * r
){};

/*ShowPen

Changes the ink of a graphics pen from invisible to visible, making pen drawing appear on the screen. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ShowPen ();
Discussion

ShowPen is called by the functions CloseRgn , ClosePoly , and ClosePicture.

The ShowPen function increments the pnVis field of the current graphics port. For 0 or positive values, the pen drawing shows on the screen.

For example, if you have used the HidePen function to decrement the pnVis field from 0 to –1, use the ShowPen function to make its value 0 so that QuickDraw resumes drawing on the screen. Subsequent calls to ShowPen increment pnVis beyond 0, so every call to ShowPen should be balanced by a call to HidePen. 

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ShowPen (){};


/*ClosePoly

Completes the collection of lines that defines a polygon. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ClosePoly ();
Discussion

The ClosePoly function stops collecting line-drawing commands for the currently open polygon and computes the polyBBox field of the Polygon structure. You should call ClosePoly only once for every call to the OpenPoly function. 

The ClosePoly function uses the ShowPen function, balancing the call to the HidePen function made by the OpenPoly function. 
Special Considerations

The ClosePoly function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ClosePoly (){};

/*SetCCursor

Specifies a color cursor for display on the screen. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetCCursor (
   CCrsrHandle cCrsr
);
Parameters
cCrsr

A handle to the color cursor to be displayed. 
Discussion

At the time the cursor is set, it is expanded to the current screen depth so that it can be drawn rapidly. You must call GetCCursor before you call SetCCursor; however, you can make several subsequent calls to SetCCursor once GetCCursor creates the CCrsr structure. 

If your application has changed the cursor’s data or its color table, it must also invalidate the crsrXValid and crsrID fields of the CCrsr structure before calling SetCCursor. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetCCursor (
   CCrsrHandle cCrsr
){};


/*Index2Color

Obtains the RGBColor data structure corresponding to an index value in the color table of the current GDevice data structure. Your application should not need to call this function; it is used by system software only. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void Index2Color (
   long index,
   RGBColor * aColor
);
Parameters
index

The index value whose color entry is sought; you should supply a long integer in which the high-order word is padded with zeros.
aColor

A pointer to the returned RGBColor data structure. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void Index2Color (
   long index,
   RGBColor * aColor
){};



/*Line

Draws a line a specified distance from the graphics pen’s current location in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void Line (
   short dh,
   short dv
);
Parameters
dh

The horizontal distance of the graphics pen’s movement.
dv

The vertical distance of the graphics pen’s movement.
Discussion

Starting at the current location of the graphics pen, the Line function draws a line the horizontal distance that you specify in the dh parameter and the vertical distance that you specify in the dv parameter. The Line function calls

LineTo(h+dh,v+dv)

where (h,v) is the current location in local coordinates. The pen location becomes the coordinates of the end of the line after the line is drawn. If you are using Line to draw a region or polygon, its outline is infinitely thin and is not affected by the values of the pnSize, pnMode, and pnPat fields of the graphics port. 
Special Considerations

The Line function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void Line (
   short dh,
   short dv
){};


/*InsetRgn

Shrinks or expands a region. (Deprecated in Mac OS X v10.4.)

void InsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
);
Parameters
rgn

A handle to the region to alter. 
dh

The horizontal distance to move points on the left and right boundaries in toward or outward from the center.
dv

The vertical distance to move points on the top and bottom boundaries in toward or outward from the center.
Discussion

The InsetRgn function moves all points on the region boundary of the region whose handle you pass in the rgn parameter inward by the vertical distance that you specify in the dv parameter and by the horizontal distance that you specify in the dh parameter. If you specify negative values for dh or dv, the InsetRgn function moves the points outward in that direction. 

The InsetRgn function leaves the region’s center at the same position, but moves the outline in (for positive values of dh and dv) or out (for negative values of dh and dv). Using InsetRgn on a rectangular region has the same effect as using the InsetRect function. 
Special Considerations

The InsetRgn function temporarily uses heap space that’s twice the size of the original region.

The InsetRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void InsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
){}

/*AddPt

Adds the coordinates of two points. (Deprecated in Mac OS X v10.4.)

void AddPt (
   Point src,
   Point * dst
);
Parameters
src

A point, the coordinates of which are to be added to the point in the dstPt parameter.
dst

A pointer to a point, the coordinates of which are to be added to the point in the srcPt parameter. On return, this value contains the result of adding the coordinates of the points you supplied in the srcPt and dstPt parameters.
Discussion

The AddPt function adds the coordinates of the point specified in the srcPt parameter to the coordinates of the point specified in the dstPt parameter, and returns the result in the dstPt parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void AddPt (
   Point src,
   Point * dst
){};


/*QDLocalToGlobalRect

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * QDLocalToGlobalRect (
   CGrafPtr port,
   Rect * bounds
);
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Rect * QDLocalToGlobalRect (
   CGrafPtr port,
   Rect * bounds
){};


/*GetPicture

Obtains a handle to a picture stored in a 'PICT' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PicHandle GetPicture (
   short pictureID
);
Parameters
pictureID

The resource ID for a 'PICT' resource.
Return Value

A handle to the picture in the specified ‘PICT’ resource. To draw the picture stored in the resource, pass this handle to the DrawPicture function. If the resource cannot be read, GetPicture returns NULL. 
Discussion

The GetPicture function calls the Resource Manager function GetResource as follows:

GetResource(‘PICT’, picID) 
Special Considerations

To release the memory occupied by a picture stored in a 'PICT' resource, use the Resource Manager function ReleaseResource.

The GetPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PicHandle GetPicture (
   short pictureID
){};


/*DiffRgn

Subtracts one region from another. (Deprecated in Mac OS X v10.4.)

void DiffRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
);
Parameters
srcRgnA

A handle to the region to subtract from. 
srcRgnB

A handle to the region to subtract.
dstRgn

On return, a handle to the region holding the resulting area. If the first source region is empty, DiffRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The DiffRgn function does not create the destination region; you must have already allocated memory for it by using the NewRgn function. 

The destination region may be one of the source regions, if desired.
Discussion

The DiffRgn procedure subtracts the region whose handle you pass in the srcRgnB parameter from the region whose handle you pass in the srcRgnA parameter and places the difference in the region whose handle you pass in the dstRgn parameter. If the first source region is empty, DiffRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The DiffRgn procedure does not create the destination region; you must have already allocated memory for it by using the NewRgn function. The destination region may be one of the source regions, if desired. 
Special Considerations

The DiffRgn function may temporarily use heap space that’s twice the size of the two input regions.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DiffRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
){};

/*EraseRgn

Erases a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRgn (
   RgnHandle rgn
);
Parameters
rgn

The region to erase. 
Discussion

Using the patCopy pattern mode, the EraseRgn function draws the interior of the region whose handle you pass in the rgn parameter with the background pattern for the current graphics port. 

This function leaves the location of the graphics pen unchanged.

This function depends on the local coordinate system of the current graphics port. If you draw a region in a graphics port different from the one in which you defined the region, it may not appear in the proper position in the graphics port.

If any horizontal or vertical line drawn through the region would intersect the region’s outline more than 50 times, the results of this graphics operation are undefined. 
Special Considerations

The EraseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void EraseRgn (
   RgnHandle rgn
){};


/*GetCTable

Obtains a color table stored in a 'clut' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CTabHandle GetCTable (
   short ctID
);
Parameters
ctID

The resource ID of a 'clut' resource.
Return Value

A handle to the color table. If the 'clut' resource with that ID is not found, GetCTable returns NULL.Before you place this handle in the pmTable field of a PixMap structure, first use the DisposeCTable function to dispose of the handle already there. 
Discussion

Before you modify a ColorTable structure, change its ctSeed field to invalidate it. To do this, use the CTabChanged function.

The GetCTable function recognizes a number of standard 'clut' resource IDs. You can obtain the default grayscale color table for a given pixel depth by calling GetCTable, adding 32 (decimal) to the pixel depth, and passing these values in the ctID parameter:
A pixel depth of 1Pass a resource ID of 33. Color table composition: black, white. 
A pixel depth of 2Pass a resource ID of 34. Color table composition: black, 33% gray, 66% gray, white. 
A pixel depth of 4Pass a resource ID of 36. Color table composition: black, 14 shades of gray, white. 
A pixel depth of 8Pass a resource ID of 40. Color table composition: black, 254 shades of gray, white. 

For full color, obtain the default color tables by adding 64 to the pixel depth and passing these values in the ctID parameter:
A pixel depth of 2Pass a resource ID of 66. Color table composition: black, 50% gray, highlight color, white. 
A pixel depth of 4Pass a resource ID of 68. Color table composition: black, 14 colors including the highlight color, white. 
A pixel depth of 8Pass a resource ID of 72. Color table composition: black, 254 colors including the highlight color, white. 
Special Considerations

The GetCTable function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

CTabHandle GetCTable (
   short ctID
){};

/*EmptyRect

Determines whether a rectangle is an empty rectangle. (Deprecated in Mac OS X v10.4.)

Boolean EmptyRect (
   const Rect * r
);
Parameters
r

The rectangle to examine.
Return Value

TRUE if the rectangle that you specify in the r parameter is an empty rectangle, FALSE if it is not. A rectangle is considered empty if the bottom coordinate is less than or equal to the top coordinate or if the right coordinate is less than or equal to the left. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean EmptyRect (
   const Rect * r
){};

/*SectRect

Determines whether two rectangles intersect. (Deprecated in Mac OS X v10.4.)

Boolean SectRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
);
Parameters
src1

The first of two rectangles to test for intersection.
src2

The second of two rectangles to test for intersection.
dstRect

On return, a pointer to the rectangle marking the intersection of the first two rectangles.
Return Value

TRUE if the specified rectangles intersect or FALSE if they do not. 
Discussion

The SectRect function calculates the rectangle that delineates the intersection of the two rectangles you specify in the src1 and src2 parameters. Rectangles that touch at a line or a point are not considered intersecting, because their intersection rectangle (actually, in this case, an intersection line or point) does not enclose any pixels in the bit image.

If the rectangles do not intersect, the destination rectangle is set to (0,0,0,0). The SectRect function works correctly even if one of the source rectangles is also the destination.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean SectRect (
   const Rect * src1,
   const Rect * src2,
   Rect * dstRect
){};


/*EqualRect

Determines whether two rectangles are equal. 

Boolean EqualRect (
   const Rect * rect1,
   const Rect * rect2
);
Parameters
rect1

The first of two rectangles to compare.
rect2

The second of two rectangles to compare.
Return Value

TRUE if the rectangles are equal, FALSE if they are not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
Boolean EqualRect (
   const Rect * rect1,
   const Rect * rect2
){};


/*ObscureCursor

Hides the cursor until the next time the user moves the mouse. (Deprecated in Mac OS X v10.4.)

void ObscureCursor ();
Discussion

Your application normally calls ObscureCursor when the user begins to type. Unlike HideCursor , ObscureCursor has no effect on the cursor level and must not be balanced by a call to ShowCursor. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ObscureCursor (){};







/*GetMaxDevice

Obtains a handle to the GDevice structure for the video device with the greatest pixel depth. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetMaxDevice (
   const Rect * globalRect
);
Parameters
globalRect

A rectangle, in global coordinates, that intersects the graphics devices that you are searching to find the one with the greatest pixel depth.
Return Value

A handle to the device with the greatest pixel depth. 
Discussion

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list. 
Special Considerations

The GetMaxDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetMaxDevice (
   const Rect * globalRect
){};


/*GetQDGlobalsScreenBits

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

BitMap * GetQDGlobalsScreenBits (
   BitMap * screenBits
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
BitMap * GetQDGlobalsScreenBits (
   BitMap * screenBits
){};

/*ClosePicture

Completes the collection of drawing commands and picture comments that define your picture. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ClosePicture ();
Discussion

The ClosePicture function stops collecting drawing commands and picture comments for the currently open picture. You should perform one and only one call to ClosePicture for every call to the OpenCPicture (or OpenPicture) function.

The ClosePicture function calls the ShowPen function, balancing the call made by OpenCPicture (or OpenPicture) to the HidePen function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ClosePicture (){};

/*RGBForeColor

Changes the color of the “ink” used for framing and painting. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBForeColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbFgColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the fgColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. For direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system. 

You can also use Palette Manager functions to set the foreground color.

To determine the current foreground color, use the GetForeColor function.

QuickDraw ignores the foreground and background colors when your application draws with a pixel pattern. Assign a pixel pattern to the foreground pattern used by the graphics pen; by using the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port; and by using the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

The RGBForeColor function is available for basic QuickDraw only in System 7. To set the foreground color for basic graphics ports on older versions of system software, use the ForeColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBForeColor (
   const RGBColor * color
){};



/*NewRgn

Begins creating a new region. (Deprecated in Mac OS X v10.4.)

RgnHandle NewRgn ();
Return Value

A handle to the new region. 
Discussion

The NewRgn function allocates space for a new, variable-size region and initializes it to the empty region defined by the rectangle (0,0,0,0). This is the only function that creates a new region; other functions merely alter the size or shape of existing regions.

To begin defining a region, use the OpenRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The NewRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

Use the Memory Manager function MaxMem to determine whether the memory for the region is valid before using NewRgn.

Ensure that the memory for a region is valid before calling this function to manipulate that region if there isn’t sufficient memory, the system may crash. Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in color QuickDraw. Before defining a region, you can use the Memory Manager function MaxMem to determine whether the memory for the region is valid. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you record drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in color QuickDraw, the QDError function returns the result code regionTooBigError.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
RgnHandle NewRgn (){};

/*OpenRgn

Begins defining a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void OpenRgn ();
Discussion

The OpenRgn function allocates temporary memory to start saving lines and framed shapes for processing as a region definition. Call OpenRgn only after initializing a region with the NewRgn function.

The NewRgn function stores the definition for a region in a Region structure.

While a region is open, all calls to Line, LineTo, and the functions that draw framed shapes (except arcs) affect the outline of the region. Only the line endpoints and shape boundaries affect the region definition—the pattern mode, pattern, and size do not affect it.

When you are finished defining the region, call the CloseRgn function.

The OpenRgn function calls HidePen, so no drawing occurs on the screen while the region is open (unless you call ShowPen just after OpenRgn, or you called ShowPen previously without balancing it by a call to HidePen). Since the pen hangs below and to the right of the pen location, drawing lines with even the smallest pen changes pixels that lie outside the region you define.

The outline of a region is mathematically defined and infinitely thin, and it separates the bit or pixel image into two groups of pixels: those within the region and those outside it. 

A region should consist of one or more closed loops. Each framed shape itself constitutes a loop. Any lines drawn with the Line or LineTo function should connect with each other or with a framed shape. Even if the onscreen presentation of a region is clipped, the definition of a region is not; you can define a region anywhere on the coordinate plane with complete disregard for the location of various graphics port entities on that plane.

When a region is open, the current graphics port’s rgnSave field contains a handle to information related to the region definition. If you want to temporarily disable the collection of lines and shapes, you can save the current value of this field, set the field to NULL, and later restore the saved value to resume the region definition. Also, calling SetPort while a region is being formed discontinues formation of the region until another call to SetPort resets the region’s original graphics port.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you structure drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. 

Do not call OpenRgn while another region or a polygon is already open. When you are finished constructing the region, use the CloseRgn function, which is described next.

The OpenRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void OpenRgn (){};


/*MoveTo

Moves the graphics pen to a particular location in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void MoveTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new position.
v

The vertical coordinate of the graphics pen’s new position.
Discussion

The MoveTo function changes the graphics pen’s current location to the new horizontal coordinate you specify in the h parameter and the new vertical coordinate you specify in the v parameter. Specify the new location in the local coordinates of the current graphics port. The MoveTo function performs no drawing. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void MoveTo (
   short h,
   short v
){};



/*LineTo

Draws a line from the graphics pen’s current location to a new location. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LineTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new location.
v

The vertical coordinate of the graphics pen’s new location.
Discussion

The LineTo function draws a line from the graphics pen’s current location in the current graphics port to the new location (h,v), which you specify in the local coordinates of the current graphics port. If you are using LineTo to draw a region or polygon, its outline is infinitely thin and is not affected by the values of the pnSize, pnMode, or pnPat field of the graphics port. 
Special Considerations

The LineTo function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/


void LineTo (
   short h,
   short v
){};

/*StdRect

QuickDraw’s standard low-level function for drawing a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void StdRect (
   GrafVerb verb,
   const Rect * r
);
Parameters
verb

The action to perform. See Verb Constants. 
r

The rectangle to draw.
Discussion

The StdRect function draws the rectangle specified in the r parameter according to the action specified in the verb parameter.

You should only call this low-level function from your customized QuickDraw functions. 
Special Considerations

The StdRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void StdRect (
   GrafVerb verb,
   const Rect * r
){};



/*StdRgn

QuickDraw’s standard low-level function for drawing a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void StdRgn (
   GrafVerb verb,
   RgnHandle rgn
);
Parameters
verb

The action to perform. See Verb Constants. 
rgn

A handle to the region data. 
Discussion

The StdRgn function draws the region specified in the rgn parameter according to the action specified in the verb parameter.

You should only call this low-level function from your customized QuickDraw functions. 
Special Considerations

The StdRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void StdRgn (
   GrafVerb verb,
   RgnHandle rgn
){};

/*SetStdProcs

Obtains a QDProcs structure with fields that point to basic QuickDraw’s standard low-level functions, which you can modify to point to your own functions. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetStdProcs (
   QDProcs * procs
);
Parameters
procs

On return, a pointer to a QDProcs structure with fields that point to basic QuickDraw’s standard low-level functions. You can change one or more fields of this structure to point to your own functions and then set the basic graphics port to use this modified QDProcs structure. By changing these pointers, you can install your own functions, and either completely override the standard ones or call them after your functions have modified their parameters as necessary. 
Discussion

The functions you install in this QDProcs structure must have the same calling sequences as the standard functions. 
Special Considerations

The Color QuickDraw function SetStdCProcs is analogous to the SetStdProcs function, which you should use with computers that support only basic QuickDraw. When drawing in a color graphics port, your application must always use SetStdCProcs instead of SetStdProcs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetStdProcs (
   QDProcs * procs
){};


/*GetPortTextSize

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

short GetPortTextSize (
   CGrafPtr port
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
short GetPortTextSize (
   CGrafPtr port
){};

/*SetPortClipRegion

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
){};


/*ForeColor

Changes the color of the “ink” used for framing, painting, and filling on computers that support only basic QuickDraw. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ForeColor (
   long color
);
Parameters
color

One of eight color values. See Color Constants.
Discussion

By default, the foreground color of a GrafPort is black.

The ForeColor function sets the foreground color for the current graphics port to the color that you specify in the color parameter. When you draw with the patCopy and srcCopy transfer modes, for example, black pixels are drawn in the color you specify with ForeColor.

When printing, use the ColorBit function to set the foreground color.

All nonwhite colors appear as black on black-and-white screens. Before you use ForeColor, use the DeviceLoop function to determine the color characteristics of the current screen. 
Special Considerations

The ForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

In System 7, you may instead use the color QuickDraw function RGBForeColor.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void ForeColor (
   long color
){};


/*CloseRgn

Organizes a collection of lines and shapes into a region definition. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CloseRgn (
   RgnHandle dstRgn
);
Parameters
dstRgn

The handle to the region to close. This handle should be a region handle returned by the NewRgn function. 
Discussion

The CloseRgn function stops the collection of lines and framed shapes, organizes them into a region definition, and saves the result in the region whose handle you pass in the dstRgn parameter. 

The CloseRgn function does not create the destination region; you must have already allocated space for it by using the OpenRgn function. The CloseRgn function calls the ShowPen function, balancing the call to the HidePen function made by OpenRgn. 

When you no longer need the memory occupied by the region, use the DisposeRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. When you structure drawing operations in an open region, the resulting region description may overflow this limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. Since the resulting region is potentially corrupt, the CloseRgn function returns an empty region if it detects QDError has returned regionTooBigError.

The CloseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void CloseRgn (
   RgnHandle dstRgn
){};


/*DisposeRgn

Releases the memory occupied by a region. (Deprecated in Mac OS X v10.4.)

void DisposeRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to dispose. This handle should be a region handle returned by the NewRgn function. 
Discussion

Use DisposeRgn only after you are completely through with a region. 
Special Considerations

The DisposeRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void DisposeRgn (
   RgnHandle rgn
){};


/*InsetRect

Shrinks or expands a rectangle. 

void InsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to alter.
dh

The horizontal distance to move the left and right sides in toward or outward from the center of the rectangle.
dv

The vertical distance to move the top and bottom sides in toward or outward from the center of the rectangle.
Discussion

The InsetRect function shrinks or expands the rectangle that you specify in the r parameter: the left and right sides are moved in by the amount you specify in the dh parameter; the top and bottom are moved toward the center by the amount you specify in the dv parameter. If the value you pass in dh or dv is negative, the appropriate pair of sides is moved outward instead of inward. The effect is to alter the size by 2*dh horizontally and 2*dv vertically, with the rectangle remaining centered in the same place on the coordinate plane.

If the resulting width or height becomes less than 1, the rectangle is set to the empty rectangle (0,0,0,0).

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void MacInsetRect (
   Rect * r,
   short dh,
   short dv
){};


/*RectRgn

Changes the structure of an existing region to that of a rectangle. (Deprecated in Mac OS X v10.4.)

void RectRgn (
   RgnHandle rgn,
   const Rect * r
);
Parameters
rgn

A handle to the region to restructure as a rectangle. 
r

The rectangle structure to use.
Discussion

The RectRgn function destroys the previous structure of the SetRectRgn function, and it then sets the new structure to a rectangle that you specify in the r parameter.

As an alternative to the RectRgn function, use the SetRectRgn function, which accepts as parameters four coordinates instead of a rectangle. 

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The RectRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void RectRgn (
   RgnHandle rgn,
   const Rect * r
){};

/*GetPixBounds

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPixBounds (
   PixMapHandle pixMap,
   Rect * bounds
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Rect * GetPixBounds (
   PixMapHandle pixMap,
   Rect * bounds
){};


/*OffsetRect

Moves a rectangle. 

void OffsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to move.
dh

The horizontal distance to move the rectangle.
dv

The vertical distance to move the rectangle.
Discussion

The OffsetRect function moves the rectangle that you specify in the r parameter by adding the value you specify in the dh parameter to each of its horizontal coordinates and the value you specify in the dv parameter to each of its vertical coordinates. If the dh and dv parameters are positive, the movement is to the right and down; if either is negative, the corresponding movement is in the opposite direction. The rectangle retains its shape and size; it is merely moved on the coordinate plane. The movement does not affect the screen unless you subsequently call a function to draw within the rectangle.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void OffsetRect (
   Rect * r,
   short dh,
   short dv
){};


/*ClipRect

Changes the clipping region of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ClipRect (
   const Rect * r
);
Parameters
r

A pointer to a rectangle for the boundary of the new clipping region. The ClipRect function changes the clipping region of the current graphics port to a region that’s equivalent to this rectangle. ClipRect doesn’t change the region handle, but it affects the clipping region itself.
Discussion

Since ClipRect makes a copy of the given rectangle, any subsequent changes you make to that rectangle do not affect the clipping region of the port.

The ClipRect function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void ClipRect (
   const Rect * r
){};


/*KillPicture

Releases the memory occupied by a picture not stored in a 'PICT' resource. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void KillPicture (
   PicHandle myPicture
);
Parameters
myPicture

A handle to the picture whose memory can be released. 
Discussion

Use this function only when you are completely finished with a picture. 
Special Considerations

If you use the Window Manager function SetWindowPic to store a picture handle in the window structure, use the Window Manager function DisposeWindow or CloseWindow to release the memory allocated to the picture. These functions automatically call KillPicture for the picture.

If the picture is stored in a 'PICT' resource, use the Resource Manager function ReleaseResource instead of KillPicture. The Window Manager functions DisposeWindow and CloseWindow will not delete it. Instead, call ReleaseResource before calling DisposeWindow or CloseWindow.

The KillPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void KillPicture (
   PicHandle myPicture
){};


/*OpenPicture

Creates a picture which allows you to specify resolutions for your pictures. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PicHandle OpenPicture (
   const Rect * picFrame
);
Parameters
picFrame

The bounding rectangle for the picture. The DrawPicture function uses this rectangle to scale the picture if you draw it into a destination rectangle of a different size.
Return Value

A handle to a new Picture structure. OpenPicture collects your subsequent drawing commands in this structure. Use this handle when referring to the picture in subsequent functions, such as the DrawPicture function. 
Discussion

The OpenPicture function, which was created for earlier versions of system software, is described here for completeness. Use the OpenPicture function to begin defining a picture. 

The OpenPicture function calls the HidePen function, so no drawing occurs on the screen while the picture is open (unless you call the ShowPen function just after OpenPicture or you called ShowPen previously without balancing it by a call to HidePen).

The OpenPicture function creates pictures in the version 2 format on computers with Color QuickDraw when the current graphics port is a color graphics port. Pictures created in this format support color drawing operations at 72 dpi. On computers supporting only basic QuickDraw, or when the current graphics port is a basic graphics port, this function creates pictures in version 1 format. Pictures created in version 1 format support only black-and-white drawing operations at 72 dpi.

When defining a picture, you can use all other QuickDraw drawing functions, with the exception of CopyMask, CopyDeepMask, SeedFill, SeedCFill, CalcMask, and CalcCMask. You can also use the PicComment function to include picture comments in your picture definition.

After defining the picture, close it by using the ClosePicture function. To draw the picture, use the DrawPicture function. 
Special Considerations

The version 2 and version 1 picture formats support only 72-dpi resolution. The OpenCPicture function creates pictures in the extended version 2 format. The extended version 2 format, which is created by the OpenCPicture function on all Macintosh computers running System 7, permits your application to specify additional resolutions when creating images.

Version 1 pictures are limited to 32 KB. You can determine the picture size while it is being formed by calling the Memory Manager function GetHandleSize.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PicHandle OpenPicture (
   const Rect * picFrame
){};



/*QDBeginCGContext

Returns a Quartz 2D drawing environment associated with a graphics port.

OSStatus QDBeginCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A color graphics port in which to draw. Offscreen graphics worlds with pixel depths of 1, 2, 4, and 8 are not supported. When using Quartz 2D to draw in a offscreen graphics world, alpha information is always ignored.
contextPtr

A pointer to your storage for a Quartz context. Upon completion, contextPtr points to a context associated with the port. The context matches the port’s pixel depth, width, and height. Otherwise the context is in a default state and does not necessarily match other port attributes such as foreground color, background color, or clip region.

You should not retain or release the context. When you are finished using the context, you should call QDEndCGContext.
Return Value

A result code. If noErr, the context was successfully initiated.
Discussion

Applications running in Mac OS X can use Quartz 2D to draw in a QuickDraw graphics port. When you call this function, you obtain a Quartz context that’s associated with the specified port. To improve performance, contexts returned by this function are cached and reused during subsequent calls whenever possible. 

Each block of Quartz 2D drawing code in your application should be surrounded by calls to this function and QDEndCGContext. Nested calls to this function for the same graphics port are not permitted—that is, for a given port you should not call this function more than once without an intervening call to QDEndCGContext.

While the Quartz context is in use, all Quickdraw imaging operations in the associated graphics port are disabled. This is done because the operations would fail during printing.

For information about how to use a Quartz context, see Quartz 2D Programming Guide. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
Quickdraw.h*/

OSStatus QDBeginCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
){};


/*QDEndCGContext

Terminates a Quartz 2D drawing environment associated with a graphics port.

OSStatus QDEndCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
);
Parameters
port

A graphics port specified in a preceding call to QDBeginCGContext.
contextPtr

A pointer to the context obtained in the preceding call to QDBeginCGContext for the port. Upon completion, the storage pointed to by contextPtr is set to NULL.
Return Value

A result code. If noErr, the context is terminated.
Discussion

After you finish using Quartz 2D to draw in a graphics port, you should call this function to terminate the context. For more information, see QDBeginCGContext.

Before calling this function, you should do one of the following:
Call CGContextSynchronize to mark the affected areas of the port for update.
Call CGContextFlush to immediately update the destination device.
Availability
Available in Mac OS X v10.1 and later.
Declared In
Quickdraw.h*/
OSStatus QDEndCGContext (
   CGrafPtr port,
   CGContextRef * contextPtr
){};

/*SetPortVisibleRegion

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
){};


/*GetPortPixMap

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle GetPortPixMap (
   CGrafPtr port
);
Return Value
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

PixMapHandle GetPortPixMap (
   CGrafPtr port
){};


/*QDGlobalToLocalPoint

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Point * QDGlobalToLocalPoint (
   CGrafPtr port,
   Point * point
);
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Point * QDGlobalToLocalPoint (
   CGrafPtr port,
   Point * point
){};


/*PtInRgn

Determines whether a pixel is within a region. (Deprecated in Mac OS X v10.4.)

Boolean PtInRgn (
   Point pt,
   RgnHandle rgn
);
Parameters
pt

The point whose pixel is to be checked.
rgn

A handle to the region to test. 
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is within the region whose handle is specified in the rgn parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Boolean PtInRgn (
   Point pt,
   RgnHandle rgn
){};

/*Initializing QuickDraw
pascal void InitGraf            (void *globalPtr);*/
pascal void InitGraf            (void *globalPtr){};

/*StdLine

QuickDraw’s standard low-level function for drawing a line. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void StdLine (
   Point newPt
);
Parameters
newPt

The point to which to draw the line.
Discussion

The StdLine function draws a line from the current pen location to the location (in local coordinates) specified in the newPt parameter.

You should only call this low-level function from your customized QuickDraw functions. 
Special Considerations

The StdLine function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void StdLine (
   Point newPt
){};

/*SetPortGrafProcs

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortGrafProcs (
   CGrafPtr port,
   CQDProcsPtr procs
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPortGrafProcs (
   CGrafPtr port,
   CQDProcsPtr procs
){};



/*SetPortPenMode

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortPenMode (
   CGrafPtr port,
   SInt32 penMode
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPortPenMode (
   CGrafPtr port,
   SInt32 penMode
){};



/*GetPortPenMode

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

SInt32 GetPortPenMode (
   CGrafPtr port
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
SInt32 GetPortPenMode (
   CGrafPtr port
){};

/*NewPixMap

Creates a new, initialized PixMap structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PixMapHandle NewPixMap ();
Return Value

A handle to the new PixMap structure. 
Discussion

All fields of the PixMap structure are copied from the current device’s PixMap structure except the color table. In System 7, the hRes and vRes fields are set to 72 dpi, no matter what values the current device’s PixMap structure contains. A handle to the color table is allocated but not initialized. 

Typically, you do not need to call this function because PixMap structures are created for you when you create a window using the Window Manager functions NewCWindow and GetNewCWindow and when you create an offscreen graphics world with the NewGWorld function. 

If your application creates a pixel map, your application must initialize the PixMap structure’s color table to describe the pixels. Use the GetCTable function to read such a table from a resource file. Use the DisposeCTable function to dispose of the PixMap structure’s color table and replace it with the one returned by GetCTable. 
Special Considerations

The NewPixMap function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
PixMapHandle NewPixMap (){};



/*GetPen

Determines the location of the graphics pen. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPen (
   Point * pt
);
Parameters
pt

On return, a pointer to the graphics pen’s current position in the current graphics port. The point returned is in the local coordinates of the current graphics port.
Discussion

In the pt parameter, the GetPen procedure returns the current pen position. The point returned is in the local coordinates of the current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPen (
   Point * pt
){};

/*DisposePixMap

Disposes a PixMap structure and its color table. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposePixMap (
   PixMapHandle pm
);
Parameters
pm

A handle to the PixMap structure to be disposed of. 
Discussion

The CloseCPort function calls DisposePixMap.

Your application typically does not need to call this function. This function is also available as DisposPixMap.

If your application uses DisposePixMap, take care that it does not dispose of a PixMap structure whose color table is the same as the current device’s CLUT. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DisposePixMap (
   PixMapHandle pm
){};

/*SetRectRgn

Changes the structure of an existing region to that of a rectangle.

void SetRectRgn (
   RgnHandle rgn,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
rgn

A handle to the region to restructure as a rectangle. 
left

The horizontal coordinate of the upper-left corner of the rectangle to set as the new region.
top

The vertical coordinate of the upper-left corner of the rectangle to set as the new region.
right

The horizontal coordinate of the lower-right corner of the rectangle to set as the new region.
bottom

The vertical coordinate of the lower-right corner of the rectangle to set as the new region.
Discussion

The SetRectRgn function destroys the previous structure of the region whose handle you pass in the rgn parameter, and it then sets the new structure to the rectangle that you specify in the left, top, right, and bottom parameters. If you specify an empty rectangle (that is, right is greater than or equal to left or bottom = top), the SetRectRgn function sets the region to the empty region defined by the rectangle (0,0,0,0).

As an alternative to the SetRectRgn function, you can change the structure of an existing region to that of a rectangle by using the RectRgn function, which accepts as a parameter a rectangle instead of four coordinates. 

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The SetRectRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Declared In
Quickdraw.h*/

void SetRectRgn (
   RgnHandle rgn,
   short left,
   short top,
   short right,
   short bottom
){};




/*QDSwapPort

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean QDSwapPort (
   CGrafPtr inNewPort,
   CGrafPtr * outOldPort
);
Availability
Available in Mac OS X v10.1 and later.
Declared In
Quickdraw.h*/
Boolean QDSwapPort (
   CGrafPtr inNewPort,
   CGrafPtr * outOldPort
){};

/*LMSetLastSPExtra

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LMSetLastSPExtra (
   SInt32 value
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void LMSetLastSPExtra (
   SInt32 value
){};

/*InvertRect

Inverts the pixels enclosed by a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void InvertRect (
   const Rect * r
);
Parameters
r

The rectangle whose enclosed pixels are to be inverted.
Discussion

The InvertRect function inverts the pixels enclosed by the rectangle that you specify in the r parameter. Every white pixel becomes black and every black pixel becomes white. The pen location does not change. 
Special Considerations

The InvertRect function was designed for 1-bit images in basic graphics ports. This function operates on color pixels in color graphics ports, but the results are predictable only with direct pixels or 1-bit pixel maps. For indexed pixels, Color QuickDraw performs the inversion on the pixel indexes, which means the results depend entirely on the contents of the CLUT. The eight colors used in basic QuickDraw are stored in a color table represented by the global variable QDColors. To display those eight basic QuickDraw colors on an indexed device, Color QuickDraw uses the Color Manager to obtain indexes to the colors in the CLUT that best map to the colors in the QDColors color table. Because the index, not the color value, is inverted, the results are unpredictable.

Inversion works better for direct pixels. Inverting a pure green, for example, that has red, green, and blue component values of $0000, $FFFF, and $0000 results in magenta, which has component values of $FFFF, $0000, and $FFFF.

The InvertRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

void InvertRect (
   const Rect * r
){};


/*Initializing Cursors
pascal void InitCursor       (void);
pascal void InitCursorCtl    (acurHandle newCursors);*/
pascal void InitCursor       (void){};


/*Opening and Closing Basic Graphics Ports
pascal void OpenPort            (GrafPtr port);
pascal void InitPort            (GrafPtr port); 
pascal void ClosePort           (GrafPtr port);*/
pascal void OpenPort            (GrafPtr port){};
pascal void ClosePort           (GrafPtr port){};

/*OpColor

Sets the maximum color values for the addPin and subPin arithmetic transfer modes and the weight color for the blend arithmetic transfer mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void OpColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure that defines a color. 
Discussion

Specify the red, green, and blue values in the RGBColor structure and specify this structure in the color parameter. 

If the current graphics port is defined by a GrafPort structure, OpColor has no effect. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void OpColor (
   const RGBColor * color
){};



/*Random

Obtains a pseudorandom integer. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

short Random ();
Return Value

A pseudorandom integer, uniformly distributed in the range -32767 to 32767. 
Discussion

The value Random returns depends solely on the global variable randSeed, which the QuickDraw InitGraf function initializes to 1. Each time the Random function executes, it uses a numerical algorithm to change the value of randSeed to prevent it from returning the same value each time it is called.

To prevent your application from generating the same sequence of pseudo-random numbers each time it is executed, initialize the randSeed global variable, when your application starts up, to a volatile long word variable such as the current date and time. If you would like to generate the same sequence of pseudo-random numbers twice, on the other hand, simply set randSeed to the same value before calling Random for each sequence. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
short Random (){};


/*SetGDevice

Sets a GDevice structure as the current device. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetGDevice (
   GDHandle gd
);
Parameters
gd

A handle to a GDevice structure. 
Discussion

Your application won’t generally need to use this function, because when your application draws into a window on one or more screens, Color QuickDraw automatically switches GDevice structures as appropriate; and when your application needs to draw into an offscreen graphics world, it can use the SetGWorld function to set the graphics port as well as the GDevice structure for the offscreen environment. However, if your application uses the SetPort function instead of the SetGWorld function to set the graphics port to or from an offscreen graphics world, then your application must use SetGDevice in conjunction with SetPort.

A handle to the currently active device is kept in the global variable TheGDevice. 
Special Considerations

The SetGDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetGDevice (
   GDHandle gd
){};


/*FillRect

Fills a rectangle with any available bit pattern. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FillRect (
   const Rect * r,
   const Pattern * pat
);
Parameters
r

The rectangle to fill.
pat

The bit pattern to use for the fill. 
Discussion

Using the patCopy pattern mode, the FillRect function draws the interior of the rectangle that you specify in the r parameter with the pattern defined in the Pattern structure that you specify in the pat parameter. This function leaves the pen location unchanged.

Use GetPattern and GetIndPattern , to get a pattern stored in a resource.

Use the PaintRect to draw the interior of a rectangle with the pen pattern for the current graphics port. To fill a rectangle with a pixel pattern, use the FillCRect function. 
Special Considerations

The FillRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void MacFillRect (
   const Rect * r,
   const Pattern * pat
){};


/*GetQDGlobalsBlack

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsBlack (
   Pattern * black
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Pattern * GetQDGlobalsBlack (
   Pattern * black
){};



/*GetGDevice

Obtains a handle to the GDevice structure for the current device. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

GDHandle GetGDevice ();
Return Value

A handle to the current device. 
Discussion

At any given time, exactly one video device is the current device—that is, the one on which drawing is actually taking place. 

Color QuickDraw stores a handle to the current device in the global variable TheGDevice.

All existing GDevice structures are linked together in the device list. After using this function to obtain a handle to the current GDevice structure, your application can use the GetNextDevice function to obtain a handle to the next GDevice structure in the list.

You can also use the GetGWorld function to get a handle to the GDevice structure for the current device. 
Special Considerations

The GetGDevice function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
GDHandle GetGDevice (){};


/*PenMode

Sets the pattern mode of the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenMode (
   short mode
);
Parameters
mode

The pattern mode. See Source, Pattern, and Arithmetic Transfer Mode Constants.
Discussion

Using the pattern mode you specify in the mode parameter, the PenMode function sets the manner in which the pattern of the graphics pen is transferred onto the bitmap (or pixel map) when you draw lines or shapes in the current graphics port.

If you specify a source mode (such as one used with the CopyBits function) instead of a pattern mode, no drawing is performed.

The current pattern mode is stored in the pnMode field of the current graphics port. The initial pattern mode value is patCopy, in which the pen pattern is copied directly to the bitmap.

To use highlighting, add the hilite constant or its value to the source or pattern mode:

With highlighting, QuickDraw replaces the background color with the highlight color when your application draws or copies images between graphics ports. This has the visual effect of using a highlighting pen to select the object. (The global variable HiliteRGB is read from parameter RAM when the machine starts. Basic graphics ports use the color stored in the HiliteRGB global variable as the highlight color. Color graphics ports default to the HiliteRGB global variable, but can be overridden by the HiliteColor function.

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Special Considerations

When your application draws with a pixel pattern, Color QuickDraw ignores the pattern mode and simply transfers the pattern directly to the pixel map without regard to the foreground and background colors.

The results of inverting a pixel are predictable only with direct pixels or 1-bit pixel maps. For indexed pixels, Color QuickDraw performs the inversion on the pixel indexes, which means the results depend entirely on the contents of the color table. The eight colors used in basic QuickDraw are stored in a color table represented by the global variable QDColors. To display those eight basic QuickDraw colors on an indexed device, Color QuickDraw uses the Color Manager to obtain indexes to the colors in the CLUT that best map to the colors in the QDColors color table. Because the index, not the color value, is inverted, the results are unpredictable.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenMode (
   short mode
){};


/*SetClip

Changes the clipping region of the current graphics port (basic or color) to a region you specify. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetClip (
   RgnHandle rgn
);
Parameters
rgn

A handle to a region. The SetClip function makes this region the clipping region of the current graphics port. The SetClip function doesn’t change the region handle, but instead affects the clipping region itself. 
Discussion

Since SetClip copies the specified region into the current graphics port’s clipping region, any subsequent changes you make to the region specified in the rgn parameter do not affect the clipping region of the graphics port.

The initial clipping region of a graphics port is an arbitrarily large rectangle. You can set the clipping region to any arbitrary region, to aid you in drawing inside the graphics port—for example, to avoid drawing over scroll bars when drawing into a window, you could define a clipping region that excludes the scroll bars. 

You can use the GetClip and SetClip functions to preserve the current clipping region: use GetClip to save the current port’s clipping region, and use SetClip to restore it.

All other system software functions preserve the current clipping region.

The SetClip function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetClip (
   RgnHandle rgn
){};

/*DrawPicture

Draws a picture on any type of output device. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DrawPicture (
   PicHandle myPicture,
   const Rect * dstRect
);
Parameters
myPicture

A handle to the picture to be drawn. You must access a picture through its handle. 

When creating pictures, the OpenCPicture and OpenPicture functions return their handles. You can use the GetPicture function to get a handle to a QuickDraw picture stored in a 'PICT' resource. To get a handle to a QuickDraw picture stored in a 'PICT' file, you must use File Manager functions. To get a picture stored in the scrap, use the Scrap Manager function GetScrap to get a handle to its data and then coerce this handle to one of type PicHandle.

dstRect

A destination rectangle, specified in coordinates local to the current graphics port, in which to draw the picture. The DrawPicture function shrinks or expands the picture as necessary to align the borders of its bounding rectangle with the rectangle you specify in this parameter. To display a picture at a resolution other than that at which it was created, your application should compute an appropriate destination rectangle by scaling its width and height by the following factor:

scale factor = destination resolution / source resolution

For example, if a picture was created at 300 dpi and you want to display it at 75 dpi, then your application should compute the destination rectangle width and height as 1/4 of those of the picture’s bounding rectangle. Use the GetPictInfo function to gather information about a picture. The PictInfo structure returned by GetPictInfo returns the picture’s resolution in its hRes and vRes fields. The sourceRect field contains the bounding rectangle for displaying the image at its optimal resolution.
Discussion

Within the rectangle that you specify in the dstRect parameter, the DrawPicture function draws the picture that you specify in the myPicture parameter. 

The DrawPicture function passes any picture comments to the StdComment function pointed to by the commentProc field of the CQDProcs or QDProcs structure, which in turn is pointed to by the grafProcs field of a CGrafPort or GrafPort structure. The default StdComment function provided by QuickDraw does no comment processing whatsoever. If you want to process picture comments when drawing a picture, use the SetStdCProcs function to assist you in changing the CQDProcs structure and use the SetStdProcs function to assist you in changing the QDProcs structure. 
Special Considerations

Always use the ClipRect function to specify a clipping region appropriate for your picture before defining it with the OpenCPicture (or OpenPicture) function. If you do not use ClipRect to specify a clipping region, OpenCPicture uses the clipping region specified in the current graphics port. If the clipping region is very large (as it is when a graphics port is initialized) and you want to scale the picture, the clipping region can become invalid when DrawPicture scales the clipping region—in which case, your picture will not be drawn. On the other hand, if the graphics port specifies a small clipping region, part of your drawing may be clipped when DrawPicture draws it. Setting a clipping region equal to the port rectangle of the current graphics port always sets a valid clipping region.

When it scales, DrawPicture changes the size of the font instead of scaling the bits. However, the widths used by bitmap fonts are not always linear. For example, the 12-point width isn’t exactly 1/2 of the 24-point width. This can cause lines of text to become slightly longer or shorter as the picture is scaled. The difference is often insignificant, but if you are trying to draw a line of text that fits exactly into a box (a spreadsheet cell, for example), the difference can become noticeable to the user—most typically, at print time. The easiest way to avoid such problems is to specify a destination rectangle that is the same size as the bounding rectangle for the picture. Otherwise, your application may need to directly process the opcodes in the picture instead of using DrawPicture.

You may also have disappointing results if the fonts contained in an image are not available on the user’s system. Before displaying a picture, your application may want to use the Picture Utilities to determine what fonts are contained in the picture, and then use Font Manager functions to determine whether the fonts are available on the user’s system. If they are not, you can use Dialog Manager functions to display an alert box warning the user of display problems.

If there is insufficient memory to draw a picture in Color QuickDraw, the QDError function returns the result code noMemForPictPlaybackErr.

The DrawPicture function may move or purge memory.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DrawPicture (
   PicHandle myPicture,
   const Rect * dstRect
){};

/*GetClip

Saves the clipping region of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetClip (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to be clipped. The GetClip function changes this region to one that’s equivalent to the clipping region of the current graphics port. The GetClip function doesn’t change the region handle. 
Discussion

You can use the GetClip and SetClip functions to preserve the current clipping region: use GetClip to save the current port’s clipping region, and use SetClip to restore it. If, for example, you want to draw a half-circle on the screen, you can set the clipping region to half of the square that would enclose the whole circle, and then draw the whole circle. Only the half within the clipping region is actually drawn in the graphics port.

The GetClip function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetClip (
   RgnHandle rgn
){};

/*ClipCGContextToRegion

Sets the clipping path in a Quartz 2D graphics context, using a clipping region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSStatus ClipCGContextToRegion (
   CGContextRef context,
   const Rect * portRect,
   RgnHandle region
);
Parameters
context

A Quartz context associated with a graphics port. You can obtain such a context by calling QDBeginCGContext.
portRect

The portRect for the graphics port associated with the context.
region

A region that represents the desired clipping path.
Return Value

A result code. If noErr, the clipping path is now the region-based path.
Discussion

This function sets the clipping path in the specified context to closely approximate the geometry of the specified region. 

Unlike clipping in Quartz 2D, this function does not intersect the new region-based path with the current clipping path—the new path simply replaces the current clipping path.

You should use this function only when absolutely necessary—it’s relatively inefficient when compared to Quartz 2D clipping functions such as CGContextClipToRect.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

OSStatus ClipCGContextToRegion (
   CGContextRef context,
   const Rect * portRect,
   RgnHandle region
){};


/*SyncCGContextOriginWithPort

Synchronizes the origin in a Quartz context with the lower-left corner of the associated graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSStatus SyncCGContextOriginWithPort (
   CGContextRef context,
   CGrafPtr port
);
Parameters
context

A Quartz context associated with a graphics port. You can obtain such a context by calling QDBeginCGContext.
port

The graphics port associated with the context.
Return Value

A result code. If noErr, the context’s origin was successfully changed.
Discussion

If you’re using Quartz 2D to draw in a graphics port and SetOrigin is called to change the port’s origin, you can call this function to maintain the correspondence between the context’s origin and the lower-left corner of the portBounds rectangle.

When you call this function:
The current transformation matrix (CTM) is reset to its default values. Any changes you made to the CTM prior to calling this function are lost.
The CTM is translated to establish the new origin, taking the port’s current origin into account.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSStatus SyncCGContextOriginWithPort (
   CGContextRef context,
   CGrafPtr port
){};


/*SetCursor

Sets the current cursor. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetCursor (
   const Cursor * crsr
);
Parameters
crsr

A Cursor structure for the cursor to be displayed. 
Discussion

If the cursor is hidden, it remains hidden and attains its new appearance only when it’s uncovered. If the cursor is already visible, it changes to the new appearance immediately.

You need to use the InitCursor function to initialize the standard arrow cursor and make it visible on the screen before you call SetCursor to change the cursor’s appearance. 

To display a color cursor, use the SetCCursor function. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

void SetCursor (
   const Cursor * crsr
){};

/*PaintRgn

Paints a region with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to paint. 
Discussion

Using the pen pattern and pattern mode for the current graphics port, the PaintRgn function draws the interior of the region whose handle you pass in the rgn parameter. The pen location does not change.

This function depends on the local coordinate system of the current graphics port. If you draw a region in a graphics port different from the one in which you defined the region, it may not appear in the proper position in the graphics port.

If any horizontal or vertical line drawn through the region would intersect the region’s outline more than 50 times, the results of this graphics operation are undefined. 

Use FillRgn to draw the interior of a region with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

void PaintRgn (
   RgnHandle rgn
){};

/*CreateNewPort

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CGrafPtr CreateNewPort ();
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
CGrafPtr CreateNewPort (){};

/*HidePen

Makes the graphics pen invisible, so that pen drawing doesn’t show on the screen. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void HidePen ();
Discussion

The HidePen function is called by the OpenRgn , OpenPicture, and OpenPoly functions so that you can create regions, pictures, and polygons without drawing on the screen.

The HidePen function decrements the pnVis field of the current graphics port. The pnVis field is initialized to 0 by the OpenPort function. Whenever pnVis is negative, the pen does not draw on the screen. The pnVis field keeps track of the number of times the pen has been hidden to compensate for nested calls to the HidePen and ShowPen functions. 

Every call to HidePen should be balanced by a subsequent call to ShowPen. 

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void HidePen (){};



/*UnionRgn

Calculates the union of two regions. 

void UnionRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
);
Parameters
srcRgnA

A handle to the first of two regions whose union is to be determined. 
srcRgnB

A handle to the second of two regions whose union is to be determined.
dstRgn

On return, a handle to the region holding the resulting union area. If both regions are empty, UnionRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The UnionRgn function does not create the destination region; you must have already allocated memory for it by using the NewRgn function.

The destination region may be one of the source regions, if desired.
Discussion

The UnionRgn procedure calculates the union of the two regions whose handles you pass in the srcRgnA and srcRgnB parameters, and it places the union in the region whose handle you pass in the dstRgn parameter. If both regions are empty, UnionRgn sets the destination to the empty region defined by the rectangle (0,0,0,0).

The UnionRgn procedure does not create the destination region; you must have already allocated memory for it by using the NewRgn function. 

The destination region may be one of the source regions, if desired. 
Special Considerations

The UnionRgn function may temporarily use heap space that’s twice the size of the two input regions.

The UnionRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Declared In
Quickdraw.h*/
void UnionRgn (
   RgnHandle srcRgnA,
   RgnHandle srcRgnB,
   RgnHandle dstRgn
){};

/*SetPortPix

Sets the pixel map for the current color graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortPix (
   PixMapHandle pm
);
Parameters
pm

A handle to the PixMap structure. 
Discussion

The SetPortPix function replaces the portPixMap field of the current CGrafPort structure with the handle you specify in the pm parameter. 

Typically, your application does not need to call this function.

The SetPortPix function is analogous to the basic QuickDraw function SetPortBits, which sets the bitmap for the current basic graphics port. The SetPortPix function has no effect when used with a basic graphics port. Similarly, SetPortBits has no effect when used with a color graphics port.

Both SetPortPix and SetPortBits allow you to perform drawing and calculations on a buffer other than the screen. However, instead of using these functions, use the offscreen graphics capabilities. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetPortPix (
   PixMapHandle pm
){};



/*GetForeColor

Obtains the color of the foreground color for the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetForeColor (
   RGBColor * color
);
Parameters
color

On return, the RGBColor structure for the current foreground color. 
Discussion

This function operates for graphics ports defined by both the GrafPort and CGrafPort structures. If the current graphics port is defined by a CGrafPort structure, the returned value is taken directly from the rgbFgColor field. 

If the current graphics port is defined by a GrafPort structure, then only eight possible RGB values can be returned. These eight values are determined by the values in a global variable named QDColors, which is a handle to a color table containing the current QuickDraw colors.

Use the RGBForeColor function to change the foreground color. 
Version Notes

This function is available for basic QuickDraw only in System 7.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetForeColor (
   RGBColor * color
){};


/*GetCursor

Loads a cursor resource into memory. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CursHandle GetCursor (
   short cursorID
);
Parameters
cursorID

The resource ID for the cursor you want to display. You can supply one of the Cursor ID Constants to get a handle to one of the standard cursors.
Return Value

A handle to a Cursor structure for the cursor with the resource ID that you specify in the cursorID parameter. If the resource cannot be read into memory, GetCursor returns NULL. 
Discussion

To get a handle to a color cursor, use the GetCCursor function. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
CursHandle GetCursor (
   short cursorID
){};

/*GetQDGlobalsArrow

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Cursor * GetQDGlobalsArrow (
   Cursor * arrow
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

Cursor * GetQDGlobalsArrow (
   Cursor * arrow
){};

/*GetBackColor

Obtains the background color of the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetBackColor (
   RGBColor * color
);
Parameters
color

On return, the RGBColor structure for the current background color. 
Discussion

This function operates for graphics ports defined by both the GrafPort and CGrafPort structures. If the current graphics port is defined by a CGrafPort structure, the returned value is taken directly from the rgbBkColor field. 

If the current graphics port is defined by a GrafPort structure, then only eight possible colors can be returned. These eight colors are determined by the values in a global variable named QDColors, which is a handle to a color table containing the current QuickDraw colors.

Use the RGBBackColor function to change the background color. 
Version Notes

This function is available for basic QuickDraw only in System 7.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void GetBackColor (
   RGBColor * color
){};


/*DisposeQDBitsUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DisposeQDBitsUPP (
   QDBitsUPP userUPP
);
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DisposeQDBitsUPP (
   QDBitsUPP userUPP
){};


/*GetPortGrafProcs

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CQDProcsPtr GetPortGrafProcs (
   CGrafPtr port
);
Return Value
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
CQDProcsPtr GetPortGrafProcs (
   CGrafPtr port
){};


/*BitMapToRegion

Converts a bitmap or pixel map to a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSErr BitMapToRegion (
   RgnHandle region,
   const BitMap * bMap
);
Parameters
region

A handle to a region to hold the converted BitMap or PixMap structure. This must be a valid region handle created with the NewRgn function. The old region contents are lost. 
bMap

A pointer to a BitMap or PixMap structure to be converted. If you supply a PixMap structure, its pixel depth must be 1.
Return Value

A result code.
Discussion

The BitMapToRegion function converts a given BitMap or PixMap structure to a region. Pixels are added to the region where the corresponding entries in the bitmap have a value of 1. You would generally use this region later for drawing operations. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
OSErr BitMapToRegion (
   RgnHandle region,
   const BitMap * bMap
){};

/*CopyRgn

Makes a copy of a region.

void CopyRgn (
   RgnHandle srcRgn,
   RgnHandle dstRgn
);
Parameters
srcRgn

A handle to the region to copy. 
dstRgn

A handle to the region to receive the copy.
Discussion

The CopyRgn function copies the mathematical structure of the region whose handle you pass in the srcRgn parameter into the region whose handle you pass in the dstRgn parameter; that is, CopyRgn makes a duplicate copy of srcRgn. When calling CopyRgn, pass handles that have been returned by the NewRgn function in the srcRgn and dstRgn parameters.

Once this is done, the region indicated by srcRgn may be altered (or even disposed of) without affecting the region indicated by dstRgn. The CopyRgn function does not create the destination region; space must already have been allocated for it by using the NewRgn function. 
Special Considerations

The CopyRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Declared In
Quickdraw.h*/
void CopyRgn (
   RgnHandle srcRgn,
   RgnHandle dstRgn
){};


/*OffsetRgn

Moves a region.

void OffsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
);
Parameters
rgn

A handle to the region to move. 
dh

The horizontal distance to move the region.
dv

The vertical distance to move the region.
Discussion

The OffsetRgn function moves the region whose handle you pass in the rgn parameter by adding the value you specify in the dh parameter to the horizontal coordinates of all points of its region boundary, and by adding the value you specify in the dv parameter to the vertical coordinates of all points of its region boundary. If the values of dh and dv are positive, the movement is to the right and down; if either is negative, the corresponding movement is in the opposite direction. The region retains its size and shape. This does not affect the screen unless you subsequently call a function to draw the region.

The OffsetRgn function is an especially efficient operation, because most of the data defining a region is stored relative to the rgnBBox field in its Region structure and so is not actually changed by OffsetRgn. 
Declared In
Quickdraw.h*/

void OffsetRgn (
   RgnHandle rgn,
   short dh,
   short dv
){};


/*StdBits

QuickDraw’s standard low-level function for transferring bits and pixels. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void StdBits (
   const BitMap * srcBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

A pointer to a bitmap or pixel map containing the image to copy. 
srcRect

A pointer to the source rectangle.
dstRect

The destination rectangle.
mode

The source mode for the copy.
maskRgn

A handle to a region acting as a mask for the transfer. 
Discussion

The StdBits function transfers a bit or pixel image between the bitmap or pixel map specified in the srcBits parameter and bitmap of the current graphics port, just as if the CopyBits function were called with the same parameters and with a destination bitmap equal to (* thePort).portBits. 

You should only call this low-level function from your customized QuickDraw functions.

See CopyBits for a discussion of the destination bitmap and of the srcBits, srcRect, dstRect, mode, and maskRgn parameters 
Special Considerations

The StdBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void StdBits (
   const BitMap * srcBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
){};

/*LocalToGlobal

Converts a point’s coordinates from the local coordinates of the current graphics port (basic or color) to global coordinates. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LocalToGlobal (
   Point * pt
);
Parameters
pt

A pointer to a point in local coordinates. On return, this point is converted to global coordinates.
Discussion

The LocalToGlobal function converts the given point from the current graphics port’s local coordinate system into the global coordinate system (where the upper-left corner of the main screen has coordinates [0,0]). This global point can then be compared to other global points, or it can be changed into the local coordinates of another graphics port.

Because a rectangle is defined by two points, you can convert a rectangle into global coordinates with two calls to LocalToGlobal. In conjunction with LocalToGlobal, you can use the OffsetRect, OffsetRgn, or OffsetPoly functions to convert a rectangle, region, or polygon into global coordinates. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void LocalToGlobal (
   Point * pt
){};


/*GetQDGlobalsThePort

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

CGrafPtr GetQDGlobalsThePort ();
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
CGrafPtr GetQDGlobalsThePort (){};


/*ScrollRect

Scroll the pixels of a specified portion of a basic graphics port’s bitmap (or a color graphics port’s pixel map). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void ScrollRect (
   const Rect * r,
   short dh,
   short dv,
   RgnHandle updateRgn
);
Parameters
r

The pointer to the rectangle defining the area to be scrolled.
dh

The horizontal distance to be scrolled.
dv

The vertical distance to be scrolled.
updateRgn

A handle to the region of the window that needs to be updated. 
Discussion

The ScrollRect function shifts pixels that are inside the specified rectangle of the current graphics port. No other pixels or the bits they represent are affected. The pixels are shifted a distance of dh horizontally and dv vertically. The positive directions are to the right and down. The pixels that are shifted out of the specified rectangle are not displayed, and the bits they represent are not saved. It is up to your application to save this data. 

The empty area created by the scrolling is filled with the graphics port’s background pattern, and the update region is changed to this filled area. 

The ScrollRect function doesn’t change the local coordinate system of the graphics port it simply moves the rectangle specified in the r parameter to different coordinates. Notice that ScrollRect doesn’t move the graphics pen or the clipping region. However, because the document has moved, they’re in different positions relative to the document.

By creating an update region for the window, ScrollRect forces an update event. After using ScrollRect, your application should use its own window-updating code to draw into the update region of the window.

The ScrollRect function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void ScrollRect (
   const Rect * r,
   short dh,
   short dv,
   RgnHandle updateRgn
){};

/*SetPt

Assigns two coordinates to a point. (Deprecated in Mac OS X v10.4.)

void SetPt (
   Point * pt,
   short h,
   short v
);
Parameters
pt

A pointer to the point to be given new coordinates. On return, this point is assigned the horizontal coordinate you specify in the h parameter and the vertical coordinate you specify in the v parameter.
h

The horizontal value of the new coordinates.
v

The vertical value of the new coordinates.
Discussion

The SetPt procedure assigns the horizontal coordinate specified in the h parameter and the vertical coordinate specified in the v parameter to the point returned in the pt parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPt (
   Point * pt,
   short h,
   short v
){};


/*FrameOval

Draws an outline inside an oval. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameOval (
   const Rect * r
);
Parameters
r

The rectangle that defines the oval’s boundary.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameOval function draws an outline just inside the oval with the bounding rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new oval is mathematically added to the region’s boundary. 
Special Considerations

The FrameOval function may move or purge memory blocks in the application; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void FrameOval (
   const Rect * r
){};

/*GetPortClipRegion

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

RgnHandle GetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
);
Return Value
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

RgnHandle GetPortClipRegion (
   CGrafPtr port,
   RgnHandle clipRgn
){};


/*GetPortVisibleRegion

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

RgnHandle GetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

RgnHandle GetPortVisibleRegion (
   CGrafPtr port,
   RgnHandle visRgn
){};

/*BackColor

Changes a basic graphics port’s background color. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void BackColor (
   long color
);
Parameters
color

One of eight color values. See Color Constants.
Discussion

The background color is the color of the pixels in the bitmap wherever no drawing has taken place. By default the background color of a GrafPort is white.

The BackColor function sets the background color for the current graphics port to the color that you specify in the color parameter. When you draw with the patCopy and srcCopy transfer modes, for example, white pixels are drawn in the color you specify with BackColor.

All nonwhite colors appear as black on black-and-white screens. Before you use BackColor, use the DeviceLoop function to determine the color characteristics of the current screen. 
Special Considerations

The BackColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

In System 7, use the Color QuickDraw function RGBBackColor.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void BackColor (
   long color
){};

/*SetDeviceAttribute

Sets the attribute bits of a GDevice structure. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetDeviceAttribute (
   GDHandle gdh,
   short attribute,

   Boolean value
);
Parameters

gdh

A handle to a GDevice structure. 
attribute

One of the specific constants, which represent bits in the gdFlags field of a GDevice structure. See GDevice for the values you can use in this parameter.
value

A value of either 0 or 1 for the flag bit specified in the attribute parameter.
Discussion

For the graphics device specified in the gdh parameter, the SetDeviceAttribute function sets the flag bit specified in the attribute parameter to the value specified in the value parameter.

Your application should never directly change the gdFlags field of the GDevice structure; instead, use only the SetDeviceAttribute function. 
Special Considerations

The SetDeviceAttribute function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetDeviceAttribute (
   GDHandle gdh,
   short attribute,
   Boolean value
){};

/*FrameArc

Draws an arc of the oval that fits inside a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameArc (
   const Rect * r,
   short startAngle,
   short arcAngle
);
Parameters
r

The rectangle that defines an oval’s boundaries.
startAngle

The angle indicating the start of the arc.
arcAngle

The angle indicating the arc’s extent.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameArc function draws an arc of the oval bounded by the rectangle that you specify in the r parameter. Use the startAngle parameter to specify where the arc begins as modulo 360. Use the arcAngle parameter to specify how many degrees the arc covers. Specify whether the angles are in positive or negative degrees a positive angle goes clockwise, while a negative angle goes counterclockwise. Zero degrees is at 12 o’clock high, 90 (or –270) is at 3 o’clock, 180 (or –180) is at 6 o’clock, and 270 (or –90) is at 9 o’clock. Measure other angles relative to the bounding rectangle.

A line from the center of the rectangle through its upper-right corner is at 45, even if the rectangle is not square a line through the lower-right corner is at 135, and so on. 

The arc is as wide as the pen width and as tall as the pen height. The pen location does not change. 
Special Considerations

The FrameArc function differs from other QuickDraw functions that frame shapes in that the arc is not mathematically added to the boundary of a region that’s open and being formed.

The FrameArc function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void FrameArc (
   const Rect * r,
   short startAngle,
   short arcAngle
){};


/*OpenPoly

Begins defining a polygon. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PolyHandle OpenPoly ();
Return Value

A handle to a new polygon. 
Discussion

The OpenPoly function starts saving lines for processing as a polygon definition. While a polygon is open, all calls to the Line and LineTo functions affect the outline of the polygon. Only the line endpoints affect the polygon definition; the pattern mode, pattern, and size do not affect it. The OpenPoly function calls the HidePen function, so no drawing occurs on the screen while the polygon is open (unless you call the ShowPen function just after calling OpenPoly, or you called ShowPen previously without balancing it by a call to HidePen).

A polygon should consist of a sequence of connected lines. The OpenPoly function stores the definition for a polygon in a Polygon structure. 

When a polygon is open, the current graphics port’s polySave field contains a handle to information related to the polygon definition. If you want to temporarily disable the polygon definition, you can save the current value of this field, set the field to NULL, and later restore the saved value to resume the polygon definition.

Even though the onscreen presentation of a polygon is clipped, the definition of a polygon is not; you can define a polygon anywhere on the coordinate plane.

When you are finished calling the line-drawing functions that define your polygon, use the ClosePoly function. 
Special Considerations

Do not call OpenPoly while a region or another polygon is already open.

Polygons are limited to 64 KB. You can determine the polygon size while it is being formed by calling the Memory Manager function GetHandleSize. 

The OpenPoly function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
PolyHandle OpenPoly (){};

/*KillPoly

Releases the memory occupied by a polygon. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void KillPoly (
   PolyHandle poly
);
Parameters
poly

A handle to the polygon to dispose of. 
Discussion

Use KillPoly only when you are completely through with a polygon. 
Special Considerations

The KillPoly function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void KillPoly (
   PolyHandle poly
){};


/*QDError

Obtains a result code from the last applicable QuickDraw function that you called. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

short QDError ();
Return Value

The error result. On a system with only basic QuickDraw, QDError always returns noErr. 
Discussion

The QDError function is helpful in determining whether insufficient memory caused a drawing operation - particularly those involving regions, polygons, pictures, and images copied with CopyBits - to fail.

Basic QuickDraw uses stack space for work buffers. For complex operations such as depth conversion, dithering, and image resizing, stack space may not be sufficient. QuickDraw attempts to get temporary memory from other parts of the system. If that is still not enough, QDError returns the nsStackErr error. If your application receives this result, reduce the memory required by the operation.

When you structure drawing operations in an open region, the resulting region description may overflow the 64 KB limit. In this case, QDError returns regionTooBigError. Since the resulting region is potentially corrupt, the CloseRgn function returns an empty region if it detects QDError has returned regionTooBigError. A similar error, rgnTooBigErr, occurs when using the BitMapToRegion function to convert a bitmap to a region.

The BitMapToRegion function also generates the pixmapTooDeepErr error if a PixMap structure is supplied that is greater than 1 bit per pixel. You may be able to recover from this problem by coercing your PixMap structure into a 1-bit PixMap structure and calling the BitMapToRegion function again. 
Special Considerations

The QDError function does not report errors returned by basic QuickDraw.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
short QDError (){};


/*OpenCPicture

Begins defining a picture in extended version 2 format. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

PicHandle OpenCPicture (
   const OpenCPicParams * newHeader
);
Parameters
newHeader

An OpenCPicParams structure. 
Return Value

A handle to a new Picture structure. OpenCPicture collects your subsequent drawing commands in this structure. Use this handle when referring to the picture in subsequent functions, such as the DrawPicture function. 
Discussion

When defining a picture, you can use all other QuickDraw drawing functions, with the exception of CopyMask, CopyDeepMask, SeedFill, SeedCFill, CalcMask, and CalcCMask. You can also use the PicComment function to include picture comments in your picture definition.

The OpenCPicture function creates a pictures in the extended version 2 format. This format permits your application to specify resolutions when creating images.

Use the OpenCPicParams structure you pass in the newHeader parameter to specify the horizontal and vertical resolution for the picture, and specify an optimal bounding rectangle for displaying the picture at this resolution. When you later call the DrawPicture function to play back the saved picture, supply a destination rectangle, and DrawPicture scales the picture so that it is completely aligned with the destination rectangle. To display a picture at a resolution other than that at which it was created, compute an appropriate destination rectangle by scaling its width and height by the following factor:

scale factor = destination resolution / source resolution 

For example, if a picture was created at 300 dpi and you want to display it at 75 dpi, then your application should compute the destination rectangle width and height as 1/4 of those of the picture’s bounding rectangle.

The OpenCPicture function calls the HidePen function, so no drawing occurs on the screen while the picture is open (unless you call the ShowPen function just after OpenCPicture, or you called ShowPen previously without balancing it by a call to HidePen).

After defining the picture, close it by using the ClosePicture function. 

After creating the picture, use the GetPictInfo function to gather information about it. The PictInfo structure returned by GetPictInfo returns the picture’s resolution and optimal bounding rectangle. 
Special Considerations

When creating a picture, use the ClosePicture function to finish it before you open the Printing Manager with the PrOpen function. There are two main reasons for this. First, you should allow the printing driver to use as much memory as possible. Second, the Printing Manager creates its own type of graphics port, one that replaces the standard QuickDraw drawing operations stored in the grafProcs field of a CGrafPort or GrafPort structure. To avoid unexpected results when creating a picture, draw into a graphics port created with QuickDraw instead of drawing into a printing port created by the Printing Manager. 

After calling OpenCPicture, be sure to finish your picture definition by calling ClosePicture before you call OpenCPicture again. You cannot nest calls to OpenCPicture.

Always use the ClipRect procedure to specify a clipping region appropriate for your picture before you call OpenCPicture. If you do not use ClipRect to specify a clipping region, OpenCPicture uses the clipping region specified in the current graphics port. If the clipping region is very large (as it is when a graphics port is initialized) and you scale the picture when drawing it, the clipping region can become invalid when DrawPicture scales the clipping region—in which case, your picture will not be drawn.

The OpenCPicture function may move or purge memory; do not call at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
PicHandle OpenCPicture (
   const OpenCPicParams * newHeader
){};


/*FramePoly

Draws the outline of a polygon. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FramePoly (
   PolyHandle poly
);
Parameters
poly

A handle to the polygon to draw. The OpenPoly function returns this handle when you first create the polygon. 
Discussion

Using the current graphics port’s pen pattern, pattern mode, and size, the FramePoly function plays back the line-drawing commands that define the polygon whose handle you pass in the poly parameter. 

The graphics pen hangs below and to the right of each point on the boundary of the polygon. Thus, the drawn polygon extends beyond the right and bottom edges of the polygon’s bounding rectangle (which is stored in the polyBBox field of the Polygon structure) by the pen width and pen height, respectively. All other graphics operations, such as painting a polygon with the PaintPoly function, occur strictly within the boundary of the polygon.

If a polygon is open and being formed, FramePoly affects the outline of the polygon just as if the line-drawing functions themselves had been called. If a region is open and being formed, the outside outline of the polygon being framed is mathematically added to the region’s boundary.

The result of this function is undefined whenever any horizontal or vertical line through the polygon would intersect the polygon’s outline more than 50 times. 
Special Considerations

The FramePoly function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void FramePoly (
   PolyHandle poly
){
printf ("FramePoly",poly);
};

/*GetPortTextFace

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Style GetPortTextFace (
   CGrafPtr port
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
Style GetPortTextFace (
   CGrafPtr port
){
printf ("GetPortTextFace",port);
};


/*PortSize

Changes the size of the port rectangle of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PortSize (
   short width,
   short height
);
Parameters
width

The width of the reset port rectangle.
height

The height of the reset port rectangle.
Discussion

The PortSize function is normally called only by the Window Manager. The PortSize function changes the size of the current graphics port’s port rectangle. The upper-left corner of the port rectangle remains at its same location the width and height of the port rectangle are set to the given width and height. In other words, PortSize moves the lower-right corner of the port rectangle to a position relative to the upper-left corner.

The PortSize function doesn’t change the clipping or visible region of the graphics port, nor does it affect the local coordinate system of the graphics port it changes only the width and height of the port rectangle. Remember that all drawing occurs only in the intersection of the boundary rectangle and the port rectangle, after being cropped to the visible region and the clipping region. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PortSize (
   short width,
   short height
){};

 void  CloseCPort(CGrafPtr port){};

 void  OpenCPort(CGrafPtr port){};


/*QDIsPortBufferDirty

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Boolean QDIsPortBufferDirty (
   CGrafPtr port
);

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Boolean QDIsPortBufferDirty (
   CGrafPtr port
){};



/*DeviceLoop

Draws images that are optimized for every screen they cross. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void DeviceLoop (
   RgnHandle drawingRgn,
   DeviceLoopDrawingUPP drawingProc,
   long userData,
   DeviceLoopFlags flags
);

Parameters
drawingRgn

A handle to the region in which you will draw; this drawing region uses coordinates that are local to its graphics port. 
drawingProc

A pointer to your own drawing function. 
userData

Any additional data that you wish to supply to your drawing function.
flags

One or more members of the set of flags defined by the Device Loop Flags data type. if you want to use the default behavior of DeviceLoop, specify an empty set ([]) in this parameter. 
Discussion

The DeviceLoop function searches for graphics devices that intersect your window’s drawing region, and it calls your drawing function for each dissimilar video device it finds. 

Because DeviceLoop provides your drawing function with the pixel depth and other attributes of each video device, your drawing function can optimize its drawing for each video device.

See DeviceLoopDrawingProcPtr for a description of the drawing function you must provide for the drawingProc parameter. 
Special Considerations

The DeviceLoop function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void DeviceLoop (
   RgnHandle drawingRgn,
   DeviceLoopDrawingUPP drawingProc,
   long userData,
   DeviceLoopFlags flags
){};


/*NewDeviceLoopDrawingUPP

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

DeviceLoopDrawingUPP NewDeviceLoopDrawingUPP (
   DeviceLoopDrawingProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
DeviceLoopDrawingUPP NewDeviceLoopDrawingUPP (
   DeviceLoopDrawingProcPtr userRoutine
){};

/*SetPortBits

Sets the bitmap for the current basic graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPortBits (
   const BitMap * bm
);

Parameters
bm

A pointer to the BitMap structure to set for the current graphics port. Be sure to prepare all fields of the BitMap structure before you call SetPortBits. 
Discussion

You should never need to use this function. This function, created for early versions of QuickDraw, allows you to perform all normal drawing and calculations on a buffer other than the screen—for example, copying a small offscreen image onto the screen with the CopyBits function. However, instead of using SetPortBits, you should use the more powerful offscreen graphics capabilities. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void SetPortBits (
   const BitMap * bm
){};


/*CopyMask

Copies a bit or pixel image from one graphics port or offscreen graphics world into another graphics port only where the bits in a mask are set to 1. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyMask (
   const BitMap * srcBits,
   const BitMap * maskBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * maskRect,
   const Rect * dstRect
);
Parameters
srcBits

The source BitMap structure. 
maskBits

The mask BitMap structure.
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
maskRect

The mask rectangle. This must be the same size as the rectangle passed in the srcRect parameter. The rectangle you pass in this parameter selects the portion of the bitmap or pixel map that you specify in the maskBits parameter to use as the mask.
dstRect

The destination rectangle.
Discussion

The CopyMask function copies the source bitmap or pixel map that you specify in the srcBits parameter to a destination bitmap or pixel map that you specify in the dstBits parameter—but only where the bits of the mask bitmap or pixel map that you specify in the maskBits parameter are set to 1. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. 

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyMask scales the source image to fit the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

If you specify pixel maps to CopyMask, they may range from 1 to 32 pixels in depth. The pixel depth of the mask that you specify in the maskBits parameter is applied as a filter between the source and destination pixel maps that you specify in the srcBits and dstBits parameters. A black mask pixel value means that the copy operation is to take the source pixel a white value means that the copy operation is to take the destination pixel. Intermediate values specify a weighted average, which is calculated on a color component basis. For each pixel’s color component value, the calculation is

(1 – mask) x source + (mask) x destination

Thus high mask values for a pixel’s color component reduce that component’s contribution from the source PixMap structure. 

Use the bitmap returned by CalcMask as the mask in order to implement a mask copy similar to that performed by the MacPaint lasso tool. In the same way, you can use the pixel map returned by the CalcCMask function.

The CopyDeepMask function combines the functions of the CopyMask and CopyBits functions. 
Special Considerations

Calls to CopyMask are not recorded in pictures and do not print.

See the list of special considerations for CopyBits; these considerations also apply to CopyMask.

The CopyMask function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyMask (
   const BitMap * srcBits,
   const BitMap * maskBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * maskRect,
   const Rect * dstRect
){};






