#include <QuickTime/QuickTime.h>


/*SGPrepare

Instructs a sequence grabber to get ready to begin a preview or record operation.

ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
prepareForPreview

The sequence grabber component sets this parameter to TRUE to prepare for a preview operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
prepareForRecord

The sequence grabber component sets this parameter to TRUE to prepare for a record operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If you do not call this function before starting a record or preview operation, the sequence grabber component makes these preparations when you start the operation. You cannot call this function after you start a preview or record operation. If you call this function without subsequently starting a record or preview operation, you should call SGRelease. This allows the sequence grabber component to release any system resources it allocated when you called this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord ){
printf ("SGPrepare", s , prepareForPreview, prepareForRecord);
};


/*PreviewShowData

Displays a preview if it does not handle events.

ComponentResult PreviewShowData (
   pnotComponent    p,
   OSType           dataType,
   Handle           data,
   const Rect       *inHere );
Parameters
p

Specifies your preview component. You obtain this identifier from OpenComponent.
dataType

The type of handle pointing to the data to be displayed in the preview.
data

A handle to the data, which is typically the same as the subtype of your preview component.
inHere

A pointer to a Rect structure that defines the area into which you draw the preview. The current port is set to the correct graphics port for drawing. You must not draw outside the given rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult PreviewShowData (
   pnotComponent    p,
   OSType           dataType,
   Handle           data,
   const Rect       *inHere ){
printf ("PreviewShowData",p,dataType,data,*inHere);
};

/*MovieImportDoUserDialog

Requests that a component display its user dialog box.

ComponentResult MovieImportDoUserDialog (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Handle                  theData,
   Boolean                 *canceled );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to a valid file specification. If the import request pertains to a file, the application must specify the source file with this parameter and set the theData parameter to NIL. If the request is for a handle, this parameter is set to NIL.
theData

A handle to the data to be imported. If the import request pertains to a handle, the application must specify the source of the data with this parameter, and set the theFile parameter to NIL. If the request is for a file, this parameter is set to NIL.
canceled

A pointer to a Boolean value. Your component should set this value to TRUE if the user cancels the dialog box; otherwise, set it to FALSE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If your component supports a user dialog box, be sure to set the hasMovieImportUserInterface flag in the componentFlags field of your component's ComponentDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportDoUserDialog (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Handle                  theData,
   Boolean                 *canceled ){
printf ("MovieImportDoUserDialog",ci,*theFile,theData,*canceled);
};


/*DisposeSGModalFilterUPP

Disposes of an SGModalFilterUPP pointer.

void DisposeSGModalFilterUPP (
   SGModalFilterUPP    userUPP );
Parameters
userUPP

An SGModalFilterUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeSGModalFilterUPP (
   SGModalFilterUPP    userUPP ){
printf ("DisposeSGModalFilterUPP",userUPP);
};




/*NewSGModalFilterUPP

Allocates a Universal Procedure Pointer for the SGModalFilterProc callback.

SGModalFilterUPP NewSGModalFilterUPP (
   SGModalFilterProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGModalFilterProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

SGModalFilterUPP NewSGModalFilterUPP (
   SGModalFilterProcPtr    userRoutine ){
printf ("NewSGModalFilterUPP",userRoutine);
};

/*SGGetVideoRect

Determines the portion of the source video image that is to be captured.

ComponentResult SGGetVideoRect (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive the dimensions of the rectangle that defines the portion of the source video image your component is going to capture.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetVideoRect (
   SGChannel    c,
   Rect         *r ){
printf ("SGGetVideoRect ",c,*r);
};

/*SGSetDataOutput

Specifies the movie file and options for a sequence grabber record operation.

ComponentResult SGSetDataOutput (
   SeqGrabComponent    s,
   const FSSpec        *movieFile,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
movieFile

A pointer to the FSSpec structure that identifies the movie file for this record operation.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk flag or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataOutput (
   SeqGrabComponent    s,
   const FSSpec        *movieFile,
   long                whereFlags ){
printf ("SGSetDataOutput ",s,*movieFile,whereFlags);
};



/*SGNewOutput

Creates a new sequence grabber output.

ComponentResult SGNewOutput (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags,
   SGOutput            *sgOut );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the destination container.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
sgOut

A pointer to a sequence grabber output. The sequence grabber component returns an output identifier that you can use with other sequence grabber component functions.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Once you have created the sequence grabber output, you can use SGSetChannelOutput to assign the output to a sequence grabber channel.
Version Notes

A sequence grabber output ties a sequence grabber channel to a specified data reference for the output of captured data. If you are capturing to a single movie file, you can continue to use SGSetDataOutput or SGSetDataRef to specify the sequence grabber's destination. However, if you want to capture movie data into several different files or data references, you must use sequence grabber outputs to do so. Even if you are using outputs, you must still use SGSetDataOutput or SGSetDataRef to identify where the sequence grabber should create the movie resource. You are responsible for creating outputs, assigning them to sequence grabber channels, and disposing of them when you are done.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewOutput (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags,
   SGOutput            *sgOut ){
printf ("SGNewOutput ",s,dataRef,dataRefType,whereFlags,*sgOut);
};


/*SGGrabPict

Lets your application obtain a Picture structure from a sequence grabber component.

ComponentResult SGGrabPict (
   SeqGrabComponent    s,
   PicHandle           *p,
   const Rect          *bounds,
   short               offscreenDepth,
   long                grabPictFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
p

A pointer to a field that is to receive a handle to the Picture structure. If the function cannot create the structure, it sets this handle to NIL.
bounds

A pointer to the boundary region for the Picture structure. By default, this rectangle lies in the current graphics port. If you set the grabPictOffScreen flag in the grabPictFlags parameter to 1, the sequence grabber places the structure in an offscreen graphics world. In this case, the rectangle is interpreted in that offscreen world.
offscreenDepth

The pixel depth for the offscreen graphics world. This parameter is typically set to 0, which chooses the best available depth. If you set the grabPictOffScreen flag in the grabPictFlags parameter to 1, the sequence grabber places the Picture structure in an offscreen graphics world. You specify the pixel depth of this offscreen graphics world with this parameter. If you are displaying the picture, this parameter is ignored.
grabPictFlags

Contains flags (see below) that control the operation. See these constants: 
grabPictOffScreen
grabPictIgnoreClip
grabPictCurrentImage
Return Value

See Error Codes. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGrabPict (
   SeqGrabComponent    s,
   PicHandle           *p,
   const Rect          *bounds,
   short               offscreenDepth,
   long                grabPictFlags ){
printf ("SGGrabPict",s,*p,*bounds,offscreenDepth,grabPictFlags);
};/*SGSetAdditionalSoundRates

Specifies a list of sound sample rates to be included in the sequence grabber's sound settings dialog box.

ComponentResult SGSetAdditionalSoundRates (
   SGChannel    c,
   Handle       rates );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
rates

A handle containing a list of unsigned 32-bit fixed-point values. The sequence grabber channel determines the number of sample rates contained in the handle, based on the size of the handle. If any of the requested rates are not supported directly by the available sound capture hardware, sound will be captured at one of the available hardware rates and then converted in software to the requested rate.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber channel makes a copy of the additional rates handle, so your application can immediately dispose of it after making this call.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetAdditionalSoundRates (
   SGChannel    c,
   Handle       rates ){
printf ("SGSetAdditionalSoundRates",c,rates);
};

/*SGSetChannelVolume

Sets a channel's sound volume.

ComponentResult SGSetChannelVolume (
   SGChannel    c,
   short        volume );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
volume

The volume setting of your channel represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelVolume (
   SGChannel    c,
   short        volume ){
printf ("SGSetChannelVolume",c,volume);
};



/*SGUpdate

Informs your component about update events, to update its display.

ComponentResult SGUpdate (
   SeqGrabComponent    s,
   RgnHandle           updateRgn );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
updateRgn

Indicates the part of the window that has been changed. 
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Applications can determine the part of the window that has been changed by examining the appropriate window record. For example, they may call the sequence grabber in this manner:SGUpdate (theSG, ((WindowPeek)updateWindow)->
updateRgn);

Special Considerations

Your application should avoid drawing where the sequence grabber is displaying video. Doing so may cause some video digitizer components to stop displaying video.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGUpdate (
   SeqGrabComponent    s,
   RgnHandle           updateRgn ){
printf ("SGUpdate",s,updateRgn);
};


/*MovieExportSetSampleDescription

Requests the format of the exported data.

ComponentResult MovieExportSetSampleDescription (
   MovieExportComponent       ci,
   SampleDescriptionHandle    desc,
   OSType                     mediaType );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
desc

A handle to a valid SampleDescription structure.
mediaType

The type of media the SampleDescription structure is for. For example, if the sample description was a sound description, this parameter would be set to SoundMediaType.
Return Value

See Error Codes. Returns badComponentSelector if you should be passing a QT atom container (see discussion, below). Returns noErr if there is no error.
Discussion

A movie export component may use all, some, or none of the settings from the SampleDescription structure.

If your application attempts to set the sample description using this function, and receives the badComponentSelector error, you may need to pass in the sample description using MovieExportSetSettingsFromAtomContainer. You can use MovieExportGetSettingsAsAtomContainer to obtain a correctly formatted atom container to modify.
Special Considerations

This function is not implemented by all movie export components, but is supported by the sound movie export component, for example.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetSampleDescription (
   MovieExportComponent       ci,
   SampleDescriptionHandle    desc,
   OSType                     mediaType ){
printf ("MovieExportSetSampleDescription",ci,desc,mediaType);
};


/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The client’s connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information––that is, a VBR format such as AAC–– allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a “pull” model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
){
printf ("SCAudioFillBuffer",ci,inInputDataProc,inInputDataProcRefCon,*ioOutputDataPacketSize,*outOutputData,*outPacketDescription);
};

/*TCSetDisplayOptions

Sets the text characteristics that apply to timecode information displayed in a movie.

HandlerError TCSetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
textOptions

A pointer to a TCTextOptions structure. This structure contains font and style information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCSetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions ){
printf ("TCSetDisplayOptions",mh,textOptions);
};



/*TCGetCurrentTimeCode

Retrieves the timecode and source identification information for the current movie time.

HandlerError TCGetCurrentTimeCode (
   MediaHandler      mh,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   UserData          *srcRefH );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
frameNum

A pointer to a field that is to receive the current frame number. Set this field to NIL if you don't want to retrieve the frame number.
tcdef

A pointer to a TimeCodeDef structure. The media handler returns the movie's timecode definition information. Set this parameter to NIL if you don't want this information.
tcrec

A pointer to a TimeCodeRecord structure. The media handler returns the current time value. Set this parameter to NIL if you don't want this information.
srcRefH

A pointer to a field that is to receive a handle containing the source information as a UserDataRecord structure. It is your responsibility to dispose of this structure when you are done with it. Set this field to NIL if you don't want this information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetCurrentTimeCode (
   MediaHandler      mh,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   UserData          *srcRefH ){
printf ("TCGetCurrentTimeCode",mh,*frameNum,*tcdef,*tcrec,*srcRefH);
};


/*DisposeSGDataUPP

Disposes of an SGDataUPP pointer.

void DisposeSGDataUPP (
   SGDataUPP    userUPP );
Parameters
userUPP

An SGDataUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeSGDataUPP (
   SGDataUPP    userUPP ){
printf ("DisposeSGDataUPP",userUPP);
};


/*SGSetChannelPlayFlags

Adjusts the speed and quality with which the sequence grabber displays data from a channel.

ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A long integer that contains flags (see below) that influence channel playback. A sequence grabber component must use one of these values. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags ){
printf ("SGSetChannelPlayFlags",c,playFlags);
};



/*SGGetChannelUsage

Determines how the sequence grabber component is using a channel.

ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

A pointer to a location that is to receive flags (see below) that specify how your channel is to be used. You may set more than one of these flags to 1. Set unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage ){
printf ("SGGetChannelUsage",c,*usage);
};

/*SGStartPreview

Instructs the sequence grabber to begin processing data from its channels.

ComponentResult SGStartPreview (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your channel component should immediately present the data to the user in the appropriate format, according to your channel's configuration. Display video data in the destination display region; play sound data at the specified volume settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartPreview (
   SeqGrabComponent    s ){
printf ("SGStartPreview ",s);
};


/*SGRelease

Instructs the sequence grabber to release any system resources it allocated when you called SGPrepare.

ComponentResult SGRelease (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record or preview operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGRelease (
   SeqGrabComponent    s ){
printf ("SGRelease",s);
};



/*SGGetChannelPlayFlags

Retrieves the playback control flags that you set with SGSetChannelPlayFlags.

ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A pointer to a long integer that is to receive flags (see below) that influence channel playback. Set unused flags to 0. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags ){
printf ("SGGetChannelPlayFlags",c,*playFlags);
};


/*SGSettingsDialog

Causes a sequence grabber to display its settings dialog box to the user.

ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
numPanels

The number of panel components to be listed in the panel component pop-up menu. You specify the panel components with the panelList parameter. You may use these parameters to limit the user's choice of panel components. If you set this parameter to 0 and the panelList parameter to NIL, the sequence grabber lists all available panel components.
panelList

A pointer to an array of component identifiers. The sequence grabber presents only these components in the panel component pop-up menu. You specify the number of identifiers in the array with the numPanels parameter. If you set this parameter to NIL, the sequence grabber lists all available panel components.
flags

Either set this to 0 or to seqGrabSettingsPreviewOnly (see below). See these constants: 
seqGrabSettingsPreviewOnly
proc

Specifies an SGModalFilterProc callback. Because the sequence grabber's settings dialog box is a movable modal dialog box, you must supply an event filter function to process update events in your window.
procRefNum

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. If the user clicks OK and the settings are acceptable to the panel and channel components, this function returns a result code of noErr.
Discussion

Because the user may change several channel configuration parameters, your application should retrieve new configuration information from the channel so that you can update any values you save, such as the channel's display boundaries or the channel device. In particular, the video rectangle for the channels may have to be adjusted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum ){
printf ("SGSettingsDialog",s,c,numPanels,panelList,flags,proc,procRefNum);
};
 
/*SGSetChannelUsage

Specifies how a channel is to be used by the sequence grabber component.

ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

Contains flags (see below) specifying how your channel is to be used. The sequence grabber component may set more than one of these flags to 1. It sets unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage ){
printf ("SGSetChannelUsage",c,usage);
};


/*SGGetPause

Determines whether the sequence grabber is paused.

ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
paused

A pointer to a field that is to receive a constant (see below) that indicates whether the sequence grabber is currently paused. See these constants: 
seqGrabUnpause
seqGrabPause
seqGrabPauseForMenu
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused ){
printf ("SGGetPause",s,*paused);
};



/*SGPause

Suspends or restarts a sequence grabber record or preview operation.

ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
pause

A constant (see below) that instructs your component to suspend or restart the current operation. See these constants: 
seqGrabUnpause
seqGrabPause
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component should not release any system resources or temporary memory associated with the current operation. You should be ready to restart the operation immediately.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause ){
printf ("SGPause ",s,pause);
};




/*SGStop

Stops a preview or record operation.

ComponentResult SGStop (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

It is dangerous to allow an update event to occur during recording. Many digitizers capture directly to the screen, and an update event will result in data loss.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStop (
   SeqGrabComponent    s ){
printf ("SGStop",s);
};

/*SGStartRecord

Instructs the sequence grabber component to begin collecting data from its channels.

ComponentResult SGStartRecord (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartRecord (
   SeqGrabComponent    s ){
printf ("SGStartRecord ",s);
};

/*SGIdle

Provides processing time for sequence grabber components.

ComponentResult SGIdle (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After starting a preview or record operation, the application calls this function as often as possible. The sequence grabber component then calls your SGIdle function. This continues until the calling application stops the operation by calling SGStop.Your SGIdle function reports several status and error conditions by means of its result code. If your component returns a nonzero result code during a record operation, the application should call SGStop so that the sequence grabber component can store the data it has collected.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGIdle (
   SeqGrabComponent    s ){
printf ("SGIdle",s);
};


/*SGSetMaximumRecordTime

Limits the duration of a record operation

ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ticks

The maximum duration for the record operation, in system ticks (sixtieths of a second). Set this parameter to 0 to remove the time limit from the operation.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By default, there is no time limit on a record operation. If you do not set a limit, a record operation will run until it exhausts the Operating System resources or you call SGStop. Memory and disk space are the two major limiting factors.
Special Considerations

You must call this function before you start a sequence grabber record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks ){
printf ("SGSetMaximumRecordTime",s,ticks);
};



/*SGSetChannelSettings

Configures a sequence grabber channel.

ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the channel component.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags ){
printf ("SGSetChannelSettings",s,c,ud,flags);
};

/*SGDisposeChannel

Removes a channel from a sequence grabber component.

ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The reference that identifies the channel you want to close. You obtain this reference from SGNewChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c ){
printf ("SGDisposeChannel",s,c);
};



/*SGGetChannelSettings

Retrieves the current settings of a channel used by the sequence grabber.

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

On return, a pointer to a UserDataRecord structure that contains the configuration information.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags ){
printf ("SGGetChannelSettings ",s,c,*ud,flags);
};

/*SGSetSettings

Configures a sequence grabber and its channels.

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the sequence grabber.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber disposes of any of its current channels before applying this configuration information. It then opens connections to new channels as appropriate.
Special Considerations

You can restore saved settings by using NewUserDataFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags ){
printf ("SGSetSettings",s,ud,flags);
};


/*SGGetIndChannel

Collects information about all of the channel components currently in use by a sequence grabber component.

ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
index

Specifies an index value that identifies the channel to be queried. The first channel has an index value of 1.
ref

A pointer to a field to receive a value identifying your connection to the channel. If you do not want to receive this information, set this parameter to NIL.
chanType

A pointer to a field to receive the channel's subtype value (see below). This value indicates the media type supported by the channel component. See these constants: 
VideoMediaType
SoundMediaType
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType ){
printf ("SGGetIndChannel ",s,index,*ref,*chanType);
};


/*SGGetSettings

Retrieves the current settings of all channels used by the sequence grabber.

ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A pointer to a space where the sequence grabber returns a pointer to a UserDataRecord structure that contains the configuration information. Your application is responsible for disposing of this structure when it is done with it.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags ){
printf ("SGGetSettings",s,*ud,flags);
};

/*(SGSetDataRef

Specifies the destination data reference for a record operation.

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the information that identifies the destination container.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to specify the destination for a record operation using a data reference, and to specify other options that govern the operation. This function is similar to SGSetDataOutput, and provides you with an alternative way to specify the destination.
Special Considerations

If you are performing a preview operation, you don't need to use this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags ){
printf ("SGSetDataRef ",s,dataRef,dataRefType,whereFlags);
};


/*SGInitialize

Initializes the sequence grabber component.

ComponentResult SGInitialize (
   SeqGrabComponent    s );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before you can call this function you must establish a connection to the sequence grabber component. Use OpenDefaultComponent or OpenComponent to establish a component connection, as shown below:// SGInitialize coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGInitialize (
   SeqGrabComponent    s ){
printf ("SGInitialize",s);
};

/*SGSetChannelBounds

Specifies a channel's display boundary rectangle.

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that defines your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds){
printf ("SGSetChannelBounds",c,*bounds);
};



/*SGSetGWorld

Establishes the graphics port and device for a sequence grabber component.

ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
gp

The destination graphics port, which must be a color graphics port. The sequence grabber component always sets this parameter to a valid value. To use the current graphics port, the parameter is set to NIL.
gd

A handle to the destination graphics device. The sequence grabber component always sets this parameter to a valid value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function if you are working with any channels that collect visual data. If you are working only with data that has no visual representation, you do not need to call this function. The sequence grabber component performs this operation implicitly when you call SGInitialize and the component uses your application's current graphics port. To set it to a specified window, use code such as the following:// SGSetGWorld coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Special Considerations

You cannot call this function during a record or preview operation, or after you have prepared the sequence grabber component for a record or preview operation by calling SGPrepare. The window in which the sequence grabber is to draw video frames as defined by this function must be visible before you call SGPrepare; otherwise, the sequence grabber does not display the frames properly.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd ){
printf ("SGSetGWorld",s,gp,gd);
};

/*SGGetChannelBounds

Determines a channel's display boundary rectangle.

ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that is to receive information about your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds ){
printf ("SGGetChannelBounds",c,*bounds);
};

/*SGGetChannelTimeScale

Lets the sequence grabber retrieve a channel's time scale.

ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
scale

A pointer to a time scale. Your channel component places information about its time scale into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The time scale you return typically corresponds to the time scale of the media that has been created by your channel. Applications may use this time scale in their data functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale ){
printf ("SGGetChannelTimeScale",c,*scale);
};


/*SGGetChannelSampleDescription

Retrieves a channel's sample description structure.

ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sampleDesc

A handle that is to receive the structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The channel returns a structure that is appropriate to the type of data being captured. For video channels, the channel component returns an ImageDescription structure; for sound channels, it receives a SoundDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc ){
printf ("SGGetChannelSampleDescription",c,sampleDesc);
};


/*SGGetSrcVideoBounds

Determines the size of the source video boundary rectangle.

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive information about your channel's source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

For video channel components that work with video digitizer components, the source video boundary rectangle corresponds to the video digitizer's active source rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r ){
printf ("SGGetSrcVideoBounds",c,*r);
};

/*SGDisposeDeviceList

Disposes of a device list.

ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
list

A pointer to a pointer to an SGDeviceListRecord structure. The sequence grabber disposes of the memory used by this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list ){
printf ("SGDisposeDeviceList",s,list);
};



/*SGGetChannelDeviceList

Retrieves a list of the devices that are valid for a specified channel.

ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
selectionFlags

Flags (see below) that control the data you are to return for each device. See these constants: 
sgDeviceListWithIcons
sgDeviceListDontCheckAvailability
sgDeviceListIncludeInputs
list

A pointer to a pointer to an SGDeviceListRecord structure. The channel creates this structure and returns a pointer to it in the field referred to by this parameter. Applications use SGDisposeDeviceList to dispose of the memory used by the list.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function can be useful for retrieving the name of the current device. Retrieve the device list and use the selectedIndex field to determine which device is currently in use.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list ){
printf ("SGGetChannelDeviceList",c,selectionFlags,*list);
};

/*SGGetChannelDeviceAndInputNames

Returns the sequence grabber's current device and input names.

ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
outDeviceName

The current device names for display to the user.
outInputName

The current input names for display to the user.
outInputNumber

A pointer to the number of currently selected inputs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a utility call that lets you find out the sequence grabber's current device and input names, instead of having to call GetDeviceList and walk it yourself. Pass NIL for parameters you are not interested in.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber ){
printf ("SGGetChannelDeviceAndInputNames",c,outDeviceName,outInputName,*outInputNumber);
};

/*TCGetTimeCodeFlags

Retrieves the timecode control flags.

HandlerError TCGetTimeCodeFlags (
   MediaHandler    mh,
   long            *flags );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
flags

A pointer to a field that is to receive a control flag (see below). See these constants: 
tcdfShowTimeCode
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetTimeCodeFlags (
   MediaHandler    mh,
   long            *flags ){
printf ("TCGetTimeCodeFlags",mh,*flags);
};





/*SCRequestImageSettings

Displays the standard image dialog box to the user and shows default settings you have established.

ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to retrieve the user's preferences for compressing a single image; use SCRequestSequenceSettings when you are working with an image sequence. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestImageSettings (
   ComponentInstance    ci ){
printf ("SCRequestImageSettings",ci);
};


/*SGNewChannel

Creates a sequence grabber channel and assigns a channel component to the channel.

ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
channelType

The type of channel to open (see below). This value corresponds to the component subtype value of the channel component. See these constants: 
VideoMediaType
SoundMediaType
ref

A pointer to the frameChannel field in the SeqGrabFrameInfo structure that is to receive a reference to the channel that is added to the sequence grabber component. If the sequence grabber component successfully locates and connects to an appropriate channel component, the sequence grabber component returns a reference to the channel component into this field.
Return Value

See Error Codes. If the sequence grabber component cannot open a connection, it sets the result code to a nonzero value. It returns noErr if there is no error.
Discussion

The channel component is responsible for providing digitized data to the sequence grabber component. You specify the type of channel component to be added to the sequence grabber component, as shown in the following sample code:// SGNewChannel coding example
// See "Discovering QuickTime," page 263
void MakeMyGrabChannels (SeqGrabComponent    seqGrab,
                            SGChannel        *sgchanVideo,
                            SGChannel        *sgchanSound,
                            const Rect       *rect,
                            Boolean          bWillRecord)
{
    OSErr           nErr;
    long            lUsage;
    // figure out the usage
    lUsage =seqGrabPreview;                // always previewing
    if (bWillRecord)
        lUsage |=seqGrabRecord;            // sometimes recording
    // create a video channel
    nErr =SGNewChannel(seqGrab, VideoMediaType, sgchanVideo);
    if (nErr ==noErr) {
        // set boundaries for new video channel
        nErr =SGSetChannelBounds(*sgchanVideo, rect);
        // set usage for new video channel
        if (nErr ==noErr)
            nErr =SGSetChannelUsage(*sgchanVideo, lUsage |
                                        seqGrabPlayDuringRecord);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanVideo);
            *sgchanVideo =NIL;
        }
    }
    // create a sound channel
    nErr =SGNewChannel(seqGrab, SoundMediaType, sgchanSound);
    if (nErr ==noErr) {
        // set usage of new sound channel
        nErr =SGSetChannelUsage(*sgchanSound, lUsage);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanSound);
            *sgchanSound =NIL;
        }
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref ){
printf ("SGNewChannel",s,channelType,*ref);
};




/*SGGetChannelRefCon

Returns a reference constant that was previously set by SGSetChannelRefCon.

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A pointer to the reference constant set by SGSetChannelRefCon, normally used to point to a data structure containing information your sequence grabber channel needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h&*/

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon ){
printf ("SGGetChannelRefCon",c,*refCon);
};



/*SGSetChannelRefCon

Sets the value of a reference constant that is passed to your callback functions for channel components.

ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A reference constant value that your component should pass to the callback functions that have been assigned to this channel. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon ){
printf ("SGSetChannelRefCon ",c,refCon);
};

/*SGSetDataProc

Specifies a data function for use by the sequence grabber.

ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
proc

A pointer to your data function. To remove your data function, set this parameter to NIL.
refCon

A reference constant. The sequence grabber provides this value to your data callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon ){
printf ("SGSetDataProc",s,proc,refCon);
};

/*SCCompressPictureFile

Compresses a Picture structure that is stored in a file.

ComponentResult SCCompressPictureFile (
   ComponentInstance    ci,
   short                srcRefNum,
   short                dstRefNum );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
srcRefNum

A reference to the file to be compressed.
dstRefNum

A reference to the file that is to receive the compressed data. This may be the same as the source file. The standard dialog component places the compressed image data into the file identified by this reference. Your application is responsible for this file after the compression operation.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressPictureFile (
   ComponentInstance    ci,
   short                srcRefNum,
   short                dstRefNum ){
printf ("SCCompressPictureFile",ci,srcRefNum,dstRefNum);
};

/*DataHGetInfoFlags

Provides information about the operation of a data handler component.

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags );
Parameters
dh

A data handler component.
flags

Flags (see below) that provide information about the data handler. See these constants: 
kDataHInfoFlagNeverStreams
kDataHInfoFlagCanUpdateDataRefs
kDataHInfoFlagNeedsNetworkBandwidth
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags ){
printf ("DataHGetInfoFlags ",dh,*flags);
};

/*VDGetDeviceNameAndFlags

Returns the current name and device visibility of a video digitizer.

VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
outName

The video digitizer device name.
outNameFlags

A pointer to a constant (see below) that determines whether to show or hide the VDIG device. See these constants: 
vdDeviceFlagShowInputsAsDevices
vdDeviceFlagHideDevice
Return Value

An error return of type ComponentResult. See Error Codes. Returns noErr if there is no error.
Discussion

This routine is designed to give the VDIG more control over how it is presented to the user, and to clarify the distinction between devices and inputs. Historically, the assumption has been that there is one component registered per device and that the component name is displayed. This function lets a component choose its name after registration. When this function is called, it is also a good time to check for hardware and register further VDIG components if needed, allowing for lazy initialization when the application needs to find a VDIG rather than initializing at every launch or replug.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags ){
printf ("VDGetDeviceNameAndFlags",ci,outName,*outNameFlags);
};

/*VDGetNumberOfInputs

Returns the number of input video sources that a video digitizer component supports.

VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputs

A pointer to an integer that is to receive the number of input video sources supported by the specified component. Video digitizer components number video sources sequentially, starting at 0. So, if a digitizer component supports two inputs, this function sets the field referred to by the inputs parameter to 1.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs ){
printf ("VDGetNumberOfInputs",ci,*inputs);
};


/*VDGetInputName

Gets the name of a video input.

VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name );
Parameters
ci

Specifies the video digitizer component for this operation. Applications can obtain this reference from OpenComponent or OpenDefaultComponent.
videoInput

The input video source for this request. Video digitizer components number video sources sequentially, starting at 0. So, to request information about the first video source, an application sets this parameter to 0. Applications can get the number of video sources supported by a video digitizer component by calling VDGetNumberOfInputs.
name

The video input source's name string.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name ){
printf ("VDGetInputName",ci,videoInput,name);
};


/*VDGetInput

Returns data that identifies the currently active input video source.

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
input

A pointer to a short integer that is to receive the identifier for the currently active input video source. Video digitizer components number video sources sequentially, starting at 0. So, if the first source is active, this function sets the field referred to by the input parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input ){
printf ("VDGetInput ",ci,*input);
};

/*VDGetSoundInputDriver

Retrieves information about a video digitizer's sound input driver.

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
soundDriverName

A pointer to a string. The video digitizer returns the name of its sound input driver. If the digitizer does not have an associated driver, it returns a result code of digiUnimpErr.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName ){
printf ("VDGetSoundInputDriver",ci,soundDriverName);
};


/*VDGetDataRate

Retrieves information that describes the performance capabilities of a video digitizer.

VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
milliSecPerFrame

A pointer to a long integer. The video digitizer returns a value that indicates the number of milliseconds of synchronous overhead involved in digitizing a single frame. This value includes the average delay incurred between the time when the digitizer requests a frame from its associated device, and the time at which the device delivers the frame.
framesPerSecond

A pointer to a fixed value. The video digitizer supplies the maximum rate at which it can capture video. Note that this value may differ from the rate that the application set with VDSetFrameRate.
bytesPerSecond

A pointer to a long integer. Video digitizers that can return compressed image data return a value that indicates the approximate number of bytes per second that the digitizer is generating compressed data, given the current compression and frame rate settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond ){
printf ("VDGetDataRate",*milliSecPerFrame,*framesPerSecond,*bytesPerSecond);
};


/*VDGetImageDescription

Retrieves an ImageDescription structure from a video digitizer.

VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
desc

A handle. The video digitizer fills this handle with an ImageDescription structure containing information about the digitizer's current compression settings. The digitizer resizes the handle appropriately. It is the application's responsibility to dispose of this handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc ){
printf ("VDGetImageDescription",ci,desc);
};


/*VDGetCurrentFlags

Returns status information about a specified video digitizer component.

VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputCurrentFlag

A pointer to a long integer that is to receive the current input state flags for the video digitizer component; see Video Digitizer Capabilities.
outputCurrentFlag

A pointer to a long integer that is to receive the current output state flags for the video digitizer component; see Video Digitizer Capabilities.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is often more convenient than VDGetDigitizerInfo. For example, this function provides a simple mechanism for determining whether a video digitizer is receiving a valid input signal. An application can retrieve the current input state flags and test the high-order bit by examining the sign of the returned value. If the value is negative (that is, the high-order bit, digiInSignalLock, is set to 1), the digitizer component is receiving a valid input signal.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag ){
printf ("VDGetCurrentFlags",ci,*inputCurrentFlag,*outputCurrentFlag);
};


/*MovieExportNewGetDataAndPropertiesProcs

Returns MovieExportGetPropertyProc and MovieExportGetDataProc callbacks that can be passed to MovieExportAddDataSource to create a new data source.

ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The format of the data to be generated by the returned MovieExportGetDataProc.
scale

The time scale returned from this function; this should be passed on to MovieExportAddDataSource with the procedures.
theMovie

The movie for this operation, supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
theTrack

The track for this operation. This track identifier is supplied by the Movie Toolbox.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exists in order to provide a standard way of getting data using this protocol out of a movie or track. The returned procedures must be disposed by calling MovieExportDisposeGetDataAndPropertiesProcs.
Special Considerations

This function is only implemented by movie data export components.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon ){
printf ("MovieExportNewGetDataAndPropertiesProcs",ci,trackType,scale,theMovie,theTrack,startTime,duration,getPropertyProc,getDataProc,refCon);
};


/*MovieExportAddDataSource

Defines a data source for use with an export operation performed by MovieExportFromProceduresToDataRef.

ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The type of media provided by this data source. This normally corresponds to a QuickTime media type such as VideoMediaType or SoundMediaType.
scale

The time scale for time values passed to getDataProc parameter. If the source data is being taken from a QuickTime track, this value is typically the media's time scale.
trackID

An identifier for the data source. This identifier is returned from the call.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before starting an export operation, all the data sources must be defined by calling this function once for each data source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon ){
printf("MovieExportAddDataSource",ci,trackType,scale,trackID,getPropertyProc,getDataProc,refCon);
};


/*MovieExportDoUserDialog

Requests that a component display its user dialog box.

ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theMovie

The movie containing the data to be exported.
onlyThisTrack

Specifies that the export component should only attempt to export the data from a single track. If this parameter is set to NIL, the exporter should attempt to export the entire movie, or all of the tracks in the movie that it can export. For example, an audio export component might export multiple audio tracks, mixing them if necessary. If this parameter is not NIL, the exporter should attempt to export only the specified track.
startTime

The movie time at which to begin the export operation. If you pass 0, the operation should start at the beginning of the movie or track.
duration

The duration, in movie timescale units, of the segment to be exported. To export the entire movie, or an entire track, pass in the value returned by GetMovieDuration or GetTrackDuration, minus the value passed in startTime, as described above.
canceled

A pointer to a Boolean value. Your component should set this value to TRUE if the user cancels the dialog box, otherwise FALSE. If the user cancels the dialog box, your component should revert to its settings as they were before executing this function.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled ){
printf("MovieExportDoUserDialog",ci,theMovie,onlyThisTrack,startTime,duration,*canceled);
};



/*DisposeMovieExportGetPropertyUPP

Disposes of a MovieExportGetPropertyUPP pointer.

void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP );
Parameters
userUPP

A MovieExportGetPropertyUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP ){
printf ("DisposeMovieExportGetPropertyUPP",userUPP);
};

/*DisposeMovieExportGetDataUPP

Disposes of a MovieExportGetDataUPP pointer.

void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP );
Parameters
userUPP

A MovieExportGetDataUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP ){
printf ("DisposeMovieExportGetDataUPP",userUPP);
};



/*MovieExportDisposeGetDataAndPropertiesProcs

Disposes of the memory associated with the procedures returned by MovieExportNewGetDataAndPropertiesProcs.

ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon ){
printf ("MovieExportDisposeGetDataAndPropertiesProcs",ci,getPropertyProc,getDataProc,refCon);
};

/*NewMovieExportGetPropertyUPP

Allocates a Universal Procedure Pointer for the MovieExportGetPropertyProc callback.

MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetPropertyProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine ){
printf ("NewMovieExportGetPropertyUPP",userRoutine);
};

/*NewMovieExportGetDataUPP

Allocates a Universal Procedure Pointer for the MovieExportGetDataProc callback.

MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine ){
printf ("NewMovieExportGetDataUPP",userRoutine);
};



/*MovieExportFromProceduresToDataRef

Exports data provided by MovieExportAddDataSource to a specified location.

ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

The data reference for the export operation.
dataRefType

The type identifier for the data reference specified by dataRef.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exports data provided by MovieExportAddDataSource to a location specified by dataRef and dataRefType. Typically dataRef contains a Macintosh file alias and dataRefType is set to rAliasType.
Special Considerations

Movie data export components that support export operations from procedures must set the canMovieExportFromProcedures flag in their component flags.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType ){
printf ("MovieExportFromProceduresToDataRef",ci,dataRef,dataRefType);
};

//work



/*MovieExportToFile

Exports data to a file, using a movie data export component.

ComponentResult MovieExportToFile (
   MovieExportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to the file that is to receive the converted movie data. This file's type value corresponds to your component's subtype value.
theMovie

The movie for this operation. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
onlyThisTrack

Identifies a track that is to be converted. This track identifier is supplied by the Movie Toolbox. If this parameter contains a track identifier, your component must convert only the specified track.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The requesting program or Movie Toolbox must create the destination file before calling this function. Furthermore, your component may not destroy any data in the destination file. If you cannot add data to the specified file, return an appropriate error. If your component can write data to a file, be sure to set the canMovieExportFiles flag in the componentFlags field of your component's ComponentDescription structure. Here is an example of using this function with a flattener component:// MovieExportToFile coding example
ComponentDescription desc;
Component flattener;
ComponentInstance qtvrExport =NIL;
desc.componentType =MovieExportType;
desc.componentSubType =MovieFileType;
desc.componentManufacturer =QTVRFlattenerType;
flattener =FindNextComponent(NIL, &desc);
if (flattener) qtvrExport =OpenComponent (flattener);
if (qtvrExport)
    MovieExportToFile (qtvrExport, &myFileSpec, myQTVRMovie, NIL, 0, 0);

Special Considerations

Your component must be prepared to perform this function at any time. You should not expect that any of your component's configuration functions will be called first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportToFile (
   MovieExportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration ){};



/*TCGetTimeCodeAtTime

Returns a track's timecode information corresponding to a specific media time.

HandlerError TCGetTimeCodeAtTime (
   MediaHandler      mh,
   TimeValue         mediaTime,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcdata,
   UserData          *srcRefH );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
mediaTime

A time value for which you want to retrieve timecode information. This time value is expressed in the media's time coordinate system.
frameNum

A pointer to a field that is to receive the current frame number. Set this field to NIL if you don't want to retrieve the frame number.
tcdef

A pointer to a TimeCodeDef structure. The media handler returns the movie's timecode definition information. Set this parameter to NIL if you don't want this information.
tcdata

A pointer to a TimeCodeRecord structure. The media handler returns the current time value. Set this parameter to NIL if you don't want this information.
srcRefH

A pointer to a field that is to receive a handle containing the source information as a UserDataRecord structure. It is your responsibility to dispose of this structure when you are done with it. Set this field to NIL if you don't want this information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetTimeCodeAtTime (
   MediaHandler      mh,
   TimeValue         mediaTime,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcdata,
   UserData          *srcRefH ){};


/*TCFrameNumberToTimeCode

Converts a frame number into its corresponding timecode time value.

HandlerError TCFrameNumberToTimeCode (
   MediaHandler      mh,
   long              frameNumber,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
frameNumber

The frame number that is to be converted.
tcdef

A pointer to the TimeCodeDef structure to use for the conversion.
tcrec

A pointer to the TimeCodeRecord structure that is to receive the time value.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCFrameNumberToTimeCode (
   MediaHandler      mh,
   long              frameNumber,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec ){};

/*TCTimeCodeToString

Converts a time value into a text string (HH:MM:SS:FF).

HandlerError TCTimeCodeToString (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   StringPtr         tcStr );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
tcdef

A pointer to the TimeCodeDef structure to use for the conversion.
tcrec

A pointer to the TimeCodeRecord structure to use for the conversion.
tcStr

A pointer to a text string that is to receive the converted time value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If the timecode uses the dropframe technique, the separators are semicolons (;) rather than colons (:).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCTimeCodeToString (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   StringPtr         tcStr ){};

/*TCSetTimeCodeFlags

Changes the flag that affects how the toolbox handles timecode information.

HandlerError TCSetTimeCodeFlags (
   MediaHandler    mh,
   long            flags,
   long            flagsMask );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
flags

The new flag value. See these constants: 
tcdfShowTimeCode
flagsMask

Specifies which of the flag values are to change. The media handler modifies only those flag values that correspond to bits that are set to 1 in this parameter. Use the flag values from the flags parameter. To turn off timecode display, set the tcdfShowTimeCode flag to 1 in the flagsMask parameter and to 0 in the flags parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCSetTimeCodeFlags (
   MediaHandler    mh,
   long            flags,
   long            flagsMask ){};



/*TCTimeCodeToFrameNumber

Converts a timecode time value into its corresponding frame number.

HandlerError TCTimeCodeToFrameNumber (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   long              *frameNumber );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
tcdef

A pointer to the TimeCodeDef structure to use for the conversion.
tcrec

A pointer to the TimeCodeRecord structure containing the time value to convert.
frameNumber

A pointer to a field that is to receive the frame number that corresponds to the time value in the tcrec parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCTimeCodeToFrameNumber (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   long              *frameNumber ){};




/*TCSetSourceRef

Changes the source information in the timecode media sample reference.

HandlerError TCSetSourceRef (
   MediaHandler                 mh,
   TimeCodeDescriptionHandle    tcdH,
   UserData                     srefH );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
tcdH

Specifies a handle containing the timecode media sample reference that is to be updated.
srefH

Specifies a handle to the source information to be placed in the sample reference as a UserDataRecord structure. It is your application's responsibility to dispose of this structure when you are done with it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCSetSourceRef (
   MediaHandler                 mh,
   TimeCodeDescriptionHandle    tcdH,
   UserData                     srefH ){};


/*TCGetDisplayOptions

Retrieves the text characteristics that apply to timecode information displayed in a movie.

HandlerError TCGetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
textOptions

A pointer to a TCTextOptions structure. This structure will receive font and style information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions ){};

/*DataHWrite

Writes data to its current data reference.

ComponentResult DataHWrite (
   DataHandler           dh,
   Ptr                   data,
   long                  offset,
   long                  size,
   DataHCompletionUPP    completion,
   long                  refCon );
Parameters
dh

Identifies the calling program's connection to your data handler component.
data

Specifies a pointer to the data to be written. Client programs should lock the memory area holding this data, allowing your component's DataHWrite function to move memory.
offset

The offset (in bytes) to the location in the current data reference at which to write the data.
size

The number of bytes to write.
completion

A pointer to a data-handler completion function, described in DataHCompletionProc. The client program must provide a completion routine for all asynchronous write requests. For synchronous requests, client programs should set this parameter to NIL. When your data handler finishes with the client program's write request, your component must call this routine even if the request fails. Your component should pass the reference constant that the client program provided with the refCon parameter.
refCon

A reference constant that your data handler component should provide to the data-handler completion function specified with the completion parameter. For synchronous operations, client programs should set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function provides both a synchronous and an asynchronous write interface. Synchronous write operations work like the DataHPutData function; the data handler component returns control to the client program only after it has serviced the write request. Asynchronous write operations allow client programs to queue write requests. Your data handler queues the request and immediately returns control to the calling program. After your component actually writes the data, it calls the client program's data-handler completion function.
Special Considerations

Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHWrite (
   DataHandler           dh,
   Ptr                   data,
   long                  offset,
   long                  size,
   DataHCompletionUPP    completion,
   long                  refCon ){};

/*DataCodecCompress

Compresses data using the specified compressor component.

ComponentResult DataCodecCompress (
   DataCodecComponent    dc,
   void                  *srcData,
   UInt32                srcSize,
   void                  *dstData,
   UInt32                dstBufferSize,
   UInt32                *actualDstSize,
   UInt32                *decompressSlop );
Parameters
dc

The compressor component to used.
srcData

A pointer to the data to be compressed.
srcSize

The size of the data to be compressed, in bytes.
dstData

A pointer to the buffer in which to store the compressed data.
dstBufferSize

The size of the buffer in which to store the compressed data, in bytes.
actualDstSize

The size of the compressed data that was created, in bytes.
decompressSlop

The number of bytes that should be added to the decompression buffer size if decompression occurs in place.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before calling this function, you should call DataCodecGetCompressBufferSize to obtain the maximum possible size of the compressed data that will be returned. You can then use this value as the value of the dstBufferSize parameter. Note that a buffer for compressed data that is the same size as the uncompressed data may not be large enough: in some cases, the size of the compressed data can be larger than the size of the decompressed data. When you compress data, you should store the size of data before compression at the beginning of the file, immediately before the compressed data. This allows you to obtain the size of the decompressed data and allocate the buffer for storing the decompressed data before calling DataCodecDecompress.
Special Considerations

You can compress sprites by calling this function. If you do, you must include the uncompressed size of the sample at the beginning of the sample, before the compressed data, and store the component subtype of the data compressor used to compress the sprite in the decompressorType field of the sample's SpriteDescription structure. You can also compress QuickDraw 3D media samples by calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataCodecCompress (
   DataCodecComponent    dc,
   void                  *srcData,
   UInt32                srcSize,
   void                  *dstData,
   UInt32                dstBufferSize,
   UInt32                *actualDstSize,
   UInt32                *decompressSlop ){};



/*DataHOpenForRead

Opens a data handler's current data reference for read-only access.

ComponentResult DataHOpenForRead (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After setting your component's current data reference by calling DataHSetDataRef, client programs call DataHOpenForRead to start reading from the data reference. Your component should open the data reference for read-only access. If the data reference is already open or cannot be opened, return an appropriate error code. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

Note that the Movie Toolbox may try to read data from a data reference without calling your component's DataHOpenForRead function. If this happens, your component should open the data reference for read-only access, respond to the read request, and then leave the data reference open in anticipation of later read requests. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHOpenForRead (
   DataHandler    dh ){};


/*DataHCloseForWrite

Closes write-only access to its data reference.

ComponentResult DataHCloseForWrite (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Data handlers provide two distinct write facilities: DataHPutData is a simple synchronous interface that allows applications to append data to the end of a container, and DataHWrite is a more capable, asynchronous write function that is suitable for movie capture operations. Before writing data to a data reference, applications must call your component's DataHOpenForWrite function to open a write path to the container. DataHCloseForWrite closes that write path. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

A client program may close its connection to your component (by calling CloseComponent) without closing the write path. If this happens, your component should close the data reference before closing the connection. Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHCloseForWrite (
   DataHandler    dh ){};



/*DisposeDataHCompletionUPP

Disposes of a DataHCompletionUPP pointer.

void DisposeDataHCompletionUPP (
   DataHCompletionUPP    userUPP );
Parameters
userUPP

A DataHCompletionUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeDataHCompletionUPP (
   DataHCompletionUPP    userUPP ){};



/*DataHCloseForRead

Closes read-only access to its data reference.

ComponentResult DataHCloseForRead (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Data handler components provide two basic read facilities: DataHGetData function is a fully synchronous read operation, while DataHScheduleData is asynchronous. Applications provide scheduling information when they call your component's DataHScheduleData function. When your component processes the queued request, it calls the application's data-handler completion function. Before any application can read data from a data reference, it must open read access to that reference by calling your component's DataHOpenForRead function. DataHCloseForRead closes that read access path.
Special Considerations

Note that a client program may close its connection to your component (by calling CloseComponent) without closing the read path. If this happens, your component should close the data reference before closing the connection.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHCloseForRead (
   DataHandler    dh ){};

/*DataHReadAsync

Undocumented

ComponentResult DataHReadAsync (
   DataHandler           dh,
   void                  *dataPtr,
   UInt32                dataSize,
   const wide            *dataOffset,
   DataHCompletionUPP    completion,
   long                  refCon );
Parameters
dh

A data handler component.
dataPtr

Undocumented
dataSize

Undocumented
dataOffset

Undocumented
completion

A pointer to a data-handler completion callback, described in DataHCompletionProc.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHReadAsync (
   DataHandler           dh,
   void                  *dataPtr,
   UInt32                dataSize,
   const wide            *dataOffset,
   DataHCompletionUPP    completion,
   long                  refCon ){};



/*DataHGetFileSize

Returns the size, in bytes, of the current data reference.

ComponentResult DataHGetFileSize (
   DataHandler    dh,
   long           *fileSize );
Parameters
dh

Identifies the calling program's connection to your data handler component.
fileSize

A pointer to a long integer. Your component returns the size of the container corresponding to the current data reference, in bytes.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is operationally equivalent to the Mac OS File Manager's GetEOF function. Before writing data to a data reference, applications must call your component's DataHOpenForWrite function to open a write path to the container. DataHCloseForWrite closes that write path. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHGetFileSize (
   DataHandler    dh,
   long           *fileSize ){};

/*DataHOpenForWrite

Opens your component's current data reference for write-only access.

ComponentResult DataHOpenForWrite (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After setting your component's current data reference by calling DataHSetDataRef, client programs call DataHOpenForWrite to start writing to the data reference. Your component should open the data reference for write-only access. If the data reference is already open or cannot be opened, return an appropriate error code. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHOpenForWrite (
   DataHandler    dh ){};

/*NewDataHCompletionUPP

Allocates a Universal Procedure Pointer for the DataHCompletionProc callback.

DataHCompletionUPP NewDataHCompletionUPP (
   DataHCompletionProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewDataHCompletionProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
DataHCompletionUPP NewDataHCompletionUPP (
   DataHCompletionProcPtr    userRoutine ){};



/*DataCodecGetCompressBufferSize

Returns the maximum possible size of the compressed data that will be returned using the specified compressor component.

ComponentResult DataCodecGetCompressBufferSize (
   DataCodecComponent    dc,
   UInt32                srcSize,
   UInt32                *dstSize );
Parameters
dc

The compressor component to used.
srcSize

The size in bytes of the data being compressed.
dstSize

A pointer to the maximum size of the compressed data that will be returned.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The actual size of the compressed data will likely be smaller than the size you initially have to allocate, so after you compress the data you should shrink the compressed data handle down to the actual data size. When compressing a movie, allocate an extra ten 32-bit integers of space to store the compressed movie resource header information, as shown in the following code sample:unsigned long compressedSize;
Handle compressedData;
DataCodecGetCompressBufferSize(dataCompressor, movieResourceSize, &compressedSize);
compressedData =NewHandle(compressedSize + (10 * sizeof(UInt32)));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataCodecGetCompressBufferSize (
   DataCodecComponent    dc,
   UInt32                srcSize,
   UInt32                *dstSize ){};



/*MovieImportGetSettingsAsAtomContainer

Retrieves the current settings from the movie import component.

ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the reference to the newly created atom container should be stored by the call.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the returned QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings ){};


/*MovieExportGetSettingsAsAtomContainer

Retrieves the current settings from the movie export component.

ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the newly-created atom container should be stored by the call. The caller is responsible for disposing of the returned QT atom container.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Applications can call this function to obtain a correctly formatted atom container to use with MovieExportSetSettingsFromAtomContainer. This might be done after a call to MovieExportDoUserDialog, for example, to apply the user-obtained settings to a series of exports.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings ){};


/*QTVideoOutputGetDisplayModeList

Returns a list of the display modes supported by a video output component.

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
outputs

A pointer to the QT atom container that lists the video modes supported by this component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After your software calls this function, it must dispose of the QT atom container returned by the function by calling QTDisposeAtomContainer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs ){};


/*VDIIDCGetFeatures

Places atoms in a QuickTime atom container that specify the current capabilities of a camera and the state of its IIDC features.

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container );
Parameters
ci

The component instance that identifies your connection to a video digitizer component. The digitizer's subtype must be vdSubtypeIIDC ('iidc').
container

Upon return, a pointer to a QuickTime atom container containing atoms of type vdIIDCAtomTypeFeature for each IIDC camera feature. If the camera has not implemented any IIDC features the container returns empty.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Discussion

The digitizer creates the container, and it is the responsibility of the client to ultimately delete it if the routine does not return an error. Since the values that this function retrieves might change underneath the client, they should not be cached but should be retrieved each time they are needed.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container ){};

/*QTVideoOutputSetClientName

Registers the name of an application or other software with an instance of a video output component.

ComponentResult QTVideoOutputSetClientName (
   QTVideoOutputComponent    vo,
   ConstStr255Param          str );
Parameters
vo

The instance of a video output component for the request. Your software obtains this reference when it calls OpenComponent or OpenDefaultComponent.
str

The name of the application or other software to be registered.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The name you specify with this function can later be used by QTVideoOutputGetCurrentClientName to specify which software has exclusive access to the video output device controlled by the component.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputSetClientName (
   QTVideoOutputComponent    vo,
   ConstStr255Param          str ){};


/*QTVideoOutputSetDisplayMode

Specifies the display mode to be used by a video output component.

ComponentResult QTVideoOutputSetDisplayMode (
   QTVideoOutputComponent    vo,
   long                      displayModeID );
Parameters
vo

The instance of a video output component for the request. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
displayModeID

The ID of the display mode to use. The ID specifies a QT atom of type kQTVODisplayModeItem in the QT atom container returned by QTVideoOutputGetDisplayModeList.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

When software changes the display mode with this function, the change does not take effect until the next time the software calls QTVideoOutputBegin for the video output component. This lets the software change other output settings before displaying the video.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputSetDisplayMode (
   QTVideoOutputComponent    vo,
   long                      displayModeID ){};




/*QTVideoOutputBegin

Obtains exclusive access to the video hardware controlled by a video output component.

ComponentResult QTVideoOutputBegin (
   QTVideoOutputComponent    vo );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error. If this function returns the videoOutputInUseErr result code that indicates that the video hardware is currently in use, your software can get the name of the application or other software that is using the hardware by calling QTVideoOutputGetCurrentClientName. You can then display an alert to the user that says that the video hardware is in use and specifies the name of the software using the video hardware.
Discussion

When your software calls this function, the video output component acquires exclusive access to the video hardware controlled by the specified video output component or returns the videoOutputInUseErr result code if the video hardware is currently in use. If the video hardware is available, the video output component also enables the display mode last set with QTVideoOutputSetDisplayMode and enables the video settings, if any, that were most recently specified by the user in a custom video configuration dialog box. If the video output component supports QTVideoOutputCustomConfigureDisplay, your software can call the function to display a custom video configuration dialog box. When your software no longer needs the video output component, release it by calling QTVideoOutputEnd.
Special Considerations

If your software needs to change the display mode, it must change it before calling this function. It cannot change the display mode between calls to this function and to QTVideoOutputEnd.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputBegin (
   QTVideoOutputComponent    vo ){};



/*QTVideoOutputGetGWorld

Returns a pointer to the graphics world used by a video output component.

ComponentResult QTVideoOutputGetGWorld (
   QTVideoOutputComponent    vo,
   GWorldPtr                 *gw );
Parameters
vo

The instance of a video output component for this request. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
gw

A pointer to the graphics world used by the video output component to display images.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If the pixel format of the graphics world is 1, 2, 4, 8, 16, or 32, your software can use either QuickDraw or QuickTime to draw graphics to it. If the graphics world has any other pixel format, your software must use QuickTime functions draw to it. Your software can pass the pointer returned by this function to the SetMovieGWorld, DecompressSequenceBegin, DecompressSequenceBeginS, DecompressImage, and FDecompressImage functions.

Your software can call QTVideoOutputGetGWorld only between calls to QTVideoOutputBegin and QTVideoOutputEnd. When your software calls QTVideoOutputEnd, the video output component automatically disposes of the graphics world. If your software needs to use the graphics world after calling QTVideoOutputEnd, it must call this function again after the next time it calls QTVideoOutputBegin.
Special Considerations

Your software must not dispose of the graphics world used by a video output component. The video output component automatically disposes of the graphics world when your software calls QTVideoOutputEnd.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputGetGWorld (
   QTVideoOutputComponent    vo,
   GWorldPtr                 *gw ){};


/*QTVideoOutputEnd

Releases access to the video hardware controlled by a video output component.

ComponentResult QTVideoOutputEnd (
   QTVideoOutputComponent    vo );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your software should release access to a video output component as soon as it is done using the video hardware controlled by the component. If you close the instance of a video output component that currently has exclusive access to video hardware, the video output component automatically calls this function to release the hardware.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputEnd (
   QTVideoOutputComponent    vo ){};


/*SCGetCompressionExtended

Undocumented

ComponentResult SCGetCompressionExtended (
   ComponentInstance    ci,
   SCParams             *params,
   Point                where,
   SCModalFilterUPP     filterProc,
   SCModalHookUPP       hookProc,
   long                 refcon,
   StringPtr            customName );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
params

A pointer to an SCParams structure.
where

Undocumented
filterProc

A Universal Procedure Pointer that accesses a SCModalFilterProc callback.
hookProc

A Universal Procedure Pointer that accesses a SCModalHookProc callback.
refcon

A reference constant to be passed to your callbacks. Use this parameter to point to a data structure containing any information your callbacks need.
customName

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetCompressionExtended (
   ComponentInstance    ci,
   SCParams             *params,
   Point                where,
   SCModalFilterUPP     filterProc,
   SCModalHookUPP       hookProc,
   long                 refcon,
   StringPtr            customName ){};


/*SGSetChannelOutput

Assigns an output to a channel.

ComponentResult SGSetChannelOutput (
   SeqGrabComponent    s,
   SGChannel           c,
   SGOutput            sgOut );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sgOut

Identifies the sequence grabber output for this operation. You obtain this identifier by calling SGNewOutput.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to assign an output to a channel. One output may be assigned to one or more channels. Note that when you call SGSetDataRef or SGSetDataOutput the sequence grabber component sets every channel to the specified file or container. If you want to use different outputs, you must use this function to assign the channels appropriately.
Version Notes

A sequence grabber output ties a sequence grabber channel to a specified data reference for the output of captured data. If you are capturing to a single movie file, you can continue to use SGSetDataOutput or SGSetDataRef to specify the sequence grabber's destination. However, if you want to capture movie data into several different files or data references, you must use sequence grabber outputs to do so. Even if you are using outputs, you must still use SGSetDataOutput or SGSetDataRef to identify where the sequence grabber should create the movie resource. You are responsible for creating outputs, assigning them to sequence grabber channels, and disposing of them when you are done.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelOutput (
   SeqGrabComponent    s,
   SGChannel           c,
   SGOutput            sgOut ){};

/*VDSetBlackLevelValue

Sets the current black level value.

VideoDigitizerError VDSetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
blackLevel

A pointer to an integer that contains the new black level value. Black level values range from 0 to 65,535, where 0 represents the maximum black value and 65,535 represents the minimum black value. The digitizer component returns the new value, so that the application can avoid using unsupported values in future requests.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDSetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel ){};


/*VDGetBlackLevelValue

Returns the current black level value.

VideoDigitizerError VDGetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
blackLevel

A pointer to an integer field that is to receive the current black level value. Black level values range from 0 to 65,535, where 0 represents the maximum black value and 65,535 represents the minimum black value.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel ){};

/*SCGetInfo

Retrieves configuration information from the standard dialog component.

ComponentResult SCGetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
infoType

A constant (see below) that specifies the type of information you want to retrieve. See these constants: 
scSpatialSettingsType
scTemporalSettingsType
scDataRateSettingsType
scColorTableType
scProgressProcType
scExtendedProcsType
scPreferenceFlagsType
scSettingsStateType
scSequenceIDType
scWindowPositionType
scCodecFlagsType
info

A pointer to a field that is to receive the information. The infoType constant descriptions (see below) include information about this field.
Return Value

See Error Codes. If the component cannot satisfy your request, it returns a result code of scTypeNotFoundErr. It returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info ){};

/*MovieExportSetSettingsFromAtomContainer

Sets the movie export component's current configuration from passed settings data.

ComponentResult MovieExportSetSettingsFromAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         settings );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

A QT atom container that contains the settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The atom container may contain atoms other than those expected by the particular component type or may be missing certain atoms. This function uses only those settings it understands.

Here is sample code that overrides compression settings:// MovieExportSetSettingsFromAtomContainer coding example
ComponentInstance sc;
QTAtomContainer compressorData;
SCSpatialSettings ss;
sc =OpenDefaultComponent(StandardCompressionType,
                             StandardCompressionSubType);
ss.codecType =kCinepakCodecType;
ss.codec =NIL;
ss.depth =0;
ss.spatialQuality =codecHighQuality
err =SCSetInfo(sc, scSpatialSettingsType, &ss);
err =SCGetSettingsAsAtomContainer(sc, &compressorData);
MovieExportSetSettingsFromAtomContainer (qtvrExport, compressorData);

Special Considerations

Some movie export components treat sample descriptions as part of their settings. If your application attempts to set the sample description using MovieExportSetSampleDescription, and receives the badComponentSelector error, you may need to pass in the SampleDescription structure using this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetSettingsFromAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         settings ){};


/*SCPositionDialog

Helps position a dialog box on the screen.

ComponentResult SCPositionDialog (
   ComponentInstance    ci,
   short                id,
   Point                *where );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
id

The resource number of a 'DLOG' resource. The function positions the dialog box that corresponds to this resource.
where

A pointer to a Point structure identifying the desired location of the upper-left corner of the dialog box in global coordinates. This parameter allows you to indicate how you want to position the dialog box on the screen.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/


ComponentResult SCPositionDialog (
   ComponentInstance    ci,
   short                id,
   Point                *where ){};

/*NewSCModalHookUPP

Allocates a Universal Procedure Pointer for the SCModalHookProc callback.

SCModalHookUPP NewSCModalHookUPP (
   SCModalHookProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSCModalHookProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/


SCModalHookUPP NewSCModalHookUPP (
   SCModalHookProcPtr    userRoutine ){};



/*SCGetSettingsAsAtomContainer

Places the current configuration from the standard image-compression component in a QT atom container.

ComponentResult SCGetSettingsAsAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      *settings );
Parameters
ci

The standard compression component instance.
settings

The address where the newly-created atom container should be stored.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the returned QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetSettingsAsAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      *settings ){};

/*SCSetSettingsFromAtomContainer

Sets the standard image-compression component's current configuration from data in a QT atom container.

ComponentResult SCSetSettingsFromAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      settings );
Parameters
ci

Standard compression component instance.
settings

A QT atom container reference to the settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The settings QT atom container may contain atoms other than those expected by the particular component type or may be missing certain atoms. The function will only use settings it understands.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCSetSettingsFromAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      settings ){};

/*MovieImportFile

Imports data from a file, using a movie data import component.

ComponentResult MovieImportFile (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to the file that contains the data that is to be imported into the movie. This file's type value corresponds to your component's subtype value.
theMovie

The movie for this operation. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to add sample data to the target movie or to obtain information about the movie.
targetTrack

The track that is to receive the imported data. This track identifier is supplied by the Movie Toolbox and is valid only if the movieImportMustUseTrack flag in the inFlags parameter is set to 1.
usedTrack

A pointer to the track that received the imported data. Your component returns this track identifier to the Movie Toolbox. Your component needs to set this parameter only if you operate on a single track or if you create a new track. If you modify more than one track, leave the field referred to by this parameter unchanged.
atTime

The time corresponding to the location where your component is to place the imported data. This time value is expressed in the movie's time coordinate system.
addedDuration

A pointer to the duration of the data that your component added to the movie. Your component must specify this value in the movie's time coordinate system.
inFlags

Flags (see below) that specify control information governing the import operation. See these constants: 
movieImportCreateTrack
movieImportMustUseTrack
movieImportInParallel
outFlags

Flags (see below) that identify a field that is to receive status information about the import operation. Your component sets the appropriate flags in this field when the operation is complete. See these constants: 
movieImportResultUsedMultipleTracks
movieImportInParallel
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component must be prepared to perform this function at any time. You should not expect that any of your component's configuration functions will be called first. If your component can accept data from a file, be sure to set the canMovieImportFiles flag in the componentFlags field of your component's ComponentDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult MovieImportFile (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags ){};




/*SCSetInfo

Modifies the standard dialog component's configuration information.

ComponentResult SCSetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
infoType

A constant (see below) that specifies the type of information you want to set. See these constants: 
scSpatialSettingsType
scTemporalSettingsType
scDataRateSettingsType
scColorTableType
scProgressProcType
scExtendedProcsType
scPreferenceFlagsType
scSettingsStateType
scSequenceIDType
scWindowPositionType
scCodecFlagsType
info

A pointer to a field that contains the new information. The infoType constant descriptions (see below) include information about this field.
Return Value

See Error Codes. If the component cannot satisfy your request, it returns a result code of scTypeNotFoundErr. It returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCSetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info ){};


/*SCSetTestImagePixMap

Sets the dialog box's test image from a Picture structure that is stored in a PixMap structure.

ComponentResult SCSetTestImagePixMap (
   ComponentInstance    ci,
   PixMapHandle         testPixMap,
   Rect                 *testRect,
   short                testFlags );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
testPixMap

A handle to a PixMap structure that contains the new test image. Your application is responsible for creating this structure before calling the function. You must also dispose of the structure when you are done with it. You must clear the image or close your connection to the standard image-compression dialog component before you dispose of the structure.
testRect

A pointer to a Rect structure. This rectangle specifies, in the coordinate system of the source image, the area of interest or point of interest in the test image. The area of interest defines a portion of the test image that is to be shown to the user in the dialog box. Use this parameter to direct the component to a specific portion of the test image. The component uses the value of the testFlags parameter to determine how it transforms large images before displaying them to the user.
testFlags

Constants (see below) that specify how the component is to display a test image that is larger than the test image portion of the dialog box. If you set this parameter to 0, the component uses a default method of its own choosing. In all cases, the component centers the area or point of interest in the test image portion of the dialog box, and then displays some part of the test image. See these constants: 
scPreferCropping
scPreferScaling
scPreferScalingAndCropping
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCSetTestImagePixMap (
   ComponentInstance    ci,
   PixMapHandle         testPixMap,
   Rect                 *testRect,
   short                testFlags ){};



/*SCDefaultPixMapSettings

Derives default compression settings for an image that is stored in a pixel map.

ComponentResult SCDefaultPixMapSettings (
   ComponentInstance    ci,
   PixMapHandle         src,
   short                motion );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be analyzed.
motion

Specifies whether the image is part of a sequence. Set this parameter to TRUE if the image is part of a sequence; set it to FALSE if you are working with a single still image.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCDefaultPixMapSettings (
   ComponentInstance    ci,
   PixMapHandle         src,
   short                motion ){};



/*SCRequestSequenceSettings

Displays the standard sequence dialog box to the user and shows default settings you have established.

ComponentResult SCRequestSequenceSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use SCRequestSequenceSettings to retrieve the user's preferences for compressing an image sequence; use SCRequestImageSettings when you are working with a single image. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestSequenceSettings (
   ComponentInstance    ci ){};


/*SCPositionRect

Positions a rectangle on the screen.

ComponentResult SCPositionRect (
   ComponentInstance    ci,
   Rect                 *rp,
   Point                *where );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
rp

A pointer to a Rect structure. When you call the function, this structure should contain the rectangle's current global coordinates. The function adjusts the coordinates in the structure to reflect the rectangle's new position.
where

A pointer to a Point structure identifying the desired location of the upper-left corner of the rectangle in global coordinates. This parameter allows your application to position the rectangle on the screen.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCPositionRect (
   ComponentInstance    ci,
   Rect                 *rp,
   Point                *where ){};


/*NewSGGrabCompressCompleteBottleUPP

Allocates a Universal Procedure Pointer for the SGGrabCompressCompleteBottleProc callback.

SGGrabCompressCompleteBottleUPP NewSGGrabCompressCompleteBottleUPP (
   SGGrabCompressCompleteBottleProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGGrabCompressCompleteBottleProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SGGrabCompressCompleteBottleUPP NewSGGrabCompressCompleteBottleUPP (
   SGGrabCompressCompleteBottleProcPtr    userRoutine ){};



/*SGSetVideoBottlenecks

Assigns callback functions to a video channel.

ComponentResult SGSetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );
Parameters
c

The connection identifier for the video channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
vb

A pointer to a VideoBottles structure, which identifies the callback functions to be assigned to the video channel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb ){};




/*SGSetFrameRate

Specifies a video channel's frame rate for recording.

ComponentResult SGSetFrameRate (
   SGChannel    c,
   Fixed        frameRate );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
frameRate

The desired frame rate. If this parameter is set to 0, use your channel's default frame rate. Typically, this corresponds to the fastest rate that your channel can support.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetFrameRate (
   SGChannel    c,
   Fixed        frameRate ){};

/*SGGetChannelTimeBase

Retrieves a reference to the time base that is being used by a sequence grabber channel.

ComponentResult SGGetChannelTimeBase (
   SGChannel    c,
   TimeBase     *tb );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
tb

A pointer to a time base identifier, such as that returned by NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelTimeBase (
   SGChannel    c,
   TimeBase     *tb ){};


/*NewSGDataUPP

Allocates a Universal Procedure Pointer for the SGDataProc callback.

SGDataUPP NewSGDataUPP (
   SGDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SGDataUPP NewSGDataUPP (
   SGDataProcPtr    userRoutine ){};



/*SGGetVideoBottlenecks

Determines the callback functions that have been assigned to a video channel.

ComponentResult SGGetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
vb

A pointer to a VideoBottles structure. This function sets the fields of that structure to indicate the callback functions that have been assigned to this video channel. You must set the procCount field in the VideoBottles structure to 9.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb ){};



/*SGSetVideoRect

Specifies a part of the source video image that is to be captured by a sequence grabber component.

ComponentResult SGSetVideoRect (
   SGChannel     c,
   const Rect    *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to the Rect structure that defines the portion of the source video image to be captured. This rectangle must lie within the boundaries of the source video boundary rectangle, which the sequence grabber can obtain by calling SGGetSrcVideoBounds. If you do not use this function to set a source rectangle, the sequence grabber component captures the entire video image, as defined by the source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetVideoRect (
   SGChannel     c,
   const Rect    *r ){};


/*SGGetAlignmentProc

Obtains information about the best screen positions for a sequence grabber's video image in terms of appearance and maximum performance.

ComponentResult SGGetAlignmentProc (
   SeqGrabComponent             s,
   ICMAlignmentProcRecordPtr    alignmentProc );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
alignmentProc

A pointer to an ICMAlignmentProcRecord structure. The sequence grabber places its alignment information into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetAlignmentProc (
   SeqGrabComponent             s,
   ICMAlignmentProcRecordPtr    alignmentProc ){};



/*SGGetVideoDigitizerComponent

Determines the video digitizer component that is providing source video to a video channel component.

ComponentInstance SGGetVideoDigitizerComponent (
   SGChannel    c );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
Return Value

A component instance that identifies the connection between your video channel component and its video digitizer component. If your video channel component does not use a video digitizer component, set this returned value to NIL.
Discussion

This function allows the sequence grabber component to determine the video digitizer component that is providing source video to your video channel component. For example, the sequence grabber component can use this function to obtain access to the video digitizer component so that the grabber component can set the digitizer's parameters.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentInstance SGGetVideoDigitizerComponent (
   SGChannel    c ){};



/*SGGetTimeBase

Retrieves a reference to the time base that is being used by a sequence grabber component.

ComponentResult SGGetTimeBase (
   SeqGrabComponent    s,
   TimeBase            *tb );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
tb

A pointer to a time base identifier, such as that returned by NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetTimeBase (
   SeqGrabComponent    s,
   TimeBase            *tb ){};



/*SGGrabCompressComplete

Provides the default behavior for your grab-compress-complete function.

ComponentResult SGGrabCompressComplete (
   SGChannel         c,
   UInt8             *queuedFrameCount,
   SGCompressInfo    *ci,
   TimeRecord        *tr );
Parameters
c

The connection identifier for the channel for this operation. The sequence grabber provides this value to your grab-compress-complete function.
queuedFrameCount

A pointer to the number of queued frames yet to be done. 0 means no frames. Some VDIGs may return 2 even if more than 2 frames are available, and some will return 1 if any number more than 0 are available.
ci

A pointer to an SGCompressInfo structure. When the operation is complete, the function fills in this structure with information about the compression operation.
tr

A pointer to a TimeRecord structure. When the operation is complete, the function uses this structure to indicate when the frame was grabbed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By setting the SGGrabCompressCompleteBottleProc callback and calling this function, your application can determine how many frames are currently queued in the VDIG, which can be useful for real-time processing.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGrabCompressComplete (
   SGChannel         c,
   UInt8             *queuedFrameCount,
   SGCompressInfo    *ci,
   TimeRecord        *tr ){};




/*SCCompressSequenceBegin

Initiates a sequence-compression operation.

ComponentResult SCCompressSequenceBegin (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed. This pixel map must contain the first image in the sequence.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire structure, set this parameter to NIL.
desc

A pointer to an image description handle. The standard dialog component creates an image description structure when it compresses the image, and returns a handle to that structure in the field referred to by this parameter. The component sizes the handle appropriately. If you do not want this information, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCCompressSequenceBegin (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc ){};




/*SCCompressSequenceFrame

Continues a sequence-compression operation.

ComponentResult SCCompressSequenceFrame (
   ComponentInstance    ci,
   PixMapHandle         src,
   const Rect           *srcRect,
   Handle               *data,
   long                 *dataSize,
   short                *notSyncFlag );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire pixel map, set this parameter to NIL.
data

A pointer to a handle. The standard compression component returns a handle to the compressed image data in the field referred to by this parameter. The component sizes that handle appropriately for the sequence.
dataSize

A pointer to a long integer. The standard compression component returns a value that indicates the number of bytes of compressed image data that it returns. Note that this value will differ from the size of the handle referred to by the data parameter, because the handle is allocated to accommodate the largest image in the sequence.
notSyncFlag

A pointer to a short integer that indicates whether the compressed frame is a key frame. If the frame is a key frame, the standard compression component sets the field referred to by this parameter to 0; otherwise, the component sets this field to mediaSampleNotSync. You may use this field to set the sampleFlags parameter of the AddMediaSample function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function once for each frame in the sequence, including the first frame.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCCompressSequenceFrame (
   ComponentInstance    ci,
   PixMapHandle         src,
   const Rect           *srcRect,
   Handle               *data,
   long                 *dataSize,
   short                *notSyncFlag ){};


/*SCCompressSequenceEnd

Ends a sequence-compression operation.

ComponentResult SCCompressSequenceEnd (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The standard dialog component disposes of any memory it used to compress the image sequence, including the data and image description buffers. You must call this function once for each sequence you start.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressSequenceEnd (
   ComponentInstance    ci ){};



/*SCDefaultPictFileSettings

Derives default compression settings for a Picture structure that is stored in a file.

ComponentResult SCDefaultPictFileSettings (
   ComponentInstance    ci,
   short                srcRef,
   short                motion );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
srcRef

A reference to the file to be analyzed.
motion

Specifies whether the image is part of a sequence. Set this parameter to TRUE if the image is part of a sequence; set it to FALSE if you are working with a single still image.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCDefaultPictFileSettings (
   ComponentInstance    ci,
   short                srcRef,
   short                motion ){};


/*SCSetTestImagePictFile

Sets the dialog box's test image from a Picture structure that is stored in a picture file.

ComponentResult SCSetTestImagePictFile (
   ComponentInstance    ci,
   short                testFileRef,
   Rect                 *testRect,
   short                testFlags );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
testFileRef

Identifies the file that contains the new test image. Your application is responsible for opening this file before calling this function. You must also close the file when you are done with it. You must clear the image or close your connection to the standard image-compression dialog component before you close the file. If the file contains a large image, the component may take some time to display the standard image-compression dialog box. In this case, the component displays the watch cursor while it loads the test image.
testRect

A pointer to a Rect structure. This rectangle specifies, in the coordinate system of the source image, the area of interest or point of interest in the test image. The area of interest defines a portion of the test image that is to be shown to the user in the dialog box. Use this parameter to direct the component to a specific portion of the test image. The component uses the value of the testFlags parameter to determine how it transforms large images before displaying them to the user.
testFlags

Constants (see below) that specify how the component is to display a test image that is larger than the test image portion of the dialog box. If you set this parameter to 0, the component uses a default method of its own choosing. In all cases, the component centers the area or point of interest in the test image portion of the dialog box, and then displays some part of the test image. See these constants: 
scPreferCropping
scPreferScaling
scPreferScalingAndCropping
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCSetTestImagePictFile (
   ComponentInstance    ci,
   short                testFileRef,
   Rect                 *testRect,
   short                testFlags ){};


/*XMLParseDataRef

Undocumented

ComponentResult XMLParseDataRef (
   ComponentInstance    aParser,
   Handle               dataRef,
   OSType               dataRefType,
   long                 parseFlags,
   XMLDoc               *document );
Parameters
aParser

Undocumented
dataRef

Undocumented
dataRefType

Undocumented
parseFlags

Undocumented
document

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseDataRef (
   ComponentInstance    aParser,
   Handle               dataRef,
   OSType               dataRefType,
   long                 parseFlags,
   XMLDoc               *document ){};



/*DataHSetDataRefWithAnchor

Sets the data reference and anchor data reference for a data handler.

ComponentResult DataHSetDataRefWithAnchor (
   DataHandler    dh,
   Handle         anchorDataRef,
   OSType         dataRefType,
   Handle         dataRef );
Parameters
dh

A data handler component.
anchorDataRef

A handle to the anchor data reference.
dataRefType

The type of the data reference. Different types of containers may require different types of data references. For example, a reference to a memory-based movie may be a handle, while a reference to a file-based movie may be an alias. Apple's memory-based data handler for the Macintosh uses handles (and has a subtype value of 'hndl'), while the HFS data handler uses Alias Manager aliases (its subtype value is 'alis'). See Data References.
dataRef

A data reference handle. Your component should make a copy of its current data reference in a handle and return that handle in this field. The client program is responsible for disposing of that handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHSetDataRefWithAnchor (
   DataHandler    dh,
   Handle         anchorDataRef,
   OSType         dataRefType,
   Handle         dataRef ){};



/*DataHGetDataRefAsType

Retrieves a data handler component's current data reference of a given type.

ComponentResult DataHGetDataRefAsType (
   DataHandler    dh,
   OSType         requestedType,
   Handle         *dataRef );
Parameters
dh

A data handler component.
requestedType

The type of the data reference to retrieve; see Data References.
dataRef

A pointer to a data reference handle. Your component should make a copy of its current data reference in a handle and return that handle in this field. The client program is responsible for disposing of that handle. Different types of containers may require different types of data references. For example, a reference to a memory-based movie may be a handle, while a reference to a file-based movie may be an alias. Apple's memory-based data handler for the Macintosh uses handles (and has a subtype value of 'hndl'), while the HFS data handler uses Alias Manager aliases (its subtype value is 'alis'). See Data References.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHGetDataRefAsType (
   DataHandler    dh,
   OSType         requestedType,
   Handle         *dataRef ){};


/*XMLParseAddElement

Undocumented

ComponentResult XMLParseAddElement (
   ComponentInstance    aParser,
   char                 *elementName,
   UInt32               nameSpaceID,
   UInt32               *elementID,
   long                 elementFlags );
Parameters
aParser

Undocumented
elementName

Undocumented
nameSpaceID

Undocumented
elementID

Undocumented
elementFlags

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult XMLParseAddElement (
   ComponentInstance    aParser,
   char                 *elementName,
   UInt32               nameSpaceID,
   UInt32               *elementID,
   long                 elementFlags ){};



/*XMLParseAddAttributeAndValue

Undocumented

ComponentResult XMLParseAddAttributeAndValue (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID,
   UInt32               attributeValueKind,
   void                 *attributeValueKindInfo );
Parameters
aParser

Undocumented
elementID

Undocumented
nameSpaceID

Undocumented
attributeName

Undocumented
attributeID

Undocumented
attributeValueKind

Undocumented
attributeValueKindInfo

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseAddAttributeAndValue (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID,
   UInt32               attributeValueKind,
   void                 *attributeValueKindInfo ){};

/*XMLParseAddAttribute

Undocumented

ComponentResult XMLParseAddAttribute (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID );
Parameters
aParser

Undocumented
elementID

Undocumented
nameSpaceID

Undocumented
attributeName

Undocumented
attributeID

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseAddAttribute (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID ){};



/*XMLParseDisposeXMLDoc

Undocumented

ComponentResult XMLParseDisposeXMLDoc (
   ComponentInstance    aParser,
   XMLDoc               document );
Parameters
aParser

Undocumented
document

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseDisposeXMLDoc (
   ComponentInstance    aParser,
   XMLDoc               document ){};

/*MovieImportDataRef

Undocumented

ComponentResult MovieImportDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags );
Parameters
ci

A movie import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

The data reference to the data to be imported.
dataRefType

The type of data reference in the dataRef parameter.
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
targetTrack

Undocumented
usedTrack

Undocumented
atTime

Undocumented
addedDuration

Undocumented
inFlags

Flags (see below) that control the behavior of this function. See these constants: 
movieImportCreateTrack
movieImportInParallel
movieImportMustUseTrack
movieImportWithIdle
outFlags

Flags (see below) that this function sets on return. See these constants: 
movieImportResultUsedMultipleTracks
movieImportResultNeedIdles
movieImportResultComplete
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags ){};

/*NewSCModalFilterUPP

Allocates a Universal Procedure Pointer for the SCModalFilterProc callback.

SCModalFilterUPP NewSCModalFilterUPP (
   SCModalFilterProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSCModalFilterProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SCModalFilterUPP NewSCModalFilterUPP (
   SCModalFilterProcPtr    userRoutine ){};

/*SCCompressImage

Compresses an image that is stored in a PixMap structure.

ComponentResult SCCompressImage (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc,
   Handle                    *data );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire pixel map, set this parameter to NIL.
desc

A pointer to a handle to an ImageDescription structure. The standard dialog component creates an ImageDescription structure when it compresses the image, and returns a handle to that structure in the field referred to by this parameter. The component sizes that handle appropriately. Your application is responsible for disposing of that handle when you are done with it.
data

A pointer to a handle. The standard dialog component returns a handle to the compressed image data in the field referred to by this parameter. The component sizes that handle appropriately. Your application is responsible for disposing of that handle when you are done with it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressImage (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc,
   Handle                    *data ){};

/*DataHSetDataRef

Assigns a data reference to your data handler component.

ComponentResult DataHSetDataRef (
   DataHandler    dh,
   Handle         dataRef );
Parameters
dh

Identifies the calling program's connection to your data handler component.
dataRef

The data reference. This parameter contains a handle to the information that identifies the container in question. Different types of containers may require different types of data references. For example, a reference to a memory-based movie may be a handle, while a reference to a file-based movie may be an alias. For example, Apple's memory-based data handler for the Macintosh uses handles (and has a subtype value of 'hndl'), while the HFS data handler uses Alias Manager aliases (its subtype value is 'alis'). The client program is responsible for disposing of the handle, so your component must make a copy of it. See Data References.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows your application to assign your data handler's current data reference. All data handler components use data references to identify and locate a movie's container. Client programs can correlate data references with data handlers by matching the component's subtype value with the data reference type; the subtype value indicates the type of data reference the component supports. All data handlers with the same subtype value must support the same data reference type.
Special Considerations

Note that the type of data reference always corresponds to the type that your component supports, and that you specify in the component subtype value of your data handler. As a result, the client program does not provide a data reference type value (unlike the Movie Toolbox's data reference functions).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHSetDataRef (
   DataHandler    dh,
   Handle         dataRef ){};

/*MovieExportSetProgressProc

Assigns a movie progress function.

ComponentResult MovieExportSetProgressProc (
   MovieExportComponent    ci,
   MovieProgressUPP        proc,
   long                    refcon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
proc

A pointer to the application's MovieProgressProc callback. If this parameter is set to NIL, the application is removing its progress function. In this case, your component should stop calling the progress function.
refcon

A reference constant. Your component should pass this constant back to the application's progress function whenever you call that function. Use this parameter to point to a data structure containing any information the callback needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

These progress functions must support the same interface as Movie Toolbox progress functions. Note that this interface not only allows you to report progress to the application, but also allows the application to cancel the request.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetProgressProc (
   MovieExportComponent    ci,
   MovieProgressUPP        proc,
   long                    refcon ){};


/*MovieExportToDataRef

Allows an application to request that data be exported to a data reference instead of to a file.

ComponentResult MovieExportToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

A handle to a data reference indicating where the data should be stored.
dataRefType

The type of the data reference. For exporting to a file, the dataRef is a Macintosh file alias and the dataRefType is rAliasType.
theMovie

The movie for this operation. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
onlyThisTrack

Identifies a track that is to be converted. This track identifier is supplied by the Movie Toolbox. If this parameter contains a track identifier, your component must convert only the specified track.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration ){};

/*QTVideoOutputGetIndSoundOutput

Determines which sound output components are associated with the video output component.

ComponentResult QTVideoOutputGetIndSoundOutput (
   QTVideoOutputComponent    vo,
   long                      index,
   Component                 *outputComponent );
Parameters
vo

The instance of a video output component for this request. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
index

Specifies which of the sound output components to return. The index of the first component is 1.
outputComponent

A pointer to a sound output component associated with the video output component that is specified by the index parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your software can display sound output components returned by this function in a dialog box and let the user choose which outputs to use for movie playback.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputGetIndSoundOutput (
   QTVideoOutputComponent    vo,
   long                      index,
   Component                 *outputComponent ){
printf ("QTVideoOutputGetIndSoundOutput",vo,index,*outputComponent);
};


/*QTVideoOutputGetClock

Returns a pointer to the clock component associated with the video output component.

ComponentResult QTVideoOutputGetClock (
   QTVideoOutputComponent    vo,
   ComponentInstance         *clock );
Parameters
vo

The instance of a video output component for this request. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
clock

A pointer to the clock component associated with the video output component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your software can use the clock component returned by this function to synchronize video and sound for a movie to the rate of the display. To associate the instance of the clock component with a movie, call SetMovieMasterClock. Because a change to the display mode could affect a clock component, your software should call this function only between calls to QTVideoOutputBegin and QTVideoOutputEnd, when it is not possible to change the display mode.
Special Considerations

When your software calls QTVideoOutputEnd, the video output component disposes of the instance of the clock component returned by this function. Because of this, software that uses the clock to control a movie must reset the clock for the movie to the default clock, by calling SetMovieMasterClock with NIL as the value of the clock component, before calling QTVideoOutputEnd.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputGetClock (
   QTVideoOutputComponent    vo,
   ComponentInstance         *clock ){
printf ("QTVideoOutputGetClock",vo,*clock);
};




/*QTVideoOutputSetEchoPort

Specifies a window on the desktop in which to display video sent to the device.

ComponentResult QTVideoOutputSetEchoPort (
   QTVideoOutputComponent    vo,
   CGrafPtr                  echoPort );
Parameters
vo

The instance of a video output component for this request. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
echoPort

The window on the computer's desktop in which to display the video.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

When your software sends video to the window you specify, the video is both displayed in the window and sent to the normal output of the video output device. When an output device can display video both on an external video display and in a window on a computer's desktop, the video displayed on the desktop is often at a smaller size and/or lower frame rate.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputSetEchoPort (
   QTVideoOutputComponent    vo,
   CGrafPtr                  echoPort ){
printf ("QTVideoOutputSetEchoPort ",vo,echoPort);
};


/*MovieImportSetMediaDataRef

Specifies a storage location that is to receive imported movie data.

ComponentResult MovieImportSetMediaDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
dataRef

A data reference that specifies a storage location that receives the imported data.
dataRefType

The type of the data reference.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Discussion

By calling this function you can specify a storage location that receives some imported movie data.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportSetMediaDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType ){};


/*MovieImportValidateDataRef

Validates the data file indicated by the data reference.

ComponentResult MovieImportValidateDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   UInt8                   *valid );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

The data reference to the file to be validated.
dataRefType

The type of data reference for the dataRef parameter.
valid

A pointer to a UInt8 value. If the data or file cannot be imported, the value returned should be 0. Otherwise, it should be set to 128.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Movie import components can implement this function to allow applications to determine if a given file referenced by a data reference is acceptable for a particular import component. The data reference can refer to any data for which there is a suitable data handler component installed and available to QuickTime. As this function may be called on many files, the validation process should be as fast as possible. Furthermore, the importer should probably limit the amount of reading it performs, especially when the data handler refers to data on the Internet.
Special Considerations

Unlike MovieImportValidate, the valid parameter for this function is a value that can be interpreted as the degree to which the importer can interpret the file's contents. In all cases, returning 0 indicates the file cannot be interpreted by the importer. However, other non-zero values can be used to determine the relative weighting between multiple importers that can import a particular kind of file. For now, it is best to return either 0 or 128 only.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportValidateDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   UInt8                   *valid ){};



/*DataHScheduleData

Reads data from its current data reference, which can be a synchronous read operation or an asynchronous read operation.

ComponentResult DataHScheduleData (
   DataHandler           dh,
   Ptr                   PlaceToPutDataPtr,
   long                  FileOffset,
   long                  DataSize,
   long                  RefCon,
   DataHSchedulePtr      scheduleRec,
   DataHCompletionUPP    CompletionRtn );
Parameters
dh

Identifies the calling program's connection to your data handler component.
PlaceToPutDataPtr

The location in memory that is to receive the data.
FileOffset

The offset in the data reference from which your component is to read.
DataSize

The number of bytes to read.
RefCon

A reference constant that your data handler component should provide to the data-handler completion function specified with the CompletionRtn parameter.
scheduleRec

A pointer to a DataHScheduleRecord. If this parameter is set to NIL, then the client program is requesting a synchronous read operation (that is, your data handler must return the data before returning control to the client program). If this parameter is not set to NIL, it must contain the location of a schedule record that has timing information for an asynchronous read request. Your data handler should return control to the client program immediately, and then call the client's data-handler completion function when the data is ready.
CompletionRtn

A pointer to a data handler completion function, described in DataHCompletionProc. The client program must provide a completion routine for all asynchronous read requests (that is, all requests that include a valid schedule record). For synchronous requests, client programs should set this parameter to NIL. However, if the function is provided, your handler must call it, even after synchronous requests. When your data handler finishes with the client program's read request, your component must call this routine even if the request fails. Your component should pass the reference constant that the client program provided with the RefCon parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function provides both a synchronous and an asynchronous read interface. Synchronous read operations work like the DataHGetData function; the data handler component returns control to the client program only after it has serviced the read request. Asynchronous read operations allow client programs to schedule read requests in the context of a specified QuickTime time base. Your data handler queues the request and immediately returns control to the calling program. After your component actually reads the data, it calls the client program's data-handler completion function. If your component cannot satisfy the request (for example, the request requires data more quickly than you can deliver it), your component should reject the request immediately, rather than queuing the request and then calling the client's data-handler completion function.typedef struct DataHScheduleRecord {
                    TimeRecord timeNeededBy; // schedule info *
                    long     extendedID; // type of data 
                    long     extendedVers; // reserved 
                    Fixed   priority;  //priority 
                    } DataHScheduleRecord, *DataHSchedulePtr;

Special Considerations

Note that the Movie Toolbox may try to read data from a data reference without calling your component's DataHOpenForRead function. If this happens, your component should open the data reference for read-only access, respond to the read request, and then leave the data reference open in anticipation of later read requests.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHScheduleData (
   DataHandler           dh,
   Ptr                   PlaceToPutDataPtr,
   long                  FileOffset,
   long                  DataSize,
   long                  RefCon,
   DataHSchedulePtr      scheduleRec,
   DataHCompletionUPP    CompletionRtn ){};


/*SGSetChannelMatrix

Sets a channel's display transformation matrix.

ComponentResult SGSetChannelMatrix (
   SGChannel             c,
   const MatrixRecord    *m );

Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
m

A pointer to a MatrixRecord structure. This parameter is set to NIL to select the identity matrix.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelMatrix (
   SGChannel             c,
   const MatrixRecord    *m ){};



/*SGGetChannelClip

Retrieves a channel's clipping region.

ComponentResult SGGetChannelClip (
   SGChannel    c,
   RgnHandle    *theClip );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
theClip

A pointer to a handle that is to receive a MacRegion structure that defines the clipping region. The application is responsible for disposing of this handle. If there is no clipping region, set this handle to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

Note that some devices may not support clipping.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelClip (
   SGChannel    c,
   RgnHandle    *theClip ){};



/*SGGetChannelMatrix

Retrieves a channel's display transformation matrix.

ComponentResult SGGetChannelMatrix (
   SGChannel       c,
   MatrixRecord    *m );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
m

A pointer to a MatrixRecord structure. Place your current matrix values into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelMatrix (
   SGChannel       c,
   MatrixRecord    *m ){};

/*SGSetChannelClip

Sets a channel's clipping region.

ComponentResult SGSetChannelClip (
   SGChannel    c,
   RgnHandle    theClip );

Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
theClip

A handle to the new clipping region. You should make a copy of this region; the application may dispose of the region immediately.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelClip (
   SGChannel    c,
   RgnHandle    theClip ){};



/*SGAddMovieData

Lets a channel component add data to a movie.

ComponentResult SGAddMovieData (
   SeqGrabComponent    s,
   SGChannel           c,
   Ptr                 p,
   long                len,
   long                *offset,
   long                chRefCon,
   TimeValue           time,
   short               writeType );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
c

Identifies the connection to your channel.
p

The location of the data to be added to the movie.
len

Indicates the number of bytes of data to be added to the movie.
offset

A pointer to a field that is to receive the offset to the new data in the movie. The sequence grabber component returns an offset that is correct in the context of the movie resource, even if the movie is currently stored in memory. That is, if the movie is in memory, the returned offset reflects the location that the data will have in a movie on a permanent storage device, such as a disk.
chRefCon

Your channel's reference constant.
time

The time at which your channel captured the frame. This time value is expressed in your channel's time scale.
writeType

A constant (see below) that determines the type of write operation to be used. See these constants: 
seqGrabWriteAppend
seqGrabWriteReserve
seqGrabWriteFill

Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function combines the services provided by SGWriteMovieData and SGAddFrameReference. Your channel component should not write data directly to the movie file; use this function instead.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGAddMovieData (
   SeqGrabComponent    s,
   SGChannel           c,
   Ptr                 p,
   long                len,
   long                *offset,
   long                chRefCon,
   TimeValue           time,
   short               writeType ){};


/*SGGetNextFrameReference

Lets a channel component retrieve the sample references that were stored by calling SGAddMovieData or SGAddFrameReference.

ComponentResult SGGetNextFrameReference (
   SeqGrabComponent       s,
   SeqGrabFrameInfoPtr    frameInfo,
   TimeValue              *frameDuration,
   long                   *frameNumber );

Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
frameInfo

A pointer to a SeqGrabFrameInfo structure. Your component must identify itself to the sequence grabber component by setting the frameChannel field of this structure to the component instance that identifies the current connection to your channel. You get this value from SGNewChannel or SGNewChannelFromComponent. The sequence grabber component then returns information about the specified frame in the remaining fields of this structure.
frameDuration

A pointer to a time value. The sequence grabber component calculates the duration of the specified frame and returns that duration in the structure referred to by this parameter. The sequence grabber component cannot calculate the duration of the last frame in a sequence. In this case, the sequence grabber component sets the returned time value to -1.
frameNumber

A pointer to a long integer. Your channel component specifies the frame number corresponding to the frame about which you want to retrieve information. Frames are numbered starting at 0. However, frame numbers need not start at 0, and they need not be sequential. Set the integer to -1 to retrieve information about the first frame in a movie.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetNextFrameReference (
   SeqGrabComponent       s,
   SeqGrabFrameInfoPtr    frameInfo,
   TimeValue              *frameDuration,
   long                   *frameNumber ){};

/*VDGetDigitizerInfo

Returns capability and status information about a specified video digitizer component.

VideoDigitizerError VDGetDigitizerInfo (
   VideoDigitizerComponent    ci,
   DigitizerInfo              *info );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
info

A pointer to a DigitizerInfo structure. The function returns information describing the capabilities of the specified video digitizer into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetDigitizerInfo (
   VideoDigitizerComponent    ci,
   DigitizerInfo              *info ){};


/*SGGrabFrameComplete

Provides the default behavior for your grab-complete function.

ComponentResult SGGrabFrameComplete (
   SGChannel    c,
   short        bufferNum,
   Boolean      *done );
Parameters
c

The reference that identifies the channel for this operation. The sequence grabber provides this value to your grab-complete function.
bufferNum

Identifies the buffer. The sequence grabber provides this value to your grab-complete function.
done

A pointer to a Boolean value. The function sets this value to TRUE if the capture is complete, and sets it to FALSE if the capture is incomplete. The sequence grabber provides this pointer to your grab-complete function.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGrabFrameComplete (
   SGChannel    c,
   short        bufferNum,
   Boolean      *done ){};


/*NewSGGrabCompleteBottleUPP

Allocates a Universal Procedure Pointer for the SGGrabCompleteBottleProc callback.

SGGrabCompleteBottleUPP NewSGGrabCompleteBottleUPP (
   SGGrabCompleteBottleProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGGrabCompleteBottleProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

SGGrabCompleteBottleUPP NewSGGrabCompleteBottleUPP (
   SGGrabCompleteBottleProcPtr    userRoutine ){};


/*DataHCreateFile

Creates a new container that meets the specifications of the current data reference.

ComponentResult DataHCreateFile (
   DataHandler    dh,
   OSType         creator,
   Boolean        deleteExisting );

Parameters
dh

Identifies the calling program's connection to your data handler component.
creator

The creator type of the new container. If the client program sets this parameter to 0, your component should choose a reasonable value (for example, 'TV0D', the creator type for Apple's movie player).
deleteExisting

Indicates whether to delete any existing data. If this parameter is set to TRUE and a container already exists for the current data reference, your component should delete that data before creating the new container. If this parameter is set to FALSE, your component should preserve any data that resides in the container defined by the current data reference (if there is any).
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Data handlers provide two distinct write facilities: DataHPutData is a simple synchronous interface that allows applications to append data to the end of a container, while DataHWrite is a more capable, asynchronous write function that is suitable for movie capture operations. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHCreateFile (
   DataHandler    dh,
   OSType         creator,
   Boolean        deleteExisting ){};


/*DataHSetMacOSFileType

Sets the Mac OS file type for a data handler's current data reference.

ComponentResult DataHSetMacOSFileType (
   DataHandler    dh,
   OSType         fileType );

Parameters
dh

A data handler component.
fileType

A file type; see File Types and Creators.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHSetMacOSFileType (
   DataHandler    dh,
   OSType         fileType ){};

OSErr
InvokeMovieExportGetPropertyUPP(
  void *                     refcon,
  long                       trackID,
  OSType                     propertyType,
  void *                     propertyValue,
  MovieExportGetPropertyUPP  userUPP){};




/*MovieExportValidate

Determines whether a movie export component can export all the data for a specified movie or track.

ComponentResult MovieExportValidate (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   Boolean                 *valid );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theMovie

The movie to validate.
onlyThisTrack

A track within the movie to validate, or NIL if the entire movie is to be validated.
valid

A pointer to a Boolean value. If the data for the movie or track can be exported by the component, the value is TRUE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows an application to determine if a particular movie or track could be exported by the specified movie data export component. The movie or track is passed in the theMovie and onlyThisTrack parameters as they are passed to MovieExportToFile. Although a movie export component can export one or more media types, it may not be able to export all the kinds of data stored in those media. The MovieExportValidate function allows applications to get this additional information. Movie data export components that implement this function also set the canMovieExportValidateMovie flag in in the componentFlags field of their ComponentDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult MovieExportValidate (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   Boolean                 *valid ){};


OSErr
InvokeMovieExportGetDataUPP(
  void *                      refCon,
  MovieExportGetDataParams *  params,
  MovieExportGetDataUPP       userUPP){};


/*GraphicsImageImportSetSequenceEnabled

Undocumented

ComponentResult GraphicsImageImportSetSequenceEnabled (
   GraphicImageMovieImportComponent    ci,
   Boolean                             enable );

Parameters
ci

The component instance that identifies your connection to the movie importer component.
enable

Pass TRUE to enable, FALSE to disable.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult GraphicsImageImportSetSequenceEnabled (
   GraphicImageMovieImportComponent    ci,
   Boolean                             enable ){};





































