#include <SearchKit/SearchKit.h>

//work


/*SKIndexCreateWithMutableData

Creates a named index stored in a CFMutableData object.

SKIndexRef SKIndexCreateWithMutableData (
   CFMutableDataRef    inData,
   CFStringRef         inIndexName,
   SKIndexType         inIndexType,
   CFDictionaryRef     inAnalysisProperties
);
Parameters
inData

An empty CFMutableData object to contain the index being created.
inIndexName

The name of the index. If you call this function with inIndexName set to NULL, Search Kit assigns the index the default index name IADefaultIndex. If you then attempt to create a second index in the same file without assigning a name, no second index is created and this function returns NULL. Search Kit does not currently support retrieving index names from an index.
inIndexType

The index type. See SKIndexType.
inAnalysisProperties

The text analysis properties dictionary, which optionally sets the minimum term length, stopwords, term substitutions, maximum unique terms to index, and proximity support (for phrase-based searches) when creating the index. See Text Analysis Keys. The inAnalysisProperties parameter can be NULL, in which case Search Kit applies the default dictionary, which is NULL.
Return Value

The newly created index.
Discussion

SKIndexCreateWithMutableData creates an index in memory as a CFMutableData object. Search Kit indexes are initially empty. A memory-based index is useful for quick searching and when your application doesn’t need persistent storage. To create a disk-based, persistent index, use SKIndexCreateWithURL.

Search Kit is thread-safe. You can use separate indexing and searching threads. Your application is responsible for ensuring that no more than one process is open at a time for writing to an index.

When your application no longer needs the index, dispose of it by calling SKIndexClose.
Availability
Available in Mac OS X v10.3 and later.
Declared In
SKIndex.h*/

SKIndexRef SKIndexCreateWithMutableData (
   CFMutableDataRef    inData,
   CFStringRef         inIndexName,
   SKIndexType         inIndexType,
   CFDictionaryRef     inAnalysisProperties
){};

/*SKIndexAddDocumentWithText

Adds a document URL object, and the associated document’s textual content, to an index.

Boolean SKIndexAddDocumentWithText (
   SKIndexRef      inIndex,
   SKDocumentRef   inDocument,
   CFStringRef     inDocumentText,
   Boolean         inCanReplace
);
Parameters
inIndex

The index to which you are adding the document URL object (SKDocumentRef).
inDocument

The document URL object to add.
inDocumentText

The document text. Can be NULL.
inCanReplace

A Boolean value specifying whether Search Kit will overwrite a document’s index entry (true, indicated by 1 or kCFBooleanTrue), or retain the entry if it exists (false, indicated by 0 or kCFBoolenFalse).
Return Value

A Boolean value of true on success, or false on failure. Also returns false if the document has an entry in the index and inCanReplace is set to false.
Discussion

Use this function to add the textual contents of arbitrary document types to an index. With this function, your application takes responsibility for getting textual content and handing it to the index as a CFString object. Because of this, your application can define what it considers to be a document—a database record, a tagged field in an XML document, an object in memory, a text file, and so on.

Search Kit will index any size text string that you give it, up to its 4 GB index file size limit.

To add the textual content of file-based documents to a Search Kit index, you can use this function or take advantage of Search Kit’s ability to locate and read certain on-disk, file-based document types—see SKIndexAddDocument.

Search Kit is thread-safe. You can use separate indexing and searching threads. Your application is responsible for ensuring that no more than one process is open at a time for writing to an index.

A single Search Kit index file can be up to 4 GB in size.
Special Considerations

In Mac OS X v10.3, some functions do not provide expected results unless you follow a call to SKIndexAddDocumentWithText with a call to SKIndexFlush. The affected functions include SKIndexGetDocumentCount, SKIndexGetDocumentTermCount, SKIndexGetDocumentTermFrequency, and SKIndexGetTermDocumentCount. However, in typical use this won’t be an issue, because applications call these functions after a search, and you must call SKIndexFlush before a search.
Availability
Available in Mac OS X v10.3 and later.
Declared In
SKIndex.h*/

Boolean SKIndexAddDocumentWithText (
   SKIndexRef      inIndex,
   SKDocumentRef   inDocument,
   CFStringRef     inDocumentText,
   Boolean         inCanReplace
){};


/*SKIndexFlush

Invokes all pending updates associated with an index and commits them to backing store.

Boolean SKIndexFlush (
   SKIndexRef  inIndex
);
Parameters
inIndex

The index you want to update and commit to backing store.
Return Value

A Boolean value of true on success, or false on failure.
Discussion

An on-disk or memory-based index becomes stale when your application updates it by adding or removing a document entry. A search on an index in such a state won’t have access to the nonflushed updates. The solution is to call this function before searching. SKIndexFlush flushes index-update information and commits memory-based index caches to disk, in the case of an on-disk index, or to a memory object, in the case of a memory-based index. In both cases, calling this function makes the state of the index consistent.

Before searching an index, always call SKIndexFlush, even though the flush process may take up to several seconds. If there are no updates to commit, a call to SKIndexFlush does nothing and takes minimal time.

A new Search Kit index does not have term IDs until it is flushed.

Search Kit is thread-safe. You can use separate indexing and searching threads. Your application is responsible for ensuring that no more than one process is open at a time for writing to an index.
Availability
Available in Mac OS X v10.3 and later.
Declared In
SKIndex.h*/
Boolean SKIndexFlush (
   SKIndexRef  inIndex
){};

/*SKIndexClose

Closes an index.

void SKIndexClose (
   SKIndexRef      inIndex
);
Parameters
inIndex

The index to close.
Discussion

When your application no longer needs an index that it has opened or created, call SKIndexClose. Calling this function is equivalent to calling CFRelease on an index.

Search Kit is thread-safe. You can use separate indexing and searching threads. Your application is responsible for ensuring that no more than one process is open at a time for writing to an index.
Availability
Available in Mac OS X v10.4 and later.
Declared In
SKIndex.h*/


void SKIndexClose (
   SKIndexRef      inIndex
){};


/*SKIndexRemoveDocument

Removes a document URL object and its children, if any, from an index.

Boolean SKIndexRemoveDocument (
   SKIndexRef      inIndex,
   SKDocumentRef   inDocument
);
Parameters
inIndex

The index from which you want to remove the document URL object (SKDocumentRef).
inDocument

The document URL object to remove.
Return Value

A Boolean value of true on success, or false on failure.
Discussion

When your application deletes a document, use this function to update the index to reflect the change.

Search Kit is thread-safe. You can use separate indexing and searching threads. Your application is responsible for ensuring that no more than one process is open at a time for writing to an index.
Availability
Available in Mac OS X v10.3 and later.
Declared In
SKIndex.h*/

Boolean SKIndexRemoveDocument (
   SKIndexRef      inIndex,
   SKDocumentRef   inDocument
){};

