#include <Security/Security.h>

//work


/*SecKeychainItemCopyContent

Copies the data and attributes stored in the given keychain item.

OSStatus SecKeychainItemCopyContent (
   SecKeychainItemRef itemRef,
   SecItemClass *itemClass,
   SecKeychainAttributeList *attrList,
   UInt32 *length,
   void **outData
);
Parameters
itemRef

A reference to the keychain item to modify.
itemClass

A pointer to the item’s class. You should pass NULL if it is not required. See “Keychain Item Class Constants” for valid constants.
attrList

A pointer to the list of attributes to get in this item on input; on output the attributes are filled in. You must call SecKeychainItemFreeContent when you no longer need the attributes and data.
length

On return, the length of the buffer pointed to by the outData parameter.
outData

On return, a pointer to a buffer containing the data in this item. You must call SecKeychainItemFreeContent when you no longer need the attributes and data.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

This function returns the data and attributes of a specific keychain item. You can use the SecKeychainSearchCopyNext function to search for a keychain item if you don’t already have the item’s reference object. To find and obtain data from a password keychain item, use the SecKeychainFindInternetPassword or SecKeychainFindGenericPassword function.

You should pair the SecKeychainItemModifyContent function with the SecKeychainItemCopyContent function when dealing with older Keychain Manager functions. The SecKeychainItemCopyAttributesAndData and SecKeychainItemModifyAttributesAndData functions handle more attributes than are support by the old Keychain Manager; however, passing them into older calls yields an invalid attribute error. 

If the keychain item data is encrypted, this function decrypts the data before returning it to you. If the calling application is not in the list of trusted applications, the user is prompted before access is allowed. If the access controls for this item do not allow decryption, the function returns the errSecAuthFailed result code.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/

OSStatus SecKeychainItemCopyContent (
   SecKeychainItemRef itemRef,
   SecItemClass *itemClass,
   SecKeychainAttributeList *attrList,
   UInt32 *length,
   void **outData
){};

/*SecKeychainItemModifyContent

Updates an existing keychain item after changing its attributes and/or data.

OSStatus SecKeychainItemModifyContent (
   SecKeychainItemRef itemRef,
   const SecKeychainAttributeList *attrList,
   UInt32 length,
   const void *data
);
Parameters
itemRef

A reference to the keychain item to modify.
attrList

A pointer to the list of attributes to set. Pass NULL if you have no attributes to set.
length

The length of the buffer pointed to by the data parameter. Pass 0 if you pass NULL in the data parameter.
data

A pointer to a buffer containing the data to store. Pass NULL if you do not need to modify the data.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

The keychain item is written to the keychain’s permanent data store. If the keychain item has not previously been added to a keychain, a call to this function does nothing and returns noErr. 

You should pair the SecKeychainItemModifyContent function with the SecKeychainItemCopyContent function when dealing with older Keychain Manager functions. The SecKeychainItemCopyAttributesAndData and SecKeychainItemModifyAttributesAndData functions handle more attributes than are support by the old Keychain Manager; however, passing them into older calls yields an invalid attribute error. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/
OSStatus SecKeychainItemModifyContent (
   SecKeychainItemRef itemRef,
   const SecKeychainAttributeList *attrList,
   UInt32 length,
   const void *data
){};

/*SecKeychainItemFreeContent

Releases the memory used by the keychain attribute list and/or the keychain data retrieved in a call to the SecKeychainItemCopyContent function.

OSStatus SecKeychainItemFreeContent (
   SecKeychainAttributeList *attrList,
   void *data
);
Parameters
attrList

A pointer to the attribute list to release. Pass NULL if there is no attribute list to release.
data

A pointer to the data buffer to release. Pass NULL if there is no data to release.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

Because the SecKeychainFindInternetPassword and SecKeychainFindGenericPassword functions call the SecKeychainItemCopyContent function, you must call SecKeychainItemFreeContent to release the data buffers after calls to those functions as well. 

Because the SecKeychainItemCopyContent function does not allocate buffers until they are needed, you should not call the SecKeychainItemFreeContent function unless data is actually returned to you.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/
OSStatus SecKeychainItemFreeContent (
   SecKeychainAttributeList *attrList,
   void *data
){};

