#include <SyncServices/ISyncChange.h>
//work
@implementation ISyncChange
/*recordIdentifier

Returns the unique record identifier for the record that changed.

- (NSString *)recordIdentifier
Discussion

Returns the unique identifier for the record returned by record, or the record identifier you specified when creating the receiver. Use the changes method to get the changes that were made to this record. 
Availability
Available in Mac OS X v10.4 and later.*/
- (NSString *)recordIdentifier{}


/*record

Returns a dictionary representation of the record that changed. 

- (NSDictionary *)record
Discussion

The dictionary contains a key-value pair for each property unless the value of a property is unspecified. Only changes created by the sync engine have an associated record. Returns nil if the client created the receiver to push changes, or this is a delete change.

When pulling changes, this method returns a copy of the record as it appears in the truth database. Only those properties supported by the client are included in this record. Use the changes method to get the changes made to this record, and use the recordIdentifier method to get the record’s unique identifier.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSDictionary *)record{}


/*type

Returns the type of change the receiver represents.

- (ISyncChangeType)type
Discussion

Returns whether or not this change was an add, delete or modify. See “Constants” for a description of the possible return values.
Availability
Available in Mac OS X v10.4 and later.
See Also
changes*/
- (ISyncChangeType)type{}



@end