#include <sys/kern_control.h>

//work
/*ctl_enqueuedata

errno_t ctl_enqueuedata(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *data,
    size_t len,
    u_int32_t flags);  
Parameters
kctlref
The control reference of the kernel control.
unit
The unit number of the kernel control instance.
data
A pointer to the data to send.
len
The length of data to send.
flags
Send flags. CTL_DATA_NOWAKEUP and CTL_DATA_EOR are currently the only supported flags.
Return Value

0 - Data was enqueued to be read by the client. EINVAL - Invalid parameters. EMSGSIZE - The buffer is too large. ENOBUFS - The queue is full or there are no free mbufs. 
Discussion 

Send data from the kernel control to the client.*/
errno_t ctl_enqueuedata(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *data,
    size_t len,
    u_int32_t flags){};  

/*ctl_deregister

errno_t ctl_deregister(
    kern_ctl_ref kctlref);  
Parameters
kctlref
The control reference of the control to unregister.
Return Value

0 - Kernel control was unregistered. EINVAL - The kernel control reference was invalid. EBUSY - The kernel control has clients still attached. 
Discussion 

Unregister a kernel control. A kernel extension must unregister it's kernel control(s) before unloading. If a kernel control has clients attached, this call will fail.*/
errno_t ctl_deregister(
    kern_ctl_ref kctlref){};  

/*ctl_register

errno_t ctl_register(
    struct kern_ctl_reg *userkctl,
    kern_ctl_ref *kctlref);  
Parameters
userkctl
A structure defining the kernel control to be attached. Each callback is optional.
kctlref
Upon successful return, the kctlref will contain a reference to the attached kernel control. This reference is used to unregister the kernel control. This reference will also be passed in to the callbacks each time they are called.
Return Value

0 - Kernel control was registered. EINVAL - The registration structure was not valid. ENOMEM - There was insufficient memory. EEXIST - A controller with that id/unit is already registered. 
Discussion 

Register a kernel control. This will enable clients to connect to the kernel control using a PF_SYSTEM socket.*/
errno_t ctl_register(
    struct kern_ctl_reg *userkctl,
    kern_ctl_ref *kctlref){};  

