@class NSDictionary;
@class NSString;
@class NSWindow;
@class NSBitmapImageRep;
@class CIContext;

@interface NSGraphicsContext (hys)

/*compositingOperation

Returns the receiver’s global compositing operation setting.

-(NSCompositingOperation)compositingOperation
Return Value

The receiver’s global compositing operation setting. See NSCompositingOperation for valid constants.
Discussion

The compositing operation is a global attribute of the graphics context and affects drawing operations that do not take an explicit compositing operation parameter. For methods that do take an explicit compositing operation parameter, the value of that parameter supersedes the global value.

The compositing operations are related to (but different from) the blend mode settings used in Quartz. Only the default compositing operation (NSCompositeCopy) is supported for PDF or PostScript content. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– setCompositingOperation:*/
-(NSCompositingOperation)compositingOperation;

/*graphicsContextWithBitmapImageRep:

Instantiates and returns a new graphics context using the supplied NSBitmapImageRep object as the context destination.

+ (NSGraphicsContext *)graphicsContextWithBitmapImageRep:(NSBitmapImageRep *)bitmapRep
Parameters
bitmapRep

The NSBitmapImageRep object to use as the destination. 
Return Value

The created NSGraphicsContext object or nil if the object could not be created.
Discussion

This method accepts only single plane NSBitmapImageRep instances. It is the equivalent of using graphicsContextWithAttributes: and passing bitmapRep as the value for the dictionary’s NSGraphicsContextDestinationAttributeName key. 
Availability
Available in Mac OS X v10.4 and later.
See Also
+ graphicsContextWithAttributes:*/
+ (NSGraphicsContext *)graphicsContextWithBitmapImageRep:(NSBitmapImageRep *)bitmapRep;

/*CIContext

Returns a CIContext object that you can use to render into the receiver.

- (CIContext *)CIContext
Discussion

The CIContext object is created on demand and remains in existence for the lifetime of its owning NSGraphicsContext object. A CIContext object is an evaluation context for rendering a CIImage object through Quartz 2D or OpenGL. You use CIContextobjects in conjunction with CIFilter, CIImage, CIVector, and CIColor objects to take advantage of the built-in Core Image filters when processing images.

For more on CIContext objects and related Core Image objects, see Core Image Programming Guide.
Availability
Available in Mac OS X v10.4 and later.*/
- (CIContext *)CIContext;

/*graphicsContextWithGraphicsPort:flipped:

Instantiates and returns a new graphics context from the given graphics port.

+ (NSGraphicsContext *)graphicsContextWithGraphicsPort:(void *)graphicsPort flipped:(BOOL)initialFlippedState
Parameters
graphicsPort

The graphics port used to create the graphics-context object. Typically graphicsPort is a CGContextRef (opaque type) object.
initialFlippedState

Specifies the receiver's initial flipped state. This is the value returned by isFlipped when no view has focus.
Return Value

The created NSGraphicsContext object or nil if the object could not be created.
Availability
Available in Mac OS X v10.4 and later.*/
+ (NSGraphicsContext *)graphicsContextWithGraphicsPort:(void *)graphicsPort flipped:(BOOL)initialFlippedState;

/*setCompositingOperation:

Sets the receiver’s global compositing operation. 

-(void)setCompositingOperation:(NSCompositingOperation)operation
Parameters
operation

A constant that specifies a compositing operating. See NSCompositingOperation for valid constants.
Discussion

The compositing operation is a global attribute of the graphics context and affects drawing operations that do not take an explicit compositing operation parameter. For methods that do take an explicit compositing operation parameter, the value of that parameter supersedes the global value. 

The compositing operations are related to (but different from) the blend mode settings used in Quartz. Only the default compositing operation (NSCompositeCopy) is supported when rendering PDF or PostScript content. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– compositingOperation*/
-(void)setCompositingOperation:(NSCompositingOperation)operation;

@end