#ifndef AUDIOUNUTPROPERTIES_H
#define AUDIOUNUTPROPERTIES_H
	
#include <AudioUnit/AUComponent.h>
#include <CoreAudio/CoreAudioTypes.h>
#include <CoreFoundation/CoreFoundation.h>

//#include <HYS/AudioUnit/AudioUnitProperties.h>
#include <APPLE/AudioUnit/AudioUnitProperties.h>

/*Output Unit Properties

These properties can be queried of any output audio unit instance.
kAudioOutputUnitProperty_CurrentDevice          = 2000
kAudioOutputUnitProperty_IsRunning              = 2001
kAudioOutputUnitProperty_ChannelMap             = 2002
kAudioOutputUnitProperty_EnableIO               = 2003
kAudioOutputUnitProperty_StartTime              = 2004
kAudioOutputUnitProperty_SetInputCallback       = 2005
kAudioOutputUnitProperty_HasIO                  = 2006*/

enum {
kAudioOutputUnitProperty_CurrentDevice          = 2000,
kAudioOutputUnitProperty_IsRunning              = 2001,
kAudioOutputUnitProperty_ChannelMap             = 2002,
kAudioOutputUnitProperty_EnableIO               = 2003,
kAudioOutputUnitProperty_StartTime              = 2004,
kAudioOutputUnitProperty_SetInputCallback       = 2005,
kAudioOutputUnitProperty_HasIO                  = 2006,
};

/*Render Quality Properties

These properties can be queried of any audio unit instance.
kRenderQuality_Max      = 0x7F
kRenderQuality_High     = 0x60
kRenderQuality_Medium   = 0x40
kRenderQuality_Low      = 0x20
kRenderQuality_Min      = 0*/
enum {
kRenderQuality_Max      = 0x7F,
kRenderQuality_High     = 0x60,
kRenderQuality_Medium   = 0x40,
kRenderQuality_Low      = 0x20,
kRenderQuality_Min      = 0
};


/*Scope Properties

These properties can be queried of any audio unit instance.kAudioUnitScope_Global  = 0
kAudioUnitScope_Input   = 1
kAudioUnitScope_Output  = 2
kAudioUnitScope_Group   = 3
kAudioUnitScope_Part    = 4*/
enum {
kAudioUnitScope_Global  = 0 ,
kAudioUnitScope_Input   = 1,
kAudioUnitScope_Output  = 2,
kAudioUnitScope_Group   = 3,
kAudioUnitScope_Part    = 4,
};

/*Audio Unit Properties

These properties can be queried of any audio unit instance.kAudioUnitProperty_ClassInfo                    = 0
kAudioUnitProperty_MakeConnection               = 1
kAudioUnitProperty_SampleRate                   = 2
kAudioUnitProperty_ParameterList                = 3
kAudioUnitProperty_ParameterInfo                = 4
kAudioUnitProperty_FastDispatch                 = 5
kAudioUnitProperty_CPULoad                      = 6
kAudioUnitProperty_StreamFormat                 = 8
kAudioUnitProperty_SRCAlgorithm                 = 9
kAudioUnitProperty_ReverbRoomType               = 10
kAudioUnitProperty_BusCount                     = 11
kAudioUnitProperty_ElementCount                 = kAudioUnitProperty_BusCount,
kAudioUnitProperty_Latency                      = 12
kAudioUnitProperty_SupportedNumChannels         = 13
kAudioUnitProperty_MaximumFramesPerSlice        = 14
kAudioUnitProperty_SetExternalBuffer            = 15
kAudioUnitProperty_ParameterValueStrings        = 16
kAudioUnitProperty_MIDIControlMapping           = 17
kAudioUnitProperty_GetUIComponentList           = 18
kAudioUnitProperty_AudioChannelLayout           = 19
kAudioUnitProperty_TailTime                     = 20
kAudioUnitProperty_BypassEffect                 = 21
kAudioUnitProperty_LastRenderError              = 22
kAudioUnitProperty_SetRenderCallback            = 23
kAudioUnitProperty_FactoryPresets               = 24
kAudioUnitProperty_ContextName                  = 25
kAudioUnitProperty_RenderQuality                = 26
kAudioUnitProperty_HostCallbacks                = 27
kAudioUnitProperty_CurrentPreset                = 28
kAudioUnitProperty_InPlaceProcessing            = 29
kAudioUnitProperty_ElementName                  = 30
kAudioUnitProperty_CocoaUI                      = 31
kAudioUnitProperty_SupportedChannelLayoutTags   = 32
kAudioUnitProperty_ParameterValueName           = 33
kAudioUnitProperty_ParameterIDName              = 34
kAudioUnitProperty_ParameterClumpName           = 35
kAudioUnitProperty_PresentPreset                = 36
ProperkAudioUnitProperty_UsesInternalReverb     = 1005*/
enum {
kAudioUnitProperty_MakeConnection               = 1,
kAudioUnitProperty_SampleRate                   = 2,
kAudioUnitProperty_ParameterList                = 3,
kAudioUnitProperty_ParameterInfo                = 4,
kAudioUnitProperty_FastDispatch                 = 5,
kAudioUnitProperty_CPULoad                      = 6,
kAudioUnitProperty_StreamFormat                 = 8,
kAudioUnitProperty_SRCAlgorithm                 = 9,
kAudioUnitProperty_ReverbRoomType               = 10,
kAudioUnitProperty_BusCount                     = 11,
kAudioUnitProperty_ElementCount                 = kAudioUnitProperty_BusCount,
kAudioUnitProperty_Latency                      = 12,
kAudioUnitProperty_SupportedNumChannels         = 13,
kAudioUnitProperty_MaximumFramesPerSlice        = 14,
kAudioUnitProperty_SetExternalBuffer            = 15,
kAudioUnitProperty_ParameterValueStrings        = 16,
kAudioUnitProperty_MIDIControlMapping           = 17,
kAudioUnitProperty_GetUIComponentList           = 18,
kAudioUnitProperty_AudioChannelLayout           = 19,
kAudioUnitProperty_TailTime                     = 20,
kAudioUnitProperty_BypassEffect                 = 21,
kAudioUnitProperty_LastRenderError              = 22,
kAudioUnitProperty_SetRenderCallback            = 23,
kAudioUnitProperty_FactoryPresets               = 24,
kAudioUnitProperty_ContextName                  = 25,
kAudioUnitProperty_RenderQuality                = 26,
kAudioUnitProperty_HostCallbacks                = 27,
kAudioUnitProperty_CurrentPreset                = 28,
kAudioUnitProperty_InPlaceProcessing            = 29,
kAudioUnitProperty_ElementName                  = 30,
kAudioUnitProperty_CocoaUI                      = 31,
kAudioUnitProperty_SupportedChannelLayoutTags   = 32,
kAudioUnitProperty_ParameterValueName           = 33,
kAudioUnitProperty_ParameterIDName              = 34,
kAudioUnitProperty_ParameterClumpName           = 35,
kAudioUnitProperty_PresentPreset                = 36,
ProperkAudioUnitProperty_UsesInternalReverb     = 1005
};

/*AURenderCallbackStruct

Encapsulates render callback information.

struct AURenderCallbackStruct {
   AURenderCallback    inputProc;
void *              inputProcRefCon; }
Fields
inputProc

The callback function.
inoutProcRefCon

Any arguments that should be passed to the callback.*/
struct AURenderCallbackStruct {
   AURenderCallback    inputProc;
void *              inputProcRefCon; };
typedef struct AURenderCallbackStruct AURenderCallbackStruct;



#endif