#ifndef NUMBERFORMATTING_H
#define NUMBERFORMATTING_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef INTLRESOURCES_H
#include <CarbonCore/IntlResources.h>
#endif




#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*FormatStatus

Defines a data type used to denote the confidence level for a conversion.

typedef short FormatStatus;
Discussion

A FormatStatus value is returned by the functions ExtendedToString, StringToExtended, FormatRecToString, and StringToFormatRec.
Availability
Available in Mac OS X v10.0 and later.*/
typedef short FormatStatus;


/*Format Result Types

Specify values that can be returned in the low byte of a format status (FormatStatus) value. 

enum {
   fFormatOK = 0,
   fBestGuess = 1,
   fOutOfSynch = 2,
   fSpuriousChars = 3,
   fMissingDelimiter = 4,
   fExtraDecimal = 5,
   fMissingLiteral = 6,
   fExtraExp = 7,
   fFormatOverflow = 8,
   fFormStrIsNAN = 9,
   fBadPartsTable = 10,
   fExtraPercent = 11,
   fExtraSeparator = 12,
   fEmptyFormatString = 13
};
typedef SInt8 FormatResultType;
Constants
fFormatOK

Specifies format is okay.

Available in Mac OS X v10.0 and later.
fBestGuess

Specifies the format is the best guess.

Available in Mac OS X v10.0 and later.
fOutOfSynch

Specifies the format is out of sync.

Available in Mac OS X v10.0 and later.
fSpuriousChars

Specifies the format contains spurious characters.

Available in Mac OS X v10.0 and later.
fMissingDelimiter

Specifies a missing delimiter.

Available in Mac OS X v10.0 and later.
fExtraDecimal

Specifies the format contains an extra decimal sign. 

Available in Mac OS X v10.0 and later.
fMissingLiteral

Specifies the format is missing a literal.

Available in Mac OS X v10.0 and later.
fExtraExp

Available in Mac OS X v10.0 and later.
fFormatOverflow

Specifies a format overflow.

Available in Mac OS X v10.0 and later.
fFormStrIsNAN

Available in Mac OS X v10.0 and later.
fBadPartsTable

Specifies the parts table is bad.

Available in Mac OS X v10.0 and later.
fExtraPercent

Specifies the format contains an extra percent sign.

Available in Mac OS X v10.0 and later.
fExtraSeparator

Specifies an extra separator.

Available in Mac OS X v10.0 and later.
fEmptyFormatString

Specifies the format string is empty.

Available in Mac OS X v10.0 and later.
Discussion

A format result type is returned in the low byte of a format status (FormatStatus) value. A FormatStatus value is returned by the functions ExtendedToString, StringToExtended, FormatRecToString, and StringToFormatRec. A format status value denotes the confidence level for a conversion.*/

enum {
   fFormatOK = 0,
   fBestGuess = 1,
   fOutOfSynch = 2,
   fSpuriousChars = 3,
   fMissingDelimiter = 4,
   fExtraDecimal = 5,
   fMissingLiteral = 6,
   fExtraExp = 7,
   fFormatOverflow = 8,
   fFormStrIsNAN = 9,
   fBadPartsTable = 10,
   fExtraPercent = 11,
   fExtraSeparator = 12,
   fEmptyFormatString = 13
};
typedef SInt8 FormatResultType;


/*NumFormatString

Contains data that represents the internal number formatting specification.

struct NumFormatString {
   UInt8 fLength;
   UInt8 fVersion;
   char data[254];
};
typedef struct NumFormatString NumFormatString;
typedef NumFormatString NumFormatStringRec;
Fields
fLength

The number of bytes in the data actually used for this number formatting specification. 
fVersion

The version number of the number formatting specification. 
data

The data that comprises the number formatting specification. 
Discussion
Availability
Available in Mac OS X v10.0 and later.*/
struct NumFormatString {
   UInt8 fLength;
   UInt8 fVersion;
   char data[254];
};
typedef struct NumFormatString NumFormatString;
typedef NumFormatString NumFormatStringRec;


//functions

/*NumToString

Converts a long integer value into a Pascal string. (Deprecated in Mac OS X v10.4. Use CFStringCreateWithFormat instead.)

void NumToString (
   long theNum,
   Str255 theString
);
Parameters
theNum

A long integer value. If the value of the number in the parameter theNum is negative, the string begins with a minus sign; otherwise, the sign is omitted. 
theString

On output, contains the Pascal string representation of the number. Leading zeros are suppressed, except that a value of 0 produces the string “0”. NumToString does not include thousand separators or decimal points in its formatted output. 
Discussion

NumToString creates a string representation of theNum as a base-10 value and returns the result in theString.

Unless patched by a script system with different rules, this function assumes that you are using standard numeric token processing, meaning that the Roman script system number processing rules are used.

For functions that make use of the token-processing information that is found in the tokens ('itl4') resource of script systems for converting numbers, see the sections “Using Number Format Specification Strings for International Number Formatting” and “Converting Between Strings and Floating-Point Numbers”. 
Special Considerations

NumToString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
void NumToString (
   long theNum,
   Str255 theString
);

/*StringToFormatRec

Creates a number format specification string structure from a number format specification string that you supply in a Pascal string. (Deprecated in Mac OS X v10.4. Use CFNumberFormatterSetFormat instead.)

FormatStatus StringToFormatRec (
   ConstStr255Param inString,
   const NumberParts * partsTable,
   NumFormatString * outString
);
Parameters
inString

A Pascal string that contains the number formatting specification.

The inString parameter contains a number format specification string that specifies how numbers appear. This string contains up to three specifications, separated by semicolons. The positive number format is specified first, the negative number format is second, and the zero number format is last. If the string contains only one part, that is the format of all three types of numbers. If the string contains two parts, the first part is the format for positive and zero number values, and the second part is the format for negative numbers.

partsTable

A pointer to a structure, usually obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
outString

On output, a pointer to a NumFormatStringRec structure that contains the values that form the internal representation of the format specification. The format of the data in this structure is private. 
Return Value

A value that denotes the confidence level for the conversion that was performed. The low byte of the value is of type FormatResultType. Be sure to cast the result of StringToFormatRec to a type FormatResultType before working with it. See the description of the FormatStatus data type.
Discussion

StringToFormatRec converts a number format specification string into the internal representation contained in a number format string structure. It uses information in the current script’s tokens resource to determine the components of the number. StringToFormatRec checks the validity both of the input format string and of the number parts table (since this table can be programmed by the application). StringToFormatRec ignores spurious characters.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Special Considerations

StringToFormatRec may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/

FormatStatus StringToFormatRec (
   ConstStr255Param inString,
   const NumberParts * partsTable,
   NumFormatString * outString
);

/*StringToExtended

Converts a string representation of a number into a floating-point number, using a NumFormatStringRec structure to specify how the input number string is formatted. (Deprecated in Mac OS X v10.4. Use CFNumberFormatterCreateStringWithNumber instead.)

FormatStatus StringToExtended (
   ConstStr255Param source,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   extended80 * x
);
Parameters
source

A Pascal string that contains the string representation of a number. 
myCanonical

A pointer to the internal representation of the formatting information for numbers, as produced by the StringToFormatRec function. 
partsTable

A pointer to a structure, obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
x

On output, contains a pointer to the 80-bit SANE representation of the floating-point number. 
Return Value

A value that denotes the confidence level for the conversion that it performed. The low byte of the FormatStatus value is of type FormatResultType. Be sure to cast the result of StringToExtended to a type FormatResultType before working with it. StringToExtended returns an 80-bit, not a 96-bit, representation. See the description of the FormatStatus data type.
Discussion

StringToExtended uses the internal representation of number formatting information that was created by a prior call to StringToFormatRec to parse the input number string. It uses the number parts table to determine the components of the number string that is being converted. StringToExtended parses the string and then converts the string to a simple form, stripping nondigits and replacing the decimal point before converting it into a floating-point number. If the input string does not match any of the patterns, then StringToExtended parses the string as well as it can and returns a confidence level result that indicates the parsing difficulties.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/

FormatStatus StringToExtended (
   ConstStr255Param source,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   extended80 * x
);

/*ExtendedToString

Converts an internal floating-point representation of a number into a string that can be presented to the user, using a NumFormatStringRec structure to specify how the output number string is formatted (Deprecated in Mac OS X v10.4. Use CFNumberFormatterCreateNumberFromString instead.)

FormatStatus ExtendedToString (
   const extended80 * x,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   Str255 outString
);
Parameters
x

A pointer to a floating-point value in 80-bit SANE representation. 
myCanonical

A pointer to the internal representation of the formatting information for numbers, as produced by the StringToFormatRec function. 
partsTable

A pointer to a structure, obtained from the tokens ('itl4') resource, that shows the correspondence between generic number part separators (tokens) and their localized version (for example, a thousand separator is a comma in the United States and a decimal point in France). 
outString

On output, contains the number formatted according to the information in myFormatRec. 
Return Value

A value that denotes the confidence level for the conversion that it performed. The low byte of the FormatStatus value is of type FormatResultType. Be sure to cast the result of ExtendedToString to a type FormatResultType before working with it. See the description of the FormatStatus data type.
Discussion

ExtendedToString creates a string representation of a floating-point number, using the formatting information in the myFormatRec parameter (which was created by a previous call to StringToFormatRec) to determine how the number should be formatted for output. It uses the number parts table to determine the component parts of the number string.

To obtain a handle to the number parts table from a tokens resource, use the GetIntlResourceTable function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
FormatStatus ExtendedToString (
   const extended80 * x,
   const NumFormatString * myCanonical,
   const NumberParts * partsTable,
   Str255 outString
);

/*StringToNum

Converts the Pascal string representation of a base-10 number into a long integer value. (Deprecated in Mac OS X v10.4. Use CFStringGetIntValue instead.)

void StringToNum (
   ConstStr255Param theString,
   long * theNum
);
Parameters
theString

A Pascal string representation of a base-10 number. The numeric string can be padded with leading zeros or with a sign. 
theNum

On output, contains a pointer to the numeric value. 
Discussion

Unless patched by a script system with different rules, this function assumes that you are using standard numeric token processing, meaning that the Roman script system number processing rules are used.

For functions that make use of the token-processing information that is found in the tokens ('itl4') resource of script systems for converting numbers, see the sections “Using Number Format Specification Strings for International Number Formatting” and “Converting Between Strings and Floating-Point Numbers”.

The 32-bit result is negated if the string begins with a minus sign. Integer overflow occurs if the magnitude is greater than or equal to 2 raised to the 31st power. StringToNum performs the negation using the two’s complement method: the state of each bit is reversed and then 1 is added to the result. For example, here are possible results produced by StringToNum:
The value of theString is “-23”. StringToNum returns the value -23 in theNum. 
The value of theString is “-0”. StringToNum returns the value 0 in theNum. 
The value of theString is “055”. StringToNum returns the value 55 in theNum. 
The value of theString is “2147483648” (magnitude is 2^31). StringToNum returns the value –2147483648 in theNum. 
The value of theString is “–2147483648”. StringToNum returns the value –2147483648 in theNum. 
The value of theString is “4294967295” (magnitude is 2^32–1). StringToNum returns the value -1 in theNum. 
The value of theString is “–4294967295”. StringToNum returns the value 1 in theNum. 

StringToNum does not check whether the characters in the string are between 0 and 9; instead, it takes advantage of the fact that the ASCII values for these characters are $30 through $39, and masks the last four bits for use as a digit. For example, StringToNum converts 2: to the number 30 since the character code for the colon (:) is $3A. Because StringToNum operates this way, spaces are treated as zeros (the character code for a space is $20), and other characters do get converted into numbers. For example, the character codes for 'C', 'A', and 'T' are $43, $41, and $54 respectively. Hence, the strings ‘CAT’, ‘+CAT’, and ‘-CAT’ would produce the results 314, 314, and -314.

One consequence of this conversion method is that StringToNum does not ignore thousand separators (the “,” character in the United States), which can lead to improper conversions. It is a good idea to ensure that all characters in theString are valid digits before you call StringToNum. 
Special Considerations

StringToNum may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
void StringToNum (
   ConstStr255Param theString,
   long * theNum
);

#ifdef __cplusplus
}
#endif
#endif