#ifndef CMAPPLICATION_H
#define CMAPPLICATION_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef CMICCPROFILE_H
#include <ColorSync/CMICCProfile.h>
#endif

#ifndef CMTYPES_H
#include <ColorSync/CMTypes.h>
#endif

#include <AvailabilityMacros.h>
//#include <HYS/ColorSync/CMApplication.h>
#include <APPLE/ColorSync/CMApplication.h>
#if PRAGMA_ONCE
#pragma once
#endif
#ifdef __cplusplus
extern "C" {
#endif

/*Use Types

Specify use types.

enum {
   cmInputUse = 'inpt',
   cmOutputUse = 'outp',
   cmDisplayUse = 'dply',
   cmProofUse = 'pruf'
};
Constants
cmInputUse

Available in Mac OS X v10.0 and later.
cmOutputUse

Available in Mac OS X v10.0 and later.
cmDisplayUse

Available in Mac OS X v10.0 and later.
cmProofUse

Available in Mac OS X v10.0 and later.
Discussion

Used for the function CMGetProfileByUse and SetDefaultProfileByUse.*/
enum {
   cmInputUse = 'inpt',
   cmOutputUse = 'outp',
   cmDisplayUse = 'dply',
   cmProofUse = 'pruf'
};


/*Profile Location Type

Defines profile location kinds.

enum {
   cmNoProfileBase = 0,
   cmFileBasedProfile = 1,
   cmHandleBasedProfile = 2,
   cmPtrBasedProfile = 3,
   cmProcedureBasedProfile = 4,
   cmPathBasedProfile = 5,
   cmBufferBasedProfile = 6
};
Constants
cmNoProfileBase

The profile is temporary. It will not persist in memory after its use for a color session. You can specify this type of profile location with the CMNewProfile and the CMCopyProfile functions.

Available in Mac OS X v10.0 and later.
cmFileBasedProfile

The profile is stored in a disk-file and the CMProfLoc union of type CMProfLoc holds a structure of type CMFileLocation identifying the profile file. You can specify this type of profile location with the CMOpenProfile, CMNewProfile, CMCopyProfile, and CMNewLinkProfile functions.

Available in Mac OS X v10.0 and later.
cmHandleBasedProfile

The profile is stored in relocatable memory and the CMProfLoc union of type CMProfLoc holds a handle to the profile in a structure of type CMHandleLocation. You can specify this type of profile location with the CMOpenProfile, CMNewProfile, and CMCopyProfile functions.

Available in Mac OS X v10.0 and later.
cmPtrBasedProfile

The profile is stored in nonrelocatable memory and the CMProfLoc union of type CMProfLoc holds a pointer to the profile in a structure of type CMPtrLocation. You can specify this type of profile location with the CMOpenProfile function only.

Available in Mac OS X v10.0 and later.
cmProcedureBasedProfile

The profile is in an arbitrary location, accessed through a procedure supplied by you. The CMProfLoc union of type CMProfLoc holds a universal procedure pointer to your profile access procedure in a structure of type CMProcedureLocation. You can specify this type of profile location with the CMOpenProfile, CMNewProfile, CMCopyProfile, and CMNewLinkProfile functions. For a description of an application-supplied profile access procedure, see CMProfileAccessProcPtr.

Available in Mac OS X v10.0 and later.
cmPathBasedProfile

Available in Mac OS X v10.0 and later.
cmBufferBasedProfile

Available in Mac OS X v10.0 and later.
Discussion

Your application specifies the location for a profile using a profile location structure of type CMProfileLocation. A ColorSync profile that you open or create is typically stored in one of the following locations:
In a disk file. The u field (a union) of the profile location data structure contains a file specification for a profile that is disk-file based. This is the most common way to store a ColorSync profile. 
In relocatable memory. The u field of the profile location data structure contains a handle specification for a profile that is stored in a handle. 
In nonrelocatable memory. The u field of the profile location data structure contains a pointer specification for a profile that is pointer based. 
In an arbitrary location, accessed by a procedure you provide. The u field of the profile location data structure contains a universal procedure pointer to your access procedure, as well as a pointer that may point to data associated with your procedure. 

Additionally, your application can create a new or duplicate temporary profile. For example, you can use a temporary profile for a color-matching session and the profile is not saved after the session. For this case, the ColorSync Manager allows you to specify the profile location as having no specific location. 

You use a pointer to a data structure of type CMProfileLocation to identify a profile’s location when your application calls
the CMOpenProfile function to obtain a reference to a profile 
the CMNewProfile, CWNewLinkProfile, or CMCopyProfile functions to create a new profile 
the CMGetProfileLocation function to get the location of an existing profile 

Your application identifies the type of data the CMProfileLocation u field holds—a file specification, a handle, and so on—in the CMProfileLocation structure’s locType field. You use the constants defined by this enumeration to identify the location type.*/
enum {
   cmNoProfileBase = 0,
   cmFileBasedProfile = 1,
   cmHandleBasedProfile = 2,
   cmPtrBasedProfile = 3,
   cmProcedureBasedProfile = 4,
   cmPathBasedProfile = 5,
   cmBufferBasedProfile = 6
};


/*CMNamedColor

Contains a color value expressed in a named color space.

struct CMNamedColor {
   UInt32 namedColorIndex;
};
typedef struct CMNamedColor CMNamedColor;
Fields
namedColorIndex
Discussion

A color value expressed in a named color space is composed of a single component, namedColorIndex, represented as a numeric value within the range of an unsigned long, or 1 to 232 – 1 inclusive. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMNamedColor {
   UInt32 namedColorIndex;
};
typedef struct CMNamedColor CMNamedColor;

/*CMMultichannel8Color

Contains a color value expressed in the multichannel color space with 8 channels

struct CMMultichannel8Color {
   UInt8 components[8];
};
typedef struct CMMultichannel8Color CMMultichannel8Color;
Fields
components
Discussion

A color expressed in the multichannel color space with 8 channels. The color value for each channel component is expressed as an unsigned byte of type char. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMMultichannel8Color {
   UInt8 components[8];
};
typedef struct CMMultichannel8Color CMMultichannel8Color;


/*CMMultichannel7Color

Contains a color value expressed in the multichannel color space with 7 channels. 

struct CMMultichannel7Color {
   UInt8 components[7];
};
typedef struct CMMultichannel7Color CMMultichannel7Color;
Fields
components
Discussion

A color expressed in the multichannel color space with 7 channels. The color value for each channel component is expressed as an unsigned byte of type char. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMMultichannel7Color {
   UInt8 components[7];
};
typedef struct CMMultichannel7Color CMMultichannel7Color;

/*CMMultichannel6Color

Contains a color expressed in the multichannel color space with 6 channels.

struct CMMultichannel6Color {
   UInt8 components[6];
};
typedef struct CMMultichannel6Color CMMultichannel6Color;
Fields
components
Discussion

A color expressed in the multichannel color space with 6 channels. The color value for each channel component is expressed as an unsigned byte of type char. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMMultichannel6Color {
   UInt8 components[6];
};
typedef struct CMMultichannel6Color CMMultichannel6Color;


/*CMMultichannel5Color

Contains a color value expressed in the multichannel color space with 5 channels.

struct CMMultichannel5Color {
   UInt8 components[5];
};
typedef struct CMMultichannel5Color CMMultichannel5Color;
Fields
components
Discussion

A color expressed in the multichannel color space with 5 channels. The color value for each channel component is expressed as an unsigned byte of type char. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMMultichannel5Color {
   UInt8 components[5];
};
typedef struct CMMultichannel5Color CMMultichannel5Color;


/*CMGrayColor

Contains a color value expressed in the gray color space.

struct CMGrayColor {
   UInt16 gray;
};
typedef struct CMGrayColor CMGrayColor;
Fields
gray
Discussion

A color value expressed in the Gray color space is composed of a single component, gray, represented as a numeric value within the range of 0 to 65535 inclusive. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMGrayColor {
   UInt16 gray;
};
typedef struct CMGrayColor CMGrayColor;

/*CMCMYKColor

Contains color values expressed in the CMYK color space.

struct CMCMYKColor {
   UInt16 cyan;
   UInt16 magenta;
   UInt16 yellow;
   UInt16 black;
};
typedef struct CMCMYKColor CMCMYKColor;
Fields
cyan
magenta
yellow
black
Discussion

A color value expressed in the CMYK color space is composed of cyan, magenta, yellow, and black component values. Each color component is expressed as a numeric value within the range of 0 to 65535 inclusive. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMCMYKColor {
   UInt16 cyan;
   UInt16 magenta;
   UInt16 yellow;
   UInt16 black;
};
typedef struct CMCMYKColor CMCMYKColor;

/*CMYxyColor

Contains values for a color expresed in the Yxy color space.

struct CMYxyColor {
   UInt16 capY;
   UInt16 x;
   UInt16 y;
};
typedef struct CMYxyColor CMYxyColor;
Fields
capY
x
y
Discussion

A color value expressed in the Yxy color space is composed of capY, x, and y component values. Each color component is expressed as a numeric value within the range of 0 to 65535 which maps to 0 to 1. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMYxyColor {
   UInt16 capY;
   UInt16 x;
   UInt16 y;
};
typedef struct CMYxyColor CMYxyColor;

/*CMLuvColor

Contains a color value expressed in the L*u*v* color space.

struct CMLuvColor {
   UInt16 L;
   UInt16 u;
   UInt16 v;
};
typedef struct CMLuvColor CMLuvColor;
Fields
L

A numeric value within the range of 0 to 65535 that maps to 0 to 100 inclusive.
u

A numeric value within the range of 0 to 65535 that maps to –128 to 127.996 inclusive.
v

A numeric value within the range of 0 to 65535 that maps to –128 to 127.996 inclusive.
Discussion

A color value expressed in the L*u*v* color space is composed of L, u, and v component values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMLuvColor {
   UInt16 L;
   UInt16 u;
   UInt16 v;
};
typedef struct CMLuvColor CMLuvColor;

/*CMLabColor

Contains a color value expressed in the L*a*b* color space.

struct CMLabColor {
   UInt16 L;
   UInt16 a;
   UInt16 b;
};
typedef struct CMLabColor CMLabColor;
Fields
L

A numeric value within the range of 0 to 65535, which maps to 0 to 100 inclusive. Note that this encoding is slightly different from the 0 to 65280 encoding of the L channel defined in the ICC specification for PCS L*a*b values.
a

A value that ranges from 0 to 65535, and maps to –128 to 127.996 inclusive. 
b

A value that ranges from 0 to 65535, and maps to –128 to 127.996 inclusive. 
Discussion

A color expressed in the L*a*b* color space is composed of L, a, and b component values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMLabColor {
   UInt16 L;
   UInt16 a;
   UInt16 b;
};
typedef struct CMLabColor CMLabColor;

/*CMCMYColor

Contains color values expressed in the CMY color space.

struct CMCMYColor {
   UInt16 cyan;
   UInt16 magenta;
   UInt16 yellow;
};
typedef struct CMCMYColor CMCMYColor;
Fields
cyan
magenta
yellow
Discussion

A color value expressed in the CMY color space is composed of cyan, magenta, and yellow component values. Each color component is expressed as a numeric value within the range of 0 to 65535 inclusive. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMCMYColor {
   UInt16 cyan;
   UInt16 magenta;
   UInt16 yellow;
};
typedef struct CMCMYColor CMCMYColor;


/*CMXYZComponent


typedef UInt16 CMXYZComponent;
Discussion

Three components combine to express a color value defined by the CMXYZColor type definition in the XYZ color space. Each color component is described by a numeric value defined by the CMXYZComponent type definition. A component value of type CMXYZComponent is expressed as a 16-bit value. This is formatted as an unsigned value with 1 bit of integer portion and 15 bits of fractional portion. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 CMXYZComponent;



/*CMHLSColor

Contains a color value expressed in the HLS color space.

struct CMHLSColor {
   UInt16 hue;
   UInt16 lightness;
   UInt16 saturation;
};
typedef struct CMHLSColor CMHLSColor;
Fields
hue

A hue value that represents a fraction of a circle in which red is positioned at 0. .
lightness

A lightness value.
saturation

A saturation value.
Discussion

A color value expressed in the HLS color space is composed of hue, lightness, and saturation component values. Each color component is expressed as a numeric value within the range of 0 to 65535 inclusive. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMHLSColor {
   UInt16 hue;
   UInt16 lightness;
   UInt16 saturation;
};
typedef struct CMHLSColor CMHLSColor;


/*CMHSVColor

Contains a color value expressed in the HSV color space.

struct CMHSVColor {
   UInt16 hue;
   UInt16 saturation;
   UInt16 value;
};
typedef struct CMHSVColor CMHSVColor;
Fields
hue
saturation
value
Discussion

A color value expressed in the HSV color space is composed of hue, saturation, and value component values. Each color component is expressed as a numeric value within the range of 0 to 65535 inclusive. The hue value represents a fraction of a circle in which red is positioned at 0. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMHSVColor {
   UInt16 hue;
   UInt16 saturation;
   UInt16 value;
};
typedef struct CMHSVColor CMHSVColor;


/*CMRGBColor

Contains a color value expressed in the RGB color space.

struct CMRGBColor {
   UInt16 red;
   UInt16 green;
   UInt16 blue;
};
typedef struct CMRGBColor CMRGBColor;
Fields
red
green
blue
Discussion

A color value expressed in the RGB color space is composed of red, green, and blue component values. Each color component is expressed as a numeric value within the range of 0 to 65535. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMRGBColor {
   UInt16 red;
   UInt16 green;
   UInt16 blue;
};
typedef struct CMRGBColor CMRGBColor;


/*CMBufferLocation


struct CMBufferLocation {
   void * buffer;
   UInt32 size;
};
typedef struct CMBufferLocation CMBufferLocation;
Fields
buffer
size
Availability
Available in Mac OS X v10.0 and later.*/
struct CMBufferLocation {
   void * buffer;
   UInt32 size;
};
typedef struct CMBufferLocation CMBufferLocation;

/*CMPathLocation

Contains path information.

struct CMPathLocation {
   char path[256];
};
typedef struct CMPathLocation CMPathLocation;
Fields
path
Availability
Available in Mac OS X v10.0 and later*/
struct CMPathLocation {
   char path[256];
};
typedef struct CMPathLocation CMPathLocation;

/*CMProfileAccessUPP

Defines a universal procedure pointer to a profile access callback.

typedef CMProfileAccessProcPtr CMProfileAccessUPP;
Discussiontypedef CMProfileAccessProcPtr CMProfileAccessUPP;

For more information, see the description of the CMProfileAccessProcPtr ) callback function.*/
typedef CMProfileAccessProcPtr CMProfileAccessUPP;

/*CMFileLocation

Contains a file specification for a profile stored in a disk file.

struct CMFileLocation {
   FSSpec spec;
};
typedef struct CMFileLocation CMFileLocation;
Fields
spec

A file system specification structure giving the location of the profile file. A file specification structure includes the volume reference number, the directory ID of the parent directory, and the filename or directory name. See the File Manager documentation for a description of the FSSpec data type.
Discussion

Your application uses the CMFileLocation structure to provide a file specification for a profile stored in a disk file. You provide a file specification structure in the CMProfileLocation structure’s u field to specify the location of an existing profile or a profile to be created. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMFileLocation {
   FSSpec spec;
};
typedef struct CMFileLocation CMFileLocation;

/*CMPtrLocation

Contains a pointer specification for a profile stored in nonrelocatable memory. 

struct CMPtrLocation {
   Ptr p;
};
typedef struct CMPtrLocation CMPtrLocation;
Fields
p

A data structure of type Ptr holding a pointer that points to the location of a profile in memory.
Discussion

Your application uses the CMPtrLocation structure to provide a pointer specification for a profile stored in nonrelocatable memory. You provide the pointer specification structure in the CMProfileLocation structure’s u field to point to an existing profile. 
Availability
Available in Mac OS X v10.0 and later*/
struct CMPtrLocation {
   Ptr p;
};
typedef struct CMPtrLocation CMPtrLocation;

/*CMProcedureLocation

Contains a universal procedure pointer to a profile access procedure. 

struct CMProcedureLocation {
   CMProfileAccessUPP proc;
   void * refCon;
};
typedef struct CMProcedureLocation CMProcedureLocation;
Fields
proc

A universal procedure pointer to a profile access procedure. For a description of the procedure, see the function CMProfileAccessProcPtr. 
refCon

A pointer to the profile access procedure’s private data, such as a file or resource name, a pointer to a current offset, and so on.
Discussion

Your application uses the CMProcedureLocation structure to provide a universal procedure pointer to a profile access procedure. You provide this structure in the CMProfileLocation structure’s u field. The CMProcedureLocation structure also contains a pointer field to specify data associated with the profile access procedure.

The ColorSync Manager calls your profile access procedure when the profile is created, initialized, opened, read, updated, or closed. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMProcedureLocation {
   CMProfileAccessUPP proc;
   void * refCon;
};
typedef struct CMProcedureLocation CMProcedureLocation;


/*CMHandleLocation

Contains a handle specification for a profile stored in relocatable memory. 

struct CMHandleLocation {
   Handle h;
};
typedef struct CMHandleLocation CMHandleLocation;
Fields
h

A data structure of type Handle containing a handle that indicates the location of a profile in memory.
Discussion

Your application uses the CMHandleLocation structure to provide a handle specification for a profile stored in relocatable memory. You provide the handle specification structure in the CMProfileLocation structure’s u field to specify an existing profile or a profile to be created. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMHandleLocation {
   Handle h;
};
typedef struct CMHandleLocation CMHandleLocation;

/*CMProfLoc

Defines a uniont that identifies the location of a profile. 

union CMProfLoc {
   CMFileLocation fileLoc;
   CMHandleLocation handleLoc;
   CMPtrLocation ptrLoc;
   CMProcedureLocation procLoc;
   CMPathLocation pathLoc;
   CMBufferLocation bufferLoc;
};
typedef union CMProfLoc CMProfLoc;
Fields
fileLoc

A data structure containing a file system specification record specifying the location of a profile disk file. 
handleLoc

A data structure containing a handle that indicates the location of a profile in relocatable memory. 
ptrLoc

A data structure containing a pointer that points to a profile in nonrelocatable memory. 
procLoc

A data structure containing a universal procedure pointer that points to a profile access procedure supplied by you. The ColorSync Manager calls your procedure when the profile is created, initialized, opened, read, updated, or closed. 
pathLoc
bufferLoc
Discussion

You use a union of type CMProfLoc to identify the location of a profile. You specify the union in the u field of the data type CMProfileLocation. Your application passes a pointer to a CMProfileLocation structure when it calls the CMOpenProfile function to identify the location of a profile or the CMNewProfile, CMCopyProfile , or CWNewLinkProfile functions to specify the location for a newly created profile.

You also pass a pointer to a CMProfileLocation structure to the NCMGetProfileLocation and CMGetProfileLocation functions to get the location of an existing profile. The NCMGetProfileLocation function is available starting with ColorSync version 2.5. It differs from its predecessor, CMGetProfileLocation, in that the newer version has a parameter for the size of the location structure for the specified profile. 
Availability
Available in Mac OS X v10.0 and later.*/
union CMProfLoc {
   CMFileLocation fileLoc;
   CMHandleLocation handleLoc;
   CMPtrLocation ptrLoc;
   CMProcedureLocation procLoc;
   CMPathLocation pathLoc;
   CMBufferLocation bufferLoc;
};
typedef union CMProfLoc CMProfLoc;


/*CMProfileLocation

Contains profile location information.

struct CMProfileLocation {
   short locType;
   CMProfLoc u;
};
typedef struct CMProfileLocation CMProfileLocation;
Fields
locType

The type of data structure that the u field’s CMProfLoc union holds—a file specification, a handle, a pointer, or a universal procedure pointer. To specify the type, you use the constants defined in the enumeration described in “Profile Location Type”.
u

A union of type CMProfLoc identifying the profile location. 
Discussion

Your application passes a profile location structure of type CMProfileLocation when it calls:
the function CMOpenProfile, specifying the location of a profile to open 
the CMNewProfile, CWNewLinkProfile, or CMCopyProfile functions, specifying the location of a profile to create or duplicate 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMProfileLocation {
   short locType;
   CMProfLoc u;
};
typedef struct CMProfileLocation CMProfileLocation;

/*CMColor

Defines a union that can be used to specify a color value defined by one of the 15 data types supported by the union. 

union CMColor {
   CMRGBColor rgb;
   CMHSVColor hsv;
   CMHLSColor hls;
   CMXYZColor XYZ;
   CMLabColor Lab;
   CMLuvColor Luv;
   CMYxyColor Yxy;
   CMCMYKColor cmyk;
   CMCMYColor cmy;
   CMGrayColor gray;
   CMMultichannel5Color mc5;
   CMMultichannel6Color mc6;
   CMMultichannel7Color mc7;
   CMMultichannel8Color mc8;
   CMNamedColor namedColor;
};
typedef union CMColor CMColor;
Fields
rgb

A color value expressed in the RGB color space as data of type CMRGBColor. 
hsv

A color value expressed in the HSV color space as data of type CMHSVColor. 
hls

A color value expressed in the HLS color space as data of type CMHLSColor. 
XYZ

A color value expressed in the XYZ color space as data of type CMXYZColor. 
Lab

A color value expressed in the L*a*b* color space as data of type CMLabColor. 
Luv

A color value expressed in the L*u*v* color space as data of type CMLuvColor. 
Yxy

A color value expressed in the Yxy color space as data of type CMYxyColor. 
cmyk

A color value expressed in the CMYK color space as data of type CMCMYKColor. 
cmy

A color value expressed in the CMY color space as data of type CMCMYColor. 
gray

A color value expressed in the Gray color space as data of type CMGrayColor. 
mc5

A color value expressed in the five-channel multichannel color space as data of type CMMultichannel5Color. See CMMultichannel5Color for a description of the CMMultichannel5Color data type. 
mc6

A color value expressed in the six-channel multichannel color space as data of type CMMultichannel6Color. See CMMultichannel6Color for a description of the CMMultichannel6Color data type. 
mc7

A color value expressed in the seven-channel multichannel color space as data of type CMMultichannel7Color. See CMMultichannel7Color for a description of the CMMultichannel7Color data type. 
mc8

A color value expressed in the eight-channel multichannel color space as data of type CMMultichannel8Color. See CMMultichannel8Color for a description of the CMMultichannel8Color data type. 
namedColor

A color value expressed as an index into a named color space. See CMNamedColor for a description of the CMNamedColor data type. 
Discussion

A color union can contain one of the above fields.

Your application can use a union of type CMColor to specify a color value defined by one of the 15 data types supported by the union. Your application uses an array of color unions to specify a list of colors to match, check, or convert. The array is passed as a parameter to the general purpose color matching, color checking, or color conversion functions. The following functions use a color union:
The function CWMatchColors matches the colors in the color list array to the data color space of the destination profile specified by the color world. 
The function CWCheckColors checks the colors in the color list array against the color gamut specified by the color world’s destination profile. 
The color conversion functions, described in “Converting Between Color Spaces”, take source and destination array parameters of type CMColor specifying lists of colors to convert from one color space to another. 

You do not use a union of type CMColor to convert colors expressed in the XYZ color space as values of type CMFixedXYZ because the CMColor union does not support the CMFixedXYZ data type. 
Availability
Available in Mac OS X v10.0 and later.*/
union CMColor {
   CMRGBColor rgb;
   CMHSVColor hsv;
   CMHLSColor hls;
   CMXYZColor XYZ;
   CMLabColor Lab;
   CMLuvColor Luv;
   CMYxyColor Yxy;
   CMCMYKColor cmyk;
   CMCMYColor cmy;
   CMGrayColor gray;
   CMMultichannel5Color mc5;
   CMMultichannel6Color mc6;
   CMMultichannel7Color mc7;
   CMMultichannel8Color mc8;
   CMNamedColor namedColor;
};
typedef union CMColor CMColor;

/*Color Packing for Color Spaces

Specify how color values are stored.

enum {
   cmNoColorPacking = 0x0000,
   cmWord5ColorPacking = 0x0500,
   cmWord565ColorPacking = 0x0600,
   cmLong8ColorPacking = 0x0800,
   cmLong10ColorPacking = 0x0A00,
   cmAlphaFirstPacking = 0x1000,
   cmOneBitDirectPacking = 0x0B00,
   cmAlphaLastPacking = 0x0000,
   cm8_8ColorPacking = 0x2800,
   cm16_8ColorPacking = 0x2000,
   cm24_8ColorPacking = 0x2100,
   cm32_8ColorPacking = cmLong8ColorPacking,
   cm40_8ColorPacking = 0x2200,
   cm48_8ColorPacking = 0x2300,
   cm56_8ColorPacking = 0x2400,
   cm64_8ColorPacking = 0x2500,
   cm32_16ColorPacking = 0x2600,
   cm48_16ColorPacking = 0x2900,
   cm64_16ColorPacking = 0x2A00,
   cm32_32ColorPacking = 0x2700,
   cmLittleEndianPacking = 0x4000,
   cmReverseChannelPacking = 0x8000
};
Constants
cmNoColorPacking

This constant is not used for ColorSync bitmaps.

Available in Mac OS X v10.0 and later.
cmWord5ColorPacking

The color values for three 5-bit color channels are stored consecutively in 16-bits, with the highest order bit unused.

Available in Mac OS X v10.0 and later.
cmWord565ColorPacking

Available in Mac OS X v10.0 and later.
cmLong8ColorPacking

The color values for three or four 8-bit color channels are stored consecutively in a 32-bit long. For three channels, this constant is combined with either cmAlphaFirstPacking or cmAlphaLastPacking to indicate whether the unused eight bits are located at the beginning or end.

Available in Mac OS X v10.0 and later.
cmLong10ColorPacking

The color values for three 10-bit color channels are stored consecutively in a 32-bit long, with the two highest order bits unused.

Available in Mac OS X v10.0 and later.
cmAlphaFirstPacking

An alpha channel is added to the color value as its first component.

Available in Mac OS X v10.0 and later.
cmOneBitDirectPacking

One bit is used as the pixel format. This storage format is used by the resulting bitmap pointed to by the resultBitMap field of the function CWMatchColors; the bitmap must be only 1 bit deep.

Available in Mac OS X v10.0 and later.
cmAlphaLastPacking

Available in Mac OS X v10.0 and later.
cm8_8ColorPacking

Available in Mac OS X v10.0 and later.
cm16_8ColorPacking

Available in Mac OS X v10.0 and later.
cm24_8ColorPacking

The color values for three 8-bit color channels are stored in consecutive bytes, for a total of 24 bits.

Available in Mac OS X v10.0 and later.
cm32_8ColorPacking

The color values for four 8-bit color channels are stored in consecutive bytes, for a total of 32 bits.

Available in Mac OS X v10.0 and later.
cm40_8ColorPacking

The color values for five 8-bit color channels are stored in consecutive bytes, for a total of 40 bits.

Available in Mac OS X v10.0 and later.
cm48_8ColorPacking

The color values for six 8-bit color channels are stored in consecutive bytes, for a total of 48 bits.

Available in Mac OS X v10.0 and later.
cm56_8ColorPacking

The color values for seven 8-bit color channels are stored in consecutive bytes, for a total of 56 bits.

Available in Mac OS X v10.0 and later.
cm64_8ColorPacking

The color values for eight 8-bit color channels are stored in consecutive bytes, for a total of 64 bits.

Available in Mac OS X v10.0 and later.
cm32_16ColorPacking

The color values for two 16-bit color channels are stored in a 32-bit word.

Available in Mac OS X v10.0 and later.
cm48_16ColorPacking

The color values for three 16-bit color channels are stored in 48 consecutive bits.

Available in Mac OS X v10.0 and later.
cm64_16ColorPacking

The color values for four 16-bit color channels are stored in 64 consecutive bits.

Available in Mac OS X v10.0 and later.
cm32_32ColorPacking

The color value for a 32-bit color channel is stored in a 32-bit word.

Available in Mac OS X v10.0 and later.
cmLittleEndianPacking

Available in Mac OS X v10.0 and later.
cmReverseChannelPacking

Available in Mac OS X v10.0 and later.
Discussion

The ColorSync bitmap data type CMBitmap includes a field that identifies the color space in which the color values of the bitmap image are expressed. This enumeration defines the types of packing for a color space’s storage format. The enumeration also defines an alpha channel that can be added as a component of a color value to define the degree of opacity or transparency of a color. These constants are combined with the constants described in “Abstract Color Space Constants” to create values that identify a bitmap’s color space. Your application does not specify color packing constants directly, but rather uses the combined constants, which are described in “Color Space Constants With Packing Formats”.
Version Notes

The constants cm48_16ColorPacking and cm64_16ColorPacking were added in ColorSync version 2.5.*/

enum {
   cmNoColorPacking = 0x0000,
   cmWord5ColorPacking = 0x0500,
   cmWord565ColorPacking = 0x0600,
   cmLong8ColorPacking = 0x0800,
   cmLong10ColorPacking = 0x0A00,
   cmAlphaFirstPacking = 0x1000,
   cmOneBitDirectPacking = 0x0B00,
   cmAlphaLastPacking = 0x0000,
   cm8_8ColorPacking = 0x2800,
   cm16_8ColorPacking = 0x2000,
   cm24_8ColorPacking = 0x2100,
   cm32_8ColorPacking = cmLong8ColorPacking,
   cm40_8ColorPacking = 0x2200,
   cm48_8ColorPacking = 0x2300,
   cm56_8ColorPacking = 0x2400,
   cm64_8ColorPacking = 0x2500,
   cm32_16ColorPacking = 0x2600,
   cm48_16ColorPacking = 0x2900,
   cm64_16ColorPacking = 0x2A00,
   cm32_32ColorPacking = 0x2700,
   cmLittleEndianPacking = 0x4000,
   cmReverseChannelPacking = 0x8000
};


/*Abstract Color Space Constants

Specify values that represent general color spaces.

enum {
   cmNoSpace = 0x0000,
   cmRGBSpace = 0x0001,
   cmCMYKSpace = 0x0002,
   cmHSVSpace = 0x0003,
   cmHLSSpace = 0x0004,
   cmYXYSpace = 0x0005,
   cmXYZSpace = 0x0006,
   cmLUVSpace = 0x0007,
   cmLABSpace = 0x0008,
   cmReservedSpace1 = 0x0009,
   cmGraySpace = 0x000A,
   cmReservedSpace2 = 0x000B,
   cmGamutResultSpace = 0x000C,
   cmNamedIndexedSpace = 0x0010,
   cmMCFiveSpace = 0x0011,
   cmMCSixSpace = 0x0012,
   cmMCSevenSpace = 0x0013,
   cmMCEightSpace = 0x0014,
   cmAlphaPmulSpace = 0x0040,
   cmAlphaSpace = 0x0080,
   cmRGBASpace = cmRGBSpace + cmAlphaSpace,
   cmGrayASpace = cmGraySpace + cmAlphaSpace,
   cmRGBAPmulSpace = cmRGBASpace + cmAlphaPmulSpace,
   cmGrayAPmulSpace = cmGrayASpace + cmAlphaPmulSpace
};
Constants
cmNoSpace

The ColorSync Manager does not use this constant.

Available in Mac OS X v10.0 and later.
cmRGBSpace

An RGB color space composed of red, green, and blue components. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component.

Available in Mac OS X v10.0 and later.
cmCMYKSpace

A CMYK color space composed of cyan, magenta, yellow, and black. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component.

Available in Mac OS X v10.0 and later.
cmHSVSpace

An HSV color space composed of hue, saturation, and value components. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component.

Available in Mac OS X v10.0 and later.
cmHLSSpace

An HLS color space composed of hue, lightness, and saturation components. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component.

Available in Mac OS X v10.0 and later.
cmYXYSpace

A Yxy color space composed of Y, x, and y components. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component.

Available in Mac OS X v10.0 and later.
cmXYZSpace

An XYZ color space composed of X, Y, and Z components. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component.

Available in Mac OS X v10.0 and later.
cmLUVSpace

An L*u*v* color space composed of L*, u*, and v* components. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component. 

Available in Mac OS X v10.0 and later.
cmLABSpace

An L*a*b* color space composed of L*, a*, b* components. A bitmap never uses this constant alone. Instead, this color space is always combined with a packing format describing the amount of storage per component.

Available in Mac OS X v10.0 and later.
cmReservedSpace1

This field is reserved for use by QuickDraw GX. 

Available in Mac OS X v10.0 and later.
cmGraySpace

A luminance color space with a single component, gray. 

Available in Mac OS X v10.0 and later.
cmReservedSpace2

This field is reserved for use by QuickDraw GX.

Available in Mac OS X v10.0 and later.
cmGamutResultSpace

A color space for the resulting bitmap pointed to by the resultBitMap field of the function CWMatchColors. A bitmap never uses this constant alone. Instead, it uses the constant cmGamutResult1Space, which combines cmGamutResultSpace and cmOneBitDirectPacking to define a bitmap that is 1 bit deep.

Available in Mac OS X v10.0 and later.
cmNamedIndexedSpace

A named indexed color space.

Available in Mac OS X v10.0 and later.
cmMCFiveSpace

A five-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCSixSpace

A six-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCSevenSpace

A seven-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCEightSpace

An eight-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmAlphaPmulSpace

A premultiplied alpha channel component is added to the color value.

Available in Mac OS X v10.0 and later.
cmAlphaSpace

An alpha channel component is added to the color value. 

Available in Mac OS X v10.0 and later.
cmRGBASpace

An RGB color space composed of red, green, and blue color value components and an alpha channel component. ColorSync does not currently support bitmaps that use this constant alone. Instead, this constant indicates the presence of an alpha channel in combination with cmLong8ColorPacking to indicate 8-bit packing format and cmAlphaFirstPacking to indicate the position of the alpha channel as the first component.

Available in Mac OS X v10.0 and later.
cmGrayASpace

A luminance color space with two components, a gray component followed by an alpha channel component. Each component value is 16 bits.

Available in Mac OS X v10.0 and later.
cmRGBAPmulSpace

Available in Mac OS X v10.0 and later.
cmGrayAPmulSpace

Available in Mac OS X v10.0 and later.
Discussion

The data type CMBitmap defines a bitmap for an image whose colors can be matched with the function CWMatchColors or color-checked with the function CWCheckColors.

The space field of the CMBitmap type definition identifies the color space in which the colors of the bitmap image are specified. A color space is characterized by a number of components or dimensions, with each component carrying a numeric value. These values together make up the color value. A color space also specifies the format in which the color value is stored. For bitmaps in which color values are packed, the space field of the CMBitmap data type holds a constant that defines the color space and the packing format.

For the CWMatchBitmap function to perform color matching successfully, the color space specified in the CMBitmap data type’s space field must correspond to the color space specified in the profile’s dataColorSpace field. The source bitmap and source profile values must match and the destination bitmap and destination profile values must match. For the CWCheckBitMap function to perform color checking successfully, the source profile’s dataColorSpace field value and the space field value of the source bitmap must specify the same color space. These functions will execute successfully as long as the color spaces are the same without regard for the packing format specified by the bitmap.

This enumeration defines constants for abstract color spaces which, when combined with a packing format constant as described in “Color Packing for Color Spaces”, can be used in the space field of the CMBitmap structure. The combined constants are shown in “Color Space Constants With Packing Formats”.
Version Notes

The constants cmRGBASpace and cmGrayASpace were moved to this enum from “Color Space Constants With Packing Formats” in ColorSync version 2.5.*/


enum {
   cmNoSpace = 0x0000,
   cmRGBSpace = 0x0001,
   cmCMYKSpace = 0x0002,
   cmHSVSpace = 0x0003,
   cmHLSSpace = 0x0004,
   cmYXYSpace = 0x0005,
   cmXYZSpace = 0x0006,
   cmLUVSpace = 0x0007,
   cmLABSpace = 0x0008,
   cmReservedSpace1 = 0x0009,
   cmGraySpace = 0x000A,
   cmReservedSpace2 = 0x000B,
   cmGamutResultSpace = 0x000C,
   cmNamedIndexedSpace = 0x0010,
   cmMCFiveSpace = 0x0011,
   cmMCSixSpace = 0x0012,
   cmMCSevenSpace = 0x0013,
   cmMCEightSpace = 0x0014,
   cmAlphaPmulSpace = 0x0040,
   cmAlphaSpace = 0x0080,
   cmRGBASpace = cmRGBSpace + cmAlphaSpace,
   cmGrayASpace = cmGraySpace + cmAlphaSpace,
   cmRGBAPmulSpace = cmRGBASpace + cmAlphaPmulSpace,
   cmGrayAPmulSpace = cmGrayASpace + cmAlphaPmulSpace
};


/*Color Space Constants With Packing Formats

Specifies bitmap spaces with a wide range of data formats appropriate for multiple platforms.

enum {
   cmGray8Space = cmGraySpace + cm8_8ColorPacking,
   cmGray16Space = cmGraySpace,
   cmGray16LSpace = cmGraySpace + cmLittleEndianPacking,
   cmGrayA16Space = cmGrayASpace + cm16_8ColorPacking,
   cmGrayA32Space = cmGrayASpace,
   cmGrayA32LSpace = cmGrayASpace + cmLittleEndianPacking,
   cmGrayA16PmulSpace = cmGrayAPmulSpace + cm16_8ColorPacking,
   cmGrayA32PmulSpace = cmGrayAPmulSpace,
   cmGrayA32LPmulSpace = cmGrayAPmulSpace + cmLittleEndianPacking,
   cmRGB16Space = cmRGBSpace + cmWord5ColorPacking,
   cmRGB16LSpace = cmRGBSpace + cmWord5ColorPacking + cmLittleEndianPacking,
   cmRGB565Space = cmRGBSpace + cmWord565ColorPacking,
   cmRGB565LSpace = cmRGBSpace + cmWord565ColorPacking + cmLittleEndianPacking,
   cmRGB24Space = cmRGBSpace + cm24_8ColorPacking,
   cmRGB32Space = cmRGBSpace + cm32_8ColorPacking,
   cmRGB48Space = cmRGBSpace + cm48_16ColorPacking,
   cmRGB48LSpace = cmRGBSpace + cm48_16ColorPacking + cmLittleEndianPacking,
   cmARGB32Space = cmRGBASpace + cm32_8ColorPacking + cmAlphaFirstPacking,
   cmARGB64Space = cmRGBASpace + cm64_16ColorPacking + cmAlphaFirstPacking,
   cmARGB64LSpace = cmRGBASpace + cm64_16ColorPacking + cmAlphaFirstPacking
+ cmLittleEndianPacking,
   cmRGBA32Space = cmRGBASpace + cm32_8ColorPacking + cmAlphaLastPacking,
   cmRGBA64Space = cmRGBASpace + cm64_16ColorPacking + cmAlphaLastPacking,
   cmRGBA64LSpace = cmRGBASpace + cm64_16ColorPacking + cmAlphaLastPacking
+ cmLittleEndianPacking,
   cmARGB32PmulSpace = cmRGBAPmulSpace + cm32_8ColorPacking + cmAlphaFirstPacking,
   cmARGB64PmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaFirstPacking,
   cmARGB64LPmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaFirstPacking
+ cmLittleEndianPacking,
   cmRGBA32PmulSpace = cmRGBAPmulSpace + cm32_8ColorPacking + cmAlphaLastPacking,
   cmRGBA64PmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaLastPacking,
   cmRGBA64LPmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaLastPacking
+ cmLittleEndianPacking,
   cmCMYK32Space = cmCMYKSpace + cm32_8ColorPacking,
   cmCMYK64Space = cmCMYKSpace + cm64_16ColorPacking,
   cmCMYK64LSpace = cmCMYKSpace + cm64_16ColorPacking + cmLittleEndianPacking,
   cmHSV32Space = cmHSVSpace + cmLong10ColorPacking,
   cmHLS32Space = cmHLSSpace + cmLong10ColorPacking,
   cmYXY32Space = cmYXYSpace + cmLong10ColorPacking,
   cmXYZ24Space = cmXYZSpace + cm24_8ColorPacking,
   cmXYZ32Space = cmXYZSpace + cmLong10ColorPacking,
   cmXYZ48Space = cmXYZSpace + cm48_16ColorPacking,
   cmXYZ48LSpace = cmXYZSpace + cm48_16ColorPacking + cmLittleEndianPacking,
   cmLUV32Space = cmLUVSpace + cmLong10ColorPacking,
   cmLAB24Space = cmLABSpace + cm24_8ColorPacking,
   cmLAB32Space = cmLABSpace + cmLong10ColorPacking,
   cmLAB48Space = cmLABSpace + cm48_16ColorPacking,
   cmLAB48LSpace = cmLABSpace + cm48_16ColorPacking + cmLittleEndianPacking,
   cmGamutResult1Space = cmOneBitDirectPacking + cmGamutResultSpace,
   cmNamedIndexed32Space = cm32_32ColorPacking + cmNamedIndexedSpace,
   cmNamedIndexed32LSpace = cm32_32ColorPacking + cmNamedIndexedSpace
+ cmLittleEndianPacking,
   cmMCFive8Space = cm40_8ColorPacking + cmMCFiveSpace,
   cmMCSix8Space = cm48_8ColorPacking + cmMCSixSpace,
   cmMCSeven8Space = cm56_8ColorPacking + cmMCSevenSpace,
   cmMCEight8Space = cm64_8ColorPacking + cmMCEightSpace
};
typedef UInt32 CMBitmapColorSpace;
Constants
cmGray8Space

Available in Mac OS X v10.0 and later.
cmGray16Space

A luminance color space with a single 16-bit component, gray.

Available in Mac OS X v10.0 and later.
cmGray16LSpace

Available in Mac OS X v10.0 and later.
cmGrayA16Space

Available in Mac OS X v10.0 and later.
cmGrayA32Space

A luminance color space with two components, a gray component followed by an alpha channel component. Each component value is 16 bits.

Available in Mac OS X v10.0 and later.
cmGrayA32LSpace

Available in Mac OS X v10.0 and later.
cmGrayA16PmulSpace

Available in Mac OS X v10.0 and later.
cmGrayA32PmulSpace

Available in Mac OS X v10.0 and later.
cmGrayA32LPmulSpace

Available in Mac OS X v10.0 and later.
cmRGB16Space

An RGB color space composed of red, green, and blue components whose values are packed with 5 bits of storage per component. The storage size for a color value expressed in this color space is 16 bits, with the high-order bit not used.

Available in Mac OS X v10.0 and later.
cmRGB16LSpace

Available in Mac OS X v10.0 and later.
cmRGB565Space

Available in Mac OS X v10.0 and later.
cmRGB565LSpace

Available in Mac OS X v10.0 and later.
cmRGB24Space

An RGB color space composed of red, green, and blue components whose values are packed with 8 bits of storage per component. The storage size for a color value expressed in this color space is 24 bits.

Available in Mac OS X v10.0 and later.
cmRGB32Space

An RGB color space composed of red, green, and blue components whose values are packed with 8 bits of storage per component. The storage size for a color value expressed in this color space is 32 bits, with bits 24-31 not used.

Available in Mac OS X v10.0 and later.
cmRGB48Space

An RGB color space composed of red, green, and blue components whose values are packed with 16 bits of storage per component. The storage size for a color value expressed in this color space is 48 bits.

Available in Mac OS X v10.0 and later.
cmRGB48LSpace

Available in Mac OS X v10.0 and later.
cmARGB32Space

An RGB color space composed of red, green, and blue color value components preceded by an alpha channel component whose values are packed with 8 bits of storage per component. The storage size for a color value expressed in this color space is 32 bits.

Available in Mac OS X v10.0 and later.
cmARGB64Space

Available in Mac OS X v10.0 and later.
cmARGB64LSpace

Available in Mac OS X v10.0 and later.
cmRGBA32Space

An RGB color space composed of red, green, and blue color value components, followed by an alpha channel component. Values are packed with 8 bits of storage per component. The storage size for a color value expressed in this color space is 32 bits.

Available in Mac OS X v10.0 and later.
cmRGBA64Space

Available in Mac OS X v10.0 and later.
cmRGBA64LSpace

Available in Mac OS X v10.0 and later.
cmARGB32PmulSpace

Available in Mac OS X v10.0 and later.
cmARGB64PmulSpace

Available in Mac OS X v10.0 and later.
cmARGB64LPmulSpace

Available in Mac OS X v10.0 and later.
cmRGBA32PmulSpace

Available in Mac OS X v10.0 and later.
cmRGBA64PmulSpace

Available in Mac OS X v10.0 and later.
cmRGBA64LPmulSpace

Available in Mac OS X v10.0 and later.
cmCMYK32Space

A CMYK color space composed of cyan, magenta, yellow, and black components whose values are packed with 8 bits of storage per component. The storage size for a color value expressed in this color space is 32 bits.

Available in Mac OS X v10.0 and later.
cmCMYK64Space

A CMYK color space composed of cyan, magenta, yellow, and black components whose values are packed with 16 bits of storage per component. The storage size for a color value expressed in this color space is 64 bits.

Available in Mac OS X v10.0 and later.
cmCMYK64LSpace

Available in Mac OS X v10.0 and later.
cmHSV32Space

An HSV color space composed of hue, saturation, and value components whose values are packed with 10 bits of storage per component. The storage size for a color value expressed in this color space is 32 bits, with the high-order 2 bits not used.

Available in Mac OS X v10.0 and later.
cmHLS32Space

An HLS color space composed of hue, lightness, and saturation components whose values are packed with 10 bits of storage per component. The storage size for a color value expressed in this color space is 32 bits, with the high-order 2 bits not used.

Available in Mac OS X v10.0 and later.
cmYXY32Space

A Yxy color space composed of Y, x, and y components whose values are packed with 10 bits of storage per component. The storage size for a color value expressed in this color space is 32 bits, with the high-order 2 bits not used.

Available in Mac OS X v10.0 and later.
cmXYZ24Space

Available in Mac OS X v10.0 and later.
cmXYZ32Space

An XYZ color space composed of X, Y, and Z components whose values are packed with 10 bits per component. The storage size for a color value expressed in this color space is 32 bits, with the high-order 2 bits not used.

Available in Mac OS X v10.0 and later.
cmXYZ48Space

Available in Mac OS X v10.0 and later.
cmXYZ48LSpace

Available in Mac OS X v10.0 and later.
cmLUV32Space

An L*u*v* color space composed of L*, u*, and v* components whose values are packed with 10 bits per component. The storage size for a color value expressed in this color space is 32 bits, with the high-order 2 bits not used.

Available in Mac OS X v10.0 and later.
cmLAB24Space

An L*a*b* color space composed of L*, a*, and b* components whose values are packed with 8 bits per component. The storage size for a color value expressed in this color space is 24 bits. The 8-bit unsigned a* and b* channels are interpreted numerically as ranging from -128.0 to approximately 128.0.

Available in Mac OS X v10.0 and later.
cmLAB32Space

An L*a*b* color space composed of L*, a*, and b* components whose values are packed with 10 bits per component. The storage size for a color value expressed in this color space is 32 bits, with the high-order 2 bits not used. The 10-bit unsigned a* and b* channels are interpreted numerically as ranging from -128.0 to approximately 128.0.

Available in Mac OS X v10.0 and later.
cmLAB48Space

An L*a*b* color space composed of L*, a*, and b* components whose values are packed with 16 bits per component. The storage size for a color value expressed in this color space is 48 bits. The 16-bit unsigned a* and b* channels are interpreted numerically as ranging from -128.0 to approximately 128.0.

Available in Mac OS X v10.0 and later.
cmLAB48LSpace

Available in Mac OS X v10.0 and later.
cmGamutResult1Space

A gamut result color space for the resulting bitmap pointed to by the resultBitMap field of the function CWMatchColors, with 1-bit direct packing. A pixel in the returned bitmap with value 1 (displayed as black) indicates an out-of-gamut color, while a pixel value of 0 (white) indicates a color that is in gamut.

Available in Mac OS X v10.0 and later.
cmNamedIndexed32Space

A color space where each color is stored as a single 32-bit value, specifying an index into a named color space. The storage size for a color value expressed in this color space is 32 bits.

Available in Mac OS X v10.0 and later.
cmNamedIndexed32LSpace

Available in Mac OS X v10.0 and later.
cmMCFive8Space

A five-channel multichannel (HiFi) data color space, whose values are packed with 8 bits per component. The storage size for a color value expressed in this color space is 40 bits.

Available in Mac OS X v10.0 and later.
cmMCSix8Space

A six-channel multichannel (HiFi) data color space, whose values are packed with 8 bits per component. The storage size for a color value expressed in this color space is 48 bits.

Available in Mac OS X v10.0 and later.
cmMCSeven8Space

A seven-channel multichannel (HiFi) data color space, whose values are packed with 8 bits per component. The storage size for a color value expressed in this color space is 56 bits.

Available in Mac OS X v10.0 and later.
cmMCEight8Space

A eight-channel multichannel (HiFi) data color space, whose values are packed with 8 bits per component. The storage size for a color value expressed in this color space is 64 bits.

Available in Mac OS X v10.0 and later.
Discussion

This enumeration defines constants for color spaces which can specify color values for a bitmap image. As a rule, these constants include a packing format, defined in “Color Packing for Color Spaces”. You can use these constants to set the space field of the CMBitmap type definition identifies the color space in which the colors of the bitmap image are specified, as described in “Abstract Color Space Constants”.
Version Notes

The constants cmRGBASpace and cmGrayASpace were moved to “Abstract Color Space Constants” in ColorSync version 2.5.

The constants cmGray16Space, cmGrayA32Space, cmRGB48Space, cmCMYK64Space, and cmLAB48Space were added in ColorSync version 2.5.*/
enum {
   cmGray8Space = cmGraySpace + cm8_8ColorPacking,
   cmGray16Space = cmGraySpace,
   cmGray16LSpace = cmGraySpace + cmLittleEndianPacking,
   cmGrayA16Space = cmGrayASpace + cm16_8ColorPacking,
   cmGrayA32Space = cmGrayASpace,
   cmGrayA32LSpace = cmGrayASpace + cmLittleEndianPacking,
   cmGrayA16PmulSpace = cmGrayAPmulSpace + cm16_8ColorPacking,
   cmGrayA32PmulSpace = cmGrayAPmulSpace,
   cmGrayA32LPmulSpace = cmGrayAPmulSpace + cmLittleEndianPacking,
   cmRGB16Space = cmRGBSpace + cmWord5ColorPacking,
   cmRGB16LSpace = cmRGBSpace + cmWord5ColorPacking + cmLittleEndianPacking,
   cmRGB565Space = cmRGBSpace + cmWord565ColorPacking,
   cmRGB565LSpace = cmRGBSpace + cmWord565ColorPacking + cmLittleEndianPacking,
   cmRGB24Space = cmRGBSpace + cm24_8ColorPacking,
   cmRGB32Space = cmRGBSpace + cm32_8ColorPacking,
   cmRGB48Space = cmRGBSpace + cm48_16ColorPacking,
   cmRGB48LSpace = cmRGBSpace + cm48_16ColorPacking + cmLittleEndianPacking,
   cmARGB32Space = cmRGBASpace + cm32_8ColorPacking + cmAlphaFirstPacking,
   cmARGB64Space = cmRGBASpace + cm64_16ColorPacking + cmAlphaFirstPacking,
   cmARGB64LSpace = cmRGBASpace + cm64_16ColorPacking + cmAlphaFirstPacking
+ cmLittleEndianPacking,
   cmRGBA32Space = cmRGBASpace + cm32_8ColorPacking + cmAlphaLastPacking,
   cmRGBA64Space = cmRGBASpace + cm64_16ColorPacking + cmAlphaLastPacking,
   cmRGBA64LSpace = cmRGBASpace + cm64_16ColorPacking + cmAlphaLastPacking
+ cmLittleEndianPacking,
   cmARGB32PmulSpace = cmRGBAPmulSpace + cm32_8ColorPacking + cmAlphaFirstPacking,
   cmARGB64PmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaFirstPacking,
   cmARGB64LPmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaFirstPacking
+ cmLittleEndianPacking,
   cmRGBA32PmulSpace = cmRGBAPmulSpace + cm32_8ColorPacking + cmAlphaLastPacking,
   cmRGBA64PmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaLastPacking,
   cmRGBA64LPmulSpace = cmRGBAPmulSpace + cm64_16ColorPacking + cmAlphaLastPacking
+ cmLittleEndianPacking,
   cmCMYK32Space = cmCMYKSpace + cm32_8ColorPacking,
   cmCMYK64Space = cmCMYKSpace + cm64_16ColorPacking,
   cmCMYK64LSpace = cmCMYKSpace + cm64_16ColorPacking + cmLittleEndianPacking,
   cmHSV32Space = cmHSVSpace + cmLong10ColorPacking,
   cmHLS32Space = cmHLSSpace + cmLong10ColorPacking,
   cmYXY32Space = cmYXYSpace + cmLong10ColorPacking,
   cmXYZ24Space = cmXYZSpace + cm24_8ColorPacking,
   cmXYZ32Space = cmXYZSpace + cmLong10ColorPacking,
   cmXYZ48Space = cmXYZSpace + cm48_16ColorPacking,
   cmXYZ48LSpace = cmXYZSpace + cm48_16ColorPacking + cmLittleEndianPacking,
   cmLUV32Space = cmLUVSpace + cmLong10ColorPacking,
   cmLAB24Space = cmLABSpace + cm24_8ColorPacking,
   cmLAB32Space = cmLABSpace + cmLong10ColorPacking,
   cmLAB48Space = cmLABSpace + cm48_16ColorPacking,
   cmLAB48LSpace = cmLABSpace + cm48_16ColorPacking + cmLittleEndianPacking,
   cmGamutResult1Space = cmOneBitDirectPacking + cmGamutResultSpace,
   cmNamedIndexed32Space = cm32_32ColorPacking + cmNamedIndexedSpace,
   cmNamedIndexed32LSpace = cm32_32ColorPacking + cmNamedIndexedSpace
+ cmLittleEndianPacking,
   cmMCFive8Space = cm40_8ColorPacking + cmMCFiveSpace,
   cmMCSix8Space = cm48_8ColorPacking + cmMCSixSpace,
   cmMCSeven8Space = cm56_8ColorPacking + cmMCSevenSpace,
   cmMCEight8Space = cm64_8ColorPacking + cmMCEightSpace
};
typedef UInt32 CMBitmapColorSpace;



/*CMBitmap

Contains information that describes color bitmap images.

struct CMBitmap {
   char * image;
   long width;
   long height;
   long rowBytes;
   long pixelSize;
   CMBitmapColorSpace space;
   long user1;
   long user2;
};
typedef struct CMBitmap CMBitmap;
Fields
image

A pointer to a bit image.
width

The width of the bit image, that is, the number of pixels in a row.
height

The height of the bit image, that is, the number of rows in the image.
rowBytes

The offset in bytes from one row of the image to the next.
pixelSize

The number of bits per pixel. The pixel size should correspond to the packing size specified in the space field. This requirement is not enforced as of ColorSync version 2.5, but it may be enforced in future versions.
space

The color space in which the colors of the bitmap image are specified. For a description of the possible color spaces for color bitmaps, see “Color Space Constants With Packing Formats”. 
user1

Not used by ColorSync. It is recommended that you set this field to 0.
user2

Not used by ColorSync. It is recommended that you set this field to 0.
Discussion

The ColorSync Manager defines a bitmap structure of type CMBitmap to describe color bitmap images. When your application calls the function CWMatchColors , you pass a pointer to a source bitmap of type CMBitmap containing the image whose colors are to be matched to the color gamut of the device specified by the destination profile of the given color world. If you do not want the image color matched in place, you can also pass a pointer to a resulting bitmap of type CMBitmap to define and hold the color-matched image. 

For QuickDraw GX, an image can have an indexed bitmap to a list of colors. The ColorSync Manager does not support indexed bitmaps in the same way QuickDraw GX does. ColorSync supports indexed bitmaps only when the cmNamedIndexed32Space color space constant is used in conjunction with a named color space profile. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CMBitmap {
   char * image;
   long width;
   long height;
   long rowBytes;
   long pixelSize;
   CMBitmapColorSpace space;
   long user1;
   long user2;
};
typedef struct CMBitmap CMBitmap;

/*NCMConcatProfileSpec


struct NCMConcatProfileSpec {
   UInt32 renderingIntent;
   UInt32 transformTag;
   CMProfileRef profile;
};
typedef struct NCMConcatProfileSpec NCMConcatProfileSpec;
Fields
renderingIntent
transformTag
profile
Availability
Available in Mac OS X v10.0 and later.*/
struct NCMConcatProfileSpec {
   UInt32 renderingIntent;
   UInt32 transformTag;
   CMProfileRef profile;
};
typedef struct NCMConcatProfileSpec NCMConcatProfileSpec;


/*Profile Concatenation Values

Specify values to use when concatnating profiles.

enum {
   kNoTransform = 0,
   kUseAtoB = 1,
   kUseBtoA = 2,
   kUseBtoB = 3,
   kDeviceToPCS = kUseAtoB,
   kPCSToDevice = kUseBtoA,
   kPCSToPCS = kUseBtoB,
   kUseProfileIntent = 0xFFFFFFFF
};
Constants
kNoTransform

Not used.

Available in Mac OS X v10.0 and later.
kUseAtoB

Use 'A2B*' tag from this profile or equivalent

Available in Mac OS X v10.0 and later.
kUseBtoA

Use 'B2A*' tag from this profile or equivalent

Available in Mac OS X v10.0 and later.
kUseBtoB

Use 'pre*' tag from this profile or equivalent

Available in Mac OS X v10.0 and later.
kDeviceToPCS

Device Dependent to Device Independent

Available in Mac OS X v10.0 and later.
kPCSToDevice

Device Independent to Device Dependent 

Available in Mac OS X v10.0 and later.
kPCSToPCS

Independent, through device's gamut

Available in Mac OS X v10.0 and later.
kUseProfileIntent

For renderingIntent in NCMConcatProfileSpec

Available in Mac OS X v10.0 and later.*/

enum {
   kNoTransform = 0,
   kUseAtoB = 1,
   kUseBtoA = 2,
   kUseBtoB = 3,
   kDeviceToPCS = kUseAtoB,
   kPCSToDevice = kUseBtoA,
   kPCSToPCS = kUseBtoB,
   kUseProfileIntent = 0xFFFFFFFF
};

/*NCMConcatProfileSet


struct NCMConcatProfileSet {
   OSType cmm;
   UInt32 flags;
   UInt32 flagsMask;
   UInt32 profileCount;
   NCMConcatProfileSpec profileSpecs[1];
};
typedef struct NCMConcatProfileSet NCMConcatProfileSet;
Fields
cmm
flags
flagsMask
profileCount
profileSpecs
Availability
Available in Mac OS X v10.0 and later.*/
struct NCMConcatProfileSet {
   OSType cmm;
   UInt32 flags;
   UInt32 flagsMask;
   UInt32 profileCount;
   NCMConcatProfileSpec profileSpecs[1];
};
typedef struct NCMConcatProfileSet NCMConcatProfileSet;

/*CMProfileIterateData

Contains a callback routine with a description of a profile that is during an iteration through the available profiles.

struct CMProfileIterateData {
   UInt32 dataVersion;
   CM2Header header;
   ScriptCode code;
   Str255 name;
   CMProfileLocation location;
   UniCharCount uniCodeNameCount;
   UniChar * uniCodeName;
   unsigned char * asciiName;
   CMMakeAndModel * makeAndModel;
   CMProfileMD5 * digest;
};
typedef struct CMProfileIterateData CMProfileIterateData;
Fields
dataVersion

A value identifying the version of the structure. Currently set to cmProfileIterateDataVersion1.
header

A ColorSync version 2.x profile header structure of type CM2Header, containing information such as the profile size, type, version, and so on. 
code

A script code identifying the script system used for the profile description. The ScriptCode data type is defined in the MacTypes.h header file.
name

The profile name, stored as a Pascal-type string (with length byte first) of up to 255 characters.
location

A structure specifying the profile location. With ColorSync 2.5, the location is always file-based, but that may not be true for future versions. Your code should always verify that the location structure contains a file specification before attempting to use it. 
uniCodeNameCount
uniCodeName
asciiName
makeAndModel
digest
TPLDEV_TYPE_WPS_SPEED
deviceData
Discussion

The ColorSync Manager defines the CMProfileIterateData structure to provide your CMProfileIterateProcPtr callback routine with a description of a profile during an iteration through the available profiles that takes place when you call CMIterateColorSyncFolder.
Availability
Available in Mac OS X v10.0 and later.*/

struct CMProfileIterateData {
   UInt32 dataVersion;
   CM2Header header;
   ScriptCode code;
   Str255 name;
   CMProfileLocation location;
   UniCharCount uniCodeNameCount;
   UniChar * uniCodeName;
   unsigned char * asciiName;
   CMMakeAndModel * makeAndModel;
   CMProfileMD5 * digest;
};
typedef struct CMProfileIterateData CMProfileIterateData;

/*CMProfileIterateProcPtr

Defines a pointer to a profile iteration callback function that the ColorSync Manager calls for each found profile file as it iterates over the available profiles.

typedef OSErr (*CMProfileIterateProcPtr)
(
   CMProfileIterateData * iterateData,
   void * refCon
);

If you name your function MyCMProfileIterateProc, you would declare it like this:

OSErr MyCMProfileIterateProc (
   CMProfileIterateData * iterateData,
   void * refCon
);
Parameters
iterateData

A pointer to a structure of type CMProfileIterateData. When the function CMIterateColorSyncFolder calls MyProfileIterateCallback, as it does once for each found profile, the structure contains key information about the profile. 
refCon

An untyped pointer to arbitrary data your application previously passed to the function CMIterateColorSyncFolder. 
Return Value

An OSErr value. If MyCMProfileIterateCallback returns an error, CMIterateColorSyncFolder stops iterating and returns the error value to its caller (presumably your code).
Discussion

When your application needs information about the profiles currently available in the profiles folder, it calls the function CMIterateColorSyncFolder , which, depending on certain conditions, calls your callback routine once for each profile. See the description of CMIterateColorSyncFolder for information on when it calls the MyCMProfileIterateCallback function.

Your MyCMProfileIterateCallback function examines the structure pointed to by the iterateData parameter to obtain information about the profile it describes. The function determines whether to do anything with that profile, such as list its name in a pop-up menu of available profiles.*/

typedef OSErr (*CMProfileIterateProcPtr)
(
   CMProfileIterateData * iterateData,
   void * refCon
);


/*CMProfileIterateUPP

Defines a universal procedure pointer to a profile iteration callback.

typedef CMProfileIterateProcPtr CMProfileIterateUPP;
Discussion

For more information, see the description of the CMProfileIterateProcPtr ) callback function.*/
typedef CMProfileIterateProcPtr CMProfileIterateUPP;


/*CMAppleProfileHeader

Defines a data structure to provide access to both version 2.x and version 1.0 profiles, as specified by the International Color Consortium.

union CMAppleProfileHeader {
   CMHeader cm1;
   CM2Header cm2;
   CM4Header cm4;
};
typedef union CMAppleProfileHeader CMAppleProfileHeader;
Fields
cm1

A version 1.0 profile header. For a description of the ColorSync version 1.0 profile header, see CMHeader. 
cm2

A current profile header. For a description of the ColorSync profile header, see CM2Header. 
cm4
Discussion

The ColorSync Manager defines the CMAppleProfileHeader structure to provide access to both version 2.x and version 1.0 profiles, as specified by the International Color Consortium. To obtain a copy of the International Color Consortium Profile Format Specification, or to get other information about the ICC, visit the ICC Web site at http://www.color.org/.
Availability
Available in Mac OS X v10.0 and later.*/
union CMAppleProfileHeader {
   CMHeader cm1;
   CM2Header cm2;
   CM4Header cm4;
};
typedef union CMAppleProfileHeader CMAppleProfileHeader;


//function

/*CMMakeProfile

Makes a display or abstract profile by modifying an existing one.

CMError CMMakeProfile(
CMProfileRef      prof,
CFDictionaryRef   spec
);
Parameters
prof

The profile to modify.
spec

A dictionary that specifies the modifications to make to the profile supplied in the prof parameter.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The function CMMakeProfile adds appropriate tags to a profile to make a display or abstract profile based on a specification dictionary you supply. 

One key in the specification dictionary must be "profileType" with a CFString value of either "abstractLab", "displayRGB" or "displayID". 

The dictionary can optionally contain these keys-value pairs:
"description", with an associated CFString value
"copyright", with an associated CFString value

For a profileType key whose value is "abstractLab", the dictionary can also contain the keys-value pairs listed in Table 1.
Table 1  Key-value pairs for “abstractLab”
Key	
Value	
Comment

"gridPoints"	
A CFNumber (SInt32) that is an odd	
Required

"proc"	
A CFNumber (SInt64) coerced from a LabToLabProcPtr data type	
Required

"refcon"	
A CFNumber (SInt64) value coerced from a void* data type	
Optional


For a profileType key whose value is "displayRGB", the dictionary can also contain the keys-value pairs listed in Table 2.
Table 2  Key-value pairs for “displayRGB”
Key	
Value	
Comment

"targetGamma"	
A CFNumber (Float), for example, 1.8 	
Optional

"targetWhite"	
A CFNumber (SInt32), for example, 6500	
Optional

"gammaR	
A CFNumber (Float), for example, 2.5	
Required

"gammaG"	
A CFNumber (Float), for example, 2.5	
Required

"gammaB"	
A CFNumber (Float), for example, 2.5	
Required

"tableChans"	
A CFNumber (SInt32), for example, 1 or 3	
Optional

"tableEntries"	
A CFNumber (SInt32), for example, 16 or 255	
Optional

"tableEntrySize"	
A CFNumber (SInt32), for example,1 or 2	
Optional

"tableData"	
A CFData (lut in RRRGGGBBB order)	
Optional

"phosphorRx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

phosphorRy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

phosphorGx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorGy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorBx"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorBy"	
A CFNumber (Float)	
Only if not supplying the phospherSet key.

"phosphorSet" 	
A CFString: "WideRGB", "700/525/450nm", "P22-EBU", "HDTV", "CCIR709", "sRGB", "AdobeRGB98" or "Trinitron" 	
Only if not supplying the phospher R, G, B keys

"whitePointx"	
A CFNumber (Float) 	
Only if not supplying a whiteTemp key

"whitePointy"	
A CFNumber (Float)	
Only if not supplying a whiteTemp key

"whiteTemp"	
A CFNumber (SInt32), for example, 5000, 6500, or 9300 	
Only if not supplying whitePointx and whitePointy keys


For a profileType key whose value is "displayID", the dictionary can also contain the keys-value pairs in Table 3
Table 3  Key-value pairs for “displayID”
Key	
Value	
Comment

"targetGamma"	
A CFNumber (Float), for example, 1.8	
Optional

"targetWhite"	
A CFNumber (SInt32), for example, 6500 	
Optional

"displayID”	
A CFNumber (SInt32)	
Required


Optionally, the keys-value pairs s for a profileType key whose value is "displayRGB" can be provided to override the values from the display.
Availability
Available in Mac OS X v. 10.3 and later. 
Declared In
CMApplication.h*/

CMError CMMakeProfile(
CMProfileRef      prof,
CFDictionaryRef   spec
);

/*CMNewProfile

Creates a new profile and associated backing copy.

CMError CMNewProfile (
   CMProfileRef * prof,
   const CMProfileLocation * theProfile
);
Parameters
prof

A pointer to a profile reference of type CMProfileRef. On return, a reference to the new profile. 
theProfile

A pointer of type CMProfileLocation to the profile location where the new profile should be created. A profile is commonly disk-file based—the disk file type for a profile is 'prof'. However, to accommodate special requirements, you can create a handle- or pointer-based profile, you can create a temporary profile that is not saved after you call the CMCloseProfile function, or you can create a profile that is accessed through a procedure provided by your application. To create a temporary profile, you either specify cmNoProfileBase as the kind of profile in the profile location structure or specify NULL for this parameter. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMNewProfile function creates a new profile and backing copy in the location you specify. After you create the profile, you must fill in the profile header fields and populate the profile with tags and their element data, and then call the function CMUpdateProfile to save the element data to the profile file. The default ColorSync profile contents include a profile header of type CM2Header and an element table.

To set profile elements outside the header, you use the function CMSetProfileElement, the function CMSetProfileElementSize, and the function CMSetPartialProfileElement. You set these elements individually, identifying them by their tag names.

When you create a new profile, all fields of the CM2Header profile header are set to 0 except the size and profileVersion fields. To set the header elements, you call the function CMGetProfileHeader to get a copy of the header, assign values to the header fields, then call the function CMSetProfileHeader to write the new header to the profile.

For each profile class, such as a device profile, there is a specific set of elements and associated tags, defined by the ICC, that a profile must contain to meet the baseline requirements. The ICC also defines optional tags that a particular CMM might use to optimize or improve its processing. You can also define private tags, whose tag signatures you register with the ICC, to provide a CMM with greater capability to refine its processing.

After you fill in the profile with tags and their element data, you must call the CMUpdateProfile function to write the new profile elements to the profile file.

This function is most commonly used by profile developers who create profiles for device manufacturers and by calibration applications. In most cases, application developers use existing profiles. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMNewProfile (
   CMProfileRef * prof,
   const CMProfileLocation * theProfile
);

/*CMCloseProfile

Decrements the reference count for the specified profile reference and, if the reference count reaches 0, frees all private memory and other resources associated with the profile.

CMError CMCloseProfile (
   CMProfileRef prof
);
Parameters
prof

A profile reference of type CMProfileRef that identifies the profile that may need to be closed. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The ColorSync Manager keeps an internal reference count for each profile reference returned from a call to the CMOpenProfile, CMNewProfile, CMCopyProfile, or CWNewLinkProfile functions. Calling the function CMCloneProfileRef increments the count; calling the CMCloseProfile function decrements it. The profile remains open as long as the reference count is greater than 0, indicating there is at least one remaining reference to the profile. When the count reaches 0, the ColorSync Manager releases all private memory, files, or resources allocated in association with that profile.

When the ColorSync Manager releases all private memory and resources associated with a profile, any temporary changes your application made to the profile are not saved unless you first call the CMUpdateProfile function to update the profile.

When your application passes a copy of a profile reference to an independent task, whether synchronous or asynchronous, it should call the function CMCloneProfileRef to increment the reference count. Both the called task and the caller should call CMCloseProfile when finished with the profile reference.

You call CMCloneProfileRef after copying a profile reference, but not after duplicating an entire profile (as with the CMCopyProfile function).

When your application passes a copy of a profile reference internally, it may not need to call CMCloneProfileRef, as long as the application calls CMCloseProfile once for the profile.

In your application, make sure that CMCloseProfile is called once for each time a profile reference is created or cloned. Otherwise, the private memory and resources associated with the profile reference may not be properly freed, or an application may attempt to use a profile reference that is no longer valid.

If you create a new profile by calling the CMNewProfile function, the profile is saved to disk when you call the CMCloseProfile function unless you specified NULL as the profile location when you created the profile.

To save changes to a profile before closing it, use the function CMUpdateProfile. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMCloseProfile (
   CMProfileRef prof
);

/*CMGetProfileByAVID

Gets the current profile for a monitor.

CMError CMGetProfileByAVID (
   CMDisplayIDType theID,
   CMProfileRef * prof
);
Parameters
theAVID

A Display Manager ID value. You pass the ID value for the monitor for which to get the profile. 
prof

A pointer to a profile reference. On return, a reference to the current profile for the monitor specified by theAVID. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

If the Display Manager supports ColorSync, the CMGetProfileByAVID function calls on the Display Manager to get the profile for the specified display. This is the case if the version of the Display Manager is 2.2.5 or higher (if gestaltDisplayMgrAttr has the gestaltDisplayMgrColorSyncAware bit set). 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetProfileByAVID (
   CMDisplayIDType theID,
   CMProfileRef * prof
);

/*CMOpenProfile

Opens the specified profile and returns a reference to the profile.

CMError CMOpenProfile (
   CMProfileRef * prof,
   const CMProfileLocation *theProfile
);
Parameters
prof

A pointer to a profile reference of type CMProfileRef. On return, the reference refers to the opened profile. 
theProfile

A pointer to a profile location of type CMProfileLocation for the profile to open. Commonly a profile is disk-file based, but it may instead be temporary, handle-based, pointer-based, or accessed through a procedure supplied by your application. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

If the CMOpenProfile function executes successfully, the profile reference refers to the opened profile. Your application uses this reference, for example, when it calls functions to color match, copy, and update a profile, and validate its contents.

The ColorSync Manager maintains private storage for each request to open a profile, allowing more than one application to use a profile concurrently.

When you create a new profile or modify the elements of an existing profile, the ColorSync Manager stores the new or modified elements in the private storage it maintains for your application. Any new or changed profile elements are not incorporated into the profile itself unless your application calls the function CMUpdateProfile to update the profile. If you call the function CMCopyProfile to create a copy of an existing profile under a new name, any changes you have made are incorporated in the profile duplicate but the original profile remains unchanged.

Before you call the CMOpenProfile function, you must set the CMProfileLocation data structure to identify the location of the profile to open. Most commonly, a profile is stored in a disk file. If the profile is in a disk file, use the profile location data type to provide its file specification. If the profile is in memory, use the profile location data type to specify a handle or pointer to the profile. If the profile is accessed through a procedure provided by your application, use the profile location data type to supply a universal procedure pointer to your procedure.

Your application must obtain a profile reference before you copy or validate a profile, and before you flatten the profile to embed it.

For example, your application can:
open a profile 
call the CMGetProfileHeader function to obtain the profile’s header to modify its values 
set new values 
call the CMSetProfileHeader function to replace the modified header 
pass the profile reference to a function such as NCWNewColorWorld as the source or destination profile in a color world for a color-matching session 
When you close your reference to the profile by calling the function CMCloseProfile, your changes are discarded (unless you called the CMUpdateProfile function). 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMOpenProfile (
   CMProfileRef * prof,
   const CMProfileLocation *theProfile
);

/*CMCloneProfileRef

Increments the reference count for the specified profile reference.

CMError CMCloneProfileRef (
   CMProfileRef prof
);
Parameters
prof

A profile reference of type CMProfileRef to the profile whose reference count is incremented. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The ColorSync Manager keeps an internal reference count for each profile reference returned from a call to the CMOpenProfile, CMNewProfile, or CMCopyProfile functions. Calling the CMCloneProfileRef function increments the count; calling the function CMCloseProfile decrements it. The profile remains open as long as the reference count is greater than 0, indicating that at least one routine retains a reference to the profile. When the count reaches 0, the ColorSync Manager releases all private memory, files, or resources allocated in association with that profile.

When your application creates a copy of an entire profile with CMCopyProfile, the copy has its own reference count. The CMCloseProfile routine should be called for the copied profile, just as for the original. When the reference count reaches 0, private resources associated with the copied profile are freed.

When your application merely duplicates a profile reference, as it may do to pass a profile reference to a synchronous or an asynchronous task, it should call CMCloneProfileRef to increment the reference count. Both the called task and the caller should call CMCloseProfile when finished with the profile reference.

In your application, you must make sure that CMCloseProfile is called once for each time a profile reference is created or cloned. Otherwise, the memory and resources associated with the profile reference may not be properly freed, or an application may attempt to use a profile reference that is no longer valid. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMCloneProfileRef (
   CMProfileRef prof
);

/*CWDisposeColorWorld

Releases the private storage associated with a color world when your application has finished using the color world. 

void CWDisposeColorWorld (
   CMWorldRef cw
);
Parameters
cw

A color world reference of type CMWorldRef. 

The function NCWNewColorWorld and the function CWConcatColorWorld both allocate color world references of type CMWorldRef.

Discussion

The following functions use color worlds. If you create a color world to pass to one of these functions, you must dispose of the color world when your application is finished with it.
CWMatchColors
CWCheckColors
CWMatchBitmap
CWCheckBitmap
CWMatchPixMap
CWCheckPixMap
Availability
Available in CarbonLib 1.0 and later when ColorSync 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

void CWDisposeColorWorld (
   CMWorldRef cw
);

/*CMGetDefaultProfileByUse

Obtains the users’ preferred device profile setting.

CMError CMGetDefaultProfileByUse (
   OSType use,
   CMProfileRef * prof
);
Parameters
use

A value that specifies the device type for which to obtain the profile.
prof
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when ColorSync 3.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetDefaultProfileByUse (
   OSType use,
   CMProfileRef * prof
);

/*CMSetDefaultProfileBySpace

Sets the default profile for the specified color space.

CMError CMSetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef prof
);
Parameters
dataColorSpace

A four-character identifier of type OSType. You pass a color space signature that identifies the color space you wish to set the default profile for. The currently-supported values are cmRGBData, cmCMYKData, cmLabData, and cmXYZData. These constants are a subset of the constants described in “Color Space Signatures”. If you supply a value that is not supported, the CMGetDefaultProfileBySpace function returns an error value of paramErr. 
prof

A profile reference. Before calling CMSetDefaultProfileBySpace, set the reference to specify the default profile for the color space. The profile must be file-based; otherwise, the function returns a CMInvalidProfileLocation error. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMSetDefaultProfileBySpace function currently supports the RGB, CMYK, Lab, and XYZ color spaces. The signature constants for these color spaces (shown above with the dataColorSpace parameter description) are described in “Color Space Signatures”. Support for additional color spaces may be provided in the future. CMSetDefaultProfileBySpace returns a value of paramErr if you pass a color space constant it does not currently support.

Note that a user can also use the ColorSync control panel to specify a default profile for the RGB and CMYK color spaces. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMSetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef prof
);

/*CMGetDefaultProfileBySpace

Gets the default profile for the specified color space.

CMError CMGetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef * prof
);
Parameters
dataColorSpace

A four-character identifier of type OSType. You pass a color space signature that identifies the color space you wish to get the default profile for. The currently-supported values are cmRGBData, cmCMYKData, cmLabData, and cmXYZData. These constants are a subset of the constants described in “Color Space Signatures”. If you supply a value that is not supported, the CMGetDefaultProfileBySpace function returns an error value of paramErr. 
prof

A pointer to a profile reference. On return, the reference specifies the current profile for the color space specified by dataColorSpace. CMGetDefaultProfileBySpace currently supports only file-based profiles. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMGetDefaultProfileBySpace function currently supports the RGB, CMYK, Lab, and XYZ color spaces. The signature constants for these color spaces (shown above with the dataColorSpace parameter description) are described in “Color Space Signatures”. Support for additional color spaces may be provided in the future. CMGetDefaultProfileBySpace returns an error value of paramErr if you pass a color space constant it does not currently support.

The CMGetDefaultProfileBySpace function always attempts to return a file-based profile for a supported color space. For example, if the user has not specified a default profile in the ColorSync control panel for the specified color space, or if the profile is not found (the user may have deleted the profiles in the ColorSync Profiles folder or even the folder itself), CMGetDefaultProfileBySpace creates a profile, stores it on disk, and returns a reference to that profile. However, you should always check for an error return—for example, a user may have booted from a CD, so that CMGetDefaultProfileBySpace cannot save a profile file to disk. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMGetDefaultProfileBySpace (
   OSType dataColorSpace,
   CMProfileRef * prof
);

/*CMSetDefaultProfileByUse

Sets values for device profile settings.

CMError CMSetDefaultProfileByUse (
   OSType use,
   CMProfileRef prof
);
Parameters
use

A value that specifies the device type for which to set the profile.
prof
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when ColorSync 3.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMSetDefaultProfileByUse (
   OSType use,
   CMProfileRef prof
);


/*CWMatchBitmap

Matches the colors of a bitmap to the gamut of a destination device using the profiles specified by a color world.

CMError CWMatchBitmap (
   CMWorldRef cw,
   CMBitmap * bitmap,
   CMBitmapCallBackUPP progressProc,
   void * refCon,
   CMBitmap * matchedBitmap
);
Parameters
cw

A reference to a color world of type CMWorldRef in which matching is to occur.

The functions NCWNewColorWorld and CWConcatColorWorld both allocate color world references of type CMWorldRef.

bitmap

A pointer to a bitmap of type CMBitmap whose colors are to be matched. 
progressProc

A calling program–supplied universal procedure pointer to a callback function that allows your application to monitor progress or abort the operation as the bitmap colors are matched. The default CMM calls your function approximately every half-second unless color matching occurs in less time this happens when there is a small amount of data to be matched. If the function returns a result of true, the operation is aborted. To match colors without monitoring the process, specify NULL for this parameter. For a description of the function your application supplies, see the function CMBitmapCallBackProcPtr. 
refCon

A pointer to a reference constant for application data passed through as a parameter to calls to the progressProc function. 
matchedBitmap

A pointer to a bitmap. On return, contains the color-matched image. You must allocate the pixel buffer pointed to by the image field of the structure CMBitmap. If you specify NULL for matchedBitMap, then the source bitmap is matched in place.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CWMatchBitmap function matches a bitmap using the profiles specified by the given color world.

You should ensure that the buffer pointed to by the image field of the bitmap passed in the bitMap parameter is zeroed out before you call this function.

The ColorSync Manager does not explicitly support a CMY color space. However, for printers that have a CMY color space, you can use either of the following circumventions to make the adjustment:
You can use a CMY profile, which the ColorSync Manager does support, with a CMYK color space. If you specify a CMYK color space in this case, the ColorSync Manager zeroes out the K channel to simulate a CMY color space. 
You can use an RGB color space and pass in the bitmap along with an RGB profile, then perform the conversion from RGB to CMY yourself. 

For this function to execute successfully, the source profile’s dataColorSpace field value and the space field value of the source bitmap pointed to by the bitMap parameter must specify the same data color space. Additionally, the destination profile’s dataColorSpace field value and the space field value of the resulting bitmap pointed to by the matchedBitMap parameter must specify the same data color space, unless the destination profile is a named color space profile.

If you set matchedBitMap to NULL to specify in-place matching, you must be sure the space required by the destination bitmap is less than or equal to the size of the source bitmap. 
Version Notes

The color spaces currently supported for the CWMatchBitmap function are defined in “Color Space Constants With Packing Formats”. Support for the following color space constants, was added with ColorSync version 2.5:
cmGray16Space
cmGrayA32Space
cmRGB48Space.
cmCMYK64Space
cmLAB48Space
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CWMatchBitmap (
   CMWorldRef cw,
   CMBitmap * bitmap,
   CMBitmapCallBackUPP progressProc,
   void * refCon,
   CMBitmap * matchedBitmap
);

/*CMGetScriptProfileDescription

Obtains the internal name (or description) of a profile and the script code identifying the language in which the profile name is specified from the specified profile.

CMError CMGetScriptProfileDescription (
   CMProfileRef prof,
   Str255 name,
   ScriptCode * code
);
Parameters
prof

A profile reference of type CMProfileRef to the profile whose profile name and script code are obtained. 
name

A pointer to a name string. On return, the profile name. 
code

A pointer to a script code. On return, the script code. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The element data of the text description tag (which has the signature 'desc' or constant cmSigProfileDescriptionType, defined in the CMICCProfile.h header file) specifies the profile name and script code. The name parameter returns the profile name as a Pascal string. Use this function so that your application does not need to obtain and parse the element data, which contains other information. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetScriptProfileDescription (
   CMProfileRef prof,
   Str255 name,
   ScriptCode * code
);

/*CMCopyProfileLocalizedString

Gets one specific string out of a profile 

CMError CMCopyProfileLocalizedString (
   CMProfileRef prof,
   OSType tag,
   CFStringRef reqLocale,
   CFStringRef * locale,
   CFStringRef * str
);
Parameters
prof

The profile to query. 
tag

The tag type of profile to query.
reqLocale

The requested locale (optional). 
locale

On ouput, points to the locale (optional). 
str

On output, points to the dictionary string (optional). 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

For example, you pass in the optional tag 'dscm' plus "enUS" for the reqLocale parameter, to for a U.S. Enlish string. If a U.S. English string is not found, ColorSync falls back to a reasonable default: err = CMCopyProfileLocalizedString (prof, 'dscm',
                CFSTR("enUS"), nil, &theStr);

Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMApplication.h*/

CMError CMCopyProfileLocalizedString (
   CMProfileRef prof,
   OSType tag,
   CFStringRef reqLocale,
   CFStringRef * locale,
   CFStringRef * str
);

/*NCWConcatColorWorld

Defines a color world for color transformations among a series of concatenated profiles. 

CMError NCWConcatColorWorld (
   CMWorldRef * cw,
   NCMConcatProfileSet * profileSet,
   CMConcatCallBackUPP proc,
   void * refCon
);
Parameters
cw

A reference to a color world that the ColorSync Manager returns if the function completes successfully. You pass this reference to other functions that use the color world for color-matching and color-checking sessions. 
profileSet

An array of profiles describing the processing to be carried out. The array is in processing order source through destination. 
proc

A calling-program-supplied callback function that allows your application to monitor progress or abort the operation. 
refCon

A reference constant containing data specified by the calling application program. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The caller can override the color management module (CMM) that would normally be selected by ColorSync by providing a CMM identifier in the NCMConcatProfileSet structure, or pass 0 to accept ColorSync's CMM selection (note that this could either be the user's preferred CMM selection or the CMM called for in the profile). The flags and k parameters are provided to allow easy customization of such attributes as quality and gamut-checking, while preserving the other settings. Each profile in the set can be customized by overriding the intent, and the selection of the transform tag. Together with other profiles, a custom-rendering environment can be set up to transform to or from device-dependent spaces with a minimum of gamut compression and/or unnecessary transformations to and from connection spaces. This flexibility comes at the price of specific knowledge of the profile contents and how device gamuts overlap. 

Note that for standard input and output device profiles, A2B and B2A tags represent transforms from data space to connection space and from connection space to data space, respectively. Under these circumstances, the caller would not normally be able to use the same transform tags (e.g., kUseAtoB ) consecutively, since a connection space would not be the same as the subsequent data space. If the spaces aren't the same, the caller will get a cmCantConcatenateError error returned. For profiles of type cmLinkClass, cmAbstractClass, cmColorSpaceClass , and cmNamedColorClass , these constants are not always meaningful, and the caller is encouraged to think in terms of the actual tags present in the profiles (e.g., A2B0 or B2A0 ). Under these conditions, it may well be appropriate to specify two transform tags of the same type consecutively, as long as the actual color spaces align in between tags. If this is not the case, a cmCantConcatenateError error is returned.

The callback proc is provided as protection against the appearance of a stalled machine during lengthy color world processing. If a CMM takes more than several seconds to process the information and create a color world, it will call the callback proc, if one is provided, and pass it the refCon provided. This is also true for NCWNewLinkProfile. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.6 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError NCWConcatColorWorld (
   CMWorldRef * cw,
   NCMConcatProfileSet * profileSet,
   CMConcatCallBackUPP proc,
   void * refCon
);

/*CMIterateColorSyncFolder

Iterates over the available profiles.

CMError CMIterateColorSyncFolder (
   CMProfileIterateUPP proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
);
Parameters
proc

A universal procedure pointer of type CMProfileIterateUPP, which is described in CMProfileIterateData. If you do not wish to receive callbacks, pass NULL for this parameter. Otherwise, pass a pointer to your callback routine. 
seed

A pointer to a value of type long. The first time you call CMIterateColorSyncFolder, you typically set the value to 0. In subsequent calls, you set the value to the seed value obtained from the previous call. ColorSync uses the value in determining whether to call your callback routine, as described in the discussion for this function.

On return, the value is the current seed for the profile cache (unless you pass NULL, as described in the discussion).

count

A pointer to a value of type long. On return, the value is the number of available profiles. CMIterateColorSyncFolder provides the number of profiles even when no iteration occurs (unless you pass NULL, as described in the discussion below). To determine the count alone, without iteration, call CMIterateColorSyncFolder and pass a value of NULL for all parameters except count.
refCon

An untyped pointer to arbitrary data supplied by your application. CMIterateColorSyncFolder passes this data to your callback routine. If you pass NULL for the refCon parameter, CMIterateColorSyncFolder passes NULL to your callback routine. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

Starting with ColorSync version 2.5, when your application needs information about the profiles currently available in the ColorSync Profiles folder, it can call the CMIterateColorSyncFolder routine, which in turn calls your callback routine once for each profile.

Even though there may be many profiles available, CMIterateColorSyncFolder can take advantage of ColorSync’s profile cache to return profile information quickly, and (if the cache is valid) without having to open any profiles. For each profile, CMIterateColorSyncFolder supplies your routine with the profile header, script code, name, and location, in a structure of type CMProfileIterateData. As a result, your routine may be able to perform its function, such as building a list of profiles to display in a pop-up menu, without further effort (such as opening each file-based profile).

Only 2.x profiles are included in the profile search result. 

Before calling CMIterateColorSyncFolder for the first time, you typically set seed to 0. ColorSync compares 0 to its current seed for the profile cache. It is not likely they will match—the odds are roughly one in two billion against it. If the values do not match, the routine iterates through all the profiles in the cache, calling your callback routine once for each profile. CMIterateColorSyncFolder then returns the actual seed value in seed (unless you passed NULL for that parameter).

If you pass the returned seed value in a subsequent call, and if there has been no change in the available profiles, the passed seed will match the stored cache seed and no iteration will take place.

Note that you can pass a NULL pointer for the seed parameter without harm. The result is the same as if you passed a pointer to 0, in that the function iterates through the available profiles, calling your callback routine once for each profile. However, the function does not return a seed value, since you have not passed a valid pointer.

You can force ColorSync to call your callback routine (if any profiles are available) by passing a NULL pointer or by passing 0 for the seed value. But suppose you have an operation, such as building a pop-up menu, that you only want to perform if the available profiles have changed. In that case, you pass the seed value from a previous call to CMIterateColorSyncFolder. If the profile folder has not changed, ColorSync will not call your callback routine.

Note that if there are no profiles available, ColorSync does not call your callback routine.

You can safely pass NULL for any or all of the parameters to the CMIterateColorSyncFolder function. If you pass NULL for all of the parameters, calling the function merely forces rebuilding of the profile cache, if necessary. 
Version Notes

Starting with version 2.5, the name and location of the profile folder changed. In addition, the folder can now contain profiles within nested folders, as well as aliases to profiles or aliases to folders containing profiles. There are limits on the nesting of folders and aliases.
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.5 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMIterateColorSyncFolder (
   CMProfileIterateUPP proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
);

/*NewCMProfileIterateUPP

Creates a new universal procedure pointer (UPP) to a profile-iteration callback.

CMProfileIterateUPP NewCMProfileIterateUPP (
   CMProfileIterateProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your profile-iteration callback function.
Return Value

The universal procedure pointer.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMProfileIterateUPP NewCMProfileIterateUPP (
   CMProfileIterateProcPtr userRoutine
);

/*DisposeCMProfileIterateUPP

Disposes of a universal procedure pointer (UPP) to a profile-iteration callback.

void DisposeCMProfileIterateUPP (
   CMProfileIterateUPP userUPP
);
Parameters
userUPP

The universal procedure pointer to dispose of.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
void DisposeCMProfileIterateUPP (
   CMProfileIterateUPP userUPP
);

/*CMGetProfileHeader

Obtains the profile header for the specified profile. 

CMError CMGetProfileHeader (
   CMProfileRef prof,
   CMAppleProfileHeader * header
);
Parameters
prof

A profile reference of type CMProfileRef to the profile whose header is to be copied. 
header

A pointer to a profile header. On input, depending on the profile version, you may allocate a ColorSync 2.x or 1.0 header. On return, contains the profile data. For information about the ColorSync 2.x profile header structure, see CM2Header. For information about the ColorSync 1.0 header, see CMHeader. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The CMGetProfileHeader function returns the header for a ColorSync 2.x or ColorSync 1.0 profile. To return the header, the function uses a union of type CMAppleProfileHeader, with variants for version 1.0 and 2.x headers. 

A 32-bit version value is located at the same offset in either header. For ColorSync 2.x profiles, this is the profileVersion field. For ColorSync 1.0 profiles, this is the applProfileVersion field. You can inspect the value at this offset to determine the profile version, and interpret the remaining header fields accordingly.

To copy a profile header to a profile after you modify the header’s contents, use the function CMSetProfileHeader. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/

CMError CMGetProfileHeader (
   CMProfileRef prof,
   CMAppleProfileHeader * header
);

/*CMCopyProfileDescriptionString

Returns the name of a profile as a CFString.

CMError CMCopyProfileDescriptionString(
CMProfileRef   prof,
CFStringRef *  str)
Parameters
prof

The profile to query.
str

On ouput, the name of the profile as a CFString.
Return Value

A CMError value. See “ColorSync Manager Result Codes”. 
Discussion

If the profile is localized, ColorSync obtains the best localized name for the current process.
Availability
Available in Mac OS X v. 10.3 and later. 
Declared In
CMApplication.h*/

CMError CMCopyProfileDescriptionString(
CMProfileRef   prof,
CFStringRef *  str);

/*CWFillLookupTexture

Fills a 3-D lookup texture from a color world.

CMError CWFillLookupTexture(
CMWorldRef   cw,
UInt32       gridPoints,
UInt32       format,
UInt32       dataSize,
void *       data
);
Parameters
cw

The color world to use.
gridPoints

The number of grid points per channel in the texture.
format

The format of pixels in texture; for example, cmTextureRGBtoRGBX8.
dataSize

The size in bytes of texture data to fill.
data

On output, points to the texture data to fill.
Return Value

A CMError value. See “ColorSync Manager Result Codes”. 
Discussion

You can use the resulting table in OpenGL to accelerate color management in hardware.
Availability
Available in Mac OS X v. 10.3 and later. 
Declared In
CMApplication.h*/

CMError CWFillLookupTexture(
CMWorldRef   cw,
UInt32       gridPoints,
UInt32       format,
UInt32       dataSize,
void *       data
);

/*CMValidateProfile

Indicates whether the specified profile contains the minimum set of elements required by the current color management module (CMM) for color matching or color checking.

CMError CMValidateProfile (
   CMProfileRef prof,
   Boolean * valid,
   Boolean * preferredCMMnotfound
);
Parameters
prof

A profile reference of type CMProfileRef to the profile to validate. 
valid

A pointer to a valid profile flag. On return, has the value true if the profile contains the minimum set of elements to be valid and false if it does not. 
preferredCMMnotfound

A pointer to a flag for whether the preferred CMM was found. On return, has the value true if the CMM specified by the profile was not available to perform validation or does not support this function and the default CMM was used. Has the value false if the profile’s preferred CMM is able to perform validation.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

When your application calls the CMValidateProfile function, the ColorSync Manager dispatches the function to the CMM specified by the CMMType header field of the profile whose reference you specify. The preferred CMM can support this function or not.

If the preferred CMM supports this function, it determines if the profile contains the baseline elements for the profile class, which the CMM requires to perform color matching or gamut checking. For each profile class, such as a device profile, there is a specific set of required tagged elements defined by the ICC that the profile must include. The ICC also defines optional tags, which may be included in a profile. A CMM might use these optional elements to optimize or improve its processing. Additionally, a profile might include private tags defined to provide a CMM with processing capability particular to the needs of that CMM. The profile developer can define these private tags, register the tag signatures with the ICC, and include the tags in a profile. The CMM checks only for the existence of profile elements it does not check the element’s content and size.

If the preferred CMM does not support the CMValidateProfile function request, the ColorSync Manager calls the default CMM to handle the validation request. 
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMValidateProfile (
   CMProfileRef prof,
   Boolean * valid,
   Boolean * preferredCMMnotfound
);

/*CMGetSystemProfile

Obtains a reference to the current system profile.

CMError CMGetSystemProfile (
   CMProfileRef * prof
);
Parameters
prof

A pointer to a profile reference of type CMProfileRef. On return, a reference to the current system profile. 
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

The following functions allow you to pass NULL as a parameter value to specify the system profile as a source or destination profile:
CMNewProfile
NCWNewColorWorld
NCMBeginMatching
NCMDrawMatchedPicture

Note that instead of passing NULL, you can pass a profile reference to a specific profile, including the system profile.

If you want to specify the system profile for any other function that requires a profile reference, such as CWConcatColorWorld and CWNewLinkProfile, you must use an explicit reference. You can obtain such a reference with the CMGetSystemProfile function.

There are other reasons you might need to obtain a reference to the current system profile. For example, your application might need to display the name of the current system profile to a user.

To identify the location of the physical file, call the function CMGetProfileLocation.

When your application has finished using the current system profile, it must close the reference to the profile by calling the function CMCloseProfile. 
Version Notes

Starting with version 2.5, use of the system profile has changed. So rather than call CMGetSystemProfile to obtain a reference to the system profile, you may be able to obtain a profile that is more appropriate for the current operation by calling CMGetDefaultProfileBySpace to get the default profile for a color space or by calling CMGetProfileByAVID to get the profile for a specific display.
Availability
Available in CarbonLib 1.0 and later when ColorSync 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
CMApplication.h*/
CMError CMGetSystemProfile (
   CMProfileRef * prof
);


#ifdef __cplusplus
}
#endif

#endif