#ifndef FONTPANEL_H
#define FONTPANEL_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Fonts Window Command

Specifies the four-character code for the show/hide Fonts window command.

enum {
   kHICommandShowHideFontPanel = 'shfp'
};
Constants
kHICommandShowHideFontPanel

Specifies the four-character code for the show/hide Fonts window command.

Available in Mac OS X v10.2 and later.
Discussion

If the user closes the Fonts window directly, your application receives a kEventFontPanelClosed Carbon event. You can then call the Carbon Event Manager function GetEventParameter to extract the HI command from the event.*/
enum {
   kHICommandShowHideFontPanel = 'shfp'
};

/*Font Information Types

Specify the type of font information.

enum {
   kFontSelectionATSUIType = 'astl',
   kFontSelectionQDType = 'qstl'
};
Constants
kFontSelectionATSUIType

Specifies ATSUI data (ATSUStyle).

Available in Mac OS X v10.2 and later.
kFontSelectionQDType

Specifies QuickDraw data (FontSelectionQDStyle).

Available in Mac OS X v10.2 and later.
Discussion

These constants specify the type of font information passed to the function SetFontInfoForSelection*/
enum {
   kFontSelectionATSUIType = 'astl',
   kFontSelectionQDType = 'qstl'
};

/*Fonts Window Events

Specify a Fonts window Carbon event.

enum {
   kEventFontPanelClosed = 1,
   kEventFontSelection = 2
};
Constants
kEventFontPanelClosed

Specifies a close event in the Fonts window. Your application should update the user interface as necessary. For example, you may need to change a Hide Fonts Window menu command to Show Fonts Window.

Available in Mac OS X v10.2 and later.
kEventFontSelection

Specifies a selection event in the Fonts window. Your application can obtain the selections from the event parameters associated with this event. Your application must check for all those parameters it handles and apply the selections to the text.

Available in Mac OS X v10.2 and later.
Discussion

When the user closes the Fonts window, the action generates the Carbon event kEventWindowClosed. You can then update any menu items or other controls whose state may need to change. The event kEventWindowClosed has no parameters. However, when the user selects an item in the Fonts window, the system sends the Carbon event kEventFontSelection to the event target you specified when your application called the Fonts Window Services function SetFontInfoForSelection. The event kEventFontSelection has parameters that reflect the current Fonts window selection.*/
enum {
   kEventFontPanelClosed = 1,
   kEventFontSelection = 2
};

/*Font Parameters and Data Types

Specify font event parameters and their associated data types.

enum {
   typeATSUFontID = typeUInt32,
   typeATSUSize = typeFixed,
   typeFMFontFamily = typeSInt16,
   typeFMFontStyle = typeSInt16,
   typeFMFontSize = typeSInt16,
   typeFontColor = typeRGBColor,
   kEventParamATSUFontID = 'auid',
   kEventParamATSUFontSize = 'ausz',
   kEventParamFMFontFamily = 'fmfm',
   kEventParamFMFontStyle = 'fmst',
   kEventParamFMFontSize = 'fmsz',
   kEventParamFontColor = 'fclr'
};
Constants
typeATSUFontID

Specifies that an ATSUFontID is of type UInt32.

Available in Mac OS X v10.2 and later.
typeATSUSize

Specifies that an ATSUSize is of type Fixed.

Available in Mac OS X v10.2 and later.
typeFMFontFamily

Specifies that an FMFontFamily is of type SInt16.

Available in Mac OS X v10.2 and later.
typeFMFontStyle

Specifies that an FMFontStyle is of type SInt16.

Available in Mac OS X v10.2 and later.
typeFMFontSize

Specifies that an FMFontSize is of type SInt16.

Available in Mac OS X v10.2 and later.
typeFontColor

Specifies that a font color is of type RGBColor.

Available in Mac OS X v10.2 and later.
kEventParamATSUFontID

Specifies the four-character code associated with an ATSUFontID selection in the Fonts window.

Available in Mac OS X v10.2 and later.
kEventParamATSUFontSize

Specifies the four-character code associated with an ATSUFontSize selection in the Fonts window.

Available in Mac OS X v10.2 and later.
kEventParamFMFontFamily

Specifies the four-character code associated with an FMFontFamily selection in the Fonts window.

Available in Mac OS X v10.2 and later.
kEventParamFMFontStyle

Specifies the four-character code associated with an FMFontStyle selection in the Fonts window.

Available in Mac OS X v10.2 and later.
kEventParamFMFontSize

Specifies the four-character code associated with an FMFontSize selection in the Fonts window.

Available in Mac OS X v10.2 and later.
kEventParamFontColor

Specifies the four-character code associated with a font color selection in the Fonts window.

Available in Mac OS X v10.2 and later.
Discussion

Table 1 lists the parameters and data types associated with the Carbon event kEventFontSelection.
Table 1  Parameters and parameter data types for a font selection event.
Parameter	
Data type

kEventParamATSUFontID	
typeATSUFontID

kEventParamATSUFontSize	
typeATSUFontSize

kEventParamFMFontFamily	
typeFMFontFamily

kEventParamFMFontSize	
typeFMFontSize

kEventParamFontColor	
typeFontColor*/
enum {
   typeATSUFontID = typeUInt32,
   typeATSUSize = typeFixed,
   typeFMFontFamily = typeSInt16,
   typeFMFontStyle = typeSInt16,
   typeFMFontSize = typeSInt16,
   typeFontColor = typeRGBColor,
   kEventParamATSUFontID = 'auid',
   kEventParamATSUFontSize = 'ausz',
   kEventParamFMFontFamily = 'fmfm',
   kEventParamFMFontStyle = 'fmst',
   kEventParamFMFontSize = 'fmsz',
   kEventParamFontColor = 'fclr'
};

/*Font Event Class

Specifies a Carbon event related to font selection or handling.

enum {
   kEventClassFont = 'font'
};
Constants
kEventClassFont

Specifies a Carbon event related to font selection or handling.

Available in Mac OS X v10.2 and later.*/
enum {
   kEventClassFont = 'font'
};

//function

/*SetFontInfoForSelection

Sets the selections that appear in the Fonts window.

OSStatus SetFontInfoForSelection (
   OSType iStyleType,
   UInt32 iNumStyles,
   void * iStyles,
   EventTargetRef   iFPEventTarget
);
Parameters
iStyleType

The type of style data you are passing to the Fonts window. Pass kFontSelectionQDType if you supply a FontSelectionQDStyle data structure in the iStyles parameter. Pass kFontSelectionATSUIType if you supply ATSUStyle data in the iStyles parameter.
iNumStyles

The number of styles passed in the iStyles parameter.
iStyles

A pointer to an array of data structures that correspond to the style type specified by the iStyleType parameter.
iFPEventTarget

The event target you want to receive the Carbon event kEventFontSelection that is associated with the Fonts window. You typically specify the event target for the window that is sending the style selection to the Fonts window.
Return Value

A result code. See “Fonts Window Services Results Codes”.
Discussion

You can programmatically set a selection in the Fonts window by calling the function SetFontInfoForSelection. You can call this function even when the Fonts window is not open or visible. When the Fonts window becomes visible later, the style information specified in the most recent call to SetFontInfoForSelection is selected in the window.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X version 10.2.
Declared In
FontPanel.h*/
OSStatus SetFontInfoForSelection (
   OSType iStyleType,
   UInt32 iNumStyles,
   void * iStyles,
   EventTargetRef   iFPEventTarget
);

#ifdef __cplusplus
}
#endif

#endif