#ifndef CFPLUGIN_H
#define CFPLUGIN_H


#include <CoreFoundation/CFBase.h>
#include <CoreFoundation/CFArray.h>
#include <CoreFoundation/CFBundle.h>
#include <CoreFoundation/CFString.h>

#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif

#include <CoreFoundation/CFUUID.h>


#if defined(__cplusplus)
extern "C" {
#endif]

/*CFPlugInRef

A reference to a CFPlugin object.

typedef struct __CFBundle *CFPlugInRef;
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CFPlugIn.h*/
typedef struct __CFBundle *CFPlugInRef;

//func

/*CFPlugInAddInstanceForFactory

Registers a new instance of a type with CFPlugIn. .

void CFPlugInAddInstanceForFactory (
   CFUUIDRef factoryID
);
Parameters
factoryID

The CFUUID object representing the plug-in factory.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/
void CFPlugInAddInstanceForFactory (
   CFUUIDRef factoryID
);

/*CFPlugInRemoveInstanceForFactory

Unregisters an instance of a type with CFPlugIn.

void CFPlugInRemoveInstanceForFactory (
   CFUUIDRef factoryID
);
Parameters
factoryID

The CFUUID object representing the plug-in factory.
Discussion

If the instance counts of every factory in a plug-in are zero, the plug-in can be unloaded.]
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/

void CFPlugInRemoveInstanceForFactory (
   CFUUIDRef factoryID
);

/*CFPlugInCreate

Creates a CFPlugIn given its URL.

CFPlugInRef CFPlugInCreate (
   CFAllocatorRef allocator,
   CFURLRef plugInURL
);
Parameters
allocator

The allocator to use to allocate memory for the new plug-in. Pass NULL or kCFAllocatorDefault to use the default allocator. 
plugInURL

The location of the plug-in.
Return Value

A new plug-in. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/

CFPlugInRef CFPlugInCreate (
   CFAllocatorRef allocator,
   CFURLRef plugInURL
);

/*CFPlugInFindFactoriesForPlugInTypeInPlugIn

Searches the given plug-in for factory functions capable of creating an instance of the given type.

CFArrayRef CFPlugInFindFactoriesForPlugInTypeInPlugIn (
   CFUUIDRef typeUUID,
   CFPlugInRef plugIn
);
Parameters
typeUUID

A UUID type.
plugIn

The plug-in to search.
Return Value

An array of UUIDs for factory functions capable of creating an instance of the given type. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/
CFArrayRef CFPlugInFindFactoriesForPlugInTypeInPlugIn (
   CFUUIDRef typeUUID,
   CFPlugInRef plugIn
);

/*CFPlugInInstanceCreate

Creates a CFPlugIn instance of a given type using a given factory.

void *CFPlugInInstanceCreate (
   CFAllocatorRef allocator,
   CFUUIDRef factoryUUID,
   CFUUIDRef typeUUID
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the default allocator. 
factoryUUID

The UUID representing the factory function to use to create a plug-in of the given type. 
typeUUID

The UUID type.
Return Value

Returns the IUnknown interface for the new plug-in.
Discussion

The plug-in host uses this function to create an instance of the given type. Unless the plug-in is using dynamic registration, this function causes the plug-in's code to be loaded into memory. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFPlugIn.h*/

void *CFPlugInInstanceCreate (
   CFAllocatorRef allocator,
   CFUUIDRef factoryUUID,
   CFUUIDRef typeUUID
);




#ifdef __cplusplus
}
#endif


#if !COREFOUNDATION_CFPLUGINCOM_SEPARATE
#include <CoreFoundation/CFPlugInCOM.h>
#endif

#endif