#import <Foundation/Foundation.h>

#import <DiscRecordingEngine/DRCoreTrack.h>
#import <DiscRecordingEngine/DRDevice.h>

#include <stdint.h>
#include <AvailabilityMacros.h>

@class DRMSF;
@class DRBurn;


//class


@interface DRTrack : NSObject 
/*initWithProducer:


Initializes a DRTrack with the producer 
private

- (id) initWithProducer:(id)producer; 
Parameters
producer
The object to use as the data producer
Return Value

A DRTrack*/
- (id) initWithProducer:(id)producer; 

/*setProperties:


Sets the properties dictionary of the track 
private

- (void) setProperties:(NSDictionary*)properties; 
Parameters
properties
NSDictionary of the properties to set.*/
- (void) setProperties:(NSDictionary*)properties; 

/*properties


Returns the properties dictionary of the track. 
private

- (NSDictionary*) properties; 
Return Value

An NSDictionary containing the properties of the track.*/
- (NSDictionary*) properties; 

/*estimateLength


Asks the track producer for a size estimate. 
private

- (uint64_t) estimateLength; 
Return Value

The estimated length of the track. 
Discussion 

This method calls the track producer to ask it to estimate the size needed for its data.
For some types of track, this call may be very expensive. For example, a DRFilesystemTrack may need to iterate folders on disk to provide an accurate estimate, which (if a large number of files and folders are involved) can cause this call to take 30 seconds or more. Since your main thread should not be allowed to block for this long, you may wish to call this function on a separate thread.*/
- (uint64_t) estimateLength; 

@end




@interface DRTrack (PropertyConvenience)
/*length


Returns the length of the track data. 
private

- (DRMSF*) length;
Return Value

A DRMSF representing the length of the track. 
Discussion 

The length returned does not include the length of the pregap. Only the length of the track data itself is returned. This is a simple wrapper to obtain the DRTrackLengthKey . If the DRTrackLengthKey property has not been set for the track this method will return a zero-length DRMSF object (0m:0s:0f).*/
- (DRMSF*) length;

@end


//@protocol DRTrackDataProduction

//@end



/*DRTrackISRCKey

extern NSString* const DRTrackISRCKey;  
Discussion 

For CD-DA audio tracks only. This key points to an NSData containing exactly 12 bytes, which will be written to the disc as the International Standard Recording Code (ISRC). If this key is not present, no ISRC is written. 

The use of this value should conform to the specifications of the IFPI. See http://www.ifpi.org/isrc/ for more details on the ISRC standard. 

Not all drives are capable of the write modes necessary to write the ISRC. If this key is present in any track and the drive cannot write the ISRC, the burn will fail with kDRDeviceCantWriteISRCErr . 
Availability
Introduced in Mac OS X v10.3.*/
extern NSString* const DRTrackISRCKey;  

/*DRPreGapLengthKey

extern NSString* const DRPreGapLengthKey;  
Discussion 

For CD tracks only. NSNumber containing the length of silence or data at the beginning of the track. This defaults to 2 seconds of silence. If this key is present, the track producer will be asked for the pregap data first. If the producer implements the proper selector, then it's the responsibility of the producer to provide data for the pregap, otherwise that length of silence will be produced by Disc Recording. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRPreGapLengthKey;  

/*DRAudioPreEmphasisKey

extern NSString* const DRAudioPreEmphasisKey;  
Discussion 

For CD-DA audio tracks only. This key points to a BOOL value indicating whether the track includes pre-emphasis of 50/15us. If this key is not present, the engine will use a default value of NO. On the media, this key corresponds to bit 0 of the control field in sub-channel Q. 
Availability
Introduced in Mac OS X v10.3.*/
extern NSString* const DRAudioPreEmphasisKey;  

/*DRTrackLengthKey

extern NSString* const DRTrackLengthKey;  
Discussion 

DRMSF representing the length of the track 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRTrackLengthKey;  

/*DRBlockSizeKey

extern NSString* const DRBlockSizeKey;  
Discussion 

NSNumber containing the size in bytes of each track block. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRBlockSizeKey;  

/*DRDataFormKey

extern NSString* const DRDataFormKey;  
Discussion 

NSNumber containing the data form of each block in the track. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRDataFormKey;  

/*DRBlockTypeKey

extern NSString* const DRBlockTypeKey;  
Discussion 

NSNumber containing the type of each track block. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRBlockTypeKey;  

/*DRTrackModeKey

extern NSString* const DRTrackModeKey;  
Discussion 

NSNumber containing the track mode of the track. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRTrackModeKey;  

/*DRSessionFormatKey

extern NSString* const DRSessionFormatKey;  
Discussion 

NSNumber containing the session format of the track. See the Mt. Fuji (INF-8090i) specification for CD/DVD devices for possible values for this property. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRSessionFormatKey;  

/*DRIndexPointsKey

extern NSString* const DRIndexPointsKey;  
Discussion 

For CD tracks only. This key points to an NSArray of NSNumbers, indicating the index points inside the track. Each index point is specified as a number of blocks (frames) relative to the start of the track. There are 75 blocks in one second of CD audio. No more than 98 index points may be specified for a track. 

Not all drives are capable of writing index points, and not all consumer CD players report or use them. If this key is present in any track and the drive cannot write index points, the burn will fail with kDRDeviceCantWriteIndexPointsErr . 
Availability
Introduced in Mac OS X v10.3.*/
extern NSString* const DRIndexPointsKey;  

/*DRIndexPointsKey

extern NSString* const DRIndexPointsKey;  
Discussion 

For CD tracks only. This key points to an NSArray of NSNumbers, indicating the index points inside the track. Each index point is specified as a number of blocks (frames) relative to the start of the track. There are 75 blocks in one second of CD audio. No more than 98 index points may be specified for a track. 

Not all drives are capable of writing index points, and not all consumer CD players report or use them. If this key is present in any track and the drive cannot write index points, the burn will fail with kDRDeviceCantWriteIndexPointsErr . 
Availability
Introduced in Mac OS X v10.3.*/
extern NSString* const DRIndexPointsKey;  

/*DRSystemIdentifier

extern NSString* const DRSystemIdentifier;  
Discussion 

NSString indicating the system identifier for ISO and Joliet volumes. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRSystemIdentifier;  

/*DRISOMacExtensions

extern NSString* const DRISOMacExtensions;  
Discussion 

NSBoolean indicating whether the track should have Mac extensions. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRISOMacExtensions;  

/*DRISOLevel

extern NSString* const DRISOLevel;  
Discussion 

NSNumber containing the ISO level of the ISO-9660 filesystem on the track. Currently should be 1 or 2. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRISOLevel;  

/*DRISORockRidgeExtensions

extern NSString* const DRISORockRidgeExtensions;  
Discussion 

NSBoolean indicating whether the track should have RockRidge (POSIX) extensions. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRISORockRidgeExtensions;  

/*DRVolumeCheckedDate

extern NSString* const DRVolumeCheckedDate;  
Discussion 

NSDate containing the volume-checked date for HFS+ volumes. DRDefaultDate is used if unspecified. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVolumeCheckedDate;  

/*DRVolumeSet

extern NSString* const DRVolumeSet;  
Discussion 

NSString indicating the volume set name for ISO and Joliet volumes. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVolumeSet;  

/*DRAbstractFile

extern NSString* const DRAbstractFile;  
Discussion 

DRFile pointing to the abstract file for ISO and Joliet volumes. The file must be in the root directory. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRAbstractFile;  

/*DRPublisher

extern NSString* const DRPublisher;  
Discussion 

NSString indicating the publisher for ISO and Joliet volumes. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRPublisher;  

/*DRVolumeModificationDate

extern NSString* const DRVolumeModificationDate;  
Discussion 

NSDate containing the volume modification date. DRDefaultDate is used if unspecified. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVolumeModificationDate;  

/*DRCopyrightFile

extern NSString* const DRCopyrightFile;  
Discussion 

DRFile pointing to the copyright file for ISO and Joliet volumes. The file must be in the root directory. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRCopyrightFile;  

/*DRDataPreparer

extern NSString* const DRDataPreparer;  
Discussion 

NSString indicating the data preparer for ISO and Joliet volumes. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRDataPreparer;  

/*DRVolumeCreationDate

extern NSString* const DRVolumeCreationDate;  
Discussion 

NSDate containing the volume creation date. DRDefaultDate is used if unspecified. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVolumeCreationDate;  

/*DRVolumeEffectiveDate

extern NSString* const DRVolumeEffectiveDate;  
Discussion 

NSDate containing the date and time at which the volume is effective for ISO and Joliet volumes. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVolumeEffectiveDate;  

/*DRApplicationIdentifier

extern NSString* const DRApplicationIdentifier;  
Discussion 

NSString indicating the application identifier for ISO, Joliet and UDF volumes. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRApplicationIdentifier;  

/*DRDefaultDate

extern NSString* const DRDefaultDate;  
Discussion 

NSDate containing the default date to use for any unspecified dates in the filesystem. The current date and time is used if unspecified. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRDefaultDate;  

/*DRVolumeExpirationDate

extern NSString* const DRVolumeExpirationDate;  
Discussion 

NSDate containing the volume expiration date for ISO and Joliet volumes. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVolumeExpirationDate;  

/*DRBibliographicFile

extern NSString* const DRBibliographicFile;  
Discussion 

DRFile pointing to the bibliographic file for ISO and Joliet volumes. The file must be in the root directory. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRBibliographicFile;  

/*DRVerificationTypeProduceAgain

extern NSString* const DRVerificationTypeProduceAgain;  
Discussion 

One of the possible values of the DRVerificationTypeKey . The engine will simply begin another production cycle and start calling <produceDataForTrack:intoBuffer:length:atAddress:blockSize:ioFlags: again. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVerificationTypeProduceAgain;  

/*DRVerificationTypeReceiveData

extern NSString* const DRVerificationTypeReceiveData;  
Discussion 

One of the possible values of the DRVerificationTypeKey . The engine will begin reading data from the disc and calling verifyDataForTrack:inBuffer:length:atAddress:blockSize:ioFlags: . 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVerificationTypeReceiveData;  

/*DRVerificationTypeKey

extern NSString* const DRVerificationTypeKey;  
Discussion 

NSString indicating the type of verification to be performed. If this is not present, the track will not be verified. 
Availability
Introduced in Mac OS X v10.2*/
extern NSString* const DRVerificationTypeKey;  
