
#ifndef _IOTIMEREVENTSOURCE
#define _IOTIMEREVENTSOURCE

#include <sys/cdefs.h>
#include <kern/clock.h>
#include <IOKit/IOEventSource.h>
#include <IOKit/IOTypes.h>

class IOTimerEventSource : public IOEventSource
{
public:
#include <APPLE/IOKit/IOTimerEventSource_IOTimerEventSource.h>
/*setTimeoutMS


Setup a callback at after the delay in milliseconds. See wakeAtTime(AbsoluteTime). 
public

virtual IOReturn setTimeoutMS(
    UInt32 ms); 
Parameters
interval
Delay from now to wake up, time in milliseconds.
Return Value

kIOReturnSuccess if everything is fine, kIOReturnNoResources if action hasn't been declared.*/
virtual IOReturn setTimeoutMS(
    UInt32 ms); 

/*timerEventSource


Allocates and returns an initialized timer instance. 
public

static IOTimerEventSource * timerEventSource(
    OSObject *owner,
    Action action = 0); 
Parameters
owner
action*/
static IOTimerEventSource * timerEventSource(
    OSObject *owner,
    Action action = 0); 

/*cancelTimeout


Disable any outstanding calls to this event source. 
public

virtual void cancelTimeout(); 
Discussion 

Clear down any oustanding calls. By the time this function completes it is guaranteed that the action will not be called again.*/
virtual void cancelTimeout(); 

};

#endif 
