
#ifndef _IOKIT_IOUSERCLIENT_H
#define _IOKIT_IOUSERCLIENT_H

#include <IOKit/IOTypes.h>
#include <IOKit/IOService.h>
#include <IOKit/OSMessageNotification.h>
#include <APPLE/IOKit/IOUserClient.h>

/*IOUserClient inside the Kernel
------------------------------
To begin implementing a user client, you'll need to add a class to your kernel
extension which is a subclass of IOUserClient. The definition for IOUserClient
is located in IOUserClient.h, inside Kernel.framework/IOKit.

The first method that gets called in the life of a user client is initWithTask
which is where you put initialization code. (On Intel-based Macs, this is also
where the user client can detect if it's being initialized by an application
running using Rosetta.) Then the start method is called which is where you
should do some sanity checking to make sure that the provider is actually a
member of your driver's family. If this check fails, your start method should
return false which causes the instantiation to fail.

In order for functions to be called in your kernel extension, you must create
an array of IOExternalMethods, which is in essence just an array of function
pointers.

The layout of an IOExternalMethod struct is defined in IOUserClient.h and is
shown below:

struct IOExternalMethod {
    IOService* object;
    IOMethod func;
    IOOptionBits flags;
    IOByteCount count0;
    IOByteCount count1;
};

User clients typically call member functions either of the user client class
itself or of the user client's provider. The actual member function to call is
obtained by IOUserClient calling getTargetAndMethodForIndex. This function
returns pointers to the object and the member function of that object which
should be called. Your array of IOExternalMethod structs can be used by your
implementation of getTargetAndMethodForIndex. This will be discussed in more
detail later.*/
struct IOExternalMethod {
    IOService* object;
    IOMethod func;
    IOOptionBits flags;
    IOByteCount count0;
    IOByteCount count1;
};


class IOUserClient : public IOService
{
   OSDeclareAbstractStructors(IOUserClient)

public:
#include <APPLE/IOKit/IOUserClient_IOUserClient.h>

/*initWithTask


Initializes a user client instance. 
public

virtual bool initWithTask( 
    task_t owningTask,
    void *securityToken,
    UInt32 type, 
    OSDictionary *properties); 
Parameters
owningTask
The Mach task representing the user task that is opening the connection.
Discussion 

The default implementation ignores all parameters and invokes IOService::init. Note that in Mac OS X, each process is based on a Mach task and one or more Mach threads. For more information on the composition of a Mach task and its relationship with Mach threads, see "Tasks and Threads".*/
virtual bool initWithTask( 
    task_t owningTask,
    void *securityToken,
    UInt32 type, 
    OSDictionary *properties); 

};

#endif 

