#ifndef  IOKIT_HID_IOHIDKEYS_H_
#define IOKIT_HID_IOHIDKEYS_H_

#include <sys/cdefs.h>
#include <IOKit/hidsystem/IOHIDParameter.h>

#include <APPLE/IOKit/hid/IOHIDKeys.h>

/*kIOHIDElementKey


Key that represents an element property.
#define kIOHIDElementKey "Elements" 
Discussion 

Property for a HID Device or element dictionary. Elements can be heirarchical, so they can contain other elements.*/
#define kIOHIDElementKey "Elements" 

/*kIOHIDDeviceKey

#define kIOHIDDeviceKey "IOHIDDevice" 
Discussion 

This key is used to find HID Devices in the IORegistry*/
#define kIOHIDDeviceKey "IOHIDDevice" 

/*HID Device Property Keys

See Also:
kIOHIDTransportKey
kIOHIDVendorIDKey
kIOHIDVendorIDSourceKey
kIOHIDProductIDKey
kIOHIDVersionNumberKey
kIOHIDManufacturerKey
kIOHIDProductKey
kIOHIDSerialNumberKey
kIOHIDCountryCodeKey
kIOHIDLocationIDKey
kIOHIDDeviceUsageKey
kIOHIDDeviceUsagePageKey
kIOHIDDeviceUsagePairsKey
kIOHIDPrimaryUsageKey
kIOHIDPrimaryUsagePageKey
kIOHIDMaxInputReportSizeKey
kIOHIDMaxOutputReportSizeKey
kIOHIDMaxFeatureReportSizeKey
#define kIOHIDTransportKey "Transport" //! "Transport"
#define kIOHIDVendorIDKey "VendorID" //! "VendorID"
#define kIOHIDVendorIDSourceKey "VendorIDSource" //! "
    VendorIDSource"
#define kIOHIDProductIDKey "ProductID" //! "ProductID"
#define kIOHIDVersionNumberKey "VersionNumber" //! "
    VersionNumber"
#define kIOHIDManufacturerKey "Manufacturer" //! "
    Manufacturer"
#define kIOHIDProductKey "Product" //! "Product"
#define kIOHIDSerialNumberKey "SerialNumber" //! "
    SerialNumber"
#define kIOHIDCountryCodeKey "CountryCode" //! "CountryCode"
    
#define kIOHIDLocationIDKey "LocationID" //! "LocationID"
#define kIOHIDDeviceUsageKey "DeviceUsage" //! "DeviceUsage"
    
#define kIOHIDDeviceUsagePageKey "DeviceUsagePage" //! "
    DeviceUsagePage"
#define kIOHIDDeviceUsagePairsKey "DeviceUsagePairs" //! "
    DeviceUsagePairs"
#define kIOHIDPrimaryUsageKey "PrimaryUsage" //! "
    PrimaryUsage"
#define kIOHIDPrimaryUsagePageKey "PrimaryUsagePage" //! "
    PrimaryUsagePage"
#define kIOHIDMaxInputReportSizeKey "MaxInputReportSize" //!
    "MaxInputReportSize"
#define kIOHIDMaxOutputReportSizeKey "MaxOutputReportSize" 
    //! "MaxOutputReportSize"
#define kIOHIDMaxFeatureReportSizeKey "MaxFeatureReportSize"
    //! "MaxFeatureReportSize"
Discussion 

Keys that represent properties of a particular element. Can be added to your matching dictionary when refining searches for HID devices. 

Please note:
kIOHIDPrimaryUsageKey and kIOHIDPrimaryUsagePageKey are no longer rich enough to describe a device's capabilities. Take, for example, a device that describes both a keyboard and a mouse in the same descriptor. The previous behavior was to only describe the keyboard behavior with the primary usage and usage page. Needless to say, this would sometimes cause a program interested in mice to skip this device when matching. 
Thus we have added 3 additional keys: 
kIOHIDDeviceUsageKey
kIOHIDDeviceUsagePageKey
kIOHIDDeviceUsagePairsKey
kIOHIDDeviceUsagePairsKey is used to represent an array of dictionaries containing key/value pairs referenced by kIOHIDDeviceUsageKey and kIOHIDDeviceUsagePageKey. These usage pairs describe all application type collections (behaviors) defined by the device. 

An application intersted in only matching on one criteria would only add the kIOHIDDeviceUsageKey and kIOHIDDeviceUsagePageKey keys to the matching dictionary. If it is interested in a device that has multiple behaviors, the application would instead add an array or dictionaries referenced by kIOHIDDeviceUsagePairsKey to its matching dictionary.*/
#define kIOHIDTransportKey "Transport" //! "Transport"
#define kIOHIDVendorIDKey "VendorID" //! "VendorID"
#define kIOHIDVendorIDSourceKey "VendorIDSource" //! "
//    VendorIDSource"
#define kIOHIDProductIDKey "ProductID" //! "ProductID"
#define kIOHIDVersionNumberKey "VersionNumber" //! "
 //   VersionNumber"
#define kIOHIDManufacturerKey "Manufacturer" //! "
//    Manufacturer"
#define kIOHIDProductKey "Product" //! "Product"
#define kIOHIDSerialNumberKey "SerialNumber" //! "
//    SerialNumber"
#define kIOHIDCountryCodeKey "CountryCode" //! "CountryCode"
//    
#define kIOHIDLocationIDKey "LocationID" //! "LocationID"
#define kIOHIDDeviceUsageKey "DeviceUsage" //! "DeviceUsage"
//    
#define kIOHIDDeviceUsagePageKey "DeviceUsagePage" //! "
  //  DeviceUsagePage"
#define kIOHIDDeviceUsagePairsKey "DeviceUsagePairs" //! "
 //   DeviceUsagePairs"
#define kIOHIDPrimaryUsageKey "PrimaryUsage" //! "
 //   PrimaryUsage"
#define kIOHIDPrimaryUsagePageKey "PrimaryUsagePage" //! "
//    PrimaryUsagePage"
//#define kIOHIDMaxInputReportSizeKey "MaxInputReportSize" //!
 //   "MaxInputReportSize"
#define kIOHIDMaxOutputReportSizeKey "MaxOutputReportSize" 
    //! "MaxOutputReportSize"
#define kIOHIDMaxFeatureReportSizeKey "MaxFeatureReportSize"
    //! "MaxFeatureReportSize"


/*HID Element Dictionary Keys


Keys that represent properties of a particular elements.
See Also:
kIOHIDElementCookieKey
kIOHIDElementTypeKey
kIOHIDElementCollectionTypeKey
kIOHIDElementUsageKey
kIOHIDElementUsagePageKey
kIOHIDElementMinKey
kIOHIDElementMaxKey
kIOHIDElementScaledMinKey
kIOHIDElementScaledMaxKey
kIOHIDElementSizeKey
kIOHIDElementReportSizeKey
kIOHIDElementReportCountKey
kIOHIDElementReportIDKey
kIOHIDElementIsArrayKey
kIOHIDElementIsRelativeKey
kIOHIDElementIsWrappingKey
kIOHIDElementIsNonLinearKey
kIOHIDElementHasPreferredStateKey
kIOHIDElementHasNullStateKey
kIOHIDElementUnitKey
kIOHIDElementUnitExponentKey
kIOHIDElementNameKey
kIOHIDElementValueLocationKey
kIOHIDElementDuplicateIndexKey
kIOHIDElementParentCollectionKey
#define kIOHIDElementCookieKey "ElementCookie" //! "
    ElementCookie"
#define kIOHIDElementTypeKey "Type" //! "Type"
#define kIOHIDElementCollectionTypeKey "CollectionType" //! 
    "CollectionType"
#define kIOHIDElementUsageKey "Usage" //! "Usage"
#define kIOHIDElementUsagePageKey "UsagePage" //! "UsagePage
    "
#define kIOHIDElementMinKey "Min" //!"Min"
#define kIOHIDElementMaxKey "Max" //! "Max"
#define kIOHIDElementScaledMinKey "ScaledMin" //! "ScaledMin
    "
#define kIOHIDElementScaledMaxKey "ScaledMax" //! "ScaledMax
    "
#define kIOHIDElementSizeKey "Size" //! "Size"
#define kIOHIDElementReportSizeKey "ReportSize" //! "
    ReportSize"
#define kIOHIDElementReportCountKey "ReportCount" //! "
    ReportCount"
#define kIOHIDElementReportIDKey "ReportID" //! "ReportID"
#define kIOHIDElementIsArrayKey "IsArray" //! "IsArray"
#define kIOHIDElementIsRelativeKey "IsRelative" //! "
    IsRelative"
#define kIOHIDElementIsWrappingKey "IsWrapping" //! "
    IsWrapping"
#define kIOHIDElementIsNonLinearKey "IsNonLinear" //! "
    IsNonLinear"
#define kIOHIDElementHasPreferredStateKey "HasPreferredState
    " //! "HasPreferredState"
#define kIOHIDElementHasNullStateKey "HasNullState" //! "
    HasNullState"
#define kIOHIDElementUnitKey "Unit" //! "Unit"
#define kIOHIDElementUnitExponentKey "UnitExponent" //! "
    UnitExponent"
#define kIOHIDElementNameKey "Name" //! "Name"
#define kIOHIDElementValueLocationKey "ValueLocation" //! "
    ValueLocation"
#define kIOHIDElementDuplicateIndexKey "DuplicateIndex" //! 
    "DuplicateIndex"
#define kIOHIDElementParentCollectionKey "ParentCollection" 
    //! "ParentCollection"
Discussion 

These keys can also be added to a matching dictionary when searching for elements via copyMatchingElements.*/
#define kIOHIDElementCookieKey "ElementCookie" //
//    ElementCookie"
#define kIOHIDElementTypeKey "Type" // "Type"
#define kIOHIDElementCollectionTypeKey "CollectionType" // 
  //  "CollectionType"
#define kIOHIDElementUsageKey "Usage" // "Usage"
#define kIOHIDElementUsagePageKey "UsagePage" // "UsagePage
   
#define kIOHIDElementMinKey "Min" //"Min"
#define kIOHIDElementMaxKey "Max" // "Max"
#define kIOHIDElementScaledMinKey "ScaledMin" // "ScaledMin
    
#define kIOHIDElementScaledMaxKey "ScaledMax" // "ScaledMax
  //  "
#define kIOHIDElementSizeKey "Size" // "Size"
#define kIOHIDElementReportSizeKey "ReportSize" // "
 //   ReportSize"
#define kIOHIDElementReportCountKey "ReportCount" // "
  //  ReportCount"
#define kIOHIDElementReportIDKey "ReportID" // "ReportID"
#define kIOHIDElementIsArrayKey "IsArray" // "IsArray"
#define kIOHIDElementIsRelativeKey "IsRelative" // "
//    IsRelative"
#define kIOHIDElementIsWrappingKey "IsWrapping" // "
  //  IsWrapping"
#define kIOHIDElementIsNonLinearKey "IsNonLinear" // "
//    IsNonLinear"
#define kIOHIDElementHasPreferredStateKey "HasPreferredState"
   // " // "HasPreferredState"
#define kIOHIDElementHasNullStateKey "HasNullState" 
//    HasNullState"
#define kIOHIDElementUnitKey "Unit" // "Unit"
#define kIOHIDElementUnitExponentKey "UnitExponent" 
  //  UnitExponent"
#define kIOHIDElementNameKey "Name" // "Name"
#define kIOHIDElementValueLocationKey "ValueLocation" 
  //  ValueLocation"
#define kIOHIDElementDuplicateIndexKey "DuplicateIndex" 
 //   "DuplicateIndex"
#define kIOHIDElementParentCollectionKey "ParentCollection" 
    //"ParentCollection"

/*IOHIDElementCookie


Abstract data type used as a unique identifier for an element. 
typedef void * IOHIDElementCookie;  */
typedef void * IOHIDElementCookie;  

/*IOHIDElementType


Describes different types of HID elements. 
See Also:
IOHIDElementType
enum IOHIDElementType { 
    kIOHIDElementTypeInput_Misc = 1, 
    kIOHIDElementTypeInput_Button = 2, 
    kIOHIDElementTypeInput_Axis = 3, 
    kIOHIDElementTypeInput_ScanCodes = 4, 
    kIOHIDElementTypeOutput = 129, 
    kIOHIDElementTypeFeature = 257, 
    kIOHIDElementTypeCollection = 513 
};  
Discussion 

Used by the IOHIDFamily to identify the type of element processed. Represented by the key kIOHIDElementTypeKey in the dictionary describing the element.*/
enum IOHIDElementType { 
    kIOHIDElementTypeInput_Misc = 1, 
    kIOHIDElementTypeInput_Button = 2, 
    kIOHIDElementTypeInput_Axis = 3, 
    kIOHIDElementTypeInput_ScanCodes = 4, 
    kIOHIDElementTypeOutput = 129, 
    kIOHIDElementTypeFeature = 257, 
    kIOHIDElementTypeCollection = 513 
};  


/*IOHIDElementType


Describes different types of HID elements. 
See Also:
IOHIDElementType
typedef enum IOHIDElementType IOHIDElementType;  
Constants
kIOHIDElementTypeInput_Misc
Misc input data field or varying size.
kIOHIDElementTypeInput_Button
One bit input data field.
kIOHIDElementTypeInput_Axis
Input data field used to represent an axis.
kIOHIDElementTypeInput_ScanCodes
Input data field used to represent a scan code or usage selector.
kIOHIDElementTypeOutput
Used to represent an output data field in a report.
kIOHIDElementTypeFeature
Describes input and output elements not intended for consumption by the end user.
kIOHIDElementTypeCollection
Element used to identify a relationship between two or more elements.
Discussion 

Used by the IOHIDFamily to identify the type of element processed. Represented by the key kIOHIDElementTypeKey in the dictionary describing the element.*/
typedef enum IOHIDElementType IOHIDElementType;  

/*IOHIDReportType


Describes different type of HID reports. 
See Also:
IOHIDReportType
enum IOHIDReportType { 
    kIOHIDReportTypeInput = 0, 
    kIOHIDReportTypeOutput, 
    kIOHIDReportTypeFeature, 
    kIOHIDReportTypeCount 
};  
Discussion 

Used by the IOHIDFamily to identify the type of report being processed.*/
enum IOHIDReportType { 
    kIOHIDReportTypeInput = 0, 
    kIOHIDReportTypeOutput, 
    kIOHIDReportTypeFeature, 
    kIOHIDReportTypeCount 
}; 

/*IOHIDReportType


Describes different type of HID reports. 
See Also:
IOHIDReportType
typedef enum IOHIDReportType IOHIDReportType;  
Constants
kIOHIDReportTypeInput
Input report.
kIOHIDReportTypeOutput
Output report.
kIOHIDReportTypeFeature
Feature report.
Discussion 

Used by the IOHIDFamily to identify the type of report being processed.*/
typedef enum IOHIDReportType IOHIDReportType;  

#endif 
