#ifndef PICTUTILS_H
#define PICTUTILS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef PALETTES_H
#include <QD/Palettes.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Color Selection Method

Indicates the color selection method used in a PictInfo record.

enum {
   systemMethod = 0,
   popularMethod = 1,
   medianMethod = 2
};
Constants
systemMethod

Lets Picture Utilities choose the method. Currently they always choose popularMethod.

Available in Mac OS X v10.0 and later.
popularMethod

Returns the most frequently used colors.

Available in Mac OS X v10.0 and later.
medianMethod

Returns a weighted distribution of colors.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used to indicate the method by which colors are selected for the ColorTable or Palette structure returned via the PictInfo structure, by the functions NewPictInfo , GetPixMapInfo , or GetPictInfo.*/
enum {
   systemMethod = 0,
   popularMethod = 1,
   medianMethod = 2
};

/*Color Information Type

Indicates the type of color information returned in a PictInfo record.

enum {
   returnColorTable = 0x0001,
   returnPalette = 0x0002,
   recordComments = 0x0004,
   recordFontInfo = 0x0008,
   suppressBlackAndWhite = 0x0010
};

Constants
returnColorTable

Specify to return a Color Table.

Available in Mac OS X v10.0 and later.
returnPalette

Specify to return a Palette structure.

Available in Mac OS X v10.0 and later.
recordComments

Specify to return comment information.

Available in Mac OS X v10.0 and later.
recordFontInfo

Specify to return font information.

Available in Mac OS X v10.0 and later.
suppressBlackAndWhite

Don't include black and white with returned colors.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the verb parameter of the GetPictInfo , GetPixMapInfo ,and NewPictInfo functions to indicate the type of information those functions should return. You can use any or all of these constants or the sum of the integers they represent.*/
enum {
   returnColorTable = 0x0001,
   returnPalette = 0x0002,
   recordComments = 0x0004,
   recordFontInfo = 0x0008,
   suppressBlackAndWhite = 0x0010
};

/*CommentSpec

Contains information about the comments in a picture.

struct CommentSpec {
   short count;
   short ID;
};
typedef struct CommentSpec CommentSpec;
typedef CommentSpec * CommentSpecPtr;
typedef CommentSpecPtr * CommentSpecHandle;
Fields
count

The number of times this kind of picture comment occurs in the picture specified to the GetPictInfo function or in all the pictures examined with the NewPictInfo function.
ID

The value set in the kind parameter when the picture comment was created using the function PicComment. For a description of this function, see Inside Mac OS X: Quickdraw Reference.
Discussion

If you specify the structureComments constant in the verb parameter to the GetPictInfo function or the NewPictInfo function, you receive a PictInfo structure that includes in its commentHandle field a handle to an array of CommentSpec structures. The uniqueComments field of the PictInfo structure indicates the number of CommentSpec structures in this array.

When you are finished using the information returned in a CommentSpec structure, use the DisposeHandle function to dispose of the memory allocated to it. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CommentSpec {
   short count;
   short ID;
};
typedef struct CommentSpec CommentSpec;
typedef CommentSpec * CommentSpecPtr;
typedef CommentSpecPtr * CommentSpecHandle;

/*FontSpec

Contains information about the fonts in a picture.

struct FontSpec {
   short pictFontID;
   short sysFontID;
   long size[4];
   short style;
   long nameOffset;
};
typedef struct FontSpec FontSpec;
typedef FontSpec * FontSpecPtr;
typedef FontSpecPtr * FontSpecHandle;
Fields
pictFontID

The ID number of the font as it is stored in the picture.
sysFontID

The number that identifies the resource file (of type 'FOND') that specifies the font family. Every font family, has a unique font family ID, in a range of values that determines the script system to which the font family belongs.
size

The point sizes of the fonts in the picture. The field contains 128 bits, in which a bit is set for each point size encountered, from 1 to 127 points. Bit 0 is set if a size larger than 127 is found.
style

The styles for this font family at any of its sizes. The values in this field can also be represented with the Style data type.
nameOffset

The offset into the list of font names (indicated by the fontNamesHandle field of the PictInfo structure) at which the name for this font family is stored. A font name is given to a font family to distinguish it from other font families.
Discussion

If you specify the recordFontInfo constant in the verb parameter to the GetPictInfo function or the NewPictInfo function, your application receives a PictInfo structure that includes in its fontHandle field a handle to an array of FontSpec structures. The uniqueFonts field of the PictInfo structure indicates the number of FontSpec structures in this array. (For bitmap fonts, a font is a complete set of glyphs in one size, typeface, and style. For outline fonts, a font is a complete set of glyphs in one typeface and style.) 

When you are finished using the information returned in a FontSpec structure, you should use the Memory Manager function DisposeHandle to dispose of the memory allocated to it. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FontSpec {
   short pictFontID;
   short sysFontID;
   long size[4];
   short style;
   long nameOffset;
};
typedef struct FontSpec FontSpec;
typedef FontSpec * FontSpecPtr;
typedef FontSpecPtr * FontSpecHandle;

/*PictInfo

Contains information about a picture.

struct PictInfo {
   short version;
   long uniqueColors;
   PaletteHandle thePalette;
   CTabHandle theColorTable;
   Fixed hRes;
   Fixed vRes;
   short depth;
   Rect sourceRect;
   long textCount;
   long lineCount;
   long rectCount;
   long rRectCount;
   long ovalCount;
   long arcCount;
   long polyCount;
   long regionCount;
   long bitMapCount;
   long pixMapCount;
   long commentCount;
   long uniqueComments;
   CommentSpecHandle commentHandle;
   long uniqueFonts;
   FontSpecHandle fontHandle;
   Handle fontNamesHandle;
   long reserved1;
   long reserved2;
};
typedef struct PictInfo PictInfo;
typedef PictInfo * PictInfoPtr;
Fields
version

The version number of the Picture Utilities, currently set to 0.
uniqueColors

The number of colors in the picture specified to the GetPictInfo function, or the number of colors in the pixel map or bitmap specified to the GetPixMapInfo function, or the total number of colors for all the pictures, pixel maps, and bitmaps returned by the RetrievePictInfo function. The number of colors returned in this field is limited by the accuracy of the Picture Utilities’ color bank for color storage. See InitPickMethodProcPtr, RecordColorsProcPtr, CalcColorTableProcPtr, and DisposeColorPickMethodProcPtr for information about the Picture Utility’s color bank and about how you can create your own for selecting colors.
thePalette

A handle to the resulting Palette structure if you specified to the GetPictInfo, GetPixMapInfo, or NewPictInfo function that colors be returned in a Palette structure. That Palette structure contains either the number of colors you specified to the function or—if there are not that many colors in the pictures, pixel maps, or bitmaps—the number of colors found. Depending on the constant you pass in the verb parameter to the function, the Palette structure contains either the most used or the widest range of colors in the pictures, pixel maps, and bitmaps. On Macintosh computers running basic QuickDraw only, this field is always returned as NULL. 
theColorTable

A handle to the resulting ColorTable structure if you specified to the GetPictInfo, GetPixMapInfo, or NewPictInfo function that colors be returned in a ColorTable structure. If the pictures, pixel maps, or bitmaps contain fewer colors found than you specified to the function, the unused entries in the ColorTable structure are filled with black. Depending on the constant you pass in the verb parameter to the function, the ColorTable structure contains either the most used or the widest range of colors in the pictures, pixel maps, and bitmaps. On Macintosh computers running basic QuickDraw only, this field is always returned as NULL.

If a picture has more than 256 colors or has pixel depths of 32 bits, then Color QuickDraw translates the colors in the ColorTable structure to 16-bit depths. In such a case, the returned colors might have a slight loss of resolution, and the uniqueColors field reflects the number of colors distinguishable at that pixel depth.

hRes

The horizontal resolution of the current picture, pixel map, or bitmap retrieved by the GetPictInfo or GetPixMapInfo function or the greatest horizontal resolution from all pictures, pixel maps, and bitmaps retrieved by the RetrievePictInfo function.
vRes

The vertical resolution of the current picture, pixel map, or bitmap retrieved by the GetPictInfo or GetPixMapInfo function or the greatest vertical resolution of all pictures, pixel maps, and bitmaps retrieved by the RetrievePictInfo function. Although the values of the hRes and vRes fields are usually the same, they do not have to be.
depth

The pixel depth of the picture specified to the GetPictInfo function or the pixel map specified to the GetPixMapInfo function. When you use the RetrievePictInfo function, this field contains the deepest pixel depth of all pictures or pixel maps retrieved by the function.
sourceRect

The optimal bounding rectangle for displaying the picture at the resolution indicated by the hRes and vRes fields. The upper-left corner of the rectangle is always (0,0). Pictures created with the OpenCPicture function have the hRes, vRes, and sourceRect fields built into their Picture structures. For pictures created by OpenPicture, the hRes and vRes fields are set to 72 dpi, and the source rectangle is calculated using the picFrame field of the Picture structure for the picture.
textCount

The number of text strings in the picture specified to the GetPictInfo function, or the total number of text objects in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps specified to GetPixMapInfo or RetrievePictInfo, this field is set to 0.
lineCount

The number of lines in the picture specified to the GetPictInfo function, or the total number of lines in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps, this field is set to 0.
rectCount

The number of rectangles in the picture specified to the GetPictInfo function, or the total number of rectangles in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps, this field is set to 0.
rRectCount

The number of rounded rectangles in the picture specified to the GetPictInfo function, or the total number of rounded rectangles in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps, this field is set to 0.
ovalCount

The number of ovals in the picture specified to the GetPictInfo function, or the total number of ovals in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps, this field is set to 0.
arcCount

The number of arcs and wedges in the picture specified to the GetPictInfo function, or the total number of arcs and wedges in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps, this field is set to 0.
polyCount

The number of polygons in the picture specified to the GetPictInfo function, or the total number of polygons in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps, this field is set to 0.
regionCount

The number of regions in the picture specified to the GetPictInfo function, or the total number of regions in all the pictures retrieved by the RetrievePictInfo function. For pixel maps and bitmaps, this field is set to 0.
bitMapCount

The total number of bitmaps in the survey.
pixMapCount

The total number of pixel maps in the survey.
commentCount

The number of comments in the picture specified to the GetPictInfo function, or the total number of comments in all the pictures retrieved by the RetrievePictInfo function. This field is valid only if you specified to the GetPictInfo or NewPictInfo function that comments be returned in a CommentSpec structure. For pixel maps and bitmaps, this field is set to 0.
uniqueComments

The number of picture comments that have different IDs in the picture specified to the GetPictInfo function, or the total number of picture comments with different IDs in all the pictures retrieved by the RetrievePictInfo function. This field is valid only if you specify that comments be returned in a CommentSpec structure. For pixel maps and bitmaps, this field is set to 0.
commentHandle

A handle to an array of CommentSpec structures. For pixel maps and bitmaps, this field is set to NULL. See CommentSpec.
uniqueFonts

The number of different fonts in the picture specified to the GetPictInfo function, or the total number of different fonts in all the pictures retrieved by the RetrievePictInfo function. For bitmap fonts, a font is a complete set of glyphs in one size, typeface, and style. For outline fonts, a font is a complete set of glyphs in one typeface and style—for example, 12-point Geneva italic. For outline fonts, a font is a complete set of glyphs in one typeface and style—for example, Geneva italic. 

This field is valid only if you specify that fonts be returned in a FontSpec structure. For pixel maps and bitmaps, this field is set to 0.
fontHandle

A handle to a list of FontSpec structures. For pixel maps and bitmaps, this field is set to NULL. 
fontNamesHandle

A handle to the names of the fonts in the picture retrieved by the GetPictInfo function or the pictures retrieved by the RetrievePictInfo function. The offset to a particular name is stored in the nameOffset field of the FontSpec structure for that font. A font name is a name given to one font family to distinguish it from other font families.
reserved1
reserved2
Discussion

When you use the GetPictInfo function to collect information about a picture, or when you use the GetPixMapInfo function to collect color information about a pixel map or bitmap, the function returns the information in a PictInfo structure. When you gather this information for multiple pictures, pixel maps, or bitmaps, the RetrievePictInfo function also returns a PictInfo structure containing this information.

Initially, all of the fields in a new PictInfo structure are set to NULL. Relevant fields are set to appropriate values depending on the information you request using the Picture Utilities functions.

When you are finished with this information, be sure to dispose of it. You can dispose of Palette structures by using the Palette Manager function, DisposePalette. Dispose of ColorTable structures by using the QuickDraw function, DisposeCTable. Dispose of other allocations with the Memory Manager function, DisposeHandle. 
Availability
Available in Mac OS X v10.0 and later.*/
struct PictInfo {
   short version;
   long uniqueColors;
   PaletteHandle thePalette;
   CTabHandle theColorTable;
   Fixed hRes;
   Fixed vRes;
   short depth;
   Rect sourceRect;
   long textCount;
   long lineCount;
   long rectCount;
   long rRectCount;
   long ovalCount;
   long arcCount;
   long polyCount;
   long regionCount;
   long bitMapCount;
   long pixMapCount;
   long commentCount;
   long uniqueComments;
   CommentSpecHandle commentHandle;
   long uniqueFonts;
   FontSpecHandle fontHandle;
   Handle fontNamesHandle;
   long reserved1;
   long reserved2;
};
typedef struct PictInfo PictInfo;
typedef PictInfo * PictInfoPtr;


//function

/*GetPictInfo

Gathers information about a single picture. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

OSErr GetPictInfo (
   PicHandle thePictHandle,
   PictInfo * thePictInfo,
   short verb,
   short colorsRequested,
   short colorPickMethod,
   short version
);
Parameters
thePictHandle

A handle to a picture. 
thePictInfo

On return, a pointer to a PictInfo structure, which holds information about the picture. Initially, all of the fields in the new PictInfo structure are set to NULL. Relevant fields are set to appropriate values depending on the information you request using the GetPictInfo function.

This function collects information from black-and-white pictures and bitmaps, and is supported in System 7 even by computers running only basic QuickDraw. However, when collecting color information on a computer running only basic QuickDraw, the function returns NULL instead of a handle to a Palette or ColorTable structure.

verb

A value indicating what type of information you want GetPictInfo to return in the PictInfo structure. See “Color Information Type” for a description of the values you can use in this parameter.

You can specify whether you want color information (in a ColorTable structure, a Palette structure, or both), whether you want picture comment information, and whether you want font information. If you want color information, be sure to use the colorPickMethod parameter to specify the method by which to select colors.

Because the Palette Manager adds black and white when creating a Palette structure, you can specify the number of colors you want minus 2 in the colorsRequested parameter and specify the suppressBlackAndWhite constant in the verb parameter when gathering colors destined for a Palette structure or a screen.

colorsRequested

From 1 to 256, the number of colors you want in the ColorTable or Palette structure returned via the PictInfo structure. If you are not requesting colors (that is, if you pass the recordComments or recordFontInfo constant in the verb parameter), specify 0 in this parameter.
colorPickMethod

The method by which colors are selected for the ColorTable or Palette structure returned via the PictInfo structure. See “Color Selection Method” for a description of the values you can use here.

You can also create your own color-picking method in a resource file of type 'cpmt' and pass its resource ID in the colorPickMethod parameter. The resource ID must be greater than 127.
version

Always set this parameter to 0.
Return Value

A result code. See “Picture Utilities Result Codes”.
Discussion

The Picture Utilities provide two color-picking methods: one (specified by the popularMethod constant) that gives you the most frequently used colors and one (specified by the medianMethod constant) that gives you the widest range of colors. Each has advantages in different situations. For example, suppose the picture of a forest image contains 400 colors, of which 300 are greens, 80 are browns, and the rest are a scattering of golden sunlight effects. If you ask for the 250 most used colors, you will probably receive all greens. If you ask for a range of 250 colors, you will receive an assortment stretching from the greens and golds to the browns, including colors in between that might not actually appear in the image. If you specify the systemMethod constant, the Picture Utilities choose the method; currently they always choose popularMethod. You can also supply a color-picking method of your own.

If your application uses more than one color-picking method, it should present the user with a choice of which method to use.

When you are finished with the information in the PictInfo structure, use the Memory Manager function DisposeHandle to dispose of the PictInfo, CommentSpec, and FontSpec structures. Dispose of the Palette structure by using the DisposePalette function. Dispose of the ColorTable structure by using the DisposeCTable function. 
Special Considerations

Because Quartz 2D uses an entirely different approach to graphics than used by QuickDraw, there is no one-to-one correlation between QuickDraw and Quartz 2D functions. However, because Quartz offers many new features and improved performance compared to QuickDraw, it is worthwhile making the effort to convert your graphics code to Quartz.

When you ask for color information, GetPictInfo takes into account only the version 2 and extended version 2 picture opcodes RGBFgCol, RGBBkCol, BkPixPat, PnPixPat, FillPixPat, HiliteColor and pixel map or bitmap data. Each occurrence of these opcodes is treated as 1 pixel, regardless of the number and sizes of the objects drawn with that color. If you need an accurate set of colors from a complex picture, create an image of the picture in an offscreen pixel map, and then call the GetPixMapInfo function to obtain color information about that pixel map.

The GetPictInfo function returns a bit depth of 1 on QuickTime-compressed 'PICT' files. However, when QuickTime is installed, QuickTime decompresses and displays the image correctly.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
PictUtils.h*/
OSErr GetPictInfo (
   PicHandle thePictHandle,
   PictInfo * thePictInfo,
   short verb,
   short colorsRequested,
   short colorPickMethod,
   short version
);

#ifdef __cplusplus
}
#endif

#endif