#ifndef SCDYNAMICSTOREKEY_H
#define SCDYNAMICSTOREKEY_H

#include <sys/cdefs.h>
#include <CoreFoundation/CoreFoundation.h>

/*SCDynamicStoreKeyCreateProxies

CFStringRef SCDynamicStoreKeyCreateProxies ( 
    CFAllocatorRef allocator );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for this key. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
Return Value

Returns a notification string for the current proxy settings. 
Discussion 

Creates a key that can be used in conjunction with the SCDynamicStoreSetNotificationKeys function to receive notifications when the current network proxy settings (such as HTTP or FTP) are changed.*/

CFStringRef SCDynamicStoreKeyCreateProxies ( 
    CFAllocatorRef allocator );  

/*SCDynamicStoreKeyCreateNetworkServiceEntity

CFStringRef SCDynamicStoreKeyCreateNetworkServiceEntity ( 
    CFAllocatorRef allocator, 
    CFStringRef domain, 
    CFStringRef serviceID, 
    CFStringRef entity );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for this key. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
domain
A string specifying the desired domain, such as the requested configuration (kSCDynamicStoreDomainSetup) or the actual state (kSCDynamicStoreDomainState).
serviceID
A string containing the service ID or a regular expression pattern.
entity
A string containing the specific global entity, such as IPv4 (kSCEntNetIPv4) or DNS (kSCEntNetDNS).
Return Value

Returns a string containing the formatted key. 

Discussion 

Creates a dynamic store key that can be used to access the per-service network configuration information stored in the dynamic store.*/
CFStringRef SCDynamicStoreKeyCreateNetworkServiceEntity ( 
    CFAllocatorRef allocator, 
    CFStringRef domain, 
    CFStringRef serviceID, 
    CFStringRef entity ); 

#endif