#ifndef SCPREFERENCESPATH_H
#define  SCPREFERENCESPATH_H

#include <sys/cdefs.h>
#include <CoreFoundation/CoreFoundation.h>
#include <SystemConfiguration/SCPreferences.h>


/*SCPreferencesPathSetValue

Boolean SCPreferencesPathSetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef path, 
    CFDictionaryRef value );  
Parameters
prefs
The preferences session.
path
A string that represents the path to be updated.
value
A dictionary that represents the data to be stored at the specified path.
Return Value

Returns TRUE if successful; FALSE otherwise. 
Discussion 

Associates a dictionary with the specified path.*/
Boolean SCPreferencesPathSetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef path, 
    CFDictionaryRef value );  

/*SCPreferencesPathGetValue

CFDictionaryRef SCPreferencesPathGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef path );  
Parameters
prefs
The preferences session.
path
A string that represents the path to be returned.
Return Value

Returns the dictionary associated with the specified path; NULL if the path does not exist. 
Discussion 

Returns the dictionary associated with the specified path.*/
CFDictionaryRef SCPreferencesPathGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef path );  

/*SCPreferencesPathGetLink

CFStringRef SCPreferencesPathGetLink ( 
    SCPreferencesRef prefs, 
    CFStringRef path );  
Parameters
prefs
The preferences session.
path
A string that represents the path to be returned.
Return Value

Returns the dictionary associated with the specified path; NULL if the path is not a link or does not exist. 
Discussion 

Returns the link (if one exists) associated with the specified path.*/
CFStringRef SCPreferencesPathGetLink ( 
    SCPreferencesRef prefs, 
    CFStringRef path );  

/*SCPreferencesPathCreateUniqueChild

CFStringRef SCPreferencesPathCreateUniqueChild ( 
    SCPreferencesRef prefs, 
    CFStringRef prefix );  
Parameters
prefs
The preferences session.
prefix
A string that represents the parent path.
Return Value

Returns a string representing the new (unique) child path; NULL if the specified path does not exist. 
Discussion 

Creates a new path component within the dictionary hierarchy.*/

CFStringRef SCPreferencesPathCreateUniqueChild ( 
    SCPreferencesRef prefs, 
    CFStringRef prefix );  

/*SCPreferencesPathRemoveValue

Boolean SCPreferencesPathRemoveValue ( 
    SCPreferencesRef prefs, 
    CFStringRef path );  
Parameters
prefs
The preferences session.
path
A string that represents the path to be returned.
Return Value

Returns TRUE if successful; FALSE otherwise. 
Discussion 

Removes the data associated with the specified path.*/
Boolean SCPreferencesPathRemoveValue ( 
    SCPreferencesRef prefs, 
    CFStringRef path );  

#endif