#import <Foundation/Foundation.h>
@class DOMDocument;
@class DOMHTMLElement;
@class NSURLRequest;
@class WebArchive;
@class WebDataSource;
@class WebFramePrivate;
@class WebFrameView;
@class WebView;


@interface WebFrame : NSObject
/*loadRequest:

Connects to a given URL by initiating an asynchronous client request.

- (void)loadRequest:(NSURLRequest *)request
Discussion

Creates a provisional data source that will transition to a committed data source once any data has been received. Use the dataSource method to check if a committed data source is available, and the stopLoading method to stop the load. This method is typically invoked on the main frame.
Availability
Available in Mac OS X v10.2 with Safari 1.0 and later.
Available in Mac OS X v10.2.7 and later.
See Also
– reload
– stopLoading*/
- (void)loadRequest:(NSURLRequest *)request;

/*loadHTMLString:baseURL:

Sets the main page contents and base URL.

- (void)loadHTMLString:(NSString *)string baseURL:(NSURL *)URL
Discussion

Sets the string to use for the main page of the document to string, and the base URL to URL. The base URL allows relative URLs within a document.

Note: Since the string is treated as a webpage with UTF-16 encoding, the default encoding for any script elements referenced by the HTML is also UTF-16. To avoid this, include a character set attribute on the script element.

Availability
Available in Mac OS X v10.2 with Safari 1.0 and later.
Available in Mac OS X v10.2.7 and later.
See Also
– loadData:MIMEType:textEncodingName:baseURL:*/
- (void)loadHTMLString:(NSString *)string baseURL:(NSURL *)URL;

/*webView

Returns the web view object that manages this frame.

- (WebView *)webView
Discussion

The WebView object returned manages the entire hierarchy of frame objects that contains the receiver.
Availability
Available in Mac OS X v10.2 with Safari 1.0 and later.
Available in Mac OS X v10.2.7 and later.
See Also
– frameView*/
- (WebView *)webView;

@end
