#ifndef VNODE_H
#define VNODE_H

#include <sys/appleapiopts.h>
#include <sys/cdefs.h>
#include <sys/kernel_types.h>
#include <sys/signal.h>
#include <stdio.h>//hys
//#include <HYS/sys/vnode.h>
#include <APPLE/sys/vnode.h>

/*Flags for ioflag.

See Also:
IO_UNIT
IO_APPEND
IO_SYNC
IO_NODELOCKED
IO_NDELAY
IO_NOZEROFILL
IO_TAILZEROFILL
IO_HEADZEROFILL
IO_NOZEROVALID
IO_NOZERODIRTY
IO_CLOSE
IO_NOCACHE
IO_RAOFF
IO_DEFWRITE
#define IO_UNIT 0x0001 // do I/O as atomic unit //
#define IO_APPEND 0x0002 // append write to end //
#define IO_SYNC 0x0004 // do I/O synchronously //
#define IO_NODELOCKED 0x0008 // underlying node already 
    locked //
#define IO_NDELAY 0x0010 // FNDELAY flag set in file table 
    //
#define IO_NOZEROFILL 0x0020 // F_SETSIZE fcntl uses to 
    prevent zero filling //
#define IO_TAILZEROFILL 0x0040 // zero fills at the tail of 
    write //
#define IO_HEADZEROFILL 0x0080 // zero fills at the head of 
    write //
#define IO_NOZEROVALID 0x0100 // do not zero fill if valid 
    page //
#define IO_NOZERODIRTY 0x0200 // do not zero fill if page is
    dirty //
#define IO_CLOSE 0x0400 // I/O issued from close path //
#define IO_NOCACHE 0x0800 // same effect as VNOCACHE_DATA, but only for this 1 I/O //
#define IO_RAOFF 0x1000 // same effect as VRAOFF, but only for this 1 I/O //
#define IO_DEFWRITE 0x2000 // defer write if vfs.defwrite is
    set //*/
#define IO_UNIT 0x0001 /* do I/O as atomic unit */
#define IO_APPEND 0x0002 /* append write to end */
#define IO_SYNC 0x0004 /* do I/O synchronously */
#define IO_NODELOCKED 0x0008 /* underlying node already 
    locked */
#define IO_NDELAY 0x0010 /* FNDELAY flag set in file table 
    */
#define IO_NOZEROFILL 0x0020 /* F_SETSIZE fcntl uses to 
    prevent zero filling */
#define IO_TAILZEROFILL 0x0040 /* zero fills at the tail of 
    write */
#define IO_HEADZEROFILL 0x0080 /* zero fills at the head of 
    write */
#define IO_NOZEROVALID 0x0100 /* do not zero fill if valid 
    page */
#define IO_NOZERODIRTY 0x0200 /* do not zero fill if page is
    dirty */
#define IO_CLOSE 0x0400 /* I/O issued from close path */
#define IO_NOCACHE 0x0800 /* same effect as VNOCACHE_DATA, but only for this 1 I/O */
#define IO_RAOFF 0x1000 /* same effect as VRAOFF, but only for this 1 I/O */
#define IO_DEFWRITE 0x2000 /* defer write if vfs.defwrite is


/*FORCECLOSE

See Also:
vnode function flags
#define FORCECLOSE 0x0002 // vflush: force file closeure *
Discussion 

Flags to various vnode functions.*/
#define FORCECLOSE 0x0002

/*vnode attributes

See Also:
VNODE_ATTR_va_rdev
VNODE_ATTR_va_nlink
VNODE_ATTR_va_total_size
VNODE_ATTR_va_total_alloc
VNODE_ATTR_va_data_size
VNODE_ATTR_va_data_alloc
VNODE_ATTR_va_iosize
VNODE_ATTR_va_uid
VNODE_ATTR_va_gid
VNODE_ATTR_va_mode
VNODE_ATTR_va_flags
VNODE_ATTR_va_filesec
VNODE_ATTR_va_create_time
VNODE_ATTR_va_access_time
VNODE_ATTR_va_modify_time
VNODE_ATTR_va_change_time
VNODE_ATTR_va_backup_time
VNODE_ATTR_va_fileid
VNODE_ATTR_va_linkid
VNODE_ATTR_va_parentid
VNODE_ATTR_va_fsid
VNODE_ATTR_va_filerev
VNODE_ATTR_va_gen
VNODE_ATTR_va_encoding
VNODE_ATTR_va_type
VNODE_ATTR_BIT
#define VNODE_ATTR_va_rdev ( 1LL<< 0)
#define VNODE_ATTR_va_nlink ( 1LL<< 1)
#define VNODE_ATTR_va_total_size ( 1LL<< 2)
#define VNODE_ATTR_va_total_alloc ( 1LL<< 3)
#define VNODE_ATTR_va_data_size ( 1LL<< 4)
#define VNODE_ATTR_va_data_alloc ( 1LL<< 5)
#define VNODE_ATTR_va_iosize ( 1LL<< 6)
#define VNODE_ATTR_va_uid ( 1LL<< 7)
#define VNODE_ATTR_va_gid ( 1LL<< 8)
#define VNODE_ATTR_va_mode ( 1LL<< 9)
#define VNODE_ATTR_va_flags ( 1LL<<10)
#define VNODE_ATTR_va_filesec ( 1LL<<11)
#define VNODE_ATTR_va_create_time ( 1LL<<12)
#define VNODE_ATTR_va_access_time ( 1LL<<13)
#define VNODE_ATTR_va_modify_time ( 1LL<<14)
#define VNODE_ATTR_va_change_time ( 1LL<<15)
#define VNODE_ATTR_va_backup_time ( 1LL<<16)
#define VNODE_ATTR_va_fileid ( 1LL<<17)
#define VNODE_ATTR_va_linkid ( 1LL<<18)
#define VNODE_ATTR_va_parentid ( 1LL<<19)
#define VNODE_ATTR_va_fsid ( 1LL<<20)
#define VNODE_ATTR_va_filerev ( 1LL<<21)
#define VNODE_ATTR_va_gen ( 1LL<<22)
#define VNODE_ATTR_va_encoding ( 1LL<<23)
#define VNODE_ATTR_va_type ( 1LL<<24)
#define VNODE_ATTR_BIT( n) ( VNODE_ATTR_ ## n)*/
#define VNODE_ATTR_va_rdev ( 1LL<< 0)
#define VNODE_ATTR_va_nlink ( 1LL<< 1)
#define VNODE_ATTR_va_total_size ( 1LL<< 2)
#define VNODE_ATTR_va_total_alloc ( 1LL<< 3)
#define VNODE_ATTR_va_data_size ( 1LL<< 4)
#define VNODE_ATTR_va_data_alloc ( 1LL<< 5)
#define VNODE_ATTR_va_iosize ( 1LL<< 6)
#define VNODE_ATTR_va_uid ( 1LL<< 7)
#define VNODE_ATTR_va_gid ( 1LL<< 8)
#define VNODE_ATTR_va_mode ( 1LL<< 9)
#define VNODE_ATTR_va_flags ( 1LL<<10)
#define VNODE_ATTR_va_filesec ( 1LL<<11)
#define VNODE_ATTR_va_create_time ( 1LL<<12)
#define VNODE_ATTR_va_access_time ( 1LL<<13)
#define VNODE_ATTR_va_modify_time ( 1LL<<14)
#define VNODE_ATTR_va_change_time ( 1LL<<15)
#define VNODE_ATTR_va_backup_time ( 1LL<<16)
#define VNODE_ATTR_va_fileid ( 1LL<<17)
#define VNODE_ATTR_va_linkid ( 1LL<<18)
#define VNODE_ATTR_va_parentid ( 1LL<<19)
#define VNODE_ATTR_va_fsid ( 1LL<<20)
#define VNODE_ATTR_va_filerev ( 1LL<<21)
#define VNODE_ATTR_va_gen ( 1LL<<22)
#define VNODE_ATTR_va_encoding ( 1LL<<23)
#define VNODE_ATTR_va_type ( 1LL<<24)
#define VNODE_ATTR_BIT( n) ( VNODE_ATTR_ ## n)


/*component name parameter descriptors.

See Also:
ISDOTDOT
MAKEENTRY
ISLASTCN
ISWHITEOUT
DOWHITEOUT
#define ISDOTDOT 0x002000 / current component name is .. /
    
#define MAKEENTRY 0x004000 / entry is to be added to name 
    cache /
#define ISLASTCN 0x008000 / this is last component of 
    pathname /
#define ISWHITEOUT 0x020000 / found whiteout /
#define DOWHITEOUT 0x040000 / do whiteouts /*/
#define MAKEENTRY 0x004000 /* entry is to be added to name 
    cache */
#define ISLASTCN 0x008000 /* this is last component of 
    pathname */
#define ISWHITEOUT 0x020000 /* found whiteout */
#define DOWHITEOUT 0x040000 /* do whiteouts */

/*Vnode Attribute Macros

See Also:
VATTR_INIT
VATTR_SET_ACTIVE
VATTR_SET_SUPPORTED
VATTR_IS_SUPPORTED
VATTR_CLEAR_ACTIVE
VATTR_CLEAR_SUPPORTED
VATTR_IS_ACTIVE
VATTR_ALL_SUPPORTED
VATTR_INACTIVE_SUPPORTED
VATTR_SET
VATTR_WANTED
VATTR_RETURN
#define VATTR_INIT( v) do {( v)->va_supported = ( v)->va_active = 0ll; ( v)->va_vaflags = 0; } while( 0)
#define VATTR_SET_ACTIVE( v, a) ( ( v)->va_active |= VNODE_ATTR_ ## a)
#define VATTR_SET_SUPPORTED( v, a) ( ( v)->va_supported |= VNODE_ATTR_ ## a)
#define VATTR_IS_SUPPORTED( v, a) ( ( v)->va_supported & VNODE_ATTR_ ## a)
#define VATTR_CLEAR_ACTIVE( v, a) ( ( v)->va_active &= ~VNODE_ATTR_ ## a)
#define VATTR_CLEAR_SUPPORTED( v, a) ( ( v)->va_supported &= ~VNODE_ATTR_ ## a)
#define VATTR_IS_ACTIVE( v, a) ( ( v)->va_active & VNODE_ATTR_ ## a)
#define VATTR_ALL_SUPPORTED( v) ( ( ( v)->va_active & ( v)->va_supported) == ( v)->va_active)
#define VATTR_INACTIVE_SUPPORTED( v) do {( v)->va_active &= ~( v)->va_supported; ( v)->va_supported = 0; } while( 0)
#define VATTR_SET( v, a, x) do { ( v)-> a = ( x); ( ( v)->va_active |= VNODE_ATTR_ ## a); } while( 0)
#define VATTR_WANTED( v, a) ( ( v)->va_active |= VNODE_ATTR_ ## a)
#define VATTR_RETURN( v, a, x) do { ( v)-> a = ( x); ( ( v)->va_supported |= VNODE_ATTR_ ## a); } while( 0)*/
#define VATTR_INIT( v) do {( v)->va_supported = ( v)->va_active = 0ll; ( v)->va_vaflags = 0; } while( 0)
#define VATTR_SET_ACTIVE( v, a) ( ( v)->va_active |= VNODE_ATTR_ ## a)
#define VATTR_SET_SUPPORTED( v, a) ( ( v)->va_supported |= VNODE_ATTR_ ## a)
#define VATTR_IS_SUPPORTED( v, a) ( ( v)->va_supported & VNODE_ATTR_ ## a)
#define VATTR_CLEAR_ACTIVE( v, a) ( ( v)->va_active &= ~VNODE_ATTR_ ## a)
#define VATTR_CLEAR_SUPPORTED( v, a) ( ( v)->va_supported &= ~VNODE_ATTR_ ## a)
#define VATTR_IS_ACTIVE( v, a) ( ( v)->va_active & VNODE_ATTR_ ## a)
#define VATTR_ALL_SUPPORTED( v) ( ( ( v)->va_active & ( v)->va_supported) == ( v)->va_active)
#define VATTR_INACTIVE_SUPPORTED( v) do {( v)->va_active &= ~( v)->va_supported; ( v)->va_supported = 0; } while( 0)
#define VATTR_SET( v, a, x) do { ( v)-> a = ( x); ( ( v)->va_active |= VNODE_ATTR_ ## a); } while( 0)
#define VATTR_WANTED( v, a) ( ( v)->va_active |= VNODE_ATTR_ ## a)
#define VATTR_RETURN( v, a, x) do { ( v)-> a = ( x); ( ( v)->va_supported |= VNODE_ATTR_ ## a); } while( 0)

/*vtagtype

enum vtagtype { 
    VT_NON,
    VT_UFS,
    VT_NFS,
    VT_MFS,
    VT_MSDOSFS,
    VT_LFS,
    VT_LOFS,
    VT_FDESC, 
    VT_PORTAL,
    VT_NULL,
    VT_UMAP,
    VT_KERNFS,
    VT_PROCFS,
    VT_AFS,
    VT_ISOFS, 
    VT_UNION,
    VT_HFS,
    VT_VOLFS,
    VT_DEVFS,
    VT_WEBDAV,
    VT_UDF,
    VT_AFP, 
    VT_CDDA,
    VT_CIFS,
    VT_OTHER
};  
Discussion 

Vnode tag types. These are for the benefit of external programs only (e.g., pstat) and should NEVER be inspected by the kernel.*/
enum vtagtype	{
	VT_NON, VT_UFS, VT_NFS, VT_MFS, VT_MSDOSFS, VT_LFS, VT_LOFS, VT_FDESC,
	VT_PORTAL, VT_NULL, VT_UMAP, VT_KERNFS, VT_PROCFS, VT_AFS, VT_ISOFS,
	VT_UNION, VT_HFS, VT_VOLFS, VT_DEVFS, VT_WEBDAV, VT_UDF, VT_AFP,
	VT_CDDA, VT_CIFS,VT_OTHER};

/*vtype

enum vtype {
    VNON,
    VREG,
    VDIR,
    VBLK,
    VCHR,
    VLNK,
    VSOCK,
    VFIFO,
    VBAD,
    VSTR, 
    VCPLX 
};  
Discussion 

Vnode types. VNON means no type.*/

enum vtype	{ VNON, VREG, VDIR, VBLK, VCHR, VLNK, VSOCK, VFIFO, VBAD, VSTR,
			  VCPLX };
typedef enum vtype vtype;

//typedef enum vtype vtype;

//func

/*vnode_isdir

int vnode_isdir(
    vnode_t);  
Discussion 

Description forthcoming*/

 int vnode_isdir(
    vnode_t);

/*vnode_create

errno_t vnode_create(
    int,
    size_t,
    void *,
    vnode_t *);  
Discussion 

Create a vnode*/

errno_t vnode_create(
    int,
    size_t,
    void *,
    vnode_t *);  

/*vnode_vid

uint32_t vnode_vid(
    vnode_t);  
Discussion 

Description forthcoming*/

uint32_t vnode_vid(
    vnode_t);  


/*vnode_getwithvid

int vnode_getwithvid(
    vnode_t,
    int);  
Discussion 

Description forthcoming*/
int vnode_getwithvid(
    vnode_t,
    int);  

/*vnode_get

int vnode_get(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_get(
    vnode_t);  

/*vnode_addfsref

int vnode_addfsref(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_addfsref(
    vnode_t);  

/*vnode_mount

mount_t vnode_mount(
    vnode_t);  
Discussion 

Description forthcoming*/

mount_t vnode_mount(
    vnode_t);  

/*vn_getpath

int vn_getpath(
    struct vnode *vp,
    char *pathbuf,
    int *len);  
Discussion 

Description forthcoming*/

int vn_getpath(
    struct vnode *vp,
    char *pathbuf,
    int *len);  

/*vnode_vtype

enum vtype vnode_vtype(
    vnode_t);  
Discussion 

Description forthcoming*/
enum vtype vnode_vtype(
    vnode_t);

/*vfs_context_ucred

ucred_t vfs_context_ucred(
    vfs_context_t);  
Discussion 

Description forthcoming*/

ucred_t vfs_context_ucred(
    vfs_context_t);  

/*vnode_fsnode

void * vnode_fsnode(
    vnode_t);  
Discussion 

Description forthcoming*/
void * vnode_fsnode(
    vnode_t);  

/*vnode_removefsref

int vnode_removefsref(
    vnode_t);  
Discussion 

Description forthcoming*/

int vnode_removefsref(
    vnode_t);  

/*vnode_clearfsnode

void vnode_clearfsnode(
    vnode_t);  
Discussion 

Description forthcoming*/
void vnode_clearfsnode(
    vnode_t);  

/*vnode_put

int vnode_put(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_put(
    vnode_t);  

/*vnode_isvroot

int vnode_isvroot(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_isvroot(
    vnode_t);  

/*vnode_isnocache

int vnode_isnocache(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_isnocache(
    vnode_t);  

/*vnode_isreg

int vnode_isreg(
    vnode_t);  
Discussion 

Description forthcoming*/

int vnode_isreg(
    vnode_t);  

/*vnode_ref

int vnode_ref(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_ref(
    vnode_t);  

/*vnode_specrdev

dev_t vnode_specrdev(
    vnode_t);  
Discussion 

Description forthcoming*/
dev_t vnode_specrdev(
    vnode_t);  

/*vnode_rele

void vnode_rele(
    vnode_t);  
Discussion 

Description forthcoming*/
void vnode_rele(
    vnode_t);  


/*vflush

int vflush(
    struct mount *mp,
    struct vnode *skipvp,
    int flags);  
Discussion 

Description forthcoming*/
int vflush(
    struct mount *mp,
    struct vnode *skipvp,
    int flags);  

/*vn_default_error

int vn_default_error(
    void);  
Discussion 

A default routine which just returns an error.*/
int vn_default_error(
    void);  

/*vnode_create

errno_t vnode_create(
    int,
    size_t,
    void *,
    vnode_t *);  
Discussion 

Create a vnode*/
errno_t vnode_create(
    int,
    size_t,
    void *,
    vnode_t *);  


/*vnode_isdir

int vnode_isdir(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_isdir(
    vnode_t);  

/*vnode_mount

mount_t vnode_mount(
    vnode_t);  
Discussion 

Description forthcoming*/
mount_t vnode_mount(
    vnode_t); 

/*vnode_get

int vnode_get(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_get(
    vnode_t);  

/*vnode_getwithvid

int vnode_getwithvid(
    vnode_t,
    int);  
Discussion 

Description forthcoming*/
int vnode_getwithvid(
    vnode_t,
    int);  

/*vnode_addfsref

int vnode_addfsref(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_addfsref(
    vnode_t);  

/*vnode_vid

uint32_t vnode_vid(
    vnode_t);  
Discussion 

Description forthcoming*/
uint32_t vnode_vid(
    vnode_t);  

/*vnode_ischr

int vnode_ischr(
    vnode_t);  
Discussion 

Description forthcoming*/
int vnode_ischr(
    vnode_t);  

#include <APPLE/sys/vnode_E.h>
#endif 