#include <CarbonCore/CarbonCore.h>

//work

/*UpgradeScriptInfoToTextEncoding

Converts any combination of a Mac OS script code, a language code, a region code, and a font name to a text encoding.

OSStatus UpgradeScriptInfoToTextEncoding (
   ScriptCode iTextScriptID,
   LangCode iTextLanguageID,
   RegionCode iRegionID,
   ConstStr255Param iTextFontname,
   TextEncoding * oEncoding
);
Parameters
iTextScriptID

A valid Script Manager script code. The Mac OS Script Manager defines constants for script codes using this format: smXxx. To designate the system script, specify the meta-value of smSystemScript. To designate the current script based on the font specified in the graphics port (grafPort), specify the metavalue of smCurrentScript. To indicate that you do not want to provide a script code for this parameter, specify the constant kTextScriptDontCare. 
iTextLanguageID

A valid Script Manager language code. The Mac OS Script Manager defines constants for language codes using this format: langXxx. To indicate that you do not want to provide a language code for this parameter, specify the constant kTextLanguageDontCare. 
iRegionID

A valid Script Manager region code. The Mac OS Script Manager defines constants for region codes using this format: verXxx. To indicate that you do not want to provide a region code for this parameter, specify the constant kTextRegionDontCare. 
iTextFontname

The name of a font associated with a particular text encoding specification, such as Symbol or Zapf Dingbats, or the name of any font that is currently installed on the system. To indicate that you do not want to provide a font name, specify a value of NULL. 
oEncoding

A pointer to a value of type TextEncoding. On return, this value holds the text encoding specification that the function created from the other values you provided. 
Return Value

A result code. See “TEC Manager Result Codes”. This function returns paramErr if two or more of the input parameter values conflict in some way—for example, the Mac OS language code does not belong to the script whose script code you specified, or if the input parameter values are invalid. The function returns a kTECTableFormatErr result code if the internal mapping tables used for translation are invalid.
Discussion

The UpgradeScriptInfoToTextEncoding function allows you to derive a text encoding specification from script codes, language codes, region codes, and font names. A one-to-one correspondence exists between many of the Script Manager’s script codes and a particular Mac OS text encoding base value. However, because text encodings are a superset of script codes, some combinations of script code, language code, region code, and font name might result in a different text encoding base value than would be the case if the translation were based on the script code alone. 

When you call the UpgradeScriptInfoToTextEncoding function, you can specify any combination of its parameters, but you must specify at least one. 

If you don’t specify an explicit value for a script, language, or region code parameter, you must pass the do-not-care constant appropriate to that parameter. If you do not specify an explicit value for iTextFontName, you must pass NULL. UpgradeScriptInfoToTextEncoding uses as much information as you supply to determine the equivalent text encoding or the closest approximation. If you provide more than one parameter, all parameters are checked against one another to ensure that they are valid in combination. 

A font name, such as 'Symbol' or 'Zapf Dingbats,' can indicate a particular text encoding base. Other font names can indicate particular variants associated with a particular text encoding base. Otherwise, the font name is used to obtain a script code, and this script code will be checked against any script code you supply (in this case, the font must be installed; if it is not, the function returns a paramErr result code). If you do not supply either a language code or a region code and the script code you supply or the one that is derived matches the system script, then the system’s localization is used to determine the appropriate region and language code. This is used for deriving text encoding base values that depend on region and language, such as kTextEncodingMacTurkish. 

For more information see the RevertTextEncodingToScriptInfo function and “Base Text Encodings”. 
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
TextCommon.h*/

OSStatus UpgradeScriptInfoToTextEncoding (
   ScriptCode iTextScriptID,
   LangCode iTextLanguageID,
   RegionCode iRegionID,
   ConstStr255Param iTextFontname,
   TextEncoding * oEncoding
){};

/*CreateTextEncoding

Creates and returns a text encoding specification.

TextEncoding CreateTextEncoding (
   TextEncodingBase encodingBase,
   TextEncodingVariant encodingVariant,
   TextEncodingFormat encodingFormat
);
Parameters
encodingBase

A base text encoding.
encodingVariant

A variant of the base text encoding. To specify the default variant for the base encoding given in the encodingBase parameter, you can use the kTextEncodingDefaultVariant constant. 
encodingFormat

A format for the base text encoding. To specify the default format for the base encoding, you can use the kTextEncodingDefaultFormat constant. If you want to obtain a TextEncoding value that references UTF-16 or UTF-8, pass kUnicode16BitFormat or kUnicodeUTF8Format . 
Return Value

The text encoding specification that the function creates from the values you pass it.
Discussion

When you create a text encoding specification, the three values that you specify are packed into an unsigned integer, which you can then pass by value to the functions that use text encodings. See the data type TextEncodingRun. 
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
TextCommon.h*/

TextEncoding CreateTextEncoding (
   TextEncodingBase encodingBase,
   TextEncodingVariant encodingVariant,
   TextEncodingFormat encodingFormat
){};

/*GetTextEncodingBase

Returns the base encoding of the specified text encoding. 

TextEncodingBase GetTextEncodingBase (
   TextEncoding encoding
);
Parameters
encoding

A text encoding specification whose base encoding you want to obtain. 
Return Value

The base encoding portion of the specified text encoding. 
Discussion

See the data type TextEncodingRun
Availability
Available in CarbonLib 1.0 and later when Text Common 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
TextCommon.h*/
TextEncodingBase GetTextEncodingBase (
   TextEncoding encoding
){};


