#include <CarbonCore/CarbonCore.h>

//work

/*DisposeThread

Deletes a thread when it finishes executing. 

OSErr DisposeThread (
   ThreadID threadToDump,
   void * threadResult,
   Boolean recycleThread
);
Parameters
threadToDump

The thread ID of the thread to delete. 
threadResult

A pointer to the thread’s result. The DisposeThread function places this result to an address which you originally specify with the threadResult parameter of the NewThread function when you create or allocate the thread. Pass a value of NULL if you are not interested in obtaining a function result. 
recycleThread

A Boolean value that specifies whether to return the thread to the allocation pool or to remove it entirely. Specify False to dispose of the thread entirely and True to return it to the thread pool. 
Return Value

A result code. See “Thread Manager Result Codes”.
Discussion

When a thread finishes executing, the Thread Manager automatically calls DisposeThread to delete it. Therefore, the only reason for you to explicitly call DisposeThread is to recycle a terminating thread. To do so, set the recycleThread parameter to True. The Thread Manager clears out the thread’s internal data structure, resets it, and puts the thread in the thread pool where it can be used again as necessary. 

The DisposeThread function sets the threadResult parameter to the thread’s function result. You allocate the storage for the thread result when you create or allocate a thread with the NewThread function.

You cannot explicitly dispose of the main application thread. If you attempt to do so, DisposeThread returns the threadProtocolErr result code.

When your application terminates, the Thread Manager calls DisposeThread to terminate any active threads. It terminates stopped and ready threads first but in no special order. It terminates the currently running thread last. This thread should always be the main application thread. 

To install a callback function to do special cleanup when a thread terminates, use the SetThreadTerminator function. 
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/

OSErr DisposeThread (
   ThreadID threadToDump,
   void * threadResult,
   Boolean recycleThread
){};

/*NewThread

Creates a new thread or allocates one from the existing pool of threads.

Modified

OSErr NewThread (
   ThreadStyle threadStyle,
   ThreadEntryTPP threadEntry,
   void * threadParam,
   Size stackSize,
   ThreadOptions options,
   void ** threadResult,
   ThreadID * threadMade
);
Parameters
threadStyle

The type of thread to create. Cooperative is the only type that you can specify. Historically, the Thread Manger supported two types of threads, preemptive and cooperative, but the Thread Manager no longer supports preemptive threads. 
threadEntry

A pointer to the thread entry function. 
threadParam

A pointer to a value that the Thread Manager passes as a parameter to the thread entry function. Specify NULL if you are passing no information. 
stackSize

The stack size (in bytes) to allocate for this thread. This stack must be large enough to handle saved thread context, normal application stack usage, interrupt handling functions, and CPU exceptions. Specify a stack size of 0 (zero) to request the Thread Manager’s default stack size. 
options

Options that define characteristics of the new thread. See the Thread Option Constants data type for details on the options. You sum the options together to create a single options parameter. 
threadResult

On return, a pointer to the address of a location to hold the function result provided by the Thread Option Constants function when the thread terminates. Specify NULL for this parameter if you are not interested in the function result.
threadMade

On return, a pointer to the thread ID of the newly created or allocated thread. If there is an error, threadMade points to a value of kNoThreadID. 
Return Value

A result code. See “Thread Manager Result Codes”.
Discussion

The NewThread function obtains a thread ID that you can use in other Thread Manager functions to identify the thread. If you want to allocate a thread from the pool of threads, specify the kUsePremadeThread option of the options parameter. Otherwise, NewThread creates a new thread.

When you request a thread from the existing pool, the Thread Manager allocates one that best fits your specified stack size. If you specify the kExactMatchThread option of the options parameter, the Thread Manager allocates a thread whose stack exactly matches your stack-size requirement or, if it can’t allocate one because no such thread exists, it returns the threadTooManyReqsErr result code.

Before making any calls to NewThread, be certain that you first have called the Memory Manager function MaxApplZone to extend the application heap to its limit. You must call MaxApplZone from the main application thread before any other threads in your application run. 

When you call the NewThread function, you pass, as the threadEntry parameter, a pointer to the name of the entry function to the thread. When the newly created thread runs initially, it begins by executing this function.

You can use the threadParam parameter to pass thread-specific information to a newly created or allocated thread. In the data structure pointed to by this parameter, you could place something like A5 information or the address of a window to update. You could also use this parameter to specify a place for a thread’s local storage.

Be sure to create the storage for the threadResult parameter in a place that is guaranteed to be available when the thread terminates—for example, in an application global variable or in a local variable of the application’s main function (the main thread, by definition, cannot be disposed of so it is always available). Do not create the storage in a local variable of a subfunction that completes before the thread terminates or the storage will become invalid.

For Carbon applications, the pointer to your thread entry function must be a universal procedure pointer (UPP).

To dispose of a thread, use the DisposeThread function.

See the description of the Thread Option Constants data type for details on the characteristics you can specify in the options parameter.

For more information about the thread entry function, see the ThreadEntryProcPtr function. 
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Carbon Porting Notes

For Carbon applications, you must create and pass a universal procedure pointer (UPP) to specify the new thread callback. Use the NewThreadEntryUPP and DisposeThreadEntryUPP functions to create and remove the UPP.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/

OSErr NewThread (
   ThreadStyle threadStyle,
   ThreadEntryTPP threadEntry,
   void * threadParam,
   Size stackSize,
   ThreadOptions options,
   void ** threadResult,
   ThreadID * threadMade
){};

/*YieldToAnyThread

Relinquishes the current thread’s control.

OSErr YieldToAnyThread ();
Return Value

A result code. See “Thread Manager Result Codes”.
Discussion

The YieldToAnyThread function invokes the Thread Manager’s scheduling mechanism. The current thread relinquishes control and the Thread Manager schedules the next available thread.

The current thread is suspended in the ready state and awaits rescheduling when the CPU is available. When the suspended thread is scheduled again, YieldToAnyThread regains control and returns to the function that called it.

If you have installed a custom scheduler, the Thread Manager passes it the thread ID of the suspended thread.

In each thread you must make one or more strategically placed calls to relinquish control to another thread. You can either make this yield call or another yield call such as YieldToThread; or you can make a call such as SetThreadState to explicitly change the state of the thread.

Threads must yield in the CPU addressing mode (24-bit or 32-bit) in which the application was launched.

To relinquish control to a specific thread, use the YieldToThread function.

To change the state of a specified thread, use the SetThreadState function. 
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/
OSErr YieldToAnyThread (){};

/*NewThreadEntryUPP


ThreadEntryUPP NewThreadEntryUPP (
   ThreadEntryProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ThreadEntryUPP data type.
Special Considerations

Active development with the Thread Manager is not recommended. The API is intended only for developers who are porting their applications to Mac OS X and whose code relies on the cooperative threading model. If you are writing a new Carbon application, you should use POSIX threads or the Multiprocessing Services API instead. See Multithreading Programming Topics for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Threads.h*/

ThreadEntryUPP NewThreadEntryUPP (
   ThreadEntryProcPtr userRoutine
){};

