#import <CoreData/NSRelationshipDescription.h>

//work
@implementation   NSRelationshipDescription

/*inverseRelationship

Returns the relationship that represents the inverse of the receiver.

- (NSRelationshipDescription *)inverseRelationship
Return Value

The relationship that represents the inverse of the receiver.
Discussion

Given a to-many relationship “employees” between a Department entity and an Employee entity (a department may have many employees), and a to-one relationship “department” between an Employee entity and a Department entity (an employee may belong to only one department), the inverse of the “department” relationship is the “employees” relationship.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSRelationshipDescription *)inverseRelationship{}



/*isToMany

Returns a Boolean value that indicates whether the receiver represents a to-many relationship.

- (BOOL)isToMany
Return Value

YES if the receiver represents a to-many relationship (its maxCount is greater than 1) otherwise NO.
Availability
Available in Mac OS X v10.4 and later.
See Also
– maxCount
– setMaxCount:*/

- (BOOL)isToMany{}


/*destinationEntity

Returns the entity description of the receiver's destination.

- (NSEntityDescription *)destinationEntity
Return Value

The entity description for the receiver's destination.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSEntityDescription *)destinationEntity{}

@end
