#include <CoreGraphics/CoreGraphics.h>

//work

/*CGContextDrawImage

Draws an image into a graphics context.

void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image
);
Parameters
context

The graphics context in which to draw the image. 
rect

The location and dimensions in user space of the bounding box in which to draw the image. 
image

The image to draw. 
Discussion

Quartz scales the image—disproportionately, if necessary—to fit the bounds specified by the rect parameter.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextDrawImage (
   CGContextRef context,
   CGRect rect,
   CGImageRef image
){};

/*CGContextAddRect

Adds a new subpath, consisting of a single rectangle, to a graphics context.

void CGContextAddRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context to which to add the rectangular subpath. 
rect

A CGRect value that specifies, in the user space, the dimensions and location of the rectangle to create. 
Discussion

This function adds a subpath consisting of a single rectangle to the specified context’s path. You can add multiple rectangular subpaths at the same time using the function CGContextAddRects. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddRect (
   CGContextRef context,
   CGRect rect
){};

/*CGContextSetGrayFillColor

Sets the current fill color to a value in the DeviceGray color space.

void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
gray

A value that specifies the desired gray level. The DeviceGray color space permits the specification of a value ranging from 0.0 (absolute black) to 1.0 (absolute white). Values outside this range are clamped to 0.0 or 1.0.
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceGray.
Quartz sets the current fill color to the value you specify in the gray and alpha parameters.

See also CGContextSetGrayStrokeColor. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetGrayFillColor (
   CGContextRef context,
   float gray,
   float alpha
){};

/*CGContextRestoreGState

Sets the current graphics state to the state most recently saved.

void CGContextRestoreGState (
   CGContextRef context
);
Parameters
context

The graphics context to modify.
Discussion

When you call CGContextRestoreGState, Quartz removes the most recently saved graphics state from the top of the stack and uses that state’s saved settings for the current graphics state. See CGContextSaveGState.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRestoreGState (
   CGContextRef context
){};

/*CGContextStrokePath

Paints a line along the current path.

void CGContextStrokePath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to stroke.
Discussion

This function strokes the current path. See also CGContextDrawPath, CGContextEOFillPath, and CGContextFillPath.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextStrokePath (
   CGContextRef context
){};

/*CGContextFillPath

Paints the area within the current path, using the nonzero winding number rule.

void CGContextFillPath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to fill. 
Discussion

When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines. 

There are two different methods of filling paths. The CGContextFillPath function uses the nonzero winding number rule. The function CGContextEOFillPath uses the even-odd rule to fill a path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextFillPath (
   CGContextRef context
){};

/*CGContextAddArc

Adds an arc of a circle to the current path, using a center point, radius, and end point.

void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
);
Parameters
context

The graphics context to which to add the arc.
x

The x-coordinate of the user space for the center of the arc.
y

The y-coordinate of the user space for the center of the arc.
radius

The radius of the arc, in user space coordinates.
startAngle

The angle to the starting point of the arc, measured in radians from the positive x-axis.
endAngle

The angle to the end point of the arc, measured in radians from the positive x-axis.
clockwise

Pass 1 if the arc is to be drawn clockwise; 0 otherwise.
Discussion

When you call this function, Quartz builds an arc of a circle centered on the point you provide. The arc is of the specified radius and extends between the start and end point. (You can also use CGContextAddArc as a convenient way to draw a circle, by setting the start point to 0 and the end point to 2*Pi.)

If the current path already contains a subpath, Quartz additionally appends a straight line segment from the current point to the starting point of the arc. If the current path is empty, Quartz creates a new subpath for the arc and does not add the initial straight line segment.

After adding the arc, the current point is reset to the end point of arc (the second tangent point).

See also CGContextAddArcToPoint. 
Availability
Available in Mac OS X version 10.0 and later.*/
void CGContextAddArc (
   CGContextRef context,
   float x,
   float y,
   float radius,
   float startAngle,
   float endAngle,
   int clockwise
){};

/*CGContextBeginPath

Creates a new empty path in a graphics context.

void CGContextBeginPath (
   CGContextRef context
);
Parameters
context

The graphics context in which to begin a new path.
Discussion

A graphics context can have only a single path in use at any time. Therefore, if the specified context already contains a current path when you call this function, Quartz replaces the previous current path with the new path. In this case, Quartz discards the old path and any data associated with it.

The current path is not part of the graphics state. Consequently, saving and restoring the graphics state has no effect on the current path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextBeginPath (
   CGContextRef context
){};

/*CGContextSetRGBStrokeColor

Sets the current stroke color to a value in the DeviceRGB color space.

void CGContextSetRGBStrokeColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current stroke color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current stroke color space to DeviceRGB.
Quartz sets the current stroke color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBFillColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBStrokeColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
){};

/*CGContextSetLineWidth

Sets the line width for a graphics context.

void CGContextSetLineWidth (
   CGContextRef context,
   float width
);
Parameters
context

The graphics context for which to set the line width parameter of the current graphics state. 
width

The new line width to be used, in user space units. The value must be greater than 0.
Discussion

The line width is the total width of the line, expressed in units of the user space. The line surrounds the center of the path, with half of the total width on either side. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetLineWidth (
   CGContextRef context,
   float width
){};

/*CGContextSaveGState

Pushes a copy of the current graphics state on the top of a context’s graphics state stack.

void CGContextSaveGState (
   CGContextRef context
);
Parameters
context

The graphics context for which to save the current graphics state. 
Discussion

Each graphics context maintains a stack of graphics states. When you call CGContextSaveGState, Quartz saves the current graphics state to the top of the context’s graphics state stack.

Note that not all aspects of the current drawing environment are elements of the graphics state. For example, the current path is not considered part of the graphics state and is therefore not saved when you call the CGContextSaveGState function. The graphics state parameters that are saved are:
CTM (current transformation matrix) 
clip region
image interpolation quality 
line width 
line join 
miter limit 
line cap 
line dash 
flatness 
should anti-alias 
rendering intent 
fill color space 
stroke color space 
fill color 
stroke color 
alpha value 
font 
font size 
character spacing 
text drawing mode
shadow parameters
the pattern phase
the font smoothing parameter
blend mode

To restore your drawing environment to a previously saved state, you can use the function CGContextRestoreGState. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSaveGState (
   CGContextRef context
){};

/*CGContextSetRGBFillColor

Sets the current fill color to a value in the DeviceRGB color space.

void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
);
Parameters
context

The graphics context for which to set the current fill color. 
red

The red intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
green

The green intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
blue

The blue intensity value for the color to set. The DeviceRGB colorspace permits the specification of a value ranging from 0.0 (zero intensity) to 1.0 (full intensity).
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current fill color space to DeviceRGB. 
Quartz sets the current fill color to the value specified by the red, green, blue, and alpha parameters.

See also CGContextSetRGBStrokeColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetRGBFillColor (
   CGContextRef context,
   float red,
   float green,
   float blue,
   float alpha
){};

/*CGContextFillRect

Paints the area contained within a rectangle.

void CGContextFillRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
Discussion

This function paints the area contained within the specified rectangle, using the fill color specified in the current graphics state. As a side effect when you call this function, Quartz clears the current path.

See also CGContextFillRects.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextFillRect (
   CGContextRef context,
   CGRect rect
){};


/*CGContextRelease

Decrements the retain count of a graphics context.

void CGContextRelease (
   CGContextRef context
);
Parameters
context

The graphics context to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the context parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRelease (
   CGContextRef context
){};

/*CGContextMoveToPoint

Begins a new subpath at the point you specify.

void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

A graphics context. 
x

A value for the x-coordinate of the user space at which to begin the subpath.
y

A value for the y-coordinate of the user space at which to begin the subpath.
Discussion

The CGContextMoveToPoint function begins a new subpath starting at the point you specify. This point is defined to be the “current” point, and it defines the starting point of the next line segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextMoveToPoint (
   CGContextRef context,
   float x,
   float y
){};

/*CGContextAddCurveToPoint

Appends a cubic Bézier curve from the current point, using control points and an end point you specify.

void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
);
Parameters
context

The graphics context to which to add the curve. The context’s path must not be empty.
cp1x

The x-coordinate of the user space for the first control point of the curve.
cp1y

The y-coordinate of the user space for the first control point of the curve.
cp2x

The x-coordinate of the user space for the second control point of the curve.
cp2y

The y-coordinate of the user space for the second control point of the curve.
x

The x-coordinate of the user space at which to end the curve.
y

The y-coordinate of the user space at which to end the curve.
Discussion

This function appends a cubic curve to the current path. After adding the segment, the current point is reset from the beginning of the new segment to the end point of that segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddCurveToPoint (
   CGContextRef context,
   float cp1x,
   float cp1y,
   float cp2x,
   float cp2y,
   float x,
   float y
){};

/*CGContextAddLineToPoint

Appends a straight line segment from the current point to the point you specify.

void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

The graphics context to which to add a line segment. The context’s path must not be empty.
x

A value for the x-coordinate of the user space at which to end the line segment.
y

A value for the y-coordinate of the user space at which to end the line segment.
Discussion

This function appends a single straight line segment to the current subpath. After adding the line segment, the current point is reset from the beginning of the new line segment to the endpoint of that line segment. You can add a subpath consisting of multiple straight line segments using the function CGContextAddLines.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddLineToPoint (
   CGContextRef context,
   float x,
   float y
){};

/*CGContextSetLineCap

Sets the style for the endpoints of lines in a graphics context.

void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap
);
Parameters
context

The graphics context for which to set the line cap parameter of the current graphics state. 
cap

A CGLineCap value that specifies the line cap style to be used. For a discussion of the available line cap styles, see Line Cap Styles.
Discussion

The line cap style specifies how Quartz draws the endpoint of a line. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetLineCap (
   CGContextRef context,
   CGLineCap cap
){};

/*CGContextClipToMask

Maps a mask into the specified rectangle and intersects it with the current clipping area of the graphics context.

void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
);
Parameters
c

A graphics context. 
rect

The rectangle to map the mask parameter to.
mask

An image or an image mask. If mask is an image, then it must be in the DeviceGray color space, may not have an alpha component, and may not be masked by an image mask or masking color.
Discussion

If the mask parameter is an image mask, then Quartz clips in a manner identical to the behavior seen with the function CGContextDrawImage—the mask indicates an area to be left unchanged when drawing. The source samples of the image mask determine which points of the clipping area are changed, acting as an "inverse alpha" value. If the value of a source sample in the image mask is S, then the corresponding point in the current clipping area is multiplied by an alpha value of (1–S). For example, if S is 1 then the point in the clipping area becomes transparent. If S is 0, the point in the clipping area is unchanged.

If the mask parameter is an image, then mask acts like an alpha mask and is blended with the current clipping area. The source samples of mask determine which points of the clipping area are changed. If the value of the source sample in mask is S, then the corresponding point in the current clipping area is multiplied by an alpha of S. For example, if S is 0, then the point in the clipping area becomes transparent. If S is 1, the point in the clipping area is unchanged.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/
void CGContextClipToMask(
CGContextRef c,
CGRect rect,
CGImageRef mask
){};

/*CGContextTranslateCTM

Changes the origin of the user coordinate system in a context.

void CGContextTranslateCTM (
   CGContextRef context,
   float tx,
   float ty
);
Parameters
context

A graphics context. 
tx

The amount to displace the x-axis of the coordinate space, in units of the user space, of the specified context.
ty

The amount to displace the y-axis of the coordinate space, in units of the user space, of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextTranslateCTM (
   CGContextRef context,
   float tx,
   float ty
){};

/*CGContextConcatCTM

Transforms the user coordinate system in a context using a specified matrix.

void CGContextConcatCTM (
   CGContextRef context,
   CGAffineTransform transform
);
Parameters
context

A graphics context. 
transform

The transformation matrix to apply to the specified context’s current transformation matrix. 
Discussion

When you call the function CGContextConcatCTM, it concatenates (that is, it combines) two matrices, by multiplying them together. The order in which matrices are concatenated is important, as the operations are not commutative. When you call CGContextConcatCTM, the resulting CTM in the context is: CTMnew = transform * CTMcontext.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextConcatCTM (
   CGContextRef context,
   CGAffineTransform transform
){};

/*CGContextRotateCTM

Rotates the user coordinate system in a context.

void CGContextRotateCTM (
   CGContextRef context,
   float angle
);
Parameters
context

A graphics context. 
angle

The angle, in radians, by which to rotate the coordinate space of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextRotateCTM (
   CGContextRef context,
   float angle
){};

/*CGContextScaleCTM

Changes the scale of the user coordinate system in a context.

void CGContextScaleCTM (
   CGContextRef context,
   float sx,
   float sy
);
Parameters
context

A graphics context. 
sx

The factor by which to scale the x-axis of the coordinate space of the specified context.
sy

The factor by which to scale the y-axis of the coordinate space of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextScaleCTM (
   CGContextRef context,
   float sx,
   float sy
){};

/*CGContextClearRect

Paints a transparent rectangle.

void CGContextClearRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle. 
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint transparently. 
Discussion

If the specified context is a window or bitmap context, Quartz effectively “clears” the rectangle. For other types of context, Quartz fills the rectangle in a device-dependent manner.
Special Considerations

The use of this function is not recommended in contexts other than window or bitmap contexts.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextClearRect (
   CGContextRef context,
   CGRect rect
){};

/*CGContextSetGrayStrokeColor

Sets the current stroke color to a value in the DeviceGray color space.

void CGContextSetGrayStrokeColor (
   CGContextRef context,
   float gray,
   float alpha
);
Parameters
context

The graphics context for which to set the current stroke color. 
gray

A value that specifies the desired gray level. The DeviceGray color space permits the specification of a value ranging from 0.0 (absolute black) to 1.0 (absolute white). Values outside this range are clamped to 0.0 or 1.0.
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

When you call this function, two things happen:
Quartz sets the current stroke color space to DeviceGray. The DeviceGray color space is a single-dimension space in which color values are specified solely by the intensity of a gray value (from absolute black to absolute white). 
Quartz sets the current stroke color to the value you specify in the gray and alpha parameters.

See also CGContextSetGrayFillColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetGrayStrokeColor (
   CGContextRef context,
   float gray,
   float alpha
){};

/*CGContextStrokeRect

Paints an outline of a rectangle.

void CGContextStrokeRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
Discussion

This function paints a line along the path of the specified rectangle, using the current attributes of the graphics state. As a side effect when you call this function, Quartz clears the current path.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextStrokeRect (
   CGContextRef context,
   CGRect rect
){};

/*CGContextGetTextPosition

Returns the location at which text is drawn.

CGPoint CGContextGetTextPosition (
   CGContextRef context
);
Parameters
context

The graphics context from which to obtain the current text position. 
Return Value

Returns a CGPoint value that specifies the x and y values at which text is to be drawn, in user space coordinates. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

CGPoint CGContextGetTextPosition (
   CGContextRef context
){};

/*CGContextSetTextDrawingMode

Sets the current text drawing mode.

void CGContextSetTextDrawingMode (
   CGContextRef context,
   CGTextDrawingMode mode
);
Parameters
context

The graphics context for which to set the text drawing mode. 
mode

A CGTextDrawingMode value that specifies the text drawing mode to use. For possible values, see Text Drawing Modes.
Discussion

Text drawing modes determine how Quartz renders individual glyphs in a graphics context. For more information, see Text Drawing Modes.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetTextDrawingMode (
   CGContextRef context,
   CGTextDrawingMode mode
){};

/*CGContextSelectFont

Sets the font and font size in a graphics context.

void CGContextSelectFont (
   CGContextRef context,
   const char * name,
   float size,
   CGTextEncoding textEncoding
);
Parameters
context

The graphics context for which to set the font and font size. 
name

A null-terminated string that contains the PostScript name of the font to set.
size

A value that specifies the font size to set, in text space units.
textEncoding

A CGTextEncoding value that specifies the encoding used for the font. For a description of the available values, see Text Encodings.
Discussion

For information about when to use this function, see CGFontCreateWithPlatformFont.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSelectFont (
   CGContextRef context,
   const char * name,
   float size,
   CGTextEncoding textEncoding
){};

/*CGContextShowTextAtPoint

Displays a character string at a position you specify.

void CGContextShowTextAtPoint (
   CGContextRef context,
   float x,
   float y,
   const char * bytes,
   size_t length
);
Parameters
context

The graphics context in which to display the text. 
x

A value for the x-coordinate of the text space at which to display the text.
y

A value for the y-coordinate of the text space at which to display the text.
bytes

An array of characters to draw.
length

The length of the array specified in the bytes parameter.
Discussion

This function displays a character array at the position in the text space that you specify. Quartz use font data provided by ATS (Apple Type Services) to map each byte of the array through the encoding vector of the current font to obtain the glyph to display. Note that the font must have been set using CGContextSelectFont; CGContextShowTextAtPoint should not be used in conjunction with CGContextSetFont.

See also CGContextShowText, CGContextShowGlyphs, CGContextShowGlyphsAtPoint, and CGContextShowGlyphsWithAdvances.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextShowTextAtPoint (
   CGContextRef context,
   float x,
   float y,
   const char * bytes,
   size_t length
){};


/*CGContextFlush

Forces all pending drawing operations in a window context to be rendered immediately to the destination device.

void CGContextFlush (
   CGContextRef context
);
Parameters
context

The window context to flush. If you pass a PDF context or a bitmap context, this function does nothing.
Discussion

When you call this function, Quartz immediately flushes the current drawing to the destination device (for example, a screen). Because the system software flushes a context automatically at the appropriate times, calling this function could have an adverse effect on performance. Under normal conditions, you do not need to call this function.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextFlush (
   CGContextRef context
){};


/*CGContextSetTextMatrix

Sets the current text matrix.

void CGContextSetTextMatrix (
   CGContextRef context,
   CGAffineTransform transform
);
Parameters
context

The graphics context for which to set the text matrix. 
transform

A text matrix to set. 
Discussion

The text matrix specifies the transform from text space to user space. To produce the final text rendering matrix that is used to actually draw the text on the page, Quartz concatenates the text matrix with the current transformation matrix and other parameters from the graphics state.

Note that the text matrix is not a part of the graphics state—saving or restoring the graphics state has no effect on the text matrix. The text matrix is an attribute of the graphics context, not of the current font.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetTextMatrix (
   CGContextRef context,
   CGAffineTransform transform
){};

/*CGContextSetShadow

Enables shadowing in a graphics context. 

void CGContextSetShadow (
   CGContextRef context,
   CGSize offset,
   float blur
);
Parameters
context

A graphics context.
offset

Specifies a translation of the context’s coordinate system, to establish an offset for the shadow ({0,0} specifies a light source immediately above the screen).
blur

A non-negative number specifying the amount of blur.
Discussion

Shadow parameters are part of the graphics state in a context. After shadowing is set, all objects drawn are shadowed using a black color with 1/3 alpha (i.e., RGBA = {0, 0, 0, 1.0/3.0}) in the DeviceRGB color space.

To turn off shadowing:
Use the standard save/restore mechanism for the graphics state.
Use CGContextSetShadowWithColor to set the shadow color to a fully transparent color (or pass NULL as the color).
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGContext.h*/
void CGContextSetShadow (
   CGContextRef context,
   CGSize offset,
   float blur
){};


/*CGContextSetShouldSmoothFonts

Enables or disables font smoothing in a graphics context.

void CGContextSetShouldSmoothFonts (
CGContextRef context,
bool shouldSmoothFonts
);
Parameters
context

The graphics context to modify.
shouldSmoothFonts

A Boolean value that specifies whether font smoothing should be enabled.
Discussion

There are cases, such as rendering to a bitmap, when font smoothing is not appropriate and should be disabled. Note that some contexts (such as PostScript contexts) do not support font smoothing.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGContext.h*/
void CGContextSetShouldSmoothFonts (
CGContextRef context,
bool shouldSmoothFonts
){};

/*CGContextClipToRect

Sets the clipping path to the intersection of the current clipping path with the area defined by the specified rectangle.

void CGContextClipToRect (
   CGContextRef context,
   CGRect rect
);
Parameters
context

The graphics context for which to set the clipping path. 
rect

A CGRect value that specifies, in the user space, the location and dimensions of the rectangle to be used in determining the new clipping path. 
Discussion

This function sets the specified graphics context’s clipping region to the area which intersects both the current clipping path and the specified rectangle.

After determining the new clipping path, the CGContextClipToRect function resets the context’s current path to an empty path.

See also CGContextClipToRects. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextClipToRect (
   CGContextRef context,
   CGRect rect
){};

/*CGContextAddRects

Adds a set of new rectangular subpaths to a graphics context.

void CGContextAddRects (
   CGContextRef context,
   const CGRect rects[],
   size_t count
);
Parameters
context

The graphics context to which to add the rectangular subpaths.
rects

An array of CGRect values that specify, in the user space, the dimensions and locations of the rectangles to create. 
count

The number of members in the array that you are passing in the rects parameter.
Discussion

This function adds multiple rectangular subpaths to a path at the same time. You can add a subpath consisting of a single rectangle using the function CGContextAddRect. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextAddRects (
   CGContextRef context,
   const CGRect rects[],
   size_t count
){};

/*CGContextGetPathBoundingBox

Returns the smallest rectangle that contains the current path.

CGRect CGContextGetPathBoundingBox (
   CGContextRef context
);
Parameters
context

The graphics context, containing a path, to examine. 
Return Value

A CGRect value that specifies the dimensions and location, in user space, of the bounding box of the path. If there is no path, the function returns CGRectNull.
Discussion

The bounding box is the smallest rectangle completely enclosing all points in a path, including control points for Bézier cubic and quadratic curves.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

CGRect CGContextGetPathBoundingBox (
   CGContextRef context
){};

/*CGContextClosePath

Closes and terminates an open subpath.

void CGContextClosePath (
   CGContextRef context
);
Parameters
context

The graphics context containing the subpath to close.
Discussion

If a subpath is open, this function closes the subpath (draws a straight line that connects the current point to the starting point), and terminates the subpath (the current point is no longer defined).

If no subpath is open, this function does nothing.

NOTE: You can stroke along an open subpath. When a subpath is open and you fill or clip, however, Quartz implicitly closes the subpath for you.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextClosePath (
   CGContextRef context
){};

/*CGContextSynchronize

Marks a window context for update.

void CGContextSynchronize (
   CGContextRef context
);
Parameters
context

The window context to synchronize. If you pass a PDF context or a bitmap context, this function does nothing. 
Discussion

When you call this function, all drawing operations since the last update will be flushed at the next regular opportunity. Under normal conditions, you do not need to call this function.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSynchronize (
   CGContextRef context
){};

/*CGContextGetCTM

Returns the current transformation matrix.

CGAffineTransform CGContextGetCTM (
   CGContextRef context
);
Parameters
context

A graphics context.
Return Value

The transformation matrix for the current graphics state of the specified context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
CGAffineTransform CGContextGetCTM (
   CGContextRef context
){};

/*CGContextStrokeRectWithWidth

Paints an outline of a rectangle, using the specified line width.

void CGContextStrokeRectWithWidth (
   CGContextRef context,
   CGRect rect,
   float width
);
Parameters
context

The graphics context in which to paint the rectangle.
rect

A CGRect value that specifies the dimensions and location in the user space of the rectangle to paint. 
width

The line width to use for stroking the rectangle, expressed in user space units. The value must be greater than zero.
Discussion

This function paints a line of the specified width along the path of a rectangle. The line surrounds the center of the path, with half of the total width on either side. As a side effect when you call this function, Quartz clears the current path.

Aside from the line width value, which is taken from the function’s width parameter, CGContextStrokeRectWithWidth uses the current attributes of the graphics state to paint the line. 

On return, the line width in the context’s graphics state is unaffected.

See also CGContextStrokeRect.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextStrokeRectWithWidth (
   CGContextRef context,
   CGRect rect,
   float width
){};

/*CGContextBeginPage

Starts a new page in a page-based graphics context.

void CGContextBeginPage (
   CGContextRef context,
   const CGRect * mediaBox
);
Parameters
context

A page-based graphics context such as a PDF context. If you specify a context that does not support multiple pages, this function does nothing.
mediaBox

A Quartz rectangle defining the bounds of the new page, expressed in units of the default user space, or NULL. These bounds supersede any supplied for the media box when you created the context. If you pass NULL, Quartz uses the rectangle you supplied for the media box when the graphics context was created. 
Discussion

When using a graphics context that supports multiple pages, you should call this function together with CGContextEndPage to delineate the page boundaries in the output. In other words, each page should be bracketed by calls to CGContextBeginPage and CGContextEndPage. Quartz ignores all drawing operations performed outside a page boundary in a page-based context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextBeginPage (
   CGContextRef context,
   const CGRect * mediaBox
){};

/*CGContextEndPage

Ends the current page in a page-based graphics context.

void CGContextEndPage (
   CGContextRef context
);
Parameters
context

A page-based graphics context.
Discussion

When using a graphics context that supports multiple pages, you should call this function to terminate drawing in the current page. 

For more information, see CGContextBeginPage.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextEndPage (
   CGContextRef context
){};

/*CGContextSetLineJoin

Sets the style for the joins of connected lines in a graphics context.

void CGContextSetLineJoin (
   CGContextRef context,
   CGLineJoin join
);
Parameters
context

The graphics context for which to set the line join parameter of the current graphics state. 
join

A CGLineJoin value that specifies the new line join style to be used. For an discussion of the available line join styles, see Line Joins. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetLineJoin (
   CGContextRef context,
   CGLineJoin join
){};

/*CGContextSetMiterLimit

Sets the miter limit for the joins of connected lines in a graphics context.

void CGContextSetMiterLimit (
   CGContextRef context,
   float limit
);
Parameters
context

The graphics context for which to set the miter limit parameter of the current graphics state. 
limit

The new miter limit to be used.
Discussion

If the current line join style is set to kCGLineJoinMiter (see CGContextSetLineJoin), Quartz uses the miter limit to determine whether the lines should be joined with a bevel instead of a miter. Quartz divides the length of the miter by the line width. If the result is greater than the miter limit, the style is converted to a bevel. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetMiterLimit (
   CGContextRef context,
   float limit
){};

/*CGContextDrawShading

Fills the clipping path of a context with the specified shading.

void CGContextDrawShading (
CGContextRef context,
CGShadingRef shading
);
Parameters
context

The graphics context in which to draw the shading. 
shading

A Quartz shading. Quartz retains this object; upon return, you may safely release it.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGContext.h*/

void CGContextDrawShading (
CGContextRef context,
CGShadingRef shading
){};

/*CGContextSetTextPosition

Sets the location at which text is drawn.

void CGContextSetTextPosition (
   CGContextRef context,
   float x,
   float y
);
Parameters
context

The graphics context for which to set the current text position. 
x

A value for the x-coordinate at which to draw the text, in user space coordinates.
y

A value for the y-coordinate at which to draw the text.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetTextPosition (
   CGContextRef context,
   float x,
   float y
){};

/*CGContextShowText

Displays a character string at the current text position.

void CGContextShowText (
   CGContextRef context,
   const char * bytes,
   size_t length
);
Parameters
context

The graphics context in which the text is drawn. 
bytes

An array of characters to draw.
length

The length of the array specified in the bytes parameter.
Discussion

This function displays a character array at the current text position, a point specified by the current text matrix. Quartz use font data provided by ATS (Apple Type Services) to map each byte of the array through the encoding vector of the current font to obtain the glyph to display. Note that the font must have been set using CGContextSelectFont; CGContextShowText should not be used in conjunction with CGContextSetFont.

See also CGContextShowTextAtPoint, CGContextShowGlyphs, CGContextShowGlyphsAtPoint, and CGContextShowGlyphsWithAdvances.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextShowText (
   CGContextRef context,
   const char * bytes,
   size_t length
){};

/*CGContextSetFillColor

Sets the current fill color.

void CGContextSetFillColor(
   CGContextRef context,
   const float components[]
);
Parameters
context

The graphics context for which to set the current fill color.
components 

An array of intensity values describing the color to set. The number of array elements must equal the number of components in the current fill color space, plus an additional component for the alpha value.
Discussion

The current fill color space must not be a pattern colorspace. For information on setting the fill color when using a pattern colorspace, see CGContextSetFillPattern. Note that the preferred API to use is now CGContextSetFillColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextSetFillColor(
   CGContextRef context,
   const float components[]
){};

/*CGContextSetStrokeColor

Sets the current stroke color.

void CGContextSetStrokeColor(
   CGContextRef context,
   const float components[]
);
Parameters
context

The graphics context for which to set the current stroke color.
components

An array of intensity values describing the color to set. The number of array elements must equal the number of components in the current stroke color space, plus an additional component for the alpha value.
Discussion

The current stroke color space must not be a pattern color space. For information on setting the stroke color when using a pattern colorspace, see CGContextSetStrokePattern. Note that the preferred API is now CGContextSetStrokeColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetStrokeColor(
   CGContextRef context,
   const float components[]
){};

/*CGContextSetLineDash

Sets the pattern for dashed lines in a graphics context.

void CGContextSetLineDash (
   CGContextRef context,
   float phase,
   const float lengths[],
   size_t count
);
Parameters
context

The graphics context for which to set the line dash parameter of the current graphics state. 
phase

A value that specifies how far into the dash pattern the line starts, in units of the user space. For example, passing a value of 3 means the line is drawn with the dash pattern starting at 3 units in from its beginning. Passing a value of 0 draws a line starting with the beginning of a dash pattern.
lengths

An array of values that specify the lengths of the painted segments and unpainted segments, respectively, of the dash pattern—or NULL for no dash pattern.

For example, passing an array with the values [2,3] sets a dash pattern that alternates between a 2-user-space-unit-long painted segment and a 3-user-space-unit-long unpainted segment. Passing the values [1,3,4,2] sets the pattern to a 1-unit painted segment, a 3-unit unpainted segment, a 4-unit painted segment, and a 2-unit unpainted segment.
count

If the lengths parameter specifies an array, pass the number of elements in the array. Otherwise, pass 0.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetLineDash (
   CGContextRef context,
   float phase,
   const float lengths[],
   size_t count
){};


/*CGContextAddArcToPoint

Adds an arc of a circle to the current subpath, using a radius and tangent points.

void CGContextAddArcToPoint (
   CGContextRef context,
   float x1,
   float y1,
   float x2,
   float y2,
   float radius
);
Parameters
context

The graphics context to which to add the arc. The context’s path must not be empty.
x1

The x-coordinate of the user space for the end point of the first tangent line. The first tangent line is drawn from the current point to (x1,y1).
y1

The y-coordinate of the user space for the end point of the first tangent line. The first tangent line is drawn from the current point to (x1,y1).
x2

The x-coordinate of the user space for the end point of the second tangent line. The second tangent line is drawn from (x1,y1) to (x2,y2).
y2

The y-coordinate of the user space for the end point of the second tangent line. The second tangent line is drawn from (x1,y1) to (x2,y2).
radius

The radius of the arc, in user space coordinates.
Discussion

This function draws an arc that is tangent to the line from the current point to (x1,y1) and to the line from (x1,y1) to (x2,y2). The start and end points of the arc are located on the first and second tangent lines, respectively. The start and end points of the arc are also the “tangent points” of the lines.

If the current point and the first tangent point of the arc (the starting point) are not equal, Quartz appends a straight line segment from the current point to the first tangent point. After adding the arc, the current point is reset to the end point of arc (the second tangent point).

See also CGContextAddArc.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextAddArcToPoint (
   CGContextRef context,
   float x1,
   float y1,
   float x2,
   float y2,
   float radius
){};

/*CGContextDrawPath

Draws the current path using a specified drawing mode.

void CGContextDrawPath (
   CGContextRef context,
   CGPathDrawingMode mode
);
Parameters
context

The graphics context containing the path to paint.
mode

A CGPathDrawingMode value that specifies how to paint the path. See CGPathDrawingMode for possible values.
Discussion

This function draws the current path using the specified drawing mode. When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines.

See also CGContextFillPath, CGContextEOFillPath, and CGContextStrokePath.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

void CGContextDrawPath (
   CGContextRef context,
   CGPathDrawingMode mode
){};

/*CGContextSetFillColorSpace

Sets the fill color space in a graphics context.

void CGContextSetFillColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
);
Parameters
context

The graphics context for which to set the fill color space.
colorspace

The new fill color space. Quartz retains this object; upon return, you may safely release it.
Discussion

As a side effect of this function, Quartz assigns an appropriate initial value to the fill color, based on the specified color space. To change this value, call CGContextSetFillColor. Note that the preferred API to use is now CGContextSetFillColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetFillColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
){};

/*CGContextSetStrokeColorSpace

Sets the stroke color space in a graphics context.

void CGContextSetStrokeColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
);
Parameters
context

The graphics context for the new stroke color space.
colorspace

The new stroke color space. Quartz retains this object; upon return, you may safely release it.
Discussion

As a side effect when you call this function, Quartz assigns an appropriate initial value to the stroke color, based on the color space you specify. To change this value, call CGContextSetStrokeColor. Note that the preferred API is now CGContextSetStrokeColorWithColor.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetStrokeColorSpace (
   CGContextRef context,
   CGColorSpaceRef colorspace
){};

/*CGContextDrawPDFPage

Draws a page in the current user space of a PDF context.

void CGContextDrawPDFPage (
   CGContextRef context,
   CGPDFPageRef page
);
Parameters
context

The graphics context in which to draw the PDF page. 
page

A Quartz PDF page.
Discussion

This function works in conjunction with the opaque type CGPDFPageRef to draw individual pages into a PDF context.

For applications running in Mac OS X version 10.3 and later, this function is recommended as a replacement for the older function CGContextDrawPDFDocument.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGContext.h*/
void CGContextDrawPDFPage (
   CGContextRef context,
   CGPDFPageRef page
){};

/*CGContextEOClip

Modifies the current clipping path, using the even-odd rule.

void CGContextEOClip (
   CGContextRef context
);
Parameters
context

A graphics context containing a path. If the context does not have a current path, the function does nothing.
Discussion

The function uses the even-odd rule to calculate the intersection of the current path with the current clipping path. Quartz then uses the path resulting from the intersection as the new current clipping path for subsequent painting operations.

Unlike the current path, the current clipping path is part of the graphics state. Therefore, to re-enlarge the paintable area by restoring the clipping path to a prior state, you must save the graphics state before you clip and restore the graphics state after you’ve completed any clipped drawing.

After determining the new clipping path, the function resets the context’s current path to an empty path.

See also CGContextClip.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextEOClip (
   CGContextRef context
){};

/*CGContextGetPathCurrentPoint

Returns the current point in a non-empty path.

CGPoint CGContextGetPathCurrentPoint (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to examine. 
Return Value

A CGPoint value that specifies the location, in user space, of current point in the context’s path. If there is no path, the function returns CGPointZero.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
CGPoint CGContextGetPathCurrentPoint (
   CGContextRef context
){};

/*CGContextIsPathEmpty

Indicates whether the current path contains any subpaths.

int CGContextIsPathEmpty (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to examine. 
Return Value

Returns 1 if the context’s path contains no subpaths, otherwise returns 0. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/

int CGContextIsPathEmpty (
   CGContextRef context
){};


/*CGContextSetShouldAntialias

Sets anti-aliasing on or off for a graphics context.

void CGContextSetShouldAntialias (
   CGContextRef context,
   bool shouldAntialias
);
Parameters
context

The graphics context to modify.
shouldAntialias

A Boolean value that specifies whether anti-aliasing should be turned on.
Discussion

Anti-aliasing is a graphics state parameter. When a window or bitmap context is created, anti-aliasing is turned on by default. For other types of context, anti-aliasing is turned off.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetShouldAntialias (
   CGContextRef context,
   bool shouldAntialias
){};

/*CGContextAddLines

Creates a new subpath that consists of a sequence of connected straight-line segments.

void CGContextAddLines (
   CGContextRef context,
   const CGPoint points[],
   size_t count
);
Parameters
context

The graphics context to which to add a subpath of line segments. 
points

An array of CGPoint values specifying the start and end points of the line segments to be drawn. Each point in the array specifies a position in user space. 
count

The number of elements in the array specified in the points parameter.
Discussion

This is a convenience function that adds a sequence of connected line segments to a graphics path. The first point in your CGPoint array specifies the initial starting point for the subpath. Quartz builds the subpath by connecting each point in the array with the subsequent point in the array, using straight line segments.

Upon return, the current point is the last point in the array. This function does not automatically close the subpath for you.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddLines (
   CGContextRef context,
   const CGPoint points[],
   size_t count
){};

/*CGContextEOFillPath

Paints the area within the current path, using the even-odd fill rule.

void CGContextEOFillPath (
   CGContextRef context
);
Parameters
context

The graphics context containing the path to fill.
Discussion

When you fill the current path, Quartz fills each subpath independently. Any subpath that has not been explicitly closed is closed implicitly by the fill routines. 

There are two different methods of filling paths. The CGContextEOFillPath function uses the even-odd rule to fill a path. The function CGContextFillPath uses the nonzero winding number rule to fill a path. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextEOFillPath (
   CGContextRef context
){};

/*CGContextAddEllipseInRect

Adds an ellipse that fits inside the specified rectangle.

void CGContextAddEllipseInRect(
   CGContextRef context,
   CGRect rect
);
Parameters
context

A graphics context. 
rect

A rectangle that defines the area for the ellipse to fit in. 
Discussion

The ellipse is approximated by a sequence of Bézier curves. Its center is the midpoint of the rectangle defined by the rect parameter. If the rectangle is square, then the ellipse is circular with a radius equal to one-half the width (or height) of the rectangle. If the rect parameter specifies a rectangular shape, then the major and minor axes of the ellipse are defined by the width and height of the rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/

void CGContextAddEllipseInRect(
   CGContextRef context,
   CGRect rect
){};

/*CGContextSetInterpolationQuality

Sets the level of interpolation quality for a graphics context.

void CGContextSetInterpolationQuality (
   CGContextRef context,
   CGInterpolationQuality quality
);
Parameters
context

The graphics context to modify.
quality

A CGInterpolationQuality constant that specifies the required level of interpolation quality. For possible values, see Interpolation Qualities.
Discussion

Note that interpolation quality is merely a hint to the context—not all contexts support all interpolation quality levels.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CGContext.h*/
void CGContextSetInterpolationQuality (
   CGContextRef context,
   CGInterpolationQuality quality
){};

/*CGContextSetFillColorWithColor

Sets the current fill color in a graphics context, using a Quartz color.

void CGContextSetFillColorWithColor (
   CGContextRef context,
   CGColorRef color
);
Parameters
context

The graphics context for which to set the fill color.
color

The new fill color.
Discussion

See also CGContextSetFillColor.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGContext.h*/
void CGContextSetFillColorWithColor (
   CGContextRef context,
   CGColorRef color
){};

/*CGContextGetInterpolationQuality

Returns the current level of interpolation quality for a graphics context.

CGInterpolationQuality CGContextGetInterpolationQuality (
   CGContextRef context
);
Parameters
context

The graphics context to examine.
Return Value

The current level of interpolation quality. 
Discussion

Interpolation quality is a graphics state parameter that controls the level of quality when an image is interpolated (for example, when scaling the image). Note that this parameter is merely a hint to the context—not all contexts support all interpolation quality levels.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CGContext.h*/
CGInterpolationQuality CGContextGetInterpolationQuality (
   CGContextRef context
){};

/*CGContextClip

Modifies the current clipping path, using the nonzero winding number rule.

void CGContextClip (
   CGContextRef context
);
Parameters
context

A graphics context that contains a path. If the context does not have a current path, the function does nothing.
Discussion

The function uses the nonzero winding number rule to calculate the intersection of the current path with the current clipping path. Quartz then uses the path resulting from the intersection as the new current clipping path for subsequent painting operations.

Unlike the current path, the current clipping path is part of the graphics state. Therefore, to re-enlarge the paintable area by restoring the clipping path to a prior state, you must save the graphics state before you clip and restore the graphics state after you’ve completed any clipped drawing.

After determining the new clipping path, the function resets the context’s current path to an empty path.

See alsoCGContextEOClip
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextClip (
   CGContextRef context
){};

/*CGContextDrawPDFDocument

Draws a page of a PDF document into a graphics context.

void CGContextDrawPDFDocument (
   CGContextRef context,
   CGRect rect,
   CGPDFDocumentRef document,
   int page
);
Parameters
context

The graphics context in which to draw the PDF page. 
rect

A CGRect value that specifies the dimensions and location of the area in which to draw the PDF page, in units of the user space. When drawn, Quartz scales the media box of the page to fit the rectangle you specify. 
document

The PDF document to draw. 
page

A value that specifies the PDF page number to draw. If the specified page does not exist, the function does nothing.
Special Considerations

For applications running in Mac OS X version 10.3 and later, it is recommended that you replace this function with CGContextDrawPDFPage. If you do so, and want to specify the drawing rectangle, you should use CGPDFPageGetDrawingTransform to get an appropriate transform, concatenate it with the current transformation matrix, clip to the rectangle, and then call CGContextDrawPDFPage.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextDrawPDFDocument (
   CGContextRef context,
   CGRect rect,
   CGPDFDocumentRef document,
   int page
){};

/*CGContextSetStrokeColorWithColor

Sets the current stroke color in a context, using a Quartz color.

void CGContextSetStrokeColorWithColor (
   CGContextRef context,
   CGColorRef color
);
Parameters
context

The graphics context to modify.
color

The new stroke color.
Discussion

See also CGContextSetStrokeColor.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGContext.h*/
void CGContextSetStrokeColorWithColor (
   CGContextRef context,
   CGColorRef color
){};

/*CGContextSetAlpha

Sets the opacity level for objects drawn in a graphics context.

void CGContextSetAlpha (
   CGContextRef context,
   float alpha
);
Parameters
context

The graphics context for which to set the current graphics state’s alpha value parameter. 
alpha

A value that specifies the opacity level. Values can range from 0.0 (transparent) to 1.0 (opaque). Values outside this range are clipped to 0.0 or 1.0.
Discussion

This function sets the alpha value parameter for the specified graphics context. To clear the contents of the drawing canvas, you should use the function CGContextClearRect.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextSetAlpha (
   CGContextRef context,
   float alpha
){};

/*CGContextAddPath

Appends a Quartz path to the existing path in a graphics context.

void CGContextAddPath (
CGContextRef context,
CGPathRef path
);
Parameters
context

The graphics context to which to add the path.
path

The path to append.
Discussion

Quartz applies the current transformation matrix (CTM) to the points in the new path, before they are appended to the existing path.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGContext.h*/
void CGContextAddPath (
CGContextRef context,
CGPathRef path
){};

/*CGContextStrokeLineSegments

Strokes a sequence of line segments.

void CGContextStrokeLineSegments(
CGContextRef c,
const CGPoint points[],
size_t count
);
Parameters
c

A graphics context. 
points

An array of points, organized as pairs—the starting point of a line segment followed by the ending point of a line segment. For example, the first point in the array specifies the starting position of the first line, the second point specifies the ending position of the first line, the third point specifies the starting position of the second line, and so forth. 
count

The number of points in the points array. 
Discussion

This function is equivalent to the following code:CGContextBeginPath (context);
for (k = 0; k < count; k += 2) {
    CGContextMoveToPoint(context, s[k].x, s[k].y);
    CGContextAddLineToPoint(context, s[k+1].x, s[k+1].y);
}
CGContextStrokePath(context);

Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/
void CGContextStrokeLineSegments(
CGContextRef c,
const CGPoint points[],
size_t count
){};

/*CGContextFillEllipseInRect

Fills an ellipse that fits inside the specified rectangle.

void CGContextFillEllipseInRect(
   CGContextRef context,
   CGRect rect
);
Parameters
context

A graphics context. 
rect

A rectangle that defines the area for the ellipse to fit in.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGContext.h*/
void CGContextFillEllipseInRect(
   CGContextRef context,
   CGRect rect
){};

/*CGContextAddQuadCurveToPoint

Appends a quadratic Bézier curve from the current point, using a control point and an end point you specify.

void CGContextAddQuadCurveToPoint (
   CGContextRef context,
   float cpx,
   float cpy,
   float x,
   float y
);
Parameters
context

The graphics context to which to add the curve. The context’s path must not be empty.
cpx

The x-coordinate of the user space for the control point of the curve.
cpy

The y-coordinate of the user space for the control point of the curve.
x

The x-coordinate of the user space at which to end the curve.
y

The y-coordinate of the user space at which to end the curve.
Discussion

This function appends a quadratic curve to the current subpath. After adding the segment, the current point is reset from the beginning of the new segment to the end point of that segment.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGContext.h*/
void CGContextAddQuadCurveToPoint (
   CGContextRef context,
   float cpx,
   float cpy,
   float x,
   float y
){};


