#include <CoreGraphics/CoreGraphics.h>

//work

/*CGDisplayUsesOpenGLAcceleration

Returns a Boolean value indicating whether Quartz is using OpenGL-based window acceleration (Quartz Extreme) to render in a display.

boolean_t CGDisplayUsesOpenGLAcceleration (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

If true, Quartz Extreme is used to render in the specified display; otherwise, false.
Discussion

Quartz Extreme is an OpenGL-based, hardware-accelerated window compositor available in Mac OS X version 10.2 and later. Quartz Extreme requires a minimum hardware configuration to operate.

The information this function provides is typically used to adjust the demands of drawing operations to the capabilities of the display hardware. For example, an application running on an unaccelerated system could disable live window-resizing.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayConfiguration.h*/
boolean_t CGDisplayUsesOpenGLAcceleration (
   CGDirectDisplayID display
){};

/*CGDisplayIOServicePort

Returns the I/O Kit service port of the specified display.

io_service_t CGDisplayIOServicePort (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The I/O Kit service port for the specified display.
Discussion

An I/O Kit service port can be passed to I/O Kit to obtain additional information about the display. 

The port is owned by the graphics system, and should not be destroyed. 
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayConfiguration.h*/
io_service_t CGDisplayIOServicePort (
   CGDirectDisplayID display
){};

/*CGDisplayRegisterReconfigurationCallback

Registers a callback function to be invoked whenever a local display is reconfigured.

void CGDisplayRegisterReconfigurationCallback (
   CGDisplayReconfigurationCallBack proc,
   void * userInfo
);
Parameters
proc

A pointer to the callback function to be registered.
userInfo

A pointer to user-defined data, or NULL. The userInfo argument is passed back to the callback function each time it’s invoked. 
Discussion

Whenever local displays are reconfigured, the callback function you register is invoked twice for each display that’s added, removed, or currently online—once before the reconfiguration, and once after the reconfiguration. For more information, see the callback type CGDisplayReconfigurationCallBack. 

A callback function may be registered multiple times with different user-defined data pointers, resulting in multiple registration entries. For each registration, when notification is no longer needed you should remove the registration by calling the function CGDisplayRemoveReconfigurationCallback. 
Availability
Available in Mac OS X version 10.3 and later. 
Declared In
CGDisplayConfiguration.h*/
void CGDisplayRegisterReconfigurationCallback (
   CGDisplayReconfigurationCallBack proc,
   void * userInfo
){};

/*CGDisplayRemoveReconfigurationCallback

Removes the registration of a callback function that’s invoked whenever a local display is reconfigured. 

void CGDisplayRemoveReconfigurationCallback (
   CGDisplayReconfigurationCallBack proc,
   void * userInfo
);
Parameters
proc

A pointer to the callback function associated with the registration to be removed.
userInfo

A pointer to user-defined data associated with the registration to be removed, or NULL. This is the same pointer that’s passed to the function CGDisplayRegisterReconfigurationCallback when registering the callback. 
Discussion

When you call this function, the two arguments must match the registered entry to be removed.
Availability
Available in Mac OS X version 10.3 and later. 
Declared In
CGDisplayConfiguration.h*/

void CGDisplayRemoveReconfigurationCallback (
   CGDisplayReconfigurationCallBack proc,
   void * userInfo
){};

/*CGDisplayUnitNumber

Returns the logical unit number of a display.

uint32_t CGDisplayUnitNumber (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

A logical unit number for the specified display.
Discussion

The logical unit number represents a particular node in the I/O Kit device tree associated with the display’s frame buffer. For a particular hardware configuration, this value will not change when the attached monitor is changed. 

The unit number will change if the I/O Kit device tree changes, as when hardware is reconfigured, drivers are replaced, or significant changes occur to I/O Kit, so it should not be assumed to be invariant across login sessions.

For more information about I/O Kit, see the Apple publication “I/O Kit Fundamentals”.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayConfiguration.h*/
uint32_t CGDisplayUnitNumber (
   CGDirectDisplayID display
){};

