#include <CoreGraphics/CoreGraphics.h>

//work

/*CGLayerGetContext

Gets the graphics context associated with a CGLayer object.

CGContextRef CGLayerGetContext(
   CGLayerRef layer
);
Parameters
layer

The layer whose graphics context you want to obtain.
Return Value

The graphics context associated with the layer.
Discussion

The context that’s returned is the context for the layer itself, not the context that you specified when you created the layer.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
CGContextRef CGLayerGetContext(
   CGLayerRef layer
){};

/*CGLayerRelease

Decrements the retain count of a CGLayer object.

void CGLayerRelease(CGLayerRef layer);
Parameters
layer

The layer to release.
Discussion

This function is equivalent to calling CFRelease (layer) except that it does not crash (as CFRetain does) if the layer parameter is null.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
void CGLayerRelease(CGLayerRef layer){};

/*CGLayerCreateWithContext

Creates a CGLayer object that is associated with a graphics context.

CGLayerRef CGLayerCreateWithContext (
   CGContextRef context,
   CGSize size,
   CFDictionaryRef auxiliaryInfo
);
Parameters
context

The graphics context you want to create the layer relative to. The layer uses this graphics context as a reference for initialization.
size

The size, in default user space units, of the layer relative to the graphics context.
auxiliaryInfo

Reserved for future use. Pass NULL.
Return Value

A CGLayer object. You are responsible for releasing this object using the function CGLayerRelease when you no longer need the layer.
Discussion

After you create a CGLayer object, you should reuse it whenever you can to facilitate the Quartz caching strategy. Quartz caches any CG objects that are reused, including CGLayer objects. Objects that are reused frequently remain in the cache. In contrast, objects that are used once in a while may be moved in and out of the cache according to their frequency of use. If you don’t reuse CGLayer objects, Quartz won’t cache them. This means that you lose an opportunity to improve the performance of your application.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
CGLayerRef CGLayerCreateWithContext (
   CGContextRef context,
   CGSize size,
   CFDictionaryRef auxiliaryInfo
){};

/*CGLayerGetSize

Obtains the width and height of a CGLayer object.

CGSize CGLayerGetSize (
   CGLayerRef layer
);
Parameters
layer

The layer whose width and height you want to obtain.
Return Value



The width and height of the layer, in default user space coordinates.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
CGSize CGLayerGetSize (
   CGLayerRef layer
){};

/*CGContextDrawLayerAtPoint

Draws the contents of a CGLayer object at the specified point.

void CGContextDrawLayerAtPoint (
   CGContextRef context,
   CGPoint point,
   CGLayerRef layer
);
Parameters
context

The graphics context associated with the layer.
point

The location, in current user space coordinates, to use as the origin for the drawing.
layer

The layer whose contents you want to draw.
Discussion

Calling the function CGContextDrawLayerAtPoint is equivalent to calling the function CGContextDrawLayerInRect with a rectangle that has its origin at point and its size equal to the size of the layer.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGLayer.h*/
void CGContextDrawLayerAtPoint (
   CGContextRef context,
   CGPoint point,
   CGLayerRef layer
){};

