#include <CoreGraphics/CoreGraphics.h>

//work

/*CGPDFContextCreateWithURL

Creates a URL-based PDF graphics context.

CGContextRef CGPDFContextCreateWithURL (
   CFURLRef url,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
);
Parameters
url

A Core Foundation URL that specifies where you want to place the resulting PDF file.
mediaBox

A rectangle that specifies the bounds of the PDF. The origin of the rectangle should typically be (0,0). The CGPDFContextCreateWithURL function uses this rectangle as the default page media bounding box. If you pass NULL, CGPDFContextCreateWithURL uses a default page size of 8.5 by 11 inches (612 by 792 points). 
auxiliaryInfo

A dictionary that specifies any additional information to be used by the PDF context when generating the PDF file, or NULL. The dictionary is retained by the new context, so on return you may safely release it.
Return Value

A new PDF context, or NULL if a context could not be created. You are responsible for releasing this object using CGContextRelease.
Discussion

When you call this function, Quartz creates a PDF drawing environment—that is, a graphics context—to your specifications. When you draw into the resulting context, Quartz renders your drawing as a series of PDF drawing commands stored in the specified location.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFContext.h*/
CGContextRef CGPDFContextCreateWithURL (
   CFURLRef url,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
){};

/*CGPDFContextCreate

Creates a PDF graphics context.

CGContextRef CGPDFContextCreate (
   CGDataConsumerRef consumer,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
);
Parameters
consumer

A data consumer to receive the PDF output data. 
mediaBox

A pointer to a rectangle that defines the size and location of the PDF page, or NULL. The origin of the rectangle should typically be (0,0). Quartz uses this rectangle as the default bounds of the page’s media box. If you pass NULL, Quartz uses a default page size of 8.5 by 11 inches (612 by 792 points). 
auxiliaryInfo

A dictionary that specifies any additional information to be used by the PDF context when generating the PDF file, or NULL. The dictionary is retained by the new context, so on return you may safely release it. See Auxiliary Dictionary Keys for keys you can include in the dictionary.
Return Value

A new PDF context, or NULL if the context could not be created. You are responsible for releasing this object using CGContextRelease.
Discussion

This function creates a PDF drawing environment to your specifications. When you draw into the new context, Quartz renders your drawing as a sequence of PDF drawing commands that are passed to the data consumer object.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFContext.h*/

CGContextRef CGPDFContextCreate (
   CGDataConsumerRef consumer,
   const CGRect * mediaBox,
   CFDictionaryRef auxiliaryInfo
){};

