#include <HIToolbox/HIToolbox.h>

OSStatus 
GetTextAndEncodingFromCFString(
  CFStringRef     inString,
  BytePtr         outText,
  ByteCount       inTextMaxLength,
  ByteCount *     outTextLength,
  TextEncoding *  outEncoding){
printf ("GetTextAndEncodingFromCFString",inString,outText,inTextMaxLength,outTextLength,outEncoding);
};    

/*GetTheme

Obtains a collection containing data describing the current theme.

OSStatus GetTheme (
   Collection ioCollection
);
Parameters
ioCollection

A value of type Collection. Pass a reference to a collection object, such as that created by calling the Collection Manager function NewCollection. On return, the collection contains data describing attributes of the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetTheme function obtains a collection containing a copy of the data for the current theme. The theme data is in the form of collection items, each corresponding to an attribute of the theme. For a given theme, the actual number of collection items may vary, depending upon how fully the theme’s attributes are specified. See “Theme Collection Tags” for descriptions of the possible theme collection items.

Your application can use theme collection tags, along with various Collection Manager functions, to access the data in the collection.

Also see the function SetTheme. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetTheme (
   Collection ioCollection
){
printf ("GetTheme",ioCollection);
};


/*GetThemeMetric

OSStatus GetThemeMetric (
   ThemeMetric inMetric,
   SInt32 * outMetric
);
Return Value

A result code. See “Appearance Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeMetric (
   ThemeMetric inMetric,
   SInt32 * outMetric
){
printf ("GetThemeMetric",inMetric,*outMetric);
};


/*NormalizeThemeDrawingState

Sets the current graphics port to a default drawing state.

OSStatus NormalizeThemeDrawingState (
);
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The NormalizeThemeDrawingState function sets the background of a graphics port to white; the pen of the port to a size of 1 pixel by 1 pixel, a pattern mode of patCopy, and a pattern of black; and the text mode of the port to srcOr. NormalizeThemeDrawingState also flushes from memory any color foreground or background patterns saved in the port’s GrafPort.pnPat or GrafPort.bkPat fields, respectively. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus NormalizeThemeDrawingState (
){
printf ("NormalizeThemeDrawingState");
};


/*DrawThemeMenuSeparator

Draws a menu item separator line.

OSStatus DrawThemeMenuSeparator (
   const Rect * inItemRect
);
Parameters
inItemRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuSeparator, set the rectangle to contain the menu item separator to be drawn, in global coordinates. The rectangle should be the same height as the height returned by the function GetThemeMenuSeparatorHeight.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeMenuSeparator function draws a theme-compliant menu item separator line. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeMenuSeparator (
   const Rect * inItemRect
){
printf ("DrawThemeMenuSeparator",*inItemRect);
};

/*NewMenuItemDrawingUPP

Creates a new universal procedure pointer (UPP) to a menu item drawing function.

MenuItemDrawingUPP NewMenuItemDrawingUPP (
   MenuItemDrawingProcPtr userRoutine
);
Return Value

A UPP. See MenuItemDrawingProcPtr for information on the menu item drawing function. See the description of the MenuItemDrawingUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
MenuItemDrawingUPP NewMenuItemDrawingUPP (
   MenuItemDrawingProcPtr userRoutine
){
printf ("NewMenuItemDrawingUPP",userRoutine);
};

/*GetThemeMenuSeparatorHeight

Obtains the height of a menu separator line.

OSStatus GetThemeMenuSeparatorHeight (
   SInt16 * outHeight
);
Parameters
outHeight

A pointer to a signed 16-bit integer. On return, the integer value represents the height (in pixels) of the menu separator line.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetThemeMenuSeparatorHeight function obtains the height of a menu separator line under the current theme. Your application should call the GetThemeMenuSeparatorHeight function when you are writing your own menu definition function and wish to calculate a menu rectangle for a separator to match the current theme. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeMenuSeparatorHeight (
   SInt16 * outHeight
){
printf ("GetThemeMenuSeparatorHeight",*outHeight);
};

/*DrawThemeMenuItem

Draws a menu item.

OSStatus DrawThemeMenuItem (
   const Rect * inMenuRect,
   const Rect * inItemRect,
   SInt16 inVirtualMenuTop,
   SInt16 inVirtualMenuBottom,
   ThemeMenuState inState,
   ThemeMenuItemType inItemType,
   MenuItemDrawingUPP inDrawProc,
   UInt32 inUserData
);
Parameters
inMenuRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuItem, set the rectangle to contain the entire menu, in global coordinates. This is the actual menu rectangle as used in your menu definition function.
inItemRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuItem, set the rectangle to contain the menu item, in global coordinates. The menu item’s background is drawn in the rectangle passed in the inItemRect parameter. You should calculate the size of the menu item’s content and then call GetThemeMenuItemExtra to get the amount of padding surrounding menu items in the current theme; the width and height of the menu item rectangle are determined by adding these values together.
inVirtualMenuTop

A signed 16-bit integer. Pass a value representing the actual top of the menu. Normally this value is the top coordinate of the rectangle supplied in the inMenuRect parameter. This value could be different, however, if a menu is scrolled or bigger than can be displayed in the menu rectangle. You typically pass the value of the global variable TopMenuItem into this parameter if you are writing a custom menu definition function.
inVirtualMenuBottom

A signed 16-bit integer. Pass a value representing the actual bottom of the menu. Typically this value is the bottom coordinate of the rectangle supplied in the inMenuRect parameter. This value could be different, however, if a menu is scrolled or bigger than can be displayed in the menu rectangle. You typically pass the value of the global variable AtMenuBottom into this parameter if you are writing a custom menu definition function.
inState

A value of type ThemeMenuState. Pass a constant specifying the state (active, selected, or disabled) in which to draw the menu item; see “Theme Menu States”.
inItemType

A value of type ThemeMenuItemType. If you pass kThemeMenuItemScrollUpArrow or kThemeMenuItemScrollDownArrow, then you should pass NULL for the inDrawProc parameter, since there is no content to be drawn. If you pass kThemeMenuItemHierarchical, the hierarchical arrow is drawn for you. See “Theme Menu Item Types” for descriptions of possible values.
inDrawProc

A value of type MenuItemDrawingUPP. Pass a universal function pointer to a menu item drawing function such as MenuItemDrawingProcPtr. The value of the inDrawProc parameter can be a valid universal function pointer or NULL.
inUserData

An unsigned 32-bit integer. Provide any data to be passed in to the inUserData parameter of MenuItemDrawingProcPtr.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeMenuItem function draws a theme-compliant menu item. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeMenuItem (
   const Rect * inMenuRect,
   const Rect * inItemRect,
   SInt16 inVirtualMenuTop,
   SInt16 inVirtualMenuBottom,
   ThemeMenuState inState,
   ThemeMenuItemType inItemType,
   MenuItemDrawingUPP inDrawProc,
   UInt32 inUserData
){
printf ("DrawThemeMenuItem",*inMenuRect,*inItemRect,inVirtualMenuTop,inVirtualMenuBottom,inState,inItemType,inDrawProc,inUserData);
};



/*SetThemeCursor

Sets the cursor to a version of the specified cursor type that is consistent with the current theme.

OSStatus SetThemeCursor (
   ThemeCursor inCursor
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of possible values.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors. Because these are color cursors, they currently cannot be set from interrupt time. 

Your application should call the SetThemeCursor function to ensure that its cursors are theme-compliant, rather than the QuickDraw cursor utilities functions SetCursor or SetCCursor. If you wish an animatable cursor to be theme-compliant, call the function SetAnimatedThemeCursor. 
Special Considerations

Do not call SetThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemeCursor (
   ThemeCursor inCursor
){
printf ("SetThemeCursor",inCursor);
};

/*SetAnimatedThemeCursor

Animates a version of the specified cursor type that is consistent with the current theme.

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of the possible values. Note that only cursors designated as able to be animated should be used for this function. If you specify an unanimatable cursor type, SetAnimatedThemeCursor returns the error themeBadCursorIndexErr (–30565).
inAnimationStep

An unsigned 32-bit value. Pass a value specifying the current animation step of the cursor. To animate the cursor, increment the value by 1 with each call to SetAnimatedThemeCursor.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors.

Your application should call the SetAnimatedThemeCursor function to ensure that its animated cursors are theme-compliant, rather than using any QuickDraw cursor utilities functions such as SetCursor, SetCCursor, SpinCursor, or RotateCursor. If you wish a non-animated cursor to be theme-compliant, call the function SetThemeCursor.

Because these are color cursors, they currently cannot be set from interrupt time. Therefore, if you support animated cursors that are changed at interrupt time you should continue to use your own cursors for now. 
Special Considerations

Do not call SetAnimatedThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
){
printf ("SetAnimatedThemeCursor",inCursor,inAnimationStep);
};

/*DrawThemeTextBox

Draws text into the area you specify.

OSStatus DrawThemeTextBox (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   const Rect * inBoundingBox,
   SInt16 inJust,
   void * inContext
);
Parameters
inString

A CFStringRef containing the unicode characters you wish to render. You must not pass in a CFStringRef that was allocated with any of the "NoCopy" CFString creation functions; a string created with a "NoCopy" function has transient storage which is incompatible with DrawThemeTextBox's caches.
inFontID

The ThemeFontID describing the font you'd like to render the text with. See “Theme Font IDs” for the values you can use here.
inState

The ThemeDrawState describing the state of the interface element you are drawing the text for. If, for example, you are drawing text for an inactive window, you would pass kThemeStateInactive. The ThemeDrawState is generally only used to determine the shadow characteristics for the text on Mac OS X. 

See “Theme Drawing States” for the values you can use here.

Note that the ThemeDrawState does not imply a color. It is not used as a mechanism for graying the text. If you wish to draw grayed text, you must set up the desired gray color and apply it to either the current QuickDraw port or the CGContextRef, as appropriate.
inWrapToWidth

A Boolean value indicating whether you want to draw multiple lines of text wrapped to a bounding box. False indicates that only one line of text should be drawn without any sort of wrapping.
inBoundingBox

The rectangle, in coordinates relative to the current QuickDraw port, describing the area to draw the text within. The first line of text will be top-justified to this rectangle. Wrapping, if desired, will happen at the horizontal extent of this rectangle. Regardless of the amount of text in your CFStringRef, all drawn text will be clipped to this rectangle.
inJust

The horizontal alignment you would like for your text. You can use one of the standard alignment constants from TextEdit.h.
inContext

The CGContextRef into which you would like to draw the text. On Mac OS X, all text drawing happens in CGContextRefs; if you pass NULL, a transient CGContextRef will be allocated and deallocated for use within the single function call. Relying on the system behavior if transiently creating CGContextRefs may result in performance problems. On Mac OS 9, this parameter is ignored.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

DrawThemeTextBox allows you to draw theme-savvy —that is, Aqua-savvy on Mac OS X— text. It is unicode savvy, although only partially so under CarbonLib, and allows you to customize certain text rendering characteristics such as the font, wrapping behavior, and justification. The text is drawn into the CGContextRef you provide, or into the current QuickDraw port if no CGContextRef is provided. None of DrawThemeTextBox's parameters imply a color, so you must set up the desired text color separately before calling DrawThemeTextBox. If you provide a CGContextRef, its fill color will be used to draw the text. If you do not provide a CGContextRef, a color based on the current QuickDraw port's foreground color and the grayishTextOr mode, if set, will be used to draw the text.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeTextBox (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   const Rect * inBoundingBox,
   SInt16 inJust,
   void * inContext
){
printf ("DrawThemeTextBox",inString,inFontID,inState,inWrapToWidth,*inBoundingBox,inJust,inContext);
};



/*GetThemeBrushAsColor

Obtains the color that corresponds to a given theme brush type under the current theme.

OSStatus GetThemeBrushAsColor (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
);
Parameters
inBrush

A value of type ThemeBrush. Pass a constant specifying the theme brush type for which you wish to obtain a color; see “Theme Brushes” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inColorDev

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
outColor

A pointer to a structure of type RGBColor. On return, the structure contains a color corresponding to the color or pattern used by the specified theme brush under the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetThemeBrushAsColor function obtains a color that corresponds to that which is in use for a specified theme brush. If, in the current theme, the specified brush draws with a pattern instead of a color, a theme-specified approximate color is obtained. Your application should call GetThemeBrushAsColor only when you must use an RGBColor value for a specific operation; typically, your application should call the functions SetThemeBackground and SetThemePen for greatest fidelity with the current theme. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeBrushAsColor (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
){
printf ("GetThemeBrushAsColor",inBrush,inDepth,inColorDev,*outColor);
};


/*GetThemeMenuItemExtra

Obtains a measurement of the space surrounding a menu item.

OSStatus GetThemeMenuItemExtra (
   ThemeMenuItemType inItemType,
   SInt16 * outHeight,
   SInt16 * outWidth
);
Parameters
inItemType

A value of type ThemeMenuItemType. Pass a constant identifying the type of menu item for which you are interested in getting a measurement. See “Theme Menu Item Types”.
outHeight

A pointer to a signed 16-bit integer. On return, the integer value represents the total amount of padding between the content of the menu item and the top and bottom of its frame (in pixels). Your content’s height plus the measurement provided by the outHeight parameter equals the total item height.
outWidth

A pointer to a signed 16-bit integer. On return, the integer value represents the total amount of padding between the content of the menu item and the left and right limits of the menu (in pixels). Your content’s width plus the measurement provided by the outWidth parameter equals the total item width.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application should call the GetThemeMenuItemExtra function when you are writing your own menu definition function and wish to be theme-compliant. Once you have determined the height and width of the content of a menu item, call GetThemeMenuItemExtra to get a measurement in pixels of the space surrounding a menu item, including any necessary inter-item spacing, in the current theme. By combining the values for your menu item’s content and the extra padding needed by the theme, you can derive the size of the rectangle needed to encompass both the content and the theme element together. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeMenuItemExtra (
   ThemeMenuItemType inItemType,
   SInt16 * outHeight,
   SInt16 * outWidth
){
printf ("GetThemeMenuItemExtra",inItemType,*outHeight,*outWidth);
};


/*UseThemeFont

Sets the font of the current graphics port to one of the current theme’s system fonts.

OSStatus UseThemeFont (
   ThemeFontID inFontID,
   ScriptCode inScript
);
Parameters
inFontID

A value of type ThemeFontID. Pass a constant specifying the kind of font (that is, the current large, small, or small emphasized system fonts or the views font) to be applied to the current port. See “Theme Font IDs” for descriptions of possible values.
inScript

A value of type ScriptCode. Pass a script code specifying the script system for which you wish to set the current font; you may pass the metascript code smSystemScript to specify the system script.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application can call the UseThemeFont function to draw text in one of the current theme’s system fonts.

Also see the function GetThemeFont. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/


OSStatus UseThemeFont (
   ThemeFontID inFontID,
   ScriptCode inScript
){
printf ("UseThemeFont",inFontID,inScript);
};


/*GetThemeTextDimensions

Tells you the height, width, and baseline for a string.

OSStatus GetThemeTextDimensions (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   Point * ioBounds,
   SInt16 * outBaseline
);
Parameters
inString

A CFStringRef containing the unicode characters you wish to measure. You must not pass in a CFStringRef that was allocated with any of the "NoCopy" CFString creation functions, as mentioned in the description of the DrawThemeTextBox function.
inFontID

The ThemeFontID describing the font you'd like to measure the text with. See “Theme Font IDs” for the values you can use here.
inState

The ThemeDrawState which matches the state you will ultimately render the string with. Drawing state may affect text measurement, so you should be sure the value you pass to GetThemeTextDimensions matches the value you will eventually use for drawing. See “Theme Drawing States” for the values you can use here.
inWrapToWidth

A Boolean indicating whether you want the measurements based on wrapping the text to a specific width. If you pass true, you must specify the desired width in ioBounds->h.
ioBounds

On output, ioBounds->v contains the height of the text. If you pass false in the inWrapToWidth parameter, ioBounds->h will contain the width of the text on output. If you pass true in inWrapToWidth, ioBounds->h must (on input) contain the desired width for wrapping; on output, ioBounds->h contains the same value you specified on input.
outBaseline

On output, outBaseline contains the offset (in QuickDraw space) from the bottom edge of the last line of text to the baseline of the first line of text. outBaseline will generally be a negative value.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

GetThemeTextDimensions measures the given string using the font and drawing state you specify. It always reports the actual height and baseline. It sometimes reports the actual width. It can measure a string that wraps. It is unicode savvy, although only partially so under CarbonLib.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeTextDimensions (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   Point * ioBounds,
   SInt16 * outBaseline
){
printf ("GetThemeTextDimensions",inString,inFontID,inState,inWrapToWidth,*ioBounds,*outBaseline);
};

/*RegisterAppearanceClient

Registers your program with the Appearance Manager.

OSStatus RegisterAppearanceClient (
);
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceProcessRegisteredErr indicates that your program was already registered when you called the RegisterAppearanceClient function.
Discussion

The RegisterAppearanceClient function must be called at the beginning of your program, prior to initializing or drawing any onscreen elements or invoking any definition functions, such as the menu bar.

You should call RegisterAppearanceClient in order to receive Appearance Manager Apple events. Under Appearance Manager 1.1 and later, when the user changes the current appearance (that is, when a theme switch occurs), the Appearance Manager sends Apple events to all running applications that are registered as clients of the Appearance Manager and which are high-level event aware. Because typical results of a theme switch might include a change in menu bar height or window structure dimensions, as well as changes to the system fonts, colors, and patterns currently in use, you should listen for and respond to the Appearance Manager Apple events under most circumstances. See “Appearance Manager Apple Events” for more details.

When your program calls RegisterAppearanceClient, the Appearance Manager also automatically maps standard pre–Appearance Manager definition functions to their theme-compliant equivalents for your program, whether or not systemwide appearance is active.

See also the function UnregisterAppearanceClient. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus RegisterAppearanceClient (
){
printf ("RegisterAppearanceClient");
};


/*UnregisterAppearanceClient

Informs the Appearance Manager that your program is no longer its client.

OSStatus UnregisterAppearanceClient (
);
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceProcessNotRegisteredErr indicates that your program was not registered when you called the UnregisterAppearanceClient function.
Discussion

The UnregisterAppearanceClient function is automatically called for you when your program terminates. While you do not typically need to call this function, you might want to call UnregisterAppearanceClient if you are running a plug-in architecture, and you know that a given plug-in is not theme-compliant. In this case you would bracket your use of the plug-in with calls to UnregisterAppearanceClient (before the plug-in is used) and RegisterAppearanceClient (after the plug-in is used), so that the Appearance Manager is turned off for the duration of the plug-in’s usage.

See also the function RegisterAppearanceClient. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus UnregisterAppearanceClient (){
printf ("UnregisterAppearanceClient");
};


/*DrawThemeGenericWell

Draws an image well frame.

OSStatus DrawThemeGenericWell (
   const Rect * inRect,
   ThemeDrawState inState,
   Boolean inFillCenter
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeGenericWell, set the rectangle to the position around which to draw the image well frame, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the image well frame; see “Theme Drawing States”. The well can be drawn as active or inactive; passing kThemeStatePressed produces an error.
inFillCenter

A value of type Boolean. Set to true to fill the image well frame with white; otherwise, false.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeGenericWell function draws a theme-compliant image well frame. You can specify that the center of the well be filled in with white. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeGenericWell (
   const Rect * inRect,
   ThemeDrawState inState,
   Boolean inFillCenter
){
printf ("DrawThemeGenericWell",*inRect,inState,inFillCenter);
};

/*SetThemePen

Applies a theme-compliant color or pattern to the foreground of the current port.

OSStatus SetThemePen (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inIsColorDevice
);
Parameters
inBrush

A value of type ThemeBrush. Pass a constant specifying the theme brush type to which to set the pen; see “Theme Brushes” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inIsColorDevice

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceBadBrushIndexErr indicates that the brush constant passed in was not valid.
Discussion

Your application should call the SetThemePen function each time you wish to draw an element in a specified brush constant.

Because the constant in the inBrush parameter can represent a color or pattern, depending on the current theme, your application must save and restore the current drawing state of the graphics port around calls to SetThemePen. Under Appearance Manager 1.1 and later, you can use the functions GetThemeDrawingState and SetThemeDrawingState to do this. Prior to Appearance Manager 1.1, you must save and restore the pnPixPat and bkPixPat fields of your graphics port when saving the text and background colors. Because patterns in the pnPixPat field override the foreground color of the window, call the QuickDraw function PenPat to set your foreground pattern to a normal white pattern. This ensures that you can use RGBForeColor to set your foreground color to white, call the QuickDraw function PaintRect, and get the expected results. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemePen (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inIsColorDevice
){
printf ("SetThemePen",inBrush,inDepth,inIsColorDevice);
};


/*DrawThemeEditTextFrame

Draws an editable text frame.

OSStatus DrawThemeEditTextFrame (
   const Rect * inRect,
   ThemeDrawState inState
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeEditTextFrame, set the rectangle to the position around which to draw the editable text frame, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the editable text frame; see “Theme Drawing States”. The frame can be drawn as active or inactive; passing kThemeStatePressed produces an error.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeEditTextFrame function draws a theme-compliant frame for an editable text field. The frame is a maximum of 2 pixels thick and is drawn outside the specified rectangle. You should not use this function to draw frames for items other than editable text fields.

To ensure that you get an appropriate focus ring for your editable text field, you should pass the same rectangle that you use with DrawThemeEditTextFrame function to the function DrawThemeFocusRect. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeEditTextFrame (
   const Rect * inRect,
   ThemeDrawState inState
){
printf ("DrawThemeEditTextFrame",*inRect,inState);
};


/*DrawThemeFocusRect

Draws or erases a focus ring around a specified rectangle.

OSStatus DrawThemeFocusRect (
   const Rect * inRect,
   Boolean inHasFocus
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeFocusRect, set the rectangle to the position around which to draw the focus ring, in local coordinates. The focus ring is drawn outside the rectangle that is passed in, and it can be outset a maximum of 3 pixels.
inHasFocus

A value of type Boolean. Pass true to draw the focus ring. Pass false to erase the focus ring.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application can use the DrawThemeFocusRect function to draw a theme-compliant focus ring. The presence of a focus ring indicates whether an item has keyboard focus.

If you are drawing a focus ring around an element for which you have drawn a frame using DrawThemeEditTextFrame or DrawThemeListBoxFrame, you must coordinate your drawing sequence to achieve the correct look. When drawing the element, your application should first call DrawThemeEditTextFrame or DrawThemeListBoxFrame and then call DrawThemeFocusRect, passing the same rectangle in the inRect parameter. If you use DrawThemeFocusRect to erase the focus ring around an editable text frame or list box frame, you must redraw the editable text frame or list box frame after calling DrawThemeFocusRect, because there is typically an overlap.
Version Notes

This function is available with Appearance Manager 1.0 and later. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeFocusRect (
   const Rect * inRect,
   Boolean inHasFocus
){
printf ("DrawThemeFocusRect",*inRect,inHasFocus);
};


/*DrawThemeTrack

Draws a track.

OSStatus DrawThemeTrack (
   const ThemeTrackDrawInfo * drawInfo,
   RgnHandle rgnGhost,
   ThemeEraseUPP eraseProc,
   UInt32 eraseData
);
Parameters
drawInfo

A pointer to a structure of type ThemeTrackDrawInfo. Before calling DrawThemeTrack, set the structure to contain the current visual characteristics of the track. 
rgnGhost

A value of type RgnHandle. If the track is of a type that contains an indicator, such as a scroll bar or slider, you may pass a handle to the region where DrawThemeTrack is to draw a ghost image of the track indicator. Your application should only use a ghost image with the indicator when a track does not support live feedback. Pass NULL if you do not want to draw a ghost image. 
eraseProc

A value of type ThemeEraseUPP. If you have a custom background, pass a universal function pointer to an application-defined function such as that described in ThemeEraseProcPtr. DrawThemeTrack calls that function to erase the background before drawing the track. If you pass NULL, no erasing occurs.
eraseData

An unsigned 32-bit integer. Provide any data to be passed in to the callback function specified in the eraseProc parameter.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application may use the DrawThemeTrack function to draw a theme-compliant slider, progress bar, or scroll bar. If you use DrawThemeTrack to draw a scroll bar, use the function DrawThemeScrollBarArrows to draw the scroll bar’s arrows. If you use DrawThemeTrack to draw a slider, use DrawThemeTrackTickMarks to draw any tick marks for the slider. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeTrack (
   const ThemeTrackDrawInfo * drawInfo,
   RgnHandle rgnGhost,
   ThemeEraseUPP eraseProc,
   UInt32 eraseData
){
printf ("DrawThemeTrack",*drawInfo,rgnGhost,eraseProc,eraseData);
};



/*GetThemeTextColor

Obtains the text color used for a specified element under the current theme.

OSStatus GetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
);
Parameters
inColor

A value of type ThemeTextColor. Pass a constant specifying the element for which you wish to obtain the current text color; see “Theme Text Colors” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inColorDev

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
outColor

A pointer to a structure of type RGBColor. On return, the structure contains the text color used for the specified element under the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Also see the function SetThemeTextColor. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
){
printf ("GetThemeTextColor ",inColor,inDepth,inColorDev,*outColor);
};

/*SetThemeTextColor

Sets the current text color to be consistent with that of a specified element.

OSStatus SetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inIsColorDevice
);

Parameters
inColor

A value of type ThemeTextColor. Pass a constant specifying an interface element. SetThemeTextColor sets the current text color to be the same as the color of that element’s text. See “Theme Text Colors” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inIsColorDevice

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceBadTextColorIndexErr indicates that the text color index passed was not valid.
Discussion

Your application typically uses the SetThemeTextColor function inside a DeviceLoop drawing function to set the foreground color to a theme-compliant value.

Also see the function GetThemeTextColor. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inIsColorDevice
){};


/*DrawThemePlacard

Draws a placard.

OSStatus DrawThemePlacard (
   const Rect * inRect,
   ThemeDrawState inState
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemePlacard, set the rectangle to a size and position that contains the placard, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the placard; see “Theme Drawing States”. The placard can be drawn as active, inactive, or pressed.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemePlacard function draws a theme-compliant placard inside the specified rectangle. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemePlacard (
   const Rect * inRect,
   ThemeDrawState inState
){};

