#include <HIToolbox/HIToolbox.h>

 void InitDialogs(void * ignored){
printf ("InitDialogs",ignored);
};


/*RunStandardAlert

Shows and runs a standard alert using a modal dialog loop.

OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);
Parameters
inAlert

The alert to display. Note that this function automatically disposes of the dialog you pass in this parameter before returning. 
filterProc

An event filter function for handling events that do not apply to the alert. May be NULL. 
outItemHit

On exit, contains the item index of the button that was pressed to close the alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit){
printf ("RunStandardAlert",inAlert,filterProc,*outItemHit);
};

/*CreateStandardAlert

Creates an alert containing standard elements and using standard formatting rules.

OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
outAlert

On exit, contains the new alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

CreateStandardAlert should be used in conjunction with RunStandardAlert. After CreateStandardAlert returns, the alert is still invisible. RunStandardAlert will show the alert and run a modal dialog loop to process events in the alert.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert){
printf ("CreateStandardAlert",alertType,error,explanation,*param,*outAlert);
};

/*AppendDITL

Adds items to an existing dialog box while your application is running. 

void AppendDITL (
   DialogRef theDialog,
   Handle theHandle,
   DITLMethod method
);
Parameters
theDialog

A pointer to a dialog structure. This is the dialog structure to which you will add the item list resource specified in the parameter theHandle. 
theHandle

A handle to the item list resource whose items you want to append to the dialog box. To avoid item number conflicts, AppendDITL assigns new numbers to the items you are adding. For example, if you have a dialog with item numbers 1-5, and you use AppendDITL to add a 'DITL' resource containing item numbers 1-3, those become item numbers 6-8 in the dialog. 
method

The manner in which you want the new items to be displayed in the existing dialog box. You can pass a negative value to offset the appended items from a particular item in the existing dialog box. You can also pass one of the values defined by the DITLMethod constant. See “Dialog Item List Display Constants” for possible values. 
Discussion

The AppendDITL function adds the items specified in the theHandle parameter to the items of a dialog box (handle-based). This function is especially useful if several dialog boxes share a single item list resource, because you can use AppendDITL to add items that are appropriate for individual dialog boxes. Your application can use the Resource Manager function GetResource to get a handle to the item list resource whose items you wish to add.

In the parameter method, you specify how to append the new items, as follows:
If you use the overlayDITL constant, AppendDITL superimposes the appended items over the dialog box. That is, AppendDITL interprets the coordinates of the display rectangles for the appended items (as specified in their item list resource) as local coordinates within the dialog box. 
If you use the appendDITLRight constant, AppendDITL appends the items to the right of the dialog box by positioning the display rectangles of the appended items relative to the upper-right coordinate of the dialog box. The AppendDITL function automatically expands the dialog box to accommodate the new dialog items. 
If you use the appendDITLBottom constant, AppendDITL appends the items to the bottom of the dialog box by positioning the display rectangles of the appended items relative to the lower-left coordinate of the dialog box. The AppendDITL function automatically expands the dialog box to accommodate the new dialog items. 
You can also append a list of items relative to an existing item by passing a negative number in the parameter method. The absolute value of this number is interpreted as the item in the dialog box relative to which the new items are to be positioned. For example, if you pass –2, the display rectangles of the appended items are offset relative to the upper-left corner of item number 2 in the dialog box. 

You typically create an invisible dialog box, call the AppendDITL function, then make the dialog box visible by using the Window Manager function ShowWindow. 
Special Considerations

The AppendDITL function modifies the contents of the dialog box (for instance, by enlarging it). To use an unmodified version of the dialog box at a later time, your application should use the Resource Manager function ReleaseResource to release the memory occupied by the appended item list resource. Otherwise, if your application calls AppendDITL to add items to that dialog box again, the dialog box remains modified by your previous call—for example, it will still be longer at the bottom if you previously used the appendDITLBottom constant.

Before calling AppendDITL, you should make sure that it is available by using the Gestalt function with the gestaltDITLExtAttr selector. Test the bit indicated by the gestaltDITLExtPresent constant in the response parameter. If the bit is set, then AppendDITL is available.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void AppendDITL (
   DialogRef theDialog,
   Handle theHandle,
   DITLMethod method
){
printf ("AppendDITL",theDialog,theHandle,method);
};

/*SetDialogFont

Sets the font used in static and edit text items. 

void SetDialogFont (
   SInt16 fontNum
);
Parameters
fontNum

A font ID number. Do not rely on font number constants. Instead, use the Font Manager function GetFNum to find the font number to pass in this parameter. 
Discussion

For subsequently created dialog and alert boxes, SetDialogFont sets the font of the dialog or alert box’s graphics port to the specified font. If you don’t call this function, the system font is used. The SetDialogFont function does not affect titles of controls, which are always displayed in the system font. 
Special Considerations

There are a number of caveats regarding the SetDialogFont function:
Most importantly, your application will be much easier to localize if you always use the system font in your alert and dialog boxes and never use SetDialogFont.
The Standard File Package does not always properly calculate the position of the standard file dialog box once this function has been called; for example, the standard file dialog box may be partially obscured by a menu bar. 
Be aware that this function affects all static text and edit text items in all of the alert and dialog boxes you subsequently display. 
SetDialogFont does not change the font for control titles. 
You can’t use SetDialogFont to change the font size or font style. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetDialogFont (
   SInt16 fontNum
){
printf ("SetDialogFont",fontNum);
};

/*FindDialogItem

Determines the item number of an item at a particular location in a dialog box. 

DialogItemIndexZeroBased FindDialogItem (
   DialogRef theDialog,
   Point thePt
);
Parameters
theDialog

A pointer to a dialog structure. 
thePt

The point (in local coordinates) where the mouse-down event occurred. 
Return Value

When an embedding hierarchy is established, the FindDialogItem function returns the deepest control selected by the user corresponding to the point specified in the thePt parameter. When an embedding hierarchy does not exist, FindDialogItem performs a linear search of the item list resource and returns a number corresponding to the hit item’s position in the item list resource. For example, it returns 0 for the first item in the item list, 1 for the second, and 2 for the third. If the mouse is not over a dialog item, FindDialogItem returns –1. See the description of the DialogItemIndexZeroBased data type.
Discussion

The function FindDialogItem is useful for changing the cursor when the user moves the cursor over a particular item. 

To get the proper item number before calling the GetDialogItem function or the SetDialogItem function, add 1 to the result of FindDialogItem, as shown here:

theItem = FindDialogItem(theDialog, thePoint) + 1;

Note that FindDialogItem returns the item number of disabled items as well as enabled items. 
Version Notes

This function was changed with Appearance Manager 1.0 to support embedding hierarchies.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogItemIndexZeroBased FindDialogItem (
   DialogRef theDialog,
   Point thePt
){
printf ("FindDialogItem",theDialog,thePt);
};

/*CreateStandardSheet

Creates an alert containing standard elements and using standard formatting rules, and prepares it to be displayed as a sheet.¬

OSStatus CreateStandardSheet (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   EventTargetRef notifyTarget,
   DialogRef * outSheet
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
notifyTarget

The event target to be notified when the sheet is closed. The caller should install an event handler on this target for the [kEventClassCommand, kEventProcessCommand] event. 
outSheet

On exit, contains the new alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

CreateStandardSheet should be used in conjunction with ShowSheetWindow. After CreateStandardSheet returns, the alert is still invisible. ShowSheetWindow will show the alert and then return. Events in the sheet are handled asynchronously; the application should be prepared for the sheet window to be part of its windowlist while running its own event loop. When a button in the sheet is pressed, the EventTargetRef passed to CreateStandardSheet will receive a command event with one of the command IDs kHICommandOK, kHICommandCancel, or kHICommandOther. The sheet is closed before the command is sent.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/

OSStatus CreateStandardSheet (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   EventTargetRef notifyTarget,
   DialogRef * outSheet
){
printf ("CreateStandardSheet",alertType,error,explanation,*param,notifyTarget,*outSheet);
};



/*GetStandardAlertDefaultParams

Fills out an AlertStdCFStringAlertParamRec with default values: - not movable - no help button - default button with title "OK" - no cancel or other buttons.

OSStatus GetStandardAlertDefaultParams (
   AlertStdCFStringAlertParamPtr param,
   UInt32 version
);
Parameters
param

The parameter block to initialize. 
version

The parameter block version; pass kStdCFStringAlertVersionOne. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus GetStandardAlertDefaultParams (
   AlertStdCFStringAlertParamPtr param,
   UInt32 version
){
printf ("GetStandardAlertDefaultParams",param,version);
};

/*CautionAlert

Displays an alert box with a caution icon and/or plays an alert sound.

DialogItemIndex CautionAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
);
Parameters
alertID

The resource ID of an alert resource and extended alert resource. If the alert resource is missing, the Dialog Manager returns to your application without creating the requested alert. See ‘alrx’ for a description of the extended alert resource. 
modalFilter

A universal procedure pointer for a filter function that responds to events not handled by the ModalDialog function. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
Return Value

If no alert box is to be drawn at the current alert stage, CautionAlert returns –1 otherwise, it uses NewDialog to create and display the alert box and returns the item hit; see “Alert Button Constants”. See the description of the DialogItemIndex data type.
Discussion

Displays an alert box with a caution icon in its upper-left corner or, if appropriate for the alert stage, to play an alert sound instead of or in addition to displaying the alert box.

The CautionAlert function is the same as the Alert function except that, before drawing the items in the alert box, CautionAlert draws the caution icon in the upper-left corner. The caution icon has resource ID 2, which you can also specify with the constant kCautionIcon. By default, the Dialog Manager uses the standard caution icon from the System file. You can change this icon by providing your own 'ICON' resource with resource ID 2.

Use a caution alert to alert the user of an operation that may have undesirable results if it’s allowed to continue. Give the user the choice of continuing the action (by clicking an OK button) or stopping it (by clicking a Cancel button).

Your application should never draw its own default rings or alert icons. Prior to Mac OS 8, the CautionAlert function would only redraw the alert icon and default button ring once and never redraw them on an update event. However, when Appearance is available, alert icons and default rings do redraw when you call CautionAlert.

See also the functions NoteAlert and StopAlert. 
Special Considerations
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended alert ('alrx') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogItemIndex CautionAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
){
printf ("CautionAlert",alertID,modalFilter);
};

/*ShortenDITL

Removes items from an existing dialog box while your application is running.

void ShortenDITL (
   DialogRef theDialog,
   DialogItemIndex numberItems
);
Parameters
theDialog

A pointer to a dialog structure. 
numberItems

The number of items to remove (starting from the last item in the item list resource). 
Discussion

The ShortenDITL function removes the specified number of items from the dialog box. This function is especially useful if several dialog boxes share a single item list resource, because you can use ShortenDITL to remove items as necessary for individual dialog boxes.

You typically create an invisible dialog box, call the ShortenDITL function, then make the dialog box visible by using the Window Manager function ShowWindow. Note that ShortenDITL does not automatically resize the dialog box; you can use AutoSizeDialog or the Window Manager function SizeWindow if you need to resize the dialog box. 
Special Considerations

The ShortenDITL function is available in System 7 and in earlier versions of the Communications Toolbox. Before calling ShortenDITL, you should make sure that it is available by using the Gestalt function with the gestaltDITLExtAttr selector. Test the bit indicated by the gestaltDITLExtPresent constant in the response parameter. If the bit is set, then ShortenDITL is available.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/
void ShortenDITL (
   DialogRef theDialog,
   DialogItemIndex numberItems
){
printf ("ShortenDITL",theDialog,numberItems);
};

/*GetDialogKeyboardFocusItem

Returns the item number of the editable text item in a dialog box that has keyboard focus.

SInt16 GetDialogKeyboardFocusItem (
   DialogRef dialog
);
Parameters
dialog

On input, a pointer to the dialog structure for the dialog box whose currently focused item you want to identify. 
Return Value

The number of the editable text item in a dialog box that currently has keyboard focus. 
Discussion

When the Appearance Manager is available and an embedding hierarchy is established, you should call the Control Manager function GetKeyboardFocus instead of GetDialogKeyboardFocusItem to return the item number of the item in a dialog box that has keyboard focus.

The GetDialogKeyboardFocusItem function accesses the edit field in the dialog structure. GetDialogKeyboardFocusItem should only be called when there is no embedding hierarchy in the dialog box. 
Version Notes

This function is not recommended with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
SInt16 GetDialogKeyboardFocusItem (
   DialogRef dialog
){
printf ("GetDialogKeyboardFocusItem",dialog);
};

/*NewDialog

Creates a dialog box from information passed in memory. 

DialogRef NewDialog (
   void * dStorage,
   const Rect * boundsRect,
   ConstStr255Param title,
   Boolean visible,
   SInt16 procID,
   WindowRef behind,
   Boolean goAwayFlag,
   SInt32 refCon,
   Handle items
);
Parameters
dStorage

On input, a pointer to the memory for the dialog structure. If you set this parameter to null, the Dialog Manager automatically allocates a nonrelocatable block in your application heap. 
boundsRect

On input, a pointer to a rectangle, given in global coordinates, that determines the size and position of the dialog box; these coordinates specify the upper-left and lower-right corners of the dialog box. 
title

On input, a text string used for the title of a modeless or movable modal dialog box. You can specify an empty string (not null) for a title bar that contains no text. 
visible

On input, a flag that specifies whether the dialog box should be drawn on the screen immediately. If you set this parameter to false, the dialog box is not drawn until your application uses the Window Manager function ShowWindow to display it. 
procID

On input, the window definition ID for the type of dialog box, specified with constants defined by the Window Manager. Use the kWindowModalDialogProc constant to specify modal dialog boxes, the kWindowDocumentProc constant to specify modeless dialog boxes, and the kWindowMovableModalDialogProc constant to specify movable modal dialog boxes. 
behind

On input, a pointer to the window behind which the dialog box is to be placed on the desktop. Set this parameter to the window pointer (WindowPtr)-1L to bring the dialog box in front of all other windows. 
goAwayFlag

On input, a flag to specify whether a modeless dialog box can have a close box in its title bar when the dialog box is active. If you set this parameter to true, the modeless dialog box has a close box in its title bar when the window is active.
refCon

On input, a value that the Dialog Manager uses to set the refCon field of the dialog box’s window structure. Your application may store any value here for any purpose. For example, your application can store a number that represents a dialog box type, or it can store a handle to a structure that maintains state information about the dialog box. You can use the Window Manager function SetWRefCon at any time to change this value in the dialog structure for a dialog box, and you can use the GetWRefCon function to determine its current value. 
items

On input, a handle to an item list resource for the dialog box. You can get the handle by calling the Resource Manager function GetResource to read the item list resource into memory. Use the Memory Manager function HNoPurge to make the handle unpurgeable while you use it or use the Operating System utility function HandToHand to make a copy of the handle and use the copy. 
Return Value

A pointer to the new dialog box. If the function doesn’t create a new dialog box, returns null. See the description of the DialogRef data type.
Discussion

The NewDialog function is identical to the NewColorDialog function, except that NewDialog returns a pointer to a black-and-white graphics port. See the discussion of NewColorDialog for descriptions of the parameters that you also pass to NewDialog.

The NewDialog function creates a dialog box as specified by its parameters and returns a pointer to a black-and-white graphics port for the new dialog box. The first eight parameters ( wStorage through refCon) are passed to the Window Manager function NewWindow, which creates the dialog box. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogRef NewDialog (
   void * dStorage,
   const Rect * boundsRect,
   ConstStr255Param title,
   Boolean visible,
   SInt16 procID,
   WindowRef behind,
   Boolean goAwayFlag,
   SInt32 refCon,
   Handle items
){
printf ("NewDialog",dStorage,*boundsRect,title,visible,procID,behind,goAwayFlag,refCon,items);
};


/*GetDialogPort


CGrafPtr GetDialogPort (
   DialogRef dialog
);
Parameters
dialog
Return Value

See the QuickDraw Manager documentation for a description of the CGrafPtr data type.
Discussion
Special Considerations
Version Notes
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/
CGrafPtr GetDialogPort (
   DialogRef dialog
){
printf ("GetDialogPort",dialog);
};


/*UpdateDialog

Redraws the update region of a specified dialog box.

void UpdateDialog (
   DialogRef theDialog,
   RgnHandle updateRgn
);
Parameters
theDialog

A pointer to a dialog structure. 
updateRgn

A handle to the window region that needs to be updated. 
Discussion

The UpdateDialog function redraws only the region in a dialog box specified in the updateRgn parameter. Your application generally should not use UpdateDialog. The Dialog Manager generally handles update events in alert and dialog boxes. Alert. StopAlert , NoteAlert , and CautionAlert handle update events on their own.

Instead of drawing the entire contents of the specified dialog box, UpdateDialog draws only the items in the specified update region. You can use UpdateDialog in response to an update event, and you should usually bracket it by calls to the Window Manager functions BeginUpdate and EndUpdate. UpdateDialog uses the QuickDraw function SetPort to make the dialog box the current graphics port. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void UpdateDialog (
   DialogRef theDialog,
   RgnHandle updateRgn
){
printf ("UpdateDialog",theDialog,updateRgn);
};

/*StandardAlert

Displays a standard alert box. 

OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit
);
Parameters
inAlertType

A constant indicating the type of alert box you wish to create; see “Alert Type Constants”. 
inError

A pointer to a Pascal string containing the primary error text you wish to display. 
inExplanation

A pointer to a Pascal string containing the secondary text you wish to display; secondary text is displayed in the small system font. Pass null to indicate no secondary text.
inAlertParam

A pointer to the standard alert structure; see AlertStdAlertParamRec. Pass null to specify that you do not wish to your alert box to incorporate any of the features that the standard alert structure provides. 
outItemHit

A pointer to a signed 16-bit integer value. On return, the value indicates the alert button pressed; see “Alert Button Constants”. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

The StandardAlert function displays an alert box based on the values you pass it. You can pass the error text you wish displayed in the error and explanation parameters, and customize the alert button text by filling in the appropriate fields of the standard alert structure passed in the inAlertParam parameter.

StandardAlert automatically resizes the height of a dialog box to fit all static text. It ignores alert stages and therefore provides no corresponding alert sounds. 
Special Considerations

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit){
printf ("StandardAlert",inAlertType,inError,inExplanation,*inAlertParam,*outItemHit);
};

/*NoteAlert

Displays an alert box with a note icon and/or plays an alert sound. 

DialogItemIndex NoteAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
);
Parameters
alertID

The resource ID of an alert resource and extended alert resource. If the alert resource is missing, the Dialog Manager returns to your application without creating the requested alert. See ‘alrx’ for a description of the extended alert resource. 
modalFilter

A universal procedure pointer for a filter function that responds to events not handled by the ModalDialog function. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
Return Value

If no alert box is to be drawn at the current alert stage, NoteAlert returns –1 otherwise, it creates and displays the alert box and returns the item number of the control selected by the user see “Alert Button Constants”. See the description of the DialogItemIndex data type.
Discussion

The NoteAlert function displays an alert box with a note icon in its upper-left corner or, if appropriate for the alert stage, plays an alert sound instead of or in addition to displaying the alert box. 

The NoteAlert function is the same as the Alert function except that, before drawing the items in the alert box, NoteAlert draws the note icon in the upper-left corner. The note icon has resource ID 1, which you can also specify with the constant noteIcon. By default, the Dialog Manager uses the standard note icon from the System file. You can change this icon by providing your own 'ICON' resource with resource ID 1.

Use a note alert to inform users of a minor mistake that won’t have any disastrous consequences if left as is. Usually this type of alert simply offers information, and the user responds by clicking an OK button. Occasionally, a note alert may ask a simple question and provide a choice of responses.

Your application should never draw its own default rings or alert icons. Prior to Mac OS 8, the NoteAlert function would only redraw the alert icon and default button ring once and never redraw them on an update event. However, when Appearance is available, alert icons and default rings do redraw when you call NoteAlert.

See also the functions CautionAlert and StopAlert. 
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended alert ('alrx') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/
DialogItemIndex NoteAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
){
printf ("NoteAlert",alertID,modalFilter);
};


/*SetDialogDefaultItem

Sets the default item for a dialog box and draws an appropriate border around the default item. 

OSErr SetDialogDefaultItem (
   DialogRef theDialog,
   DialogItemIndex newItem
);
Parameters
theDialog

On input, a pointer to the dialog structure for the dialog box whose default item you want to set. 
newItem

On input, the item number of the item you want to set as the default item. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

If you call the SetDialogDefaultItem function before you call the standard filter function, the standard filter function automatically interprets Return and Enter keypresses to mean that the specified default item has been selected. 

If you don’t explicitly call SetDialogDefaultItem, the standard filter function treats item 1 as the default item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr SetDialogDefaultItem (
   DialogRef theDialog,
   DialogItemIndex newItem
){
printf ("SetDialogDefaultItem",theDialog,newItem);
};


/*SetDialogCancelItem

Sets the cancel item for a dialog box.

OSErr SetDialogCancelItem (
   DialogRef theDialog,
   DialogItemIndex newItem
);
Parameters
theDialog

On input, a pointer to the dialog structure for the dialog box whose cancel item you want to set. 
newItem

On input, the item number of the item you want to set as the cancel item; see “Alert Button Constants”. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

If you intend to use the standard filter function, you can first use the functions SetDialogDefaultItem and SetDialogCancelItem to set the items that the standard filter function will treat as the default and cancel items. You can use GetDialogDefaultItem and GetDialogCancelItem to determine the dialog item numbers that the standard filter function will treat as the default and cancel items.

If you call the SetDialogCancelItem function before you call the standard filter function, the standard filter function automatically interprets Escape and Command-period keypresses to mean that the specified cancel item has been selected.

If you don’t explicitly call SetDialogCancelItem, the standard filter function treats item 2 as the cancel item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr SetDialogCancelItem (
   DialogRef theDialog,
   DialogItemIndex newItem
){
printf ("SetDialogCancelItem",theDialog,newItem);
};

/*AppendDialogItemList

Adds items to an existing dialog box while your program is running.

OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method
);
Parameters
dialog

A pointer to the dialog box to which the items in the item list resource specified in the ditlID parameter are to be appended. 
ditlID

The resource ID of the item list resource whose items are to be appended to the dialog box specified in the dialog parameter. 
method

The manner in which the new items are to be displayed in the dialog box.

If you use the overlayDITL constant, AppendDialogItemList superimposes the appended items over the dialog box by interpreting the coordinates of the display rectangles for the appended items (as specified in their item list resource) as local coordinates within the dialog box.

If you use the appendDITLRight constant, AppendDialogItemList appends the items to the right of the dialog box by positioning the display rectangles of the appended items relative to the upper-right coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

If you use the appendDITLBottom constant, AppendDialogItemList appends the items to the bottom of the dialog box by positioning the display rectangles of the appended items relative to the lower-left coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

You can append a list of items relative to an existing item by passing a negative number. The absolute value of this number is interpreted as the item in the dialog box relative to which the new items are to be positioned. For example, if you pass -2, the display rectangles of the appended items are offset relative to the upper-left corner of item number 2 in the dialog box.

Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

To be Appearance-compliant, your program should use the AppendDialogItemList function rather than the AppendDITL function. Unlike AppendDITL, the AppendDialogItemList function takes a 'DITL' resource ID instead of a handle as the parameter describing the dialog item list to be appended, and it properly appends entries from a dialog font table ( 'dftb') resource, if there is a 'dftb' resource with the same resource ID as the 'DITL' resource.

The AppendDialogItemList function adds the items in the item list resource specified in the parameter ditlID to the items of a dialog box. This is especially useful if several dialog boxes share a single item list resource, because you can use AppendDialogItemList to add items that are appropriate for individual dialog boxes. Your application can use the Resource Manager function GetResource to get a handle to the item list resource whose items you wish to add.

You typically create an invisible dialog box, call the AppendDialogItemList function, then make the dialog box visible by using the Window Manager function ShowWindow. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method){
printf ("AppendDialogItemList",dialog,ditlID,method);
};



/*ErrorSound

Sets the alert sound for your application. 

Unsupported

void ErrorSound (
   SoundUPP soundProc
);
Parameters
soundProc

On input, the universal procedure pointer to a function that generates the desired alert sounds. 
Discussion

Your application does not normally need to call this function. The Dialog Manager uses the system alert sound for signaling the user during various alert stages. The system alert sound, which is a sound resource stored in the System file, is played whenever system software or your application uses the Sound Manager function SysBeep. By changing the setting in the Sound control panel, the user can determine which sound is played. For details on SysBeep, see the Sound Manager Reference .

If you want to use sounds other than the system alert sound at various alert stages, write your own sound function and call the ErrorSound function to make it the sound function for your application. 
Special Considerations

If you pass null in the soundProc parameter, the Dialog Manager neither plays sounds nor causes the menu bar to blink, and thus the user receives no signal.
Version Notes
Availability
Carbon Porting Notes

Using custom sounds in dialog boxes is not supported in Carbon.
Declared In
Dialogs.h*/
void ErrorSound (
   SoundUPP soundProc
){
printf ("ErrorSound",soundProc);
};

/*HideDialogItem

Makes an item in a dialog box invisible. 

void HideDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
);
Parameters
theDialog

A pointer to a dialog structure. 
itemNo

A number corresponding to the position of an item in the dialog box’s item list resource. 
Return Value
Discussion

The HideDialogItem function hides the item specified by itemNo by giving it a display rectangle that’s off the screen. Specifically, if the left coordinate of the item’s display rectangle is less than 8192 (hexadecimal 0x2000), HideDialogItem adds 16,384 (hexadecimal 0x4000) to both the left and right coordinates of the rectangle. If the item is already hidden (that is, if the left coordinate is greater than 8192), HideDialogItem does nothing. To redisplay an item that’s been hidden by HideDialogItem, you can use the ShowDialogItem function. 
Special Considerations

If your application needs to display a number of dialog boxes that are similar except for one or two items, it’s generally easier to modify the common elements using the AppendDITL and ShortenDITL functions than to use the HideDialogItem and ShowDialogItem functions. 

If you hid an edit text item, the next visible edit text item will be highlighted.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

void HideDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
){
printf ("HideDialogItem",theDialog,itemNo);
};


/*ShowDialogItem

Redisplays an item that has been hidden by HideDialogItem. 

void ShowDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
);
Parameters
theDialog

On input, a pointer to a dialog structure. 
itemNo

On input, a number corresponding to the position of an item in the dialog box’s item list resource. 
Return Value
Discussion

The ShowDialogItem function redisplays the item specified in the itemNo parameter by restoring the display rectangle the item had prior to HideDialogItem. If the left coordinate of the item’s display rectangle is greater than 8192, ShowDialogItem subtracts 16,384 from both the left and right coordinates of the rectangle. If the item is already visible (that is, if the left coordinate is less than 8192), ShowDialogItem does nothing.

The ShowDialogItem function adds the rectangle that contained the item to the update region so that it will be drawn. Note that if the item is a control you define in a control (' CNTL ') resource, the rectangle added to the update region is the rectangle defined in the control resource, not the display rectangle defined in the item list resource. If the item is an edit text item, ShowDialogItem activates it by calling the TextEdit function TEActivate. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ShowDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
){
printf ("ShowDialogItem",theDialog,itemNo);
};

/*GetDialogWindow


WindowRef GetDialogWindow (
   DialogRef dialog
);
Parameters
dialog
Return Value

See the QuickDraw Manager documentation for a description of the WindowRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
WindowRef GetDialogWindow (
   DialogRef dialog
){
printf ("GetDialogWindow",dialog);
};


/*GetDialogItem

Obtains a handle to a dialog item. 

void GetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType * itemType,
   Handle * item,
   Rect * box
);
Parameters
theDialog

A pointer to the dialog box to examine. 
itemNo

The position of the item in the dialog box’s item list resource use FindDialogItem to determine this value. 
itemType

A pointer to a short value. On return, the value identifies the item type of the dialog item requested in the itemNo parameter. 
item

A pointer to an item handle. On return the handle refers to the item specified in the itemNo parameter or, for application-defined draw functions, a pointer (coerced to a handle) to the draw function. 
box

A pointer to a rectangle. On return, the rectangle specifies the display rectangle (described in coordinates local to the dialog box), for the item specified in the itemNo parameter. 
Return Value
Discussion

The GetDialogItem function produces the item type, a handle to the item (or, for application-defined draw functions, the function pointer), and the display rectangle for a specified item in an item list resource. When a control hierarchy is present in the dialog box, GetDialogItem gets the appropriate information (for example, a text handle) from the controls. If you wish to get a control handle for a dialog item in an embedding hierarchy, see GetDialogItemAsControl.

You should call GetDialogItem before calling functions such as SetDialogItemText that need a handle to a dialog item. 

See also the function SetDialogItem. 
Version Notes

This function was changed with Appearance Manager 1.0 to support retrieving item information from controls.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h */

void GetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType * itemType,
   Handle * item,
   Rect * box
){
printf ("GetDialogItem",theDialog,itemNo,*itemType,*item,*box);
};


/*SetPortDialogPort


void SetPortDialogPort (
   DialogRef dialog
);
Parameters
dialog
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetPortDialogPort (
   DialogRef dialog
){
printf ("SetPortDialogPort",dialog);
};


/*SelectDialogItemText

Selects and highlights text contained in an edit text item. 

void SelectDialogItemText (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   SInt16 strtSel,
   SInt16 endSel
);
Parameters
theDialog

On input, a pointer to a dialog structure. 
itemNo

On input, a number corresponding to the position of an edit text item in the dialog box’s item list resource. 
strtSel

On input, a number representing the position of the first character to begin selecting. 
endSel

On input, a number representing one position past the last character to be selected.
Discussion

If the item in the itemNo parameter is an edit text item that contains text, the SelectDialogItemText function sets the text selection range to extend from the character position specified in the strtSel parameter up to but not including the character position specified in the endSel parameter. The selection range is highlighted unless strtSel equals endSel, in which case a blinking vertical bar is displayed to indicate an insertion point at that position. If the edit text item doesn’t contain text, SelectDialogItemText displays the insertion point.

You can select the entire text by specifying the number 0 in the strtSel parameter and the number 32767 in the endSel parameter.

For example, if the user makes an unacceptable entry in the edit text item, your application can display an alert box reporting the problem and then use SelectDialogItemText to select the entire text so it can be replaced by a new entry. Without this function, the user would have to select the item before making the new entry. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/
void SelectDialogItemText (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   SInt16 strtSel,
   SInt16 endSel
){
printf ("SelectDialogItemText",theDialog,itemNo,strtSel,endSel);
};


//work

/*ModalDialog

Handles events while your application displays a modal or movable modal dialog box.

void ModalDialog (
   ModalFilterUPP modalFilter,
   DialogItemIndex * itemHit
);
Parameters
modalFilter

A universal procedure pointer for an event filter function. For modal dialog boxes, you can specify null if you want to use the standard event-handling function. For movable modal dialog boxes, you should specify your own event filter function. 
itemHit

A pointer to a short integer. After receiving an event involving an enabled item, ModalDialog produces a number representing the position of the selected item in the active dialog box’s item list resource. 
Return Value
Discussion

Call the ModalDialog function immediately after displaying a modal or movable modal dialog box. Your application should continue calling ModalDialog until the user dismisses your dialog.

For modal dialogs, the ModalDialog function repeatedly handles events until an event involving an enabled dialog box item—such as a click in a radio button, for example—occurs. If the event is a mouse-down event outside the content region of the dialog box, ModalDialog plays the system alert sound and gets the next event.

For movable modal dialogs, if the kDialogFlagsHandleMovableModal feature bit in the extended dialog resource is set, the ModalDialog function will handle all standard movable modal user interactions, such as dragging a dialog box by its title bar and allowing the user to switch into another application. However, a difference between the ModalDialog function’s behavior with movable modal and modal dialogs is that, with movable modal dialogs, your event filter function receives all events. If you want the Dialog Manager to assist you in handling events in movable modal dialog boxes, call GetStdFilterProc and StdFilterProc. 

For events inside the dialog box, ModalDialog passes the event to the event filter function pointed to in the modalFilter parameter before handling the event. When the event filter returns false, ModalDialog handles the event. If the event filter function handles the event, returning true, ModalDialog performs no more event handling.

If you set the modalFilter parameter to null, the standard event filter function is executed. The standard event filter function checks whether
the user has pressed the Enter or Return key and, if so, returns the item number of the default button 
the user has pressed the Escape key or Command-period and, if so, returns the item number of the Cancel button 
the cursor is over an editable text box, and optionally changes the cursor to an I-beam whenever this is the case 

If you set the modalFilter parameter to point to your own event filter function, that function can use the standard filter function to accomplish the above tasks. (To do so, you can call GetStdFilterProc, and dispatch the event to the standard filter function yourself, or you can call StdFilterProc, which obtains a ModalFilterUPP for the standard filter function and then dispatches the function.) Additionally, your own event filter function should also
handle update events, so that background processes can receive processor time, and return false 
return false for all events that your event filter function doesn’t handle 

You can also use your event filter function to test for and respond to keyboard equivalents and more complex events—for instance, the user dragging the cursor within an application-defined item. You can use your same event filter function in most or all of your alert and modal dialog boxes.

If the event filter function does not handle the event (returning false), ModalDialog handles the event as follows: 
In response to an activate or update event for the dialog box, ModalDialog activates or updates its window. 
If the user presses the mouse button while the cursor is in an editable text item, ModalDialog responds to the mouse activity as appropriate—that is, either by displaying an insertion point or by selecting text. If a key-down event occurs and there’s an editable text item, ModalDialog uses TextEdit to handle text entry and editing automatically. If the editable text item is enabled, ModalDialog produces its item number after it receives either the mouse-down or key-down event. Normally, editable text items are disabled, and you use the GetDialogItemText function to read the information in the items only after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in a control, ModalDialog calls the Control Manager function TrackControl. If the user releases the mouse button while the cursor is in an enabled control, ModalDialog produces the control’s item number. Your application should respond appropriately—for example, by performing a command after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in any other enabled item in the dialog box, ModalDialog produces the item’s number, and your application should respond appropriately. Generally, only controls should be enabled. If your application creates a control more complex than a button, radio button, or checkbox, your application must handle events inside that item with your event filter function. 
If the user presses the mouse button while the cursor is in a disabled item or in no item, or if any other event occurs, ModalDialog does nothing. 
Special Considerations

The ModalDialog function traps all events. This prevents your event loop from receiving activate events for your windows. Thus, if one of your application’s windows is active when you use GetNewDialog to create a modal dialog box, you must explicitly deactivate that window before displaying the modal dialog box.

When ModalDialog calls the Control Manager function TrackControl, it does not allow you to specify the action function necessary for anything more complex than a button, radio button, or checkbox. If you need a more complex control, you can create your own control, a picture, or an application-defined item that draws a control-like object in your dialog box. You must then provide an event filter function that appropriately handles events in that item. 
Version Notes

This function was changed with Appearance Manager 1.0 to handle events for movable modal dialogs.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ModalDialog (
   ModalFilterUPP modalFilter,
   DialogItemIndex * itemHit
){};




/*SetDialogItemText

Sets the text string for static text and editable text fields.

void SetDialogItemText (
   Handle item,
   ConstStr255Param text
);
Parameters
item

A handle to an editable text field or static text field. When embedding is on, you should pass in the control handle produced by a call to the function . If embedding is not on, pass in the handle produced by the “Alert Button Constants” function. 
text

A pointer to a string containing the text to display in the field. 
Discussion

The SetDialogItemText function sets and redraws text strings for static text and editable text fields. SetDialogItemText is useful for supplying a default text string—such as a document name—for an editable text field while your application is running. 
Version Notes

This function was changed with Appearance Manager 1.0 to support embedding hierarchies.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetDialogItemText (
   Handle item,
   ConstStr255Param text
){};


/*DisposeDialog

Dismisses a dialog box for which the Dialog Manager supplies memory and disposes of the dialog structure.

void DisposeDialog (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value
Discussion

The DisposeDialog function calls CloseDialog and, in addition, releases the memory occupied by the dialog box’s item list resource and the dialog structure. Call DisposeDialog when you’re done with a dialog box if you pass null in the dStorage parameter to GetNewDialog , NewColorDialog , or NewDialog. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void DisposeDialog (
   DialogRef theDialog
){};


/*GetDialogItemAsControl

Obtains the control handle for a dialog item in an embedding hierarchy. 

OSErr GetDialogItemAsControl (
   DialogRef inDialog,
   SInt16 inItemNo,
   ControlRef * outControl
);
Parameters
inDialog

A pointer to the dialog box to examine. 
inItemNo

The position of an item in the dialog box’s item list. 
outControl

A pointer to a control handle that, on return, refers to the embedded control. 
Return Value

A result code. See “Dialog Manager Result Codes”. The Control Manager result code errItemNotControl indicates that the specified dialog item is not a control.
Discussion

When an embedding hierarchy is established, GetDialogItemAsControl produces a handle to the embedded controls (except Help items). It should be used instead of GetDialogItem when an embedding hierarchy is established. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr GetDialogItemAsControl (
   DialogRef inDialog,
   SInt16 inItemNo,
   ControlRef * outControl
){};

/*GetNewDialog

Creates a dialog box from a resource-based description. 

DialogRef GetNewDialog (
   SInt16 dialogID,
   void * dStorage,
   WindowRef behind
);
Parameters
dialogID

The resource ID of a dialog resource and an extended dialog resource. The resource IDs for both resources must be identical. If the dialog resource is missing, the Dialog Manager returns to your application without creating the requested dialog box. See ‘DLOG’ and ‘dlgx’ for a description of the dialog resource and the extended dialog resource, respectively. 
dStorage

A pointer to the memory for the dialog structure. If you set this parameter to null, the Dialog Manager automatically allocates a nonrelocatable block in your application heap. 
behind

A pointer to the window behind which the dialog box is to be placed on the desktop. Set this parameter to the window pointer (WindowPtr)-1L to bring the dialog box in front of all other windows. 
Return Value

Returns a pointer to a dialog box. If none was created, returns null. See the description of the DialogRef data type.
Discussion

The GetNewDialog function creates a dialog structure from information in a dialog resource and an extended dialog resource (if it exists) and returns a pointer to the dialog structure. You can use this pointer with Window Manager or QuickDraw functions to manipulate the dialog box. If the dialog resource specifies that the dialog box should be visible, the dialog box is displayed. If the dialog resource specifies that the dialog box should initially be invisible, use the Window Manager function ShowWindow to display the dialog box.

The dialog resource contains a resource ID that specifies both the dialog box’s item list ( 'DITL') resource and its dialog font table ( 'dftb') resource. After calling the Resource Manager to read these resources into memory (if they are not already in memory), GetNewDialog makes a copy of the 'DITL' resource and uses that copy; thus you may have several dialog boxes with identical items.

If you supply a dialog color table ( 'dctb') resource with the same resource ID as the dialog resource, GetNewDialog uses NewColorDialog and returns a pointer to a color graphics port. If no dialog color table resource is present, GetNewDialog uses NewDialog to return a pointer to a black-and-white graphics port, although system software draws the window frame using the system’s default colors. However, if the Appearance Manager is available and the kDialogFlagsUseThemeBackground feature bit of the extended dialog resource is set, then the 'dctb' resource is ignored and a color graphics port is created. 
Special Considerations

The GetNewDialog function doesn’t release the memory occupied by the resources. Therefore, your application should mark all resources used for a dialog box as purgeable or you should release the resources yourself.

If either the dialog resource or the item list resource can’t be read, the function result is null; your application should test to ensure that null is not returned before performing any more operations with the dialog box or its items.

As with all other windows, dialogs are created with an update region equal to their port rectangle. However, if the dialog’s 'DLOG' resource specifies that the dialog be made visible upon creation, the Dialog Manager draws the controls immediately and calls ValidRgn for each of their bounding rectangles. Other items are not drawn until the first update event for the dialog box is serviced.

If you need to display an alert box while your application is running in the background or is otherwise invisible to the user, call AEInteractWithUser
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended dialog ('dlgx') resource and the dialog font table ('dftb') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogRef GetNewDialog (
   SInt16 dialogID,
   void * dStorage,
   WindowRef behind
){};

/*SetDialogItem

Sets or changes information for a dialog item.

void SetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType itemType,
   Handle item,
   const Rect * box
);
Parameters
theDialog

A pointer to the dialog box containing the dialog item. 
itemNo

The position of the item in the dialog box’s item list resource use FindDialogItem to determine this value. 
itemType

A short value. Pass an item type constant identifying the dialog item specified in the itemNo parameter. When an embedding hierarchy is established, only the kItemDisableBit item type constant is honored. 
item

Either a handle to the dialog item specified in the itemNo parameter or, for a custom dialog item, a pointer (coerced to a handle) to an application-defined item drawing function. When an embedding hierarchy is established, the item parameter is ignored unless you pass a universal procedure pointer to an application-defined item draw function. 
box

A pointer to the display rectangle (in local coordinates) for the item specified in the itemNo parameter. If you set the control rectangle on an item when an embedding hierarchy is present, SetDialogItem will move and resize the item appropriately for you, on return. 
Return Value
Discussion

The SetDialogItem function sets the item specified by the itemNo parameter for the specified dialog box. If an embedding hierarchy exists, however, you cannot change the type or handle of an item, although application-defined item drawing functions can still be set.

See also the function GetDialogItem. 
Version Notes

This function was changed with Appearance Manager 1.0 to work with embedding hierarchies.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType itemType,
   Handle item,
   const Rect * box
){};


/*DisposeModalFilterYDUPP


void DisposeModalFilterYDUPP (
   ModalFilterYDUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0.2 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This function is supported in Carbon because several QuickTime routines require it.
Declared In
Dialogs.h*/
void DisposeModalFilterYDUPP (
   ModalFilterYDUPP userUPP
){};



/*Alert

Displays an alert box and/or plays an alert sound.

DialogItemIndex Alert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
);
Parameters
alertID

The resource ID of an alert resource and extended alert resource. If the alert resource is missing, the Dialog Manager returns to your application without creating the requested alert. See ‘alrx’ for a description of the extended alert resource. 
modalFilter

A universal procedure pointer for a filter function that responds to events not handled by the ModalDialog function. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
Return Value

If no alert box is to be drawn at the current alert stage or the 'ALRT' resource is not found, Alert returns –1 otherwise, it creates and displays the alert box and returns the item number of the control selected by the user see “Alert Button Constants”. See the description of the DialogItemIndex data type.
Discussion

The Alert function displays an alert box or, if appropriate for the alert stage, plays an alert sound instead of or in addition to displaying the alert box. The Alert function creates the alert defined in the specified alert resource and its corresponding extended alert resource. The function calls the current alert sound function and passes it the sound number specified in the alert resource for the current alert stage. If no alert box is to be drawn at this stage, Alert returns –1 otherwise, it uses the NewDialog function to create and display the alert box. The default system window colors are used unless your application provides an alert color table resource with the same resource ID as the alert resource. The Alert function uses the ModalDialog function to get and handle most events for you.

The Alert function does not display a default icon in the upper-left corner of the alert box you can leave this area blank, or you can specify your own icon in the alert’s item list resource, which in turn is specified in the alert resource.

The Alert function continues calling ModalDialog until the user selects an enabled control (typically a button), at which time the Alert function removes the alert box from the screen and returns the item number of the selected control. Your application then responds as appropriate when the user clicks this item.

Your application should never draw its own default rings. Prior to Mac OS 8, the Alert function would only redraw the default button ring once and never redraw it on an update event. However, when Appearance is available, default rings do redraw when you call Alert.

See also the functions NoteAlert , CautionAlert , and StopAlert. 
Special Considerations

If you need to display an alert box while your application is running in the background or is otherwise invisible to the user, call AEInteractWithUser

The Dialog Manager uses the system alert sound as the error sound unless you change it by calling the ErrorSound function .
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended alert ('alrx') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogItemIndex Alert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
){};



/*SetDialogTracksCursor

Determines whether the Dialog Manager tracks the cursor’s movements and changes the cursor to an I-beam whenever it is over an edit dialog box.

OSErr SetDialogTracksCursor (
   DialogRef theDialog,
   Boolean tracks
);
Parameters
theDialog

On input, a pointer to the dialog structure for the dialog box containing one or more edit text items for which you want the Dialog Manager to track the cursor. 
tracks

On input, a Boolean value. A value of true indicates you want the Dialog Manager to track the cursor’s movements and change it to an I-beam whenever the cursor is over an edit dialog box a value of false indicates you don’t want the Dialog Manager to track the cursor in this manner. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

You should call SetDialogTracksCursor before you call the standard filter function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr SetDialogTracksCursor (
   DialogRef theDialog,
   Boolean tracks
){};

/*ParamText

Replaces the text strings in the static text items of your alert or dialog boxes while your application is running.

void ParamText (
   ConstStr255Param param0,
   ConstStr255Param param1,
   ConstStr255Param param2,
   ConstStr255Param param3
);
Parameters
param0

A text string to substitute for the special string ^0 in the static text items of all subsequently created alert and dialog boxes. 
param1

A text string to substitute for the special string ^1 in the static text items of all subsequently created alert and dialog boxes.
param2

A text string to substitute for the special string ^2 in the static text items of all subsequently created alert and dialog boxes.
param3

A text string to substitute for the special string ^3 in the static text items of all subsequently created alert and dialog boxes.
Discussion

The ParamText function replaces the special strings ^0 through ^3 in the static text items of all subsequently created alert and dialog boxes with the text strings you pass as parameters. Pass empty strings (not null) for parameters not used. 
Special Considerations

If the user launches a desk accessory (such as a driver) in your application’s partition and the desk accessory calls ParamText, it may change the text in your application’s dialog box. 

You should be very careful about using ParamText in modeless dialog boxes. If a modeless dialog box using ParamText is onscreen and you display another dialog box or alert box that also uses ParamText, both boxes will be affected by the latest call to ParamText.

Note that you should try to store text strings in resource files to facilitate translation into other languages; therefore, ParamText is best used for supplying text strings, such as document names, that the user specifies. To avoid problems with grammar and sentence structure when you localize your application, you should use ParamText to supply only one text string per screen message.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ParamText (
   ConstStr255Param param0,
   ConstStr255Param param1,
   ConstStr255Param param2,
   ConstStr255Param param3
){};

/*StopAlert

Displays an alert box with a stop icon and/or plays an alert sound.

DialogItemIndex StopAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
);
Parameters
alertID

The resource ID of an alert resource and extended alert resource. The resource ID of both types of resources must be identical. If the alert resource is missing, the Dialog Manager returns to your application without creating the requested alert. See ‘alrx’ for a description of the extended alert resource. 
modalFilter

A universal procedure pointer for a filter function that responds to events not handled by the ModalDialog function. If you set this parameter to null, the Dialog Manager uses the standard event filter function. 
Return Value

If no stop alert box is to be drawn at the current alert stage, StopAlert returns –1 otherwise, it creates and displays the alert box and returns the item number of the control selected by the user see “Alert Button Constants”. See the description of the DialogItemIndex data type.
Discussion

The StopAlert function displays an alert box with a stop icon in its upper-left corner or, if appropriate for the alert stage, plays an alert sound instead of or in addition to displaying the alert box.

The StopAlert function is the same as the Alert function except that, before drawing the items in the alert box, StopAlert draws the stop icon in the upper-left corner. The stop icon has resource ID 0, which you can also specify with the constant stopIcon . By default, the Dialog Manager uses the standard stop icon from the System file. You can change this icon by providing your own 'ICON' resource with resource ID 0.

Use a stop alert to inform the user that a problem or situation is so serious that the action cannot be completed. Stop alerts typically have only a single button (OK), because all the user can do is acknowledge that the action cannot be completed.

Your application should never draw its own default rings or alert icons. Prior to Mac OS 8, the StopAlert function would only redraw the alert icon and default button ring once and never redraw them on an update event. However, when Appearance is available, alert icons and default rings do redraw when you call StopAlert.

See also the functions NoteAlert and CautionAlert. 
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended alert ('alrx') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

DialogItemIndex StopAlert (
   SInt16 alertID,
   ModalFilterUPP modalFilter
){};

/*InvokeModalFilterUPP


Boolean InvokeModalFilterUPP (
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit,
   ModalFilterUPP userUPP
);
Parameters
theDialog
theEvent
itemHit
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

Boolean InvokeModalFilterUPP (
   DialogRef theDialog,
   EventRecord * theEvent,
   DialogItemIndex * itemHit,
   ModalFilterUPP userUPP
){};

/*IsDialogEvent

Determines whether a modeless dialog box or a movable modal dialog box is active when an event occurs.

Boolean IsDialogEvent (
   const EventRecord * theEvent
);
Parameters
theEvent

A pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
Return Value

A Boolean value. If any event, including a null event, occurs when your dialog box is active, IsDialogEvent returns true; otherwise, it returns false. 
Discussion

When IsDialogEvent returns false, pass the event to the rest of your event-handling code. When IsDialogEvent returns true, pass the event to DialogSelect after testing for the events that DialogSelect does not handle.

A dialog structure includes a window structure. When you use the GetNewDialog , NewDialog , NewFeaturesDialog , or NewColorDialog functions to create a dialog box, the Dialog Manager sets the windowKind field in the window structure to dialogKind. To determine whether the active window is a dialog box, IsDialogEvent checks the windowKind field.

Before passing the event to DialogSelect, you should perform the following tests whenever IsDialogEvent returns true :
Check whether the event is a key-down event for the Return, Enter, Esc, or Command-period keystrokes. When the user presses the Return or Enter key, your application should respond as if the user had clicked the default button; when the user presses Esc or Command-period, your application should respond as if the user had clicked the Cancel button. Use the Control Manager function HiliteControl to highlight the applicable button for 8 ticks. 
At this point, you may also want to check for and respond to any special events that you do not wish to pass to DialogSelect or that require special processing before you pass them to DialogSelect. You would need to do this, for example, if the dialog box needs to respond to disk-inserted events. 
Check whether the event is an update event for a window other than the dialog box and, if it is, update your window. 
For complex items that you create, such as pictures or application-defined items that emulate complex controls, test for and respond to mouse events inside those items as appropriate. When DialogSelect calls the Control Manager function TrackControl, it does not allow you to specify the action function necessary for anything more complex than a button, radio button, or checkbox. If you need a more complex control (for example, one that measures how long the user holds down the mouse button or how far the user has moved an indicator), you can create your own control or a picture or an application-defined item that draws a control-like object in your dialog box. You must then test for and respond to those events yourself. 

If your application uses IsDialogEvent to help handle events when you display a movable modal dialog box, perform the following additional tests before passing events to DialogSelect :
Test for mouse-down events in the title bar of the movable modal dialog box and respond by dragging the dialog box accordingly. 
Test for and respond to mouse-down events in the Apple menu and, if the movable modal dialog box includes edit text items, in the Edit menu. (You should disable all other menus when you display a movable modal dialog box.) 
Play the system alert sound for every other mouse-down event outside the movable modal dialog box. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

Boolean IsDialogEvent (
   const EventRecord * theEvent
){};


/*DialogSelect

Handles most of the events inside the dialog box after you have determined that an event related to an active modeless dialog box or an active movable modal dialog box has occurred.

Boolean DialogSelect (
   const EventRecord * theEvent,
   DialogRef * theDialog,
   DialogItemIndex * itemHit
);
Parameters
theEvent

A pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
theDialog

A pointer to a dialog structure for the dialog box where the event occurred. 
itemHit

A pointer to a short integer. DialogSelect returns a number corresponding to the position of an item within the item list resource of the active dialog box. 
Return Value

A Boolean value. If the event is an activate or update event for a dialog box, DialogSelect activates or updates it and returns false. If the event involves an enabled item, DialogSelect returns a function result of true. 
Discussion

The DialogSelect function handles most of the events relating to a dialog box. Through its itemHit parameter, it returns the item number of the item selected by the user. Through the parameter theDialog, it returns a pointer to the dialog structure for the dialog box where the event occurred. In all other cases, the DialogSelect function returns false. When DialogSelect returns true, do whatever is appropriate as a response to the event involving that item in that particular dialog box; when it returns false, do nothing.

Generally, only controls should be enabled in a dialog box; therefore your application should normally respond only when DialogSelect returns true after the user clicks an enabled control, such as the OK button.

The DialogSelect function first obtains a pointer to the window containing the event. For update and activate events, the event structure contains the window pointer. For other types of events, DialogSelect calls the Window Manager function FrontWindow. The Dialog Manager then makes this window the current graphics port by calling the QuickDraw function SetPort. Then DialogSelect prepares to handle the event by setting up text information if there are any edit text items in the active dialog box.

When an item is a control defined in a control resource, the rectangle added to the update region is the rectangle defined in the control resource, not the display rectangle defined in the item list resource.

The DialogSelect function handles the event as follows:
In response to an activate or update event for the dialog box, DialogSelect activates or updates its window and returns false. 
If a key-down event or an auto-key event occurs and there’s an edit text item in the dialog box, DialogSelect uses TextEdit to handle text entry and editing, and DialogSelect returns true for a function result. Through its itemHit parameter, DialogSelect returns the item number. 
If a key-down event or an auto-key event occurs and there’s no edit text item in the dialog box, DialogSelect returns false. 
If the user presses the mouse button while the cursor is in an edit text item, DialogSelect responds to the mouse activity as appropriate—that is, either by displaying an insertion point or by selecting text. If the edit text item is disabled, DialogSelect returns false. If the edit text item is enabled, DialogSelect returns true and through its itemHit parameter returns the item number. Normally, edit text items are disabled, and you use the GetDialogItemText function to read the information in the items only after the OK button is clicked. 
If the user presses the mouse button while the cursor is in a control, DialogSelect tracks the control. If the user releases the mouse button while the cursor is in an enabled control, DialogSelect returns true for a function result and through its itemHit parameter returns the control’s item number. Your application should respond appropriately—for example, by performing a command after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in any other enabled item in the dialog box, DialogSelect returns true for a function result and through its itemHit parameter returns the item’s number. Generally, only controls should be enabled. If your application creates a complex control—such as one that measures how far a dial is moved—your application must handle mouse events in that item before passing the event to DialogSelect. 
If the user presses the mouse button while the cursor is in a disabled item, or if it is in no item, or if any other event occurs, DialogSelect does nothing. 
If the event isn’t one that DialogSelect specifically checks for (if it’s a null event, for example), and if there’s an edit text item in the dialog box, DialogSelect calls the TextEdit function TEIdle to make the insertion point blink. 
Special Considerations

Because DialogSelect handles only mouse-down events in a dialog box and key-down events in a dialog box’s edit text items, you should handle other events as appropriate before passing them to DialogSelect. Likewise, when DialogSelect calls the Control Manager function TrackControl , it does not allow you to specify any action function necessary for anything more complex than a button, radio button, or checkbox. If you need a more complex control (for example, one that measures how long the user holds down the mouse button or how far the user has moved an indicator), you can create your own control or a picture or an application-defined item that draws a control-like object in your dialog box. You must then test for and respond to those events yourself.

Within dialog boxes, use the functions DialogCut, DialogCopy, DialogPaste, and DialogDelete to support Cut, Copy, Paste, and Clear commands in edit text boxes.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

Boolean DialogSelect (
   const EventRecord * theEvent,
   DialogRef * theDialog,
   DialogItemIndex * itemHit
){};


/*GetDialogFromWindow


DialogRef GetDialogFromWindow (
   WindowRef window
);
Parameters
window
Return Value

See the description of the DialogRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

DialogRef GetDialogFromWindow (
   WindowRef window
){};


/*CountDITL

Determines the number of items in a dialog box.

DialogItemIndex CountDITL (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value

The number of current items in a dialog box. See the description of the DialogItemIndex data type.
Discussion

You typically use CountDITL in conjunction with ShortenDITL to remove items from a dialog box. 
Special Considerations

Before calling CountDITL, you should make sure that it is available by using the Gestalt function with the gestaltDITLExtAttr selector. Test the bit indicated by the gestaltDITLExtPresent constant in the response parameter. If the bit is set, then CountDITL is available.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogItemIndex CountDITL (
   DialogRef theDialog
){};


/*NewModalFilterUPP


ModalFilterUPP NewModalFilterUPP (
   ModalFilterProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ModalFilterUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
ModalFilterUPP NewModalFilterUPP (
   ModalFilterProcPtr userRoutine
){};


/*GetDialogItemText

Obtains the text string contained in an edit text or a static text item. 

void GetDialogItemText (
   Handle item,
   Str255 text
);
Parameters
item

On input, a handle to an edit text or a static text item. To get this handle, call the “Alert Button Constants” function. 
text

On output, a string containing the text of the item that is specified by the item parameter. 
Discussion

The GetDialogItemText function will only return the first 255 characters in an edit text item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

void GetDialogItemText (
   Handle item,
   Str255 text
){};

/*DisposeModalFilterUPP


void DisposeModalFilterUPP (
   ModalFilterUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void DisposeModalFilterUPP (
   ModalFilterUPP userUPP
){};


/*GetStdFilterProc

Returns a pointer to the standard filter function.

OSErr GetStdFilterProc (
   ModalFilterUPP * theProc
);
Parameters
theProc

A universal procedure pointer to a filter function. On output, the Dialog Manager provides a pointer to its standard filter function. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

The GetStdFilterProc function gets a pointer to the standard filter function. You must dispatch the function yourself using the CallModalFilterProc macro; see ModalFilterProcPtr. 

You normally don’t need to use GetStdFilterProc unless your development environment doesn’t include the code required to support StdFilterProc. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

OSErr GetStdFilterProc (
   ModalFilterUPP * theProc
){};


/*StdFilterProc

Handles standard event filtering for a dialog box.

Boolean StdFilterProc (
   DialogRef theDialog,
   EventRecord * event,
   DialogItemIndex * itemHit
);
Parameters
theDialog

On input, a pointer to a dialog structure for an alert box or a modal dialog box. 
event

On output, a pointer to an event structure returned by an Event Manager function such as WaitNextEvent. 
itemHit

On output, a pointer to a short integer. StdFilterProc returns a number corresponding to the position of an item in the item list resource for the alert or modal dialog box. 
Return Value

A Boolean value representing whether the standard filter proc handled the event. true means handled; otherwise false. 
Discussion

To use the standard filter function from within your own filter function, you can call GetStdFilterProc , then dispatch the event to the standard filter function yourself; or you can call StdFilterProc, which performs both steps for you. Calling StdFilterProc is equivalent to calling GetStdFilterProc and then calling ModalFilterProcPtr. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
Boolean StdFilterProc (
   DialogRef theDialog,
   EventRecord * event,
   DialogItemIndex * itemHit
){};

/*NewUserItemUPP


UserItemUPP NewUserItemUPP (
   UserItemProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the UserItemUPP data type.
Discussion
Special Considerations
Version Notes
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/

UserItemUPP NewUserItemUPP (
   UserItemProcPtr userRoutine
){};


/*DrawDialog

Draws the entire contents of a specified dialog box.

void DrawDialog (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value
Discussion

The DrawDialog function draws all dialog items, calls the Control Manager function DrawOneControl to draw all controls, and calls the TextEdit function TEUpdate to update all static and edit text items and to draw their display rectangles. The DrawDialog function also calls the application-defined items’ draw functions if the items’ rectangles are within the update region.

DialogSelect , ModalDialog , Alert , StopAlert , NoteAlert , and CautionAlert use DrawDialog automatically. If you use GetNewDialog to create a dialog box but don’t use any of these other Dialog Manager functions when handling events in the dialog box, you can use DrawDialog to redraw the contents of the dialog box when it’s visible. If the dialog box is invisible, first use the Window Manager function ShowWindow and then use DrawDialog. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void DrawDialog (
   DialogRef theDialog
){};


/*DisposeUserItemUPP


void DisposeUserItemUPP (
   UserItemUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

void DisposeUserItemUPP (
   UserItemUPP userUPP
){};


/*CloseDialog

Dismisses a dialog box without disposing of the dialog structure.

void CloseDialog (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value
Discussion

The CloseDialog function removes a dialog box from the screen and deletes it from the window list. The CloseDialog function releases the memory occupied by
the data structures associated with the dialog box (such as its structure, content, and update regions) 
all the items in the dialog box (except for pictures and icons, which might be shared by other resources) and any data structures associated with them 

Generally, you should provide memory for the dialog structure of modeless dialog boxes when you create them. (You can let the Dialog Manager provide memory for modal and movable modal dialog boxes.) You should then use CloseDialog to close a modeless dialog box when the user clicks the close box or chooses Close from the File menu.

Because CloseDialog does not dispose of the dialog resource or the item list resource, it is important to make these resources purgeable. Unlike GetNewDialog , NewColorDialog does not use a copy of the item list resource. Thus, if you use NewColorDialog to create a dialog box, you may want to use CloseDialog to keep the item list resource in memory even if you didn’t supply a pointer to the memory. 
Carbon Porting Notes

The CloseDialog function is not supported because developers do not allocate their own memory for dialog boxes in Carbon. Use the DisposeDialog function to dismiss a dialog box instead.
Declared In
Dialogs.h*/
void CloseDialog (
   DialogRef theDialog
){};

ModalFilterYDUPP 
NewModalFilterYDUPP(ModalFilterYDProcPtr userRoutine){};



