#include <stdio.h>
#include <HIToolbox/HIToolbox.h>
#include <HIToolbox/Events.h>

 void 
SystemClick(
  const EventRecord *  theEvent,
  WindowRef            theWindow){
printf ("SystemClick",theEvent,theWindow);
};


 void 
GetMouse(Point * mouseLoc){
printf ("GetMouse",mouseLoc);
};



void 
FlushEvents(
  EventMask   whichMask,
  EventMask   stopMask){
printf ("FlushEvents",whichMask,stopMask);
};



 void 
SystemTask(void){
printf ("SystemTask");
};


Boolean 
GetNextEvent(
  EventMask      eventMask,
  EventRecord *  theEvent){
printf ("GetNextEvent",eventMask,theEvent);
};


 Boolean 
OSEventAvail(
  EventMask      mask,
  EventRecord *  theEvent){
printf ("OSEventAvail",mask,theEvent);
};


/*Button

Determines whether the user pressed the mouse button.

Not recommended

Boolean Button ();
Parameters
Return Value
Discussion

The Button function simply checks to see if the mouse button is down. If so, it returns true; otherwise, it returns false. To determine whether the mouse button is still down after a mouse-down event, use the StillDown function. To check to see if the mouse was released, use the WaitMouseUp function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

You should avoid using any calls that poll the state of the mouse button, as they use excessive processor time and slow down the system. In most cases you are more interested in the transitions of the mouse button rather than its instantaneous state, so you should adopt Carbon events and take action on mouse-up and mouse-down events. If you need to track the mouse while down, consider using the Carbon Event Manager functions TrackMouseLocation or TrackMouseRegion. On Mac OS X v.10.2 and later, if you need to know the button state, you should call the GetCurrentEventButtonState function. 
Declared In
Events.h*/
Boolean Button (){
printf ("Button");
};


/*GetCaretTime

Obtains the suggested difference in ticks that should exist between blinks of the caret (usually a vertical bar marking the insertion point) in editable text. 

UInt32 GetCaretTime ();
Parameters
Return Value

The blink delay, in ticks. 
Discussion

If your application supports editable text, your application should use the value returned by GetCaretTime to determine how often to blink the caret. If your application uses only TextEdit, you can use TextEdit functions to automatically blink the caret at the time interval that the user specifies in the General Controls panel. 

The value returned by GetCaretTime is also accessible in the system global variable CaretTime. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 GetCaretTime (){
printf ("GetCaretTime");
};


/*GetGlobalMouse

Obtains the position of the mouse, in global coordinates. 

void GetGlobalMouse (
   Point * globalMouse
);
Parameters
globalMouse

The position of the mouse, as a global point. 
Return Value
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/

void GetGlobalMouse (
   Point * globalMouse
){
printf ("GetGlobalMouse",*globalMouse);
};


/*WaitNextEvent

Retrieves events one at a time from the Event Manager.

Boolean WaitNextEvent (
   EventMask eventMask,
   EventRecord * theEvent,
   UInt32 sleep,
   RgnHandle mouseRgn
);
Parameters
eventMask

A value that indicates which kinds of events are to be returned. This parameter is interpreted as a sum of event mask constants. You specify the event mask using values defined in “Event Mask Constants”. To accept all events, you can specify the everyEvent constant as the event mask.

If no event of any of the designated types is available, WaitNextEvent returns a null event. WaitNextEvent determines the next available event to return based on the eventMask parameter and the priority of the event. 

Events not designated by the event mask remain in the event stream until retrieved by an application. Low-level events in the Operating System event queue are kept in the queue until they are retrieved by your application or another application or until the queue becomes full. Once the queue becomes full, the Operating System Event Manager begins discarding the oldest events in the queue.

theEvent

A pointer to an event structure for the next available event of the specified type or types. The WaitNextEvent function removes the returned event from the event stream and returns the information about the event in an event structure. The event structure includes the type of event received and other information. 

In addition to the event structure, high-level events can contain additional data; use the Apple Event Manager AEProcessAppleEvent function to get additional data associated with these events.

sleep

The number of ticks (a tick is approximately 1/60 of a second) indicating the amount of time your application is willing to relinquish the processor if no events are pending for your application. If you specify a value greater than 0 for the sleep parameter, your application relinquishes the processor for the specified time or until an event occurs.

You should not set the sleep parameter to a value greater than the number of ticks returned by GetCaretTime if your application provides text-editing capabilities. When the specified time expires, and if there are no pending events for your application, WaitNextEvent returns a NULL event in the parameter theEvent. 

When running on Mac OS X, a Carbon application will block for the entire duration of the sleep parameter if there are no events to be delivered. This is slightly different behavior than on Mac OS 9, where the application will often receive NULL events before the sleep duration has elapsed.

mouseRgn

A handle to a region that specifies a region inside of which mouse movement does not cause mouse-moved events. In other words, your application receives mouse-moved events only when the cursor is outside the specified region. You should specify the region in global coordinates. If you pass an empty region or a null region handle, the Event Manager does not report mouse-moved events to your application. Note that your application should recalculate the mouseRgn parameter when it receives a mouse-moved event, or it will continue to receive mouse-moved events as long as the cursor position is outside the original mouseRgn. 
Return Value

The WaitNextEvent function returns false as its function result if the event being returned is a null event or if WaitNextEvent has intercepted the event; otherwise, WaitNextEvent returns true. 
Discussion

The WaitNextEvent function calls the Operating System Event Manager function SystemEvent to determine whether the event should be handled by the application or the Operating System.

If no events are pending for your application, WaitNextEvent waits for a specified amount of time for an event. (During this time, processing time may be allocated to background processes.) If an event occurs, it is returned through the parameter theEvent, and WaitNextEvent returns a function result of true. If the specified time expires and there are no pending events for your application, WaitNextEvent returns a null event in theEvent and a function result of false. 

Before returning an event to your application, WaitNextEvent performs other processing and may intercept the event. 

The WaitNextEvent function intercepts Command–Shift–number key sequences and calls the corresponding ' FKEY ' resource to perform the associated action. The Event Manager’s processing of Command–Shift–number key sequences with numbers 3 through 9 can be disabled by setting the ScrDmpEnable global variable (a byte) to 0. 

If the returned event is a high-level event and your application supports Apple events, use the Apple Event Manager function AEProcessAppleEvent to respond to the Apple event and to get additional information associated with the Apple event.

To retrieve an event without removing it from the event stream, use EventAvail. 
Version Notes
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
Boolean WaitNextEvent (
   EventMask eventMask,
   EventRecord * theEvent,
   UInt32 sleep,
   RgnHandle mouseRgn
){
printf ("WaitNextEvent",eventMask,*theEvent,sleep,mouseRgn);
};

//work



/*LMGetKbdType

Returns a value that specifies the physical keyboard type. 

UInt8 LMGetKbdType ();
Return Value

A value that specifies the physical keyboard type.
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt8 LMGetKbdType (){};


/*GetDblTime

Determines whether a sequence of mouse events constitutes a double click.

UInt32 GetDblTime ();
Parameters
Return Value
Discussion

The GetDblTime function returns the suggested maximum elapsed time, in ticks, between a mouse-up event and a mouse-down event. The user can adjust this value using the Mouse control panel.

If your application distinguishes a double click of the mouse from a single click, your application should use the value returned by GetDblTime to make this distinction. If your application uses TextEdit, the TextEdit functions automatically recognize and handle double clicks of text within a TextEdit edit structure by appropriately highlighting or unhighlighting the selection.

The ratio of ticks to value in the DoubleTime global variable is 1:1. However, the Finder multiplies DoubleTime by 2 to determine double click time because it needs to account for user problems that typically occur during icon arrangement. Therefore, the Finder uses DoubleTime*2 whereas the rest of the system uses DoubleTime. 

Incidentally, the Finder does not limit the DoubleTime to 64 ticks. In most places, it treats it like a byte although in some others it treats it like a longword. The best method would be to provide a one-second double-byte (two seconds in the Finder).

The value returned b y GetDblTime is also accessible in the system global variable DoubleTime. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 GetDblTime (){};

/*GetKeys

Obtains the current state of the keyboard.

void GetKeys (
   KeyMap theKeys
);
Parameters
theKeys

Returns the current state of the keyboard, including the keypad, if any. The GetKeys function returns this information using the KeyMap type.

typedef long KeyMap[4];

The KeyMap type is interpreted as an array of 128 elements, each having a Boolean value. Each key on the keyboard or keypad corresponds to an element in the KeyMap array. The index for a particular key is the same as the key’s virtual key code minus 1. For example, the key with virtual key code 38 (the “J” key on the Apple Keyboard II) is the 38th element in the returned array. A KeyMap element is true if the corresponding key is down and false if it isn’t. The maximum number of keys that can be down simultaneously is two character keys plus any combination of the five modifier keys.

Return Value
Discussion

You can use the GetKeys function to determine the current state of the keyboard at any time. For example, you can determine whether one of the modifier keys is down by itself or in combination with another key using the GetKeys function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/

void GetKeys (
   KeyMap theKeys
){};

/*IsCmdChar

Tests whether the Command key is pressed in conjunction with another key (or keys) that could generate the specified test character.

Boolean IsCmdChar (
   const EventRecord * event,
   short test
);
Parameters
event

The event record for a key-down or auto-key event with the Command key down. 
test

The character you want to test.
Return Value

The function returns TRUE if the test character is produced with the current modifier keys, or if it would be produced by changing the current modifier key bits in either or both of the following ways: (1) turning the Command bit off or (2) toggling the Shift bit.
Discussion

This function tests whether the Command key is pressed in conjunction with another key (or keys) that could generate the test character for some combination of Command up or down and Shift up or down. This accommodates European keyboards that may have the test character as a shifted character, and non-Roman keyboards that will only generate the test character if the Command key is pressed. It's most useful for testing for Command-period, but it can test for command-AnyCharacter. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/

Boolean IsCmdChar (
   const EventRecord * event,
   short test
){};

/*StillDown

After receiving a mouse-down event, you can use the StillDown function to determine if the mouse button is still down.

Not recommended

Boolean StillDown ();
Parameters
Return Value
Discussion

The StillDown function looks in the Operating System event queue for a mouse event. If it finds one, the StillDown function returns false. If it does not find any mouse events pending in the Operating System event queue, the StillDown function returns true. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

You should avoid using any calls that poll the state of the mouse button, as they use excessive processor time and slow down the system. In most cases you are more interested in the transitions of the mouse button rather than its instantaneous state, so you should adopt Carbon events and take action on mouse-up and mouse-down events. If you need to track the mouse while down, consider using the Carbon Event Manager functions TrackMouseLocation or TrackMouseRegion. On Mac OS X v.10.2 and later, if you need to know the button state, you should call the GetCurrentEventButtonState function.
Declared In
Events.h*/
Boolean StillDown (){};



/*KeyTranslate

Converts a virtual key code to a character code based on a 'KCHR' resource. 

UInt32 KeyTranslate (
   const void * transData,
   UInt16 keycode,
   UInt32 * state
);
Parameters
transData

A pointer to the 'KCHR' resource that you want the KeyTranslate function to use when converting the key code to a character code. 
keycode

A 16-bit value that your application should set so that bits 0–6 contain the virtual key code and bit 7 contains either 1 to indicate an up stroke or 0 to indicate a down stroke of the key. Bits 8–15 have the same interpretation as the high byte of the modifiers field of the event structure and should be set according to the needs of your application. 
state

A pointer to a value that your application should set to 0 the first time it calls KeyTranslate or any time your application calls KeyTranslate with a different 'KCHR' resource. Thereafter, your application should pass the same value in the state parameter as KeyTranslate returned in the previous call. 
Return Value
Discussion

The KeyTranslate function returns a 32-bit value that gives the character code for the virtual key code specified by the keycode parameter. 

The KeyTranslate function returns the values that correspond to one or possibly two characters that are generated by the specified virtual key code. For example, a given virtual key code might correspond to an alphabetic character with a separate accent character. For example, when the user presses Option-E followed by N, you can map this through the KeyTranslate function using the U.S. 'KCHR' resource to produce ´n, which KeyTranslate returns as two characters in the bytes labeled Character code 1 and Character code 2. If KeyTranslate returns only one character code, it is always in the byte labeled Character code 2. However, your application should always check both bytes labeled Character code 1 and Character code 2 for possible values that map to the virtual key code. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 KeyTranslate (
   const void * transData,
   UInt16 keycode,
   UInt32 * state
){};

/*EventAvail

Retrieves the next available event from the Event Manager without removing the returned event from your application’s event stream.

Boolean EventAvail (
   EventMask eventMask,
   EventRecord * theEvent
);
Parameters
eventMask

A value that indicates which kinds of events are to be returned; this parameter is interpreted as a sum of event mask constants. You specify the event mask using one or more of the values defined by the “Event Mask Constants”. If no event of any of the designated types is available, EventAvail returns a null event. 
theEvent

A pointer to an event structure for the next available event of the specified type or types. The EventAvail function does not remove the returned event from the event stream, but does return the information about the event in an event structure. The event structure includes the type of event received and other information. 
Return Value

EventAvail returns false as its function result if the event being returned is a null event; otherwise, EventAvail returns true. 
Special Considerations

If EventAvail returns a low-level event from the Operating System event queue, the event will not be accessible later if, in the meantime, the event queue becomes full and the event is discarded from it; however, this is not a common occurrence.
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
Boolean EventAvail (
   EventMask eventMask,
   EventRecord * theEvent
){
printf ("EventAvail",eventMask,*theEvent);
};




