#include <HIToolbox/HIToolbox.h>

/*HIShapeIsEmpty

Determines whether a given shape is empty.

Boolean HIShapeIsEmpty (
   HIShapeRef inShape
);
Parameters
inShape

The shape to test. 
Return Value

True if the shape’s area is empty, False otherwise. 
Discussion

This function is comparable to the old QuickDraw function EmptyRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
Boolean HIShapeIsEmpty (
   HIShapeRef inShape
){
printf ("HIShapeIsEmpty",inShape);
};



/*HIShapeCreateDifference

Creates an immutable shape that is the difference of two shapes. 

HIShapeRef HIShapeCreateDifference (
   HIShapeRef inShape1,
   HIShapeRef inShape2
);
Parameters
inShape1

The first shape. 
inShape2

The shape to subtract from the first shape. 
Return Value

The newly-created difference shape.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/

HIShapeRef HIShapeCreateDifference (
   HIShapeRef inShape1,
   HIShapeRef inShape2
){
printf ("HIShapeCreateDifference",inShape1,inShape2);
};

/*HIShapeUnion

Sets a shape to be the union of two other shapes.

OSStatus HIShapeUnion(
   HIShapeRef inShape1,
   HIShapeRef inShape2,
   HIMutableShapeRef outResult
);
Parameters
inShape1

An existing shape.
inShape2

Another existing shape. 
outResult

The shape to hold the union of the two shapes. This parameter can be one of the source shapes. 
Return Value

A result code. 
Discussion

This function is comparable to the old QuickDraw function UnionRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
OSStatus HIShapeUnion(
   HIShapeRef inShape1,
   HIShapeRef inShape2,
   HIMutableShapeRef outResult
){
printf ("HIShapeUnion",inShape1,inShape2,outResult);
};

/*HIShapeCreateMutable

Creates an empty mutable shape.

HIMutableShapeRef HIShapeCreateMutable (void);
Return Value

An empty, mutable shape. 
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
HIMutableShapeRef HIShapeCreateMutable (void){
printf ("HIShapeCreateMutable");
};

/*HIShapeCreateWithRect

Creates an immutable shape from a Quartz rectangle.

HIShapeRef HIShapeCreateWithRect (
   const HIRect * inRect
);
Parameters
inRect

The Quartz-based rectangle to convert. 
Return Value

The newly-created shape.
Discussion

This function is comparable to the old QuickDraw function RectRgn.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/

HIShapeRef HIShapeCreateWithRect (
   const HIRect * inRect
){
printf ("HIShapeCreateWithRect",*inRect);
};



/*HIShapeGetAsQDRgn

Creates a QuickDraw region with the same shape as the specified HIShape.

OSStatus HIShapeGetAsQDRgn (
   HIShapeRef inShape,
   RgnHandle outRgn
);
Parameters
inShape

The shape to convert. 
outRgn

A valid region handle. You must obtain this handle by calling NewRgn before calling this function. 
Return Value

A result code. 
Discussion

You can use this function to create a handle-based region from an HIShape object. This conversion requires memory allocation, so you should convert only when necessary.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
HIShape.h*/
OSStatus HIShapeGetAsQDRgn (
   HIShapeRef inShape,
   RgnHandle outRgn
){};




